#!/usr/local/bin/python

# ftpy is ftp clone.

import ftplib,string,os
from ftpy_define import *

class ftpclient:
	def setHostname(self,hostname):
		self.hostname = hostname
	
	def getHostname(self):
		return self.hostname
	
	def setPortno(self,portno):
		self.portno = portno
		
	def getPortno(self):
		return self.portno
		
	def setUser(self,user):
		self.user = user
		
	def getUser(self):
		return self.user
		
	def setPassword(self,password):
		self.password = password
		
	def getPassword(self):
		return self.password
		
	def setLocal_dir(self,local_dir):
		self.local_dir = local_dir
		
	def getLocal_dir(self):
		return self.local_dir

	def getError_No(self):
		return self.error_no
		
	def getError_Obj(self):
		return self.error_obj
		
	def getMsg_Obj(self):
		return self.msg_obj
	
	def getRemoteDir_Obj(self):
		return self.dir_obj
	
	#FTP Connection to FTP Server
	def connect(self):
		try:
			self.ftpcon = ftplib.FTP()
			self.ftpcon.connect(self.hostname,self.portno)
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG
	
	#Loing to FTP Server
	def login(self):
		try:
			self.ftpcon.login(self.user,self.password)
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG
	
	#Close Connection
	def close(self):
		try:
			self.ftpcon.quit()
			return C_OK
		except Exception, e:
			try:
				self.ftpcon.close()
				return C_OK
			except Exception, e:
				return C_NG

	#Get remote dir list
	def getRemoteDirData(self,pattarn=""):
		try:
			self.dir_obj = []
			if pattarn == "":
				send_command = "LIST"
			else:
				send_command = "LIST " + pattarn
			self.ftpcon.retrlines(send_command,self.dir_obj.append)
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Get current remote dir
	def getCurrentRemoteDir(self):
		try:
			self.msg_obj = []
			self.msg_obj.append(self.ftpcon.pwd())
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Change remote dir
	def changeRemoteDir(self,dirname):
		try:
			self.ftpcon.cwd(dirname)
			self.getRemoteDirData()
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Get file(BINARY MODE)
	def getRemoteFile(self,remote_filename,local_filename):
		try:
			self.ftpcon.retrbinary("RETR " + remote_filename,open(local_filename,"wb").write)
			self.getRemoteDirData()
			return C_OK
		except Exception, e:
			os.remove(local_filename)
			self.error_obj = e
			return C_NG
	
	#Put file(BINARY MODE)
	def putLocalFile(self,remote_filename,local_filename):
		try:
			localfile = open(local_filename,"rb")
			self.ftpcon.storbinary("STOR " + remote_filename,localfile)
			localfile.close()
			self.getRemoteDirData()
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Get file size
	def getRemoteFileSize(self,remote_filename):
		try:
			return self.ftpcon.size(remote_filename)
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Create dir
	def createRemote_dir(self,dir_name):
		try:
			self.ftpcon.mkd(dir_name)
			self.getRemoteDirData()
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Remove dir
	def removeRemote_dir(self,dir_name):
		try:
			self.ftpcon.rmd(dir_name)
			self.getRemoteDirData()
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Remove file
	def removeRemoteFile(self,remote_filename):
		try:
			self.ftpcon.delete(remote_filename)
			self.getRemoteDirData()
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG
	
	#Chage mode to remote file
	def changeModeRemoteFile(self,remote_filename,file_mode):
		try:
			send_command = "SITE CHMOD %s %s" % (file_mode,remote_filename)
			self.ftpcon.voidcmd(send_command)
			self.getRemoteDirData()
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Get Directory
	def getRemoteDir(self,remote_dir):
		try:
			res = self.changeRemoteDir(remote_dir)
			if res == C_NG:
				return C_NG
			res = self.createLocalDir(remote_dir)
			if res == C_NG:
				res = self.changeRemoteDir("..")
				return C_NG
			res = self.changeLocalDir(remote_dir)
			if res == C_NG:
				return C_NG
			dir_list = []
			self.ftpcon.retrlines("LIST",dir_list.append)
			for line in dir_list:
				line_ent = []
				for ent in string.split(line," "):
					if ent <> "":
						line_ent.append(ent)
				if line[0] == "d":
					if line_ent[8] <> ".." and line_ent[8] <> ".":
						self.getRemoteDir(line_ent[8])
				elif line[0] == "-":
					#print self.ftpcon.pwd() + "/" + line_ent[8]
					self.getRemoteFile(line_ent[8],line_ent[8])
					if res == C_NG:
						return C_NG
			res = self.changeRemoteDir("..")
			if res == C_NG:
				return C_NG
			res = self.changeLocalDir("..")
			if res == C_NG:
				return C_NG
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Create local dir
	def createLocalDir(self,dir_name):
		try:
			os.mkdir(dir_name)
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Change local dir
	def changeLocalDir(self,dir_name):
		try:
			os.chdir(dir_name)
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Get local dir
	def getCurrentLocalDir(self):
		try:
			self.msg_obj = []
			self.msg_obj.append(os.getcwd())
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG
			
	#Set pasv mode
	def setPasvmode(self):
		try:
			self.ftpcon.set_pasv(True)
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Get file(ASCII MODE)
	def getRemoteFileAscii(self,remote_filename,local_filename):
		try:
			self.ftpcon.retrlines("RETR " + remote_filename,open(local_filename,"wb").write)
			self.getRemoteDirData()
			return C_OK
		except Exception, e:
			os.remove(local_filename)
			self.error_obj = e
			return C_NG
	
	#Put file(ASCII MODE)
	def putLocalFileAscii(self,remote_filename,local_filename):
		try:
			localfile = open(local_filename,"rb")
			self.ftpcon.storlines("STOR " + remote_filename,localfile)
			localfile.close()
			self.getRemoteDirData()
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG

	#Rename file
	def renameRemoteFile(self,from_filename,to_filename):
		try:
			self.ftpcon.rename(from_filename,to_filename)
			return C_OK
		except Exception, e:
			self.error_obj = e
			return C_NG
	
	#Class initial
	def __init__(self):
		self.hostname = ""
		self.portno = 21
		self.user = ""
		self.password = ""
		
