/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.web;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.ObjectRecord;
import com.ftinc.si.assist.test.Tool;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class BrowserSetter
extends JDialog {
    private ObjectRecord m_rec;
    private JComboBox<String> browserCombo;
    private JCheckBox chckbxGrid;
    private JComboBox<String> versionCombo;
    private JComboBox<String> platfCombo;
    private JTextField gridAdress;
    private HashMap<String, HashMap<String, String>> m_bmap = null;
    private HashMap<String, String> m_curVmap;
    private JTextField serverPort;
    private JTextField userText;
    private JTextField pwdText;

    public BrowserSetter(JDialog owner, ObjectRecord rec) {
        super((Dialog)owner, true);
        this.setTitle(Messages.getString("BrowserSetter.this.title"));
        this.setResizable(false);
        this.m_rec = rec;
        this.setBounds(owner.getX() + 50, owner.getY() + 50, 590, 300);
        this.getContentPane().setLayout(null);
        JLabel lblBrowser = new JLabel(Messages.getString("BrowserSetter.0"));
        lblBrowser.setBounds(12, 10, 70, 13);
        this.getContentPane().add(lblBrowser);
        this.browserCombo = new JComboBox();
        this.browserCombo.addItem("Firefox");
        this.browserCombo.addItem("IE");
        this.browserCombo.addItem("Chrome");
        this.browserCombo.addItem("Safari");
        this.browserCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BrowserSetter.this.browserCombo.getSelectedIndex() >= 0) {
                    BrowserSetter.this.setVersion(BrowserSetter.this.browserCombo.getSelectedItem().toString());
                } else {
                    BrowserSetter.this.setVersion(null);
                }
            }
        });
        this.browserCombo.setBounds(102, 7, 148, 19);
        this.getContentPane().add(this.browserCombo);
        this.chckbxGrid = new JCheckBox(Messages.getString("BrowserSetter.1"));
        this.chckbxGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BrowserSetter.this.chckbxGrid.isSelected()) {
                    BrowserSetter.this.versionCombo.setEnabled(true);
                    BrowserSetter.this.platfCombo.setEnabled(true);
                    BrowserSetter.this.gridAdress.setEnabled(true);
                } else {
                    BrowserSetter.this.versionCombo.setEnabled(false);
                    BrowserSetter.this.platfCombo.setEnabled(false);
                    BrowserSetter.this.gridAdress.setEnabled(false);
                }
            }
        });
        this.chckbxGrid.setBounds(8, 45, 89, 21);
        this.getContentPane().add(this.chckbxGrid);
        this.versionCombo = new JComboBox();
        this.versionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BrowserSetter.this.versionCombo.getSelectedIndex() >= 0) {
                    BrowserSetter.this.setPlatform(BrowserSetter.this.versionCombo.getSelectedItem().toString());
                } else {
                    BrowserSetter.this.setPlatform(null);
                }
            }
        });
        this.versionCombo.setBounds(172, 84, 78, 19);
        this.getContentPane().add(this.versionCombo);
        JLabel lblPlatform = new JLabel(Messages.getString("BrowserSetter.2"));
        lblPlatform.setBounds(274, 87, 78, 13);
        this.getContentPane().add(lblPlatform);
        JLabel lblVersion = new JLabel(Messages.getString("BrowserSetter.3"));
        lblVersion.setBounds(102, 87, 58, 13);
        this.getContentPane().add(lblVersion);
        this.platfCombo = new JComboBox();
        this.platfCombo.setBounds(358, 81, 214, 19);
        this.getContentPane().add(this.platfCombo);
        JButton btnOK = new JButton(Messages.getString("BrowserSetter.4"));
        btnOK.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BrowserSetter.this.setJson();
                BrowserSetter.this.setVisible(false);
            }
        });
        btnOK.setBounds(182, 240, 91, 21);
        this.getContentPane().add(btnOK);
        JButton btnCancel = new JButton(Messages.getString("BrowserSetter.5"));
        btnCancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BrowserSetter.this.setVisible(false);
            }
        });
        btnCancel.setBounds(297, 240, 91, 21);
        this.getContentPane().add(btnCancel);
        this.gridAdress = new JTextField();
        this.gridAdress.setBounds(102, 46, 470, 19);
        this.getContentPane().add(this.gridAdress);
        this.gridAdress.setColumns(10);
        this.versionCombo.setEnabled(false);
        this.platfCombo.setEnabled(false);
        this.gridAdress.setEnabled(false);
        JLabel lblProxy = new JLabel(Messages.getString("BrowserSetter.lblProxy.text"));
        lblProxy.setBounds(12, 145, 50, 13);
        this.getContentPane().add(lblProxy);
        this.serverPort = new JTextField();
        this.serverPort.setToolTipText("server address : port");
        this.serverPort.setBounds(102, 142, 470, 19);
        this.getContentPane().add(this.serverPort);
        this.serverPort.setColumns(10);
        JLabel lblUser = new JLabel(Messages.getString("BrowserSetter.lblUser.text"));
        lblUser.setBounds(102, 171, 50, 13);
        this.getContentPane().add(lblUser);
        this.userText = new JTextField();
        this.userText.setToolTipText("user_id for proxy server");
        this.userText.setBounds(172, 168, 180, 19);
        this.getContentPane().add(this.userText);
        this.userText.setColumns(10);
        JLabel lblPassword = new JLabel(Messages.getString("BrowserSetter.lblPassword.text"));
        lblPassword.setBounds(102, 200, 70, 13);
        this.getContentPane().add(lblPassword);
        this.pwdText = new JTextField();
        this.pwdText.setToolTipText("password for proxy server");
        this.pwdText.setBounds(172, 197, 180, 19);
        this.getContentPane().add(this.pwdText);
        this.pwdText.setColumns(10);
        this.initBrowserMap();
    }

    private void initBrowserMap() {
        if (System.getProperty("browser_map") != null) {
            String t_mapstr = System.getProperty("browser_map");
            this.m_bmap = (HashMap)Tool.getObjectfromJSON(HashMap.class, t_mapstr);
        }
    }

    private void setJson() {
        String t_json = "{";
        int n = this.browserCombo.getSelectedIndex();
        if (n >= 0) {
            t_json = String.valueOf(t_json) + "\"browser\":\"" + this.browserCombo.getItemAt(n).toString() + "\"";
            if (this.chckbxGrid.isSelected()) {
                t_json = String.valueOf(t_json) + ",\"grid\":\"" + this.gridAdress.getText() + "\"";
                n = this.versionCombo.getSelectedIndex();
                if (n >= 0) {
                    t_json = String.valueOf(t_json) + ",\"version\":\"" + this.versionCombo.getItemAt(n).toString() + "\"";
                }
                if ((n = this.platfCombo.getSelectedIndex()) >= 0) {
                    t_json = String.valueOf(t_json) + ",\"platform\":\"" + this.platfCombo.getItemAt(n).toString() + "\"";
                }
            }
            if (this.serverPort.getText().length() > 0) {
                t_json = String.valueOf(t_json) + ",\"proxy\":\"" + this.serverPort.getText() + "\"";
                if (this.userText.getText().length() > 0) {
                    t_json = String.valueOf(t_json) + ",\"proxy.user_id\":\"" + this.userText.getText() + "\"";
                    if (this.pwdText.getText().length() > 0) {
                        t_json = String.valueOf(t_json) + ",\"proxy.password\":\"" + this.pwdText.getText() + "\"";
                    }
                }
            }
        }
        if ((t_json = String.valueOf(t_json) + "}").length() > 2) {
            this.m_rec.setJSON(t_json);
        }
    }

    private void setVersion(String browser) {
        this.versionCombo.removeAll();
        if (this.m_bmap != null && this.m_bmap.containsKey(browser)) {
            this.m_curVmap = this.m_bmap.get(browser);
            this.versionCombo.removeAll();
            for (Map.Entry<String, String> e : this.m_curVmap.entrySet()) {
                this.versionCombo.addItem(e.getKey());
            }
            this.setPlatform(null);
        }
        this.setPlatform(null);
    }

    private void setPlatform(String ver) {
        String t_str;
        String array_str;
        String[] t_list;
        this.platfCombo.removeAll();
        if (this.m_bmap != null && this.m_curVmap != null && this.versionCombo.getSelectedIndex() >= 0 && (t_list = (String[])Tool.getObjectfromJSON(String[].class, array_str = this.m_curVmap.get(t_str = this.versionCombo.getSelectedItem().toString()))) != null && t_list.length > 0) {
            int i = 0;
            while (i < t_list.length) {
                this.platfCombo.addItem(t_list[i]);
                ++i;
            }
        }
    }
}

