/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test;

import com.ftinc.si.assist.test.AssertRecord;
import com.ftinc.si.assist.test.FakeMethodRecord;
import com.ftinc.si.assist.test.Fson;
import com.ftinc.si.assist.test.JSONRecord;
import com.ftinc.si.assist.test.ObjectRecord;
import com.ftinc.si.assist.test.Record;
import com.ftinc.si.assist.test.TestCaseRecord;
import com.ftinc.si.assist.test.TestCommandRecord;
import com.ftinc.si.assist.test.Tool;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DBService {
    public static Connection s_connect = null;
    private Statement m_statement = null;
    private boolean m_remote_mode;
    private boolean m_gc = false;
    private OutputStreamWriter m_commandWriter = null;
    private BufferedReader m_resultReader = null;
    private Process m_process = null;

    public DBService(boolean isRemote, boolean gc) {
        this.m_remote_mode = isRemote;
        this.m_gc = gc;
    }

    public boolean init(String str, String uid, String pwd) {
        str = Tool.convert2Alias(str);
        if (this.m_remote_mode) {
            return this.createDBMediator(str, uid, pwd);
        }
        try {
            s_connect = DriverManager.getConnection(str, uid, pwd);
            s_connect.setAutoCommit(false);
        }
        catch (SQLException e) {
            s_connect = null;
            Tool.alertMSG(null, e.getMessage());
            return false;
        }
        return true;
    }

    public boolean isReady() {
        Boolean t_b = false;
        if (this.m_process == null) {
            try {
                String t_sql = "SELECT table_name FROM information_schema.tables WHERE table_schema = 'public'";
                ResultSet t_res = this.select(t_sql);
                while (t_res.next()) {
                    String t_name = t_res.getString("table_name");
                    if (!"tbl_TestCaseRecord".equals(t_name)) continue;
                    t_b = true;
                }
                this.close(t_res);
            }
            catch (SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        } else {
            try {
                String t_result = this.sendCommand("isReady", "");
                t_b = (Boolean)Tool.getObjectfromJSON(Boolean.class, t_result);
            }
            catch (IOException | SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        }
        return t_b;
    }

    public void destroy() {
        if (this.m_process == null) {
            try {
                if (s_connect != null) {
                    s_connect.close();
                    s_connect = null;
                }
            }
            catch (SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        } else {
            try {
                this.sendCommand("destroy", "");
                this.m_resultReader.close();
                this.m_commandWriter.close();
                this.m_process.destroy();
            }
            catch (IOException | SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        }
    }

    private ResultSet select(String q) {
        try {
            this.m_statement = s_connect.createStatement();
            return this.m_statement.executeQuery(q);
        }
        catch (SQLException e) {
            Tool.alertMSG(null, e.getMessage());
            return null;
        }
    }

    private void close(ResultSet r) throws SQLException {
        if (this.m_process == null) {
            if (r != null) {
                r.close();
            }
            if (this.m_statement != null) {
                this.m_statement.close();
                this.m_statement = null;
            }
        } else {
            try {
                this.sendCommand("close", "");
            }
            catch (IOException | SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        }
    }

    private String _esq(String str) {
        return str.replaceAll(Pattern.quote("\\"), "");
    }

    public JSONRecord getJSONRecord(String cname, String name, String version) {
        String t_sql = "select * from \"tbl_JSONRecord\" where ";
        boolean b_added = false;
        if (name != null && name.length() > 0) {
            t_sql = name.indexOf("%") >= 0 ? String.valueOf(t_sql) + "\"Name\" like '" + this._esq(name) + "' " : String.valueOf(t_sql) + "\"Name\"='" + this._esq(name) + "' and \"ClassName\"='" + this._esq(cname) + "'";
            b_added = true;
        }
        if (cname != null && cname.length() > 0) {
            if (b_added) {
                t_sql = String.valueOf(t_sql) + " and ";
            }
            t_sql = cname.indexOf("%") >= 0 ? String.valueOf(t_sql) + "\"ClassName\" like '" + this._esq(cname) + "'" : String.valueOf(t_sql) + "\"ClassName\"='" + this._esq(cname) + "'";
        }
        if (version != null && version.length() > 0) {
            t_sql = String.valueOf(t_sql) + " AND \"Version\"='" + version + "'";
        }
        JSONRecord t_rec = null;
        if (this.m_process == null) {
            ResultSet t_res = this.select(t_sql);
            try {
                while (t_res.next()) {
                    t_rec = new JSONRecord(0);
                    t_rec.read(t_res);
                }
                this.close(t_res);
            }
            catch (SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        } else {
            try {
                String t_result = this.sendCommand("getJSONRecord", t_sql);
                t_rec = (JSONRecord)Tool.getObjectfromJSON(JSONRecord.class, t_result);
            }
            catch (IOException | SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        }
        return t_rec;
    }

    public ArrayList<JSONRecord> getJSONRecWhere(String cname, String subname, String version) {
        String t_sql = "select * from \"tbl_JSONRecord\"";
        if (version != null && version.length() > 0) {
            t_sql = String.valueOf(t_sql) + " AND \"Version\"='" + version + "'";
        }
        if (cname != null || subname != null) {
            t_sql = String.valueOf(t_sql) + " where ";
            String t1_sql = "";
            if (cname != null) {
                t1_sql = String.valueOf(t1_sql) + "\"ClassName\" like '" + this._esq(cname) + "'";
            }
            String t2_sql = "";
            if (subname != null) {
                t2_sql = String.valueOf(t2_sql) + "\"Name\" like '" + this._esq(subname) + "'";
            }
            String t3_sql = "";
            if (t1_sql.length() > 0 && t2_sql.length() > 0) {
                t3_sql = " and ";
            }
            t_sql = String.valueOf(t_sql) + t1_sql + t3_sql + t2_sql;
        }
        ArrayList<JSONRecord> t_list = new ArrayList<JSONRecord>();
        if (this.m_process == null) {
            ResultSet t_res = this.select(t_sql);
            try {
                if (t_res.next()) {
                    JSONRecord t_rec = new JSONRecord(0);
                    t_rec.read(t_res);
                    t_list.add(t_rec);
                }
                this.close(t_res);
            }
            catch (SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        } else {
            try {
                String t_json = this.sendCommand("getJSONRecWhere", t_sql);
                return (ArrayList)Tool.getObjectfromJSON(ArrayList.class, t_json);
            }
            catch (IOException | SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        }
        return t_list;
    }

    public AssertRecord getAssert(int testID) {
        String t_sql = "select * from \"tbl_AssertRecord\" where \"ID\"='" + Integer.valueOf(testID).toString() + "'";
        AssertRecord t_rec = null;
        if (this.m_process == null) {
            try {
                ResultSet t_res = this.select(t_sql);
                while (t_res.next()) {
                    t_rec = new AssertRecord(0);
                    t_rec.read(t_res);
                }
                this.close(t_res);
            }
            catch (SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        } else {
            try {
                String t_json = this.sendCommand("getAssert", t_sql);
                t_rec = (AssertRecord)Tool.getObjectfromJSON(AssertRecord.class, t_json);
            }
            catch (IOException | SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        }
        return t_rec;
    }

    public ObjectRecord getObjectRecord(ObjectRecord ord) {
        String t_sql = "select * from \"tbl_ObjectRecord\" where \"ID\"='" + ord._id() + "'";
        ObjectRecord t_rec = null;
        if (this.m_process == null) {
            ResultSet t_res = this.select(t_sql);
            try {
                if (t_res.next()) {
                    t_rec = new ObjectRecord(0);
                    t_rec.read(t_res);
                }
                this.close(t_res);
            }
            catch (SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        } else {
            try {
                String t_json = this.sendCommand("getObjectRecord", t_sql);
                t_rec = (ObjectRecord)Tool.getObjectfromJSON(ObjectRecord.class, t_json);
            }
            catch (IOException | SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        }
        return t_rec;
    }

    public ArrayList<String> getReferringObjectList(String casename, String objid) {
        ArrayList t_list = new ArrayList();
        String t_sql = "select * from \"tbl_ObjectRecord\" where ";
        t_sql = String.valueOf(t_sql) + "\"TestCase\"<>'" + this._esq(casename) + "' and (\"Stack\" like '" + objid;
        t_sql = String.valueOf(t_sql) + "%' or \"JSON\" like '%" + objid + "$%')";
        if (this.m_process == null) {
            ResultSet t_res = this.select(t_sql);
            try {
                while (t_res.next()) {
                    t_list.add(t_res.getString("ID"));
                }
                this.close(t_res);
            }
            catch (SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        } else {
            try {
                t_list = (ArrayList)Tool.getObjectfromJSON(ArrayList.class, this.sendCommand("getReferringObjectList", t_sql));
            }
            catch (IOException | SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        }
        return t_list;
    }

    public ArrayList<ObjectRecord> getReusableObjectRecord(String caseName, String className, int testID, int begin) {
        String t_sql = "select * from \"tbl_ObjectRecord\" where \"TestCase\"='" + caseName + "' and \"ClassName\"='" + className + "' and \"TestID\" <'" + Integer.toString(testID) + "' and \"TestID\" >='" + Integer.toString(begin) + "'";
        ArrayList<ObjectRecord> t_list = new ArrayList<ObjectRecord>();
        if (this.m_process == null) {
            ResultSet t_res = this.select(t_sql);
            try {
                while (t_res.next()) {
                    ObjectRecord t_rec = new ObjectRecord(0);
                    t_rec.read(t_res);
                    t_list.add(t_rec);
                }
                this.close(t_res);
            }
            catch (SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        } else {
            try {
                String t_json = this.sendCommand("getReusableObjectRecord", t_sql);
                return (ArrayList)Tool.getObjectfromJSON(ArrayList.class, t_json);
            }
            catch (IOException | SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        }
        return t_list;
    }

    public FakeMethodRecord getMethodSource(String className, String methodName, String[] argtypes, String version) {
        FakeMethodRecord frd;
        block8: {
            frd = new FakeMethodRecord(0);
            String a_types = Tool.getJSONfromObject(argtypes);
            String sql_where = " where \"ClassName\"='" + className + "' AND \"MethodName\"='" + methodName + "' AND \"ArgTypes\"='" + a_types + "'";
            if (version != null && version.length() > 0) {
                sql_where = String.valueOf(sql_where) + " AND \"Version\"='" + version + "'";
            }
            String t_sql = "select * from \"tbl_FakeMethodRecord\"" + sql_where;
            if (this.m_process == null) {
                ResultSet t_res = this.select(t_sql);
                try {
                    while (t_res.next()) {
                        frd.read(t_res);
                    }
                    this.close(t_res);
                    if (frd.source == null) {
                        return null;
                    }
                    break block8;
                }
                catch (SQLException e) {
                    Tool.alertMSG(null, e.getMessage());
                    return null;
                }
            }
            try {
                String t_json = this.sendCommand("getMethodSource", t_sql);
                frd = (FakeMethodRecord)Tool.getObjectfromJSON(FakeMethodRecord.class, t_json);
            }
            catch (IOException | SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        }
        return frd;
    }

    public ArrayList<FakeMethodRecord> getFakeMethods(String className, String version) {
        String t_sql = "select * from \"tbl_FakeMethodRecord\" where \"ClassName\"='" + className + "'";
        if (version != null && version.length() > 0) {
            t_sql = String.valueOf(t_sql) + " AND \"Version\"='" + version + "'";
        }
        ArrayList<FakeMethodRecord> t_list = new ArrayList<FakeMethodRecord>();
        if (this.m_process == null) {
            ResultSet t_res = this.select(t_sql);
            try {
                while (t_res.next()) {
                    FakeMethodRecord frd = new FakeMethodRecord(0);
                    frd.read(t_res);
                    t_list.add(frd);
                }
                this.close(t_res);
            }
            catch (SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        } else {
            try {
                String t_json = this.sendCommand("getFakeMethods", t_sql);
                return (ArrayList)Tool.getObjectfromJSON(ArrayList.class, t_json);
            }
            catch (IOException | SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        }
        return t_list;
    }

    public ArrayList<FakeMethodRecord> getAllFakes(String version) {
        String t_sql = "select * from \"tbl_FakeMethodRecord\"";
        if (version != null && version.length() > 0) {
            t_sql = String.valueOf(t_sql) + " AND \"Version\"='" + version + "'";
        }
        ArrayList<FakeMethodRecord> t_list = new ArrayList<FakeMethodRecord>();
        if (this.m_process == null) {
            ResultSet t_res = this.select(t_sql);
            try {
                while (t_res.next()) {
                    FakeMethodRecord frd = new FakeMethodRecord(0);
                    frd.read(t_res);
                    t_list.add(frd);
                }
                this.close(t_res);
            }
            catch (SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        } else {
            try {
                String t_json = this.sendCommand("getAllFakes", t_sql);
                return (ArrayList)Tool.getObjectfromJSON(ArrayList.class, t_json);
            }
            catch (IOException | SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        }
        return new ArrayList<FakeMethodRecord>();
    }

    public ArrayList<String> getTestIDsByReturnType(String caseName, String className, int begin, int end) {
        String t_sql = "select * from \"tbl_TestCommandRecord\" where \"TestCase\" like '" + caseName + "' and \"ReturnType\" like '" + className + "'";
        t_sql = String.valueOf(t_sql) + " and \"ID\">='" + Integer.toString(begin) + "' and \"ID\"<'" + Integer.toString(end) + "'";
        ArrayList t_list = new ArrayList();
        if (this.m_process == null) {
            ResultSet t_res = this.select(t_sql);
            try {
                while (t_res.next()) {
                    t_list.add(t_res.getString("ID"));
                }
                this.close(t_res);
            }
            catch (SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        } else {
            try {
                String t_json = this.sendCommand("getTestIDsByReturnType", t_sql);
                t_list = (ArrayList)Tool.getObjectfromJSON(ArrayList.class, t_json);
            }
            catch (IOException | SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        }
        return t_list;
    }

    public TestCaseRecord getNewTestCase(String version) {
        String sub_sql = "select max(\"End\") from \"tbl_TestCaseRecord\"";
        String t_sql = "select * from \"tbl_TestCaseRecord\" where \"End\"=(" + sub_sql + ")";
        if (this.m_process == null) {
            ResultSet t_res = this.select(t_sql);
            int n = 0;
            try {
                while (t_res.next()) {
                    n = t_res.getInt("End");
                }
                this.close(t_res);
            }
            catch (SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
            TestCaseRecord t_rec = new TestCaseRecord(2);
            t_rec.begin = n + 1;
            t_rec.end = n + TestCaseRecord.s_unitSize;
            t_rec.groupCode = Tool.group_code;
            t_rec.version = version;
            return t_rec;
        }
        try {
            String t_json = this.sendCommand("getNewTestCase", t_sql);
            return (TestCaseRecord)Tool.getObjectfromJSON(TestCaseRecord.class, t_json);
        }
        catch (IOException | SQLException e) {
            Tool.alertMSG(null, e.getMessage());
            return null;
        }
    }

    public ArrayList<TestCaseRecord> getTestCaseList(String substr, int begin, int end, String gcode, String version) {
        String t_sql = "select * from \"tbl_TestCaseRecord\" ";
        if (substr != null) {
            t_sql = String.valueOf(t_sql) + "where \"Name\" like '" + this._esq(substr) + "' ";
            if (end > 0) {
                t_sql = String.valueOf(t_sql) + " AND \"Begin\" <= '" + Integer.valueOf(end).toString() + "' ";
            }
            if (begin > 0) {
                t_sql = String.valueOf(t_sql) + " AND \"End\" >= '" + Integer.valueOf(begin).toString() + "'";
            }
        }
        if (gcode.length() > 0) {
            t_sql = String.valueOf(t_sql) + " AND \"GroupCode\"='" + gcode + "'";
        }
        if (version != null && version.length() > 0) {
            t_sql = String.valueOf(t_sql) + " AND \"Version\"='" + version + "'";
        }
        t_sql = String.valueOf(t_sql) + " order by \"Begin\"";
        ArrayList t_list = new ArrayList();
        if (this.m_process == null) {
            ResultSet t_res = this.select(t_sql);
            TestCaseRecord t_rec = null;
            try {
                while (t_res.next()) {
                    t_rec = new TestCaseRecord(0);
                    t_rec.read(t_res);
                    t_list.add(t_rec);
                }
                this.close(t_res);
            }
            catch (SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        } else {
            try {
                String t_json = this.sendCommand("getTestCaseList", t_sql);
                t_list = (ArrayList)Tool.getObjectfromJSON(ArrayList.class, t_json);
            }
            catch (IOException | SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        }
        return t_list;
    }

    public ArrayList<String> getReferringTestCaseList(String name, String version) {
        String t_sql = "select * from \"tbl_TestCaseRecord\" ";
        if (name != null) {
            t_sql = String.valueOf(t_sql) + "where \"Include\" = '" + this._esq(name) + "'";
        }
        if (version != null && version.length() > 0) {
            t_sql = String.valueOf(t_sql) + " AND \"Version\"='" + version + "'";
        }
        t_sql = String.valueOf(t_sql) + " order by \"Begin\"";
        ArrayList t_list = new ArrayList();
        if (this.m_process == null) {
            ResultSet t_res = this.select(t_sql);
            try {
                while (t_res.next()) {
                    t_list.add(t_res.getString("Name"));
                }
                this.close(t_res);
            }
            catch (SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        } else {
            try {
                String t_json = this.sendCommand("getReferringTestCaseList", t_sql);
                t_list = (ArrayList)Tool.getObjectfromJSON(ArrayList.class, t_json);
            }
            catch (IOException | SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        }
        return t_list;
    }

    public TestCommandRecord getTestCmd(String id) {
        String t_sql = "select * from \"tbl_TestCommandRecord\" where \"ID\"=" + id;
        TestCommandRecord t_rec = null;
        if (this.m_process == null) {
            ResultSet t_res = this.select(t_sql);
            try {
                while (t_res.next()) {
                    t_rec = new TestCommandRecord(0);
                    t_rec.read(t_res);
                }
                this.close(t_res);
                return t_rec;
            }
            catch (SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        } else {
            try {
                String t_json = this.sendCommand("getTestCmd", t_sql);
                return (TestCommandRecord)Tool.getObjectfromJSON(TestCommandRecord.class, t_json);
            }
            catch (IOException | SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        }
        return t_rec;
    }

    public ArrayList<TestCommandRecord> getTestCmdList(String uname, String cname, String mname, String version) {
        ArrayList<TestCommandRecord> t_list = new ArrayList<TestCommandRecord>();
        if (uname == null || uname.length() == 0) {
            uname = "%";
        }
        if (cname == null || cname.length() == 0) {
            cname = "%";
        }
        if (mname == null || mname.length() == 0) {
            mname = "%";
        }
        ArrayList<TestCaseRecord> case_list = this.getTestCaseList(uname, 0, 0, "", version);
        int i = 0;
        while (i < case_list.size()) {
            TestCaseRecord c_rec = case_list.get(i);
            String t_sql = "select * from \"tbl_TestCommandRecord\" where \"TestCase\" like '" + uname + "' and \"ClassName\" like '" + cname + "' and \"MethodName\" like '" + mname + "' and \"ID\">='" + Integer.toString(c_rec.begin) + "' and \"ID\"<'" + Integer.toString(c_rec.end) + "'" + " order by \"ID\"";
            if (this.m_process == null) {
                ResultSet t_res = this.select(t_sql);
                TestCommandRecord t_rec = null;
                try {
                    while (t_res.next()) {
                        t_rec = new TestCommandRecord();
                        t_rec.read(t_res);
                        t_list.add(t_rec);
                    }
                    this.close(t_res);
                }
                catch (SQLException e) {
                    Tool.alertMSG(null, e.getMessage());
                }
            } else {
                try {
                    String t_json = this.sendCommand("getTestCmdList", t_sql);
                    return (ArrayList)Tool.getObjectfromJSON(ArrayList.class, t_json);
                }
                catch (IOException | SQLException e) {
                    Tool.alertMSG(null, e.getMessage());
                }
            }
            ++i;
        }
        return t_list;
    }

    public ArrayList<TestCommandRecord> getSnapshotCmds(String caseName, String className, String mName, String version) {
        String t_sql = "select * from \"tbl_TestCommandRecord\" where \"ID\" in ";
        t_sql = String.valueOf(t_sql) + "(select \"Snapshot\" from  \"tbl_TestCaseRecord\" ";
        if (caseName == null || caseName.length() == 0) {
            caseName = "%";
        }
        if (className == null || className.length() == 0) {
            className = "%";
        }
        if (mName == null || mName.length() == 0) {
            mName = "%";
        }
        if (version != null && version.length() > 0) {
            version = " AND \"Version\"='" + version + "'";
        }
        t_sql = String.valueOf(t_sql) + "where \"Name\" like '" + caseName + "' and \"Snapshot\" > 0 " + version + ") " + "and \"ClassName\" like '" + className + "' and \"MethodName\" like '" + mName + "'";
        ArrayList t_list = new ArrayList();
        if (this.m_process == null) {
            ResultSet t_res = this.select(t_sql);
            TestCommandRecord t_rec = null;
            try {
                while (t_res.next()) {
                    t_rec = new TestCommandRecord(0);
                    t_rec.read(t_res);
                    t_list.add(t_rec);
                }
                this.close(t_res);
            }
            catch (SQLException e) {
                Tool.alertMSG(null, e.getMessage());
                return null;
            }
        }
        try {
            String t_json = this.sendCommand("getTestCmdList", t_sql);
            t_list = (ArrayList)Tool.getObjectfromJSON(ArrayList.class, t_json);
        }
        catch (IOException | SQLException e) {
            Tool.alertMSG(null, e.getMessage());
        }
        return t_list;
    }

    public ArrayList<String> getReferringTestCmdList(String caseName, String id) {
        ArrayList t_list = new ArrayList();
        String t_sql = "select * from \"tbl_TestCommandRecord\" where (\"ArgTypes\" like '%," + id + "$%' or \"Subject\" like '%," + id + "$%') and \"TestCase\"<>'" + caseName + "' order by \"ID\"";
        if (this.m_process == null) {
            ResultSet t_res = this.select(t_sql);
            try {
                while (t_res.next()) {
                    t_list.add(String.valueOf(t_res.getString("ID")) + "@" + t_res.getString("TestCase"));
                }
                this.close(t_res);
            }
            catch (SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
            if (t_list.size() == 0) {
                return null;
            }
        } else {
            try {
                String t_json = this.sendCommand("getReferringTestCmdList", t_sql);
                t_list = (ArrayList)Tool.getObjectfromJSON(ArrayList.class, t_json);
            }
            catch (IOException | SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        }
        return t_list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateRecordBySQL(String t_sql, boolean bCommit) throws SQLException {
        if (t_sql == null) {
            return;
        }
        if (this.m_process == null) {
            try {
                try {
                    if (this.m_statement == null) {
                        this.m_statement = s_connect.createStatement();
                    }
                    this.m_statement.execute(t_sql);
                    if (!bCommit) return;
                    this.commit();
                    return;
                }
                catch (SQLException e) {
                    Tool.alertMSG(null, "@DBService#updateRecordBySQL, SQLException=" + e.getMessage() + "\n sql=" + t_sql);
                    if (bCommit) {
                        this.rollback();
                    }
                    if (!bCommit) return;
                    this.close(null);
                }
                return;
            }
            finally {
                if (bCommit) {
                    this.close(null);
                }
            }
        }
        try {
            this.sendCommand("updateBySQL", String.valueOf(t_sql) + "\t" + Boolean.toString(bCommit));
            return;
        }
        catch (IOException e) {
            Tool.alertMSG(null, e.getMessage());
        }
    }

    private void commit() throws SQLException {
        if (this.m_process == null) {
            s_connect.commit();
        } else {
            try {
                this.sendCommand("commit", null);
            }
            catch (IOException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        }
    }

    private void rollback() throws SQLException {
        if (this.m_process == null) {
            s_connect.rollback();
        } else {
            try {
                this.sendCommand("rollback", null);
            }
            catch (IOException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    public boolean saveTestCase(TestCaseRecord rec, ArrayList<Record> removings, HashMap<Integer, TestCommandRecord> tests, HashMap<String, ObjectRecord> objs, HashMap<Integer, AssertRecord> asserts) throws SQLException {
        if (Tool.group_code.length() != 0 && !rec.getGroupCode().equals(Tool.group_code)) {
            return false;
        }
        boolean isOK = true;
        try {
            try {
                String t_sql = rec.getUpdateSQL();
                if (t_sql != null) {
                    this.updateRecordBySQL(t_sql, false);
                }
                if (removings != null) {
                    int i = 0;
                    while (i < removings.size()) {
                        this.updateRecordBySQL(removings.get(i).getUpdateSQL(), false);
                        ++i;
                    }
                }
                for (Map.Entry<Integer, TestCommandRecord> entry1 : tests.entrySet()) {
                    if (!entry1.getValue().isUpdated()) continue;
                    this.updateRecordBySQL(entry1.getValue().getUpdateSQL(), false);
                }
                for (Map.Entry<Object, Record> entry2 : objs.entrySet()) {
                    ObjectRecord t_rec = (ObjectRecord)entry2.getValue();
                    if (!t_rec.isUpdated()) continue;
                    this.updateRecordBySQL(((ObjectRecord)entry2.getValue()).getUpdateSQL(), false);
                }
                for (Map.Entry<Object, Record> entry3 : asserts.entrySet()) {
                    if (!((AssertRecord)entry3.getValue()).isUpdated()) continue;
                    this.updateRecordBySQL(((AssertRecord)entry3.getValue()).getUpdateSQL(), false);
                }
                this.commit();
            }
            catch (SQLException e) {
                Tool.alertMSG(null, "@saveTestCase, SQLException=" + e.getMessage());
                this.rollback();
                isOK = false;
                this.close(null);
            }
            catch (Exception e) {
                Tool.alertMSG(null, "@saveTestCase, RuntimeException=" + e.getMessage());
                this.rollback();
                isOK = false;
                this.close(null);
            }
            catch (Error e) {
                Tool.alertMSG(null, "@saveTestCase, Error=" + e.getMessage());
                this.rollback();
                isOK = false;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.close(null);
            }
        }
        finally {
            this.close(null);
        }
        return isOK;
    }

    public int countCase() {
        String t_sql = "select count(*) from \"tbl_TestCaseRecord\"";
        if (this.m_process == null) {
            try {
                int n = 0;
                this.m_statement = s_connect.createStatement();
                ResultSet t_res = this.m_statement.executeQuery(t_sql);
                if (t_res.next()) {
                    n = t_res.getInt(1);
                }
                this.close(t_res);
                return n;
            }
            catch (SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        } else {
            try {
                String t_json = this.sendCommand("countCase", t_sql);
                return Integer.valueOf(t_json);
            }
            catch (IOException | SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        }
        return -1;
    }

    public void createTable() {
        String err_msg = "";
        if (this.m_process == null) {
            ArrayList<String> t_list = Tool.createTableSQL();
            if (t_list.size() > 0) {
                try {
                    try {
                        this.m_statement = s_connect.createStatement();
                        int i = 0;
                        while (i < t_list.size()) {
                            err_msg = t_list.get(i);
                            this.m_statement.executeUpdate(t_list.get(i));
                            ++i;
                        }
                        this.commit();
                    }
                    catch (SQLException e) {
                        Tool.alertMSG(null, String.valueOf(e.getMessage()) + "\nSQL=\n" + err_msg);
                        try {
                            this.rollback();
                        }
                        catch (SQLException e1) {
                            Tool.logIfDebug(e, "@DBService#createTable");
                        }
                        try {
                            this.close(null);
                        }
                        catch (SQLException e2) {
                            Tool.logIfDebug(e2, "@DBService#createTable");
                        }
                    }
                }
                finally {
                    try {
                        this.close(null);
                    }
                    catch (SQLException e) {
                        Tool.logIfDebug(e, "@DBService#createTable");
                    }
                }
            }
        } else {
            try {
                this.sendCommand("createTable", null);
            }
            catch (IOException | SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        }
    }

    public void removeCase(String label, String version) throws SQLException {
        ArrayList<TestCaseRecord> t_list = this.getTestCaseList(label, 0, 0, Tool.group_code, version);
        if (t_list.size() > 0) {
            try {
                try {
                    int i = 0;
                    while (i < t_list.size()) {
                        TestCaseRecord t_rec = t_list.get(i);
                        t_rec.removed = true;
                        String t_sql = t_rec.getUpdateSQL();
                        this.clearCase(t_rec, false);
                        this.updateRecordBySQL(t_sql, false);
                        ++i;
                    }
                    this.commit();
                }
                catch (SQLException e) {
                    Tool.alertMSG(null, "@DBService#removeCase, SQLException=" + e.getMessage());
                    this.rollback();
                    try {
                        this.close(null);
                    }
                    catch (SQLException e2) {
                        Tool.logIfDebug(e2, "@DBService#removeCase");
                    }
                }
            }
            finally {
                try {
                    this.close(null);
                }
                catch (SQLException e) {
                    Tool.logIfDebug(e, "@DBService#removeCase");
                }
            }
        }
    }

    public void clearCase(TestCaseRecord rec, boolean bCommit) throws SQLException {
        if (rec != null) {
            try {
                try {
                    ArrayList<TestCommandRecord> t_cmds = this.getTestCmdList(rec.name, null, null, rec.version);
                    int i = 0;
                    while (i < t_cmds.size()) {
                        String t_sql = "delete from \"tbl_TestCommandRecord\" where \"ID\"='" + Integer.toString(t_cmds.get((int)i).id) + "'";
                        this.updateRecordBySQL(t_sql, false);
                        t_sql = "delete from \"tbl_ObjectRecord\" where \"TestID\"='" + Integer.toString(t_cmds.get((int)i).id) + "'";
                        this.updateRecordBySQL(t_sql, false);
                        t_sql = "delete from \"tbl_AssertRecord\" where \"ID\"='" + Integer.toString(t_cmds.get((int)i).id) + "'";
                        this.updateRecordBySQL(t_sql, false);
                        ++i;
                    }
                    if (bCommit && t_cmds.size() > 0) {
                        this.commit();
                    }
                }
                catch (SQLException e) {
                    Tool.alertMSG(null, "@DBService#clearCase, SQLException=" + e.getMessage());
                    if (bCommit) {
                        this.rollback();
                    }
                    try {
                        if (bCommit) {
                            this.close(null);
                        }
                    }
                    catch (SQLException e2) {
                        Tool.logIfDebug(e2, "@DBService#clearCase");
                    }
                }
            }
            finally {
                try {
                    if (bCommit) {
                        this.close(null);
                    }
                }
                catch (SQLException e) {
                    Tool.logIfDebug(e, "@DBService#clearCase");
                }
            }
        }
    }

    public String getCaseStatus(String casename, String begin, String end) {
        String t_result = "";
        String num_all = "";
        String num_incomp = "";
        ArrayList<String> sqls = new ArrayList<String>();
        String t_sql = "select count(*) from \"tbl_TestCommandRecord\" where \"TestCase\"='" + casename + "' and \"ID\">='" + begin + "' and \"ID\"<='" + end + "'";
        sqls.add(t_sql);
        sqls.add(String.valueOf(t_sql) + " and \"ArgStatus\" like '%false%'");
        t_sql = "select count(*) from \"tbl_ObjectRecord\" where \"TestCase\"='" + casename + "' and \"TestID\">='" + begin + "' and \"TestID\"<='" + end + "'";
        sqls.add(t_sql);
        sqls.add(String.valueOf(t_sql) + " and \"Completed\"='false'");
        t_sql = "select count(*) from \"tbl_AssertRecord\" where \"ID\">='" + begin + "' and \"ID\"<='" + end + "'";
        sqls.add(t_sql);
        sqls.add(String.valueOf(t_sql) + " and \"Completed\"='false'");
        if (this.m_process == null) {
            ResultSet t_res;
            try {
                this.m_statement = s_connect.createStatement();
                t_res = this.m_statement.executeQuery((String)sqls.get(0));
                num_all = t_res.next() ? t_res.getString(1) : "0";
                t_res.close();
            }
            catch (SQLException e) {
                Tool.logIfDebug(e, "@DBService#getCaseStatus");
            }
            try {
                t_res = this.m_statement.executeQuery((String)sqls.get(1));
                num_incomp = t_res.next() ? t_res.getString(1) : "0";
                t_res.close();
            }
            catch (SQLException e) {
                Tool.logIfDebug(e, "@DBService#getCaseStatus");
            }
            t_result = "TestCommandRecord(incompleted/all) = " + num_incomp + " / " + num_all + "\n";
            try {
                t_res = this.m_statement.executeQuery((String)sqls.get(2));
                num_all = t_res.next() ? t_res.getString(1) : "0";
                t_res.close();
            }
            catch (SQLException e) {
                Tool.logIfDebug(e, "@DBService#getCaseStatus");
            }
            try {
                t_res = this.m_statement.executeQuery((String)sqls.get(3));
                num_incomp = t_res.next() ? t_res.getString(1) : "0";
                t_res.close();
            }
            catch (SQLException e) {
                Tool.logIfDebug(e, "@DBService#getCaseStatus");
            }
            t_result = String.valueOf(t_result) + "ObjectRecord(incompleted/all) = " + num_incomp + " / " + num_all + "\n";
            try {
                t_res = this.m_statement.executeQuery((String)sqls.get(4));
                num_all = t_res.next() ? t_res.getString(1) : "0";
                t_res.close();
            }
            catch (SQLException e) {
                Tool.logIfDebug(e, "@DBService#getCaseStatus");
            }
            try {
                t_res = this.m_statement.executeQuery((String)sqls.get(5));
                num_incomp = t_res.next() ? t_res.getString(1) : "0";
                t_res.close();
            }
            catch (SQLException e) {
                Tool.logIfDebug(e, "@DBService#getCaseStatus");
            }
            try {
                this.close(null);
            }
            catch (SQLException e) {
                Tool.logIfDebug(e, "@DBService#getCaseStatus");
            }
            t_result = String.valueOf(t_result) + "AssertRecord(incompleted/all) = " + num_incomp + " / " + num_all + "\n";
        } else {
            try {
                String t_json = this.sendCommand("getCaseStatus", Tool.getJSONfromObject(sqls));
                t_result = (String)Tool.getObjectfromJSON(String.class, t_json);
            }
            catch (IOException | SQLException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        }
        return t_result;
    }

    private boolean createDBMediator(String connStr, String uid, String pwd) {
        String j_path = Tool.s_userdir;
        String t_connect = "-connectStr:" + Tool.esq4CMD(connStr);
        String t_gc = "-gc:" + Boolean.toString(this.m_gc).toLowerCase();
        ProcessBuilder t_pb = new ProcessBuilder("java", "-jar", String.valueOf(Tool.s_jarname) + ".jar", "-remoteDB", t_connect, "-uid:" + Tool.esq4CMD(uid), "-pwd:" + Tool.esq4CMD(pwd), t_gc);
        if (j_path != null && j_path.length() > 0) {
            File t_dir = new File(j_path);
            t_pb.directory(t_dir);
        }
        try {
            t_pb.redirectErrorStream(true);
            this.m_process = t_pb.start();
            this.m_resultReader = new BufferedReader(new InputStreamReader(this.m_process.getInputStream(), "UTF-8"));
            this.m_commandWriter = new OutputStreamWriter(this.m_process.getOutputStream(), "UTF-8");
            String t_result = this.sendCommand(null, null);
            if (t_result != null) {
                t_result.matches("^<(fatal|error).*$");
            }
        }
        catch (IOException | SQLException e) {
            Tool.alertMSG(null, String.valueOf(new String(e.getMessage().getBytes())) + " in DBService#createDBMediatorB");
            this.m_process.destroy();
            this.m_process = null;
            return false;
        }
        return true;
    }

    private String sendCommand(String cmd, String arg_string) throws IOException, SQLException {
        String t_result;
        if (cmd != null) {
            String t_cmd = "<" + cmd + ">" + arg_string + "</" + cmd + ">\n";
            this.m_commandWriter.write(t_cmd);
            this.m_commandWriter.flush();
        }
        if ((t_result = Tool.readResultFromStream(this.m_resultReader, false)) != null && t_result.length() > 0) {
            try {
                ArrayList<String> esq_result = Fson.escapeBraket(t_result, "\"");
                Pattern t_pat = Pattern.compile("^\\s*<(\\w+)>([\\s\\S]*)</(\\w+)>\\s*$");
                Matcher t_m = t_pat.matcher(esq_result.get(0));
                if (t_m.find() && t_m.group(1).equals(t_m.group(3))) {
                    String response = t_m.group(2);
                    response = Fson.restoreBraket(response, esq_result);
                    if ("result".equals(t_m.group(1))) {
                        return response;
                    }
                    if ("error".equals(t_m.group(1)) || "fatal".equals(t_m.group(1))) {
                        throw new SQLException(response);
                    }
                }
            }
            catch (ParseException e) {
                Tool.alertMSG(null, String.valueOf(new String(e.getMessage().getBytes())) + " in DBService#sendCommand");
            }
        }
        return null;
    }

    public ArrayList<HashMap<String, String>> selectBySQL(String sql) throws Exception {
        try {
            String t_result = this.sendCommand("selectBySQL", sql);
            if (t_result != null) {
                return (ArrayList)Tool.getObjectfromJSON(ArrayList.class, t_result);
            }
        }
        catch (IOException | SQLException e) {
            Tool.alertMSG(null, e.getMessage());
        }
        throw new IOException("");
    }
}

