/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.run;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.AssertRecord;
import com.ftinc.si.assist.test.CodeProcessor;
import com.ftinc.si.assist.test.DBService;
import com.ftinc.si.assist.test.Fson;
import com.ftinc.si.assist.test.TestLogger;
import com.ftinc.si.assist.test.Tool;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class VCentral {
    private static HashMap<String, Object> _map = null;
    private static int cur_cmd4Assertables = 0;
    private static HashMap<String, String> _tblMap = new HashMap();
    private static HashMap<String, DBService> _dbs = new HashMap();
    private static final Pattern jdbc_info_pat = Pattern.compile("\\[\\?\\(@\\.(\\w+)='([^'\"\\]]+)'\\)\\]");
    private static final Pattern db_set_pat = Pattern.compile("^\"?([^\\[\\]]+?)\"?\\[(.+)\\]$");
    private static final Pattern db_test_pat = Pattern.compile("\"?([^\\[]+?)\"?\\[(.+)\\]\\.([^\\[\\]]+)\\s*");
    private static Document s_doc;
    private static ArrayList<String[]> s_tag_adjustmap;

    static {
        s_tag_adjustmap = new ArrayList();
    }

    public static void clear() {
        cur_cmd4Assertables = 0;
        _map = null;
        for (Map.Entry<String, DBService> entry : _dbs.entrySet()) {
            entry.getValue().destroy();
        }
        _tblMap = new HashMap();
        _dbs = new HashMap();
    }

    public static void prepare(HashMap<String, Object> map) {
        if (_map == null) {
            _map = new HashMap();
        }
        if (Tool.curID != cur_cmd4Assertables) {
            cur_cmd4Assertables = Tool.curID;
            if (_map.containsKey("_ASSERTABLES")) {
                _map.remove("_ASSERTABLES");
            }
            if (_map.containsKey("_POST_EXECS")) {
                _map.remove("_POST_EXECS");
            }
        }
        if (map != null) {
            String t_key;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                t_key = entry.getKey();
                if (t_key.startsWith("dbadd ")) {
                    t_key = t_key.replaceFirst("dbadd\\s*", "");
                    VCentral.addJDBC(t_key, (ArrayList)entry.getValue());
                    continue;
                }
                if (!t_key.startsWith("exec before")) continue;
                ArrayList t_list = (ArrayList)entry.getValue();
                String t_path = (String)t_list.get(0);
                t_list.remove(0);
                String[] t_cmds = t_list.toArray(new String[t_list.size()]);
                int t_res = Tool.executeCommand(new StringBuilder(), t_path, t_cmds);
                if (t_res <= 0) continue;
                Tool.alertAndExit(String.valueOf(t_path) + Messages.getString("VCentral.8") + Integer.toString(t_res), null, Tool.curID);
            }
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                HashMap t_map;
                t_key = entry.getKey();
                if (t_key.startsWith("dbset")) {
                    VCentral.updateByJsonPath(t_key, (HashMap)entry.getValue());
                    continue;
                }
                if (t_key.matches("^\\w+test\\s.*$")) {
                    if (!_map.containsKey("_ASSERTABLES")) {
                        _map.put("_ASSERTABLES", new HashMap());
                    }
                    t_map = (HashMap)_map.get("_ASSERTABLES");
                    t_map.put(t_key, (String)map.get(t_key));
                    continue;
                }
                if (t_key.startsWith("exec after")) {
                    if (!_map.containsKey("_POST_EXECS")) {
                        _map.put("_POST_EXECS", new HashMap());
                    }
                    t_map = (HashMap)_map.get("__POST_EXECS");
                    ArrayList t_list = (ArrayList)entry.getValue();
                    String t_path = (String)t_list.get(0);
                    t_list.remove(0);
                    String[] t_cmds = t_list.toArray(new String[t_list.size()]);
                    t_map.put(t_path, Tool.getJSONfromObject(t_cmds));
                    continue;
                }
                _map.put(t_key, entry.getValue());
            }
        }
    }

    public static String getJson() {
        return Tool.getJSONfromObject(_map);
    }

    private static void addJDBC(String jdbc_info, ArrayList<String> tables) {
        String con_str = "";
        String uid = "";
        String pwd = "";
        Matcher t_m = jdbc_info_pat.matcher(jdbc_info);
        while (t_m.find()) {
            String t_key = t_m.group(1);
            String t_val = t_m.group(2);
            switch (t_key) {
                case "jdbc": {
                    con_str = t_val;
                    break;
                }
                case "uid": {
                    uid = t_val;
                    break;
                }
                case "pwd": {
                    pwd = t_val;
                }
            }
        }
        int i = 0;
        while (i < tables.size()) {
            VCentral.addTable(tables.get(i), con_str, uid, pwd);
            ++i;
        }
    }

    private static void addTable(String tableName, String jdbsStr, String uid, String pwd) {
        if (!_tblMap.containsKey(tableName = tableName.matches("^[^\\.]+\\.[^\\.]+$") ? tableName.replaceFirst("^([^\\.]+)\\.([^\\.]+)$", "$1" + Matcher.quoteReplacement(".") + "\"$2\"") : "\"" + tableName + "\"")) {
            DBService ds;
            _tblMap.put(tableName, jdbsStr);
            if (!_dbs.containsKey(jdbsStr) && (ds = new DBService(true, true)).init(jdbsStr, uid, pwd)) {
                _dbs.put(jdbsStr, ds);
            }
        }
    }

    protected static String esq(String str) {
        if (str != null) {
            String t_str = Tool.replaceB(str, "'", "''");
            return t_str;
        }
        return "";
    }

    private static void updateByJsonPath(String key, HashMap<String, String> vals) {
        String t_key = key.replaceFirst("dbset\\s*", "");
        if (t_key.toLowerCase().startsWith("SQL_")) {
            String xsql = vals.get("@sql");
            String tblName = null;
            if (xsql.toLowerCase().matches("insert\\s+into\\s+([^\\s\\(]+)[\\s\\S]*$")) {
                tblName = xsql.replaceFirst("(?i)insert\\s+into\\s+([^\\s\\(]+)[\\s\\S]*$", "$1");
            } else if (xsql.toLowerCase().matches("update\\s+([^\\s]+)\\s+set[\\s\\S]*$")) {
                tblName = xsql.replaceFirst("(?i)update\\s+([^\\s]+)\\s+set[\\s\\S]*$", "$1");
            } else if (xsql.toLowerCase().matches("delete\\s+from\\s+([^\\s\\(]+)[\\s\\S]*$")) {
                tblName = xsql.replaceFirst("(?i)delete\\s+from\\s+([^\\s\\(]+)[\\s\\S]*$", "$1");
            }
            try {
                _dbs.get(_tblMap.get(tblName)).updateRecordBySQL(xsql, true);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return;
        }
        Matcher t_m = db_set_pat.matcher(t_key);
        if (t_m.find()) {
            String tableName = t_m.group(1);
            tableName = tableName.matches("^[^\\.]+\\.[^\\.]+$") ? tableName.replaceFirst("^([^\\.]+)\\.([^\\.]+)$", "$1" + Matcher.quoteReplacement(".") + "\"$2\"") : "\"" + tableName + "\"";
            if (_tblMap.containsKey(tableName)) {
                String[] t_conds = t_m.group(2).split("\\]\\[");
                int i = 0;
                while (i < t_conds.length) {
                    if (!t_conds[i].matches("^\\?\\(@\\..*\\)$")) {
                        TestLogger.err(String.valueOf(t_conds[i]) + Messages.getString("VCentral.42"));
                        return;
                    }
                    t_conds[i] = t_conds[i].replaceFirst("\\s*" + Pattern.quote("?(@."), "\"");
                    t_conds[i] = t_conds[i].replaceFirst("\\s*([<>=]+|like)\\s*['\"]?(.+?)['\"]?\\s*\\)\\s*$", "\"$1'$2'");
                    ++i;
                }
                String t_list = VCentral.selectByJsonPath(t_key = String.valueOf(t_key) + ".*");
                if (t_list == null) {
                    String t_sql = "insert into " + tableName + " ";
                    String str_cols = "(";
                    String str_vals = "values (";
                    int j = 0;
                    while (j < t_conds.length) {
                        if (j > 0) {
                            str_cols = String.valueOf(str_cols) + ",";
                            str_vals = String.valueOf(str_vals) + ",";
                        }
                        String[] temp = t_conds[j].split("[<>=]+|like");
                        str_cols = String.valueOf(str_cols) + temp[0];
                        str_vals = String.valueOf(str_vals) + VCentral.esq(temp[1]);
                        ++j;
                    }
                    for (Map.Entry<String, String> entry : vals.entrySet()) {
                        str_cols = String.valueOf(str_cols) + ",\"" + entry.getKey() + "\"";
                        str_vals = String.valueOf(str_vals) + ",'" + VCentral.esq(entry.getValue().toString()) + "'";
                    }
                    str_cols = String.valueOf(str_cols) + ")";
                    str_vals = String.valueOf(str_vals) + ")";
                    try {
                        _dbs.get(_tblMap.get(tableName)).updateRecordBySQL(String.valueOf(t_sql) + str_cols + str_vals, true);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                } else {
                    String t_sql = "update \"" + tableName + "\" set ";
                    boolean b_add = false;
                    for (Map.Entry<String, String> entry : vals.entrySet()) {
                        if (b_add) {
                            t_sql = String.valueOf(t_sql) + ",";
                        }
                        b_add = true;
                        t_sql = String.valueOf(t_sql) + "\"" + entry.getKey() + "\"='" + VCentral.esq(entry.getValue().toString()) + "'";
                    }
                    String str_where = " ";
                    int i2 = 0;
                    while (i2 < t_conds.length) {
                        str_where = i2 > 0 ? String.valueOf(str_where) + " and " : String.valueOf(str_where) + "where ";
                        str_where = String.valueOf(str_where) + t_conds[i2];
                        ++i2;
                    }
                    try {
                        _dbs.get(_tblMap.get(tableName)).updateRecordBySQL(String.valueOf(t_sql) + str_where, true);
                    }
                    catch (SQLException e) {
                        TestLogger.err(e.getMessage());
                    }
                }
            }
        } else {
            TestLogger.err("Parse Error:" + t_key + Messages.getString("VCentral.69"));
        }
    }

    private static String selectByJsonPath(String key) {
        String varkey = key.replaceFirst("dbtest\\s*", "");
        if (varkey.toLowerCase().startsWith("SQL_")) {
            HashMap t_map = (HashMap)_map.get("_ASSERTABLES");
            try {
                String tblName = ((String)t_map.get(key)).replaceFirst("(?i)^.*?from\\s([^\\s]+)\\s[\\s\\S]*$", "$1");
                ArrayList<HashMap<String, String>> t_result = _dbs.get(_tblMap.get(tblName)).selectBySQL((String)t_map.get(key));
                if (t_result.size() > 0) {
                    return "true";
                }
            }
            catch (Exception e) {
                TestLogger.err("Pipe Error:" + key + " execution no response.");
                return null;
            }
            return "false";
        }
        Matcher t_m = db_test_pat.matcher(varkey);
        if (t_m.find()) {
            String tableName = t_m.group(1);
            tableName = tableName.matches("^[^\\.]+\\.[^\\.]+$") ? tableName.replaceFirst("^([^\\.]+)\\.([^\\.]+)$", "$1" + Matcher.quoteReplacement(".") + "\"$2\"") : "\"" + tableName + "\"";
            String selectedCol = t_m.group(3).replaceFirst("^[\"']?(.+?)[\"']?$", "$1");
            if (_tblMap.containsKey(tableName)) {
                String[] t_conds = t_m.group(2).split("\\]\\[");
                String str_where = " ";
                int i = 0;
                while (i < t_conds.length) {
                    str_where = i > 0 ? String.valueOf(str_where) + " and " : String.valueOf(str_where) + "where ";
                    if (!t_conds[i].matches("^\\s*\\?\\(@\\..*\\s*\\)\\s*$")) {
                        TestLogger.err(String.valueOf(t_conds[i]) + Messages.getString("VCentral.85"));
                        return null;
                    }
                    t_conds[i] = t_conds[i].replaceFirst("^\\s*" + Pattern.quote("?(@."), "\"");
                    t_conds[i] = t_conds[i].replaceFirst("\\s*([<>=]+|like)\\s*['\"]?(.+?)['\"]?\\s*\\)\\s*", "\"$1'$2'");
                    str_where = String.valueOf(str_where) + t_conds[i];
                    ++i;
                }
                if (!"count(*)".equals(selectedCol)) {
                    selectedCol = "\"" + selectedCol + "\"";
                }
                String t_sql = "select " + selectedCol + " from " + tableName + " " + str_where;
                try {
                    ArrayList<HashMap<String, String>> t_result = _dbs.get(_tblMap.get(tableName)).selectBySQL(t_sql);
                    if (t_result != null && t_result.size() > 0) {
                        String str_result = "";
                        if ("count(*)".equals(selectedCol)) {
                            str_result = t_result.get(0).get("count");
                        } else {
                            int i2 = 0;
                            while (i2 < t_result.size()) {
                                HashMap<String, String> t_map = t_result.get(i2);
                                if (i2 > 0) {
                                    str_result = String.valueOf(str_result) + "\n";
                                }
                                int t_i = 0;
                                for (Map.Entry<String, String> entry : t_map.entrySet()) {
                                    if (t_i > 0) {
                                        str_result = String.valueOf(str_result) + "\t";
                                    }
                                    if (selectedCol.equals("*")) {
                                        str_result = String.valueOf(str_result) + entry.getKey() + ":" + entry.getValue().toString();
                                    } else if (entry.getKey().equals(selectedCol)) {
                                        str_result = String.valueOf(str_result) + entry.getValue().toString();
                                    }
                                    ++t_i;
                                }
                                ++i2;
                            }
                        }
                        return str_result;
                    }
                }
                catch (Exception e) {
                    TestLogger.err("Pipe Error:" + key + " execution no response.");
                    return null;
                }
            }
        }
        TestLogger.err("Parse Error:" + key + Messages.getString("VCentral.99"));
        return null;
    }

    public static Object getFakeObject(String ... vals) {
        if (vals[0].endsWith("[]")) {
            TestLogger.err("VCentral#getTObject>>" + vals[0] + Messages.getString("VCentral.102"));
            return null;
        }
        return Tool.getFakeInstance(vals);
    }

    public static Object getValue(String varName) {
        if (varName.startsWith("dbtest ")) {
            return VCentral.selectByJsonPath(varName);
        }
        if (varName.matches("^\\$[0-9_]+.*$")) {
            return VCentral.getValue("objtest " + varName);
        }
        if (varName.matches("^objtest\\s+\\$[0-9_]+.*$")) {
            String t_key = varName;
            t_key = varName.replaceFirst("^objtest\\s+(\\$[0-9_]+.*)$", "objtest " + Integer.toString(Tool.curID) + "$1");
            return VCentral.getValue(t_key);
        }
        if (varName.startsWith("objtest ")) {
            Pattern t_pat = Pattern.compile("objtest\\s+([\\w\\$]+)(.*)");
            Matcher t_m = t_pat.matcher(varName);
            if (t_m.find()) {
                String obj_id = t_m.group(1);
                String jpath = t_m.group(2);
                Object t_obj = null;
                if (obj_id.startsWith("$.")) {
                    return VCentral._value(_map, jpath);
                }
                if (obj_id.startsWith("$")) {
                    obj_id = String.valueOf(Integer.toString(Tool.curID)) + obj_id;
                }
                if ((t_obj = Tool.getInstance(obj_id)) != null) {
                    if (jpath.length() > 0) {
                        return VCentral._value(t_obj, jpath);
                    }
                    return t_obj;
                }
            }
        } else if (_map != null) {
            Object t_obj = VCentral._value(_map, varName);
            if (t_obj != null && t_obj.getClass().getName().equals("java.lang.String")) {
                return Tool.convert2Alias(t_obj.toString());
            }
            return t_obj;
        }
        return null;
    }

    private static Object _value(Object obj, String path) {
        ArrayList<Object> t_list;
        String jpath = path;
        if (!(jpath = jpath.replaceFirst("^\\.*(.+?)$", "$1")).startsWith("$")) {
            jpath = "$." + jpath;
        }
        boolean isSize = false;
        if (jpath.endsWith(".length()")) {
            isSize = true;
            jpath = jpath.substring(0, jpath.length() - 9);
        }
        if (jpath.startsWith("$.[")) {
            jpath = "$" + jpath.substring(1);
        }
        if ((t_list = Fson.valueByJsonPath(obj, jpath)).size() > 0) {
            Object t_obj = t_list.get(0);
            if (isSize) {
                if (t_obj == null) {
                    return -1;
                }
                Class<?> t_c = t_obj.getClass();
                if (t_c.isArray()) {
                    return Array.getLength(t_obj);
                }
                if (List.class.isAssignableFrom(t_c)) {
                    return ((List)t_obj).size();
                }
                if (Map.class.isAssignableFrom(t_c)) {
                    return ((Map)t_obj).size();
                }
                Tool.logForTesting(null, String.valueOf(jpath) + "\" has not length/size method.");
                return -1;
            }
            return t_obj;
        }
        return null;
    }

    public static void logging(String str) {
        TestLogger.out("@out>>  " + str);
    }

    public static void loadXML(String src) throws ParserConfigurationException, SAXException, IOException {
        try {
            DocumentBuilderFactory t_fact = DocumentBuilderFactory.newInstance();
            DocumentBuilder t_builder = t_fact.newDocumentBuilder();
            s_doc = t_builder.parse(new ByteArrayInputStream(src.getBytes("UTF-8")));
        }
        catch (ParserConfigurationException e) {
            AssertRecord.setLost(e.getMessage());
            throw e;
        }
        catch (SAXException e) {
            AssertRecord.setLost(e.getMessage());
            throw e;
        }
        catch (IOException e) {
            AssertRecord.setLost(e.getMessage());
            throw e;
        }
    }

    public static String xmlContent(String path) throws XPathExpressionException {
        XPath t_xpath = XPathFactory.newInstance().newXPath();
        try {
            return t_xpath.evaluate(path, s_doc);
        }
        catch (XPathExpressionException e) {
            AssertRecord.setLost(e.getMessage());
            throw e;
        }
    }

    public static String getValueByXpath(String obj, String xpath) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        String xhtml = VCentral.html2XML(VCentral.getFakeObject(obj).toString());
        VCentral.loadXML(xhtml);
        return VCentral.xmlContent(xpath);
    }

    public static String html2XML(String data) {
        s_tag_adjustmap.add(new String[]{"li", "(<li[\\s>]|</ol>|</ul>)", "(<ol[\\s>]|<ul[\\s>]|</li>)"});
        s_tag_adjustmap.add(new String[]{"dt", "(<dt[\\s>]|</dl>)", "(<dl[\\s>]|</dt>)"});
        s_tag_adjustmap.add(new String[]{"dd", "(<dd[\\s>]|</dl>)", "(<dl[\\s>]|</dd>)"});
        s_tag_adjustmap.add(new String[]{"optgroup", "(<optgroup[\\s>]|</select>)", "(<select[\\s>]|</optgroup>)"});
        s_tag_adjustmap.add(new String[]{"option", "(<optgroup[\\s>]|</select>)", "(<select[\\s>]|</option>)"});
        s_tag_adjustmap.add(new String[]{"tr", "<(tr[\\s>]|</table>)", "(<table[\\s>]|</tr>)"});
        s_tag_adjustmap.add(new String[]{"th", "(<th[\\s>]|</tr>|</table>)", "(<table[\\s>]|</th>)"});
        s_tag_adjustmap.add(new String[]{"td", "(<td[\\s>]|</tr>|</table>)", "(<table[\\s>]|</td>)"});
        s_tag_adjustmap.add(new String[]{"tbody", "(<tbodyt[\\s>]|<tfoot[\\s>]|</table>)", "(<table[\\s>]|</tbody>)"});
        s_tag_adjustmap.add(new String[]{"thead", "(<tfoot[\\s>]|<tbody[\\s>]|<thead[\\s>]|</table>)", "(<table[\\s>]|</thead>)"});
        s_tag_adjustmap.add(new String[]{"tfoot", "(<<tfoot[\\s>]|</table>)", "(<table[\\s>]|</tfoot>)"});
        s_tag_adjustmap.add(new String[]{"a", "(<a[\\s>]|</ol>|</ul>|</div>|</table>)", "(<table[\\s>]|<td|<ul[\\s>]|<ol[\\s>]|<div[\\s>]|</a>)"});
        String t_str = data.replaceFirst("(?i)<!doctype.*?>", "");
        t_str = Tool.regReplaceAll(t_str, "<\\s*/([a-zA-Z\\-]+)\\s*>", "</$1>");
        t_str = t_str.replaceFirst("(?i)<html[^>]*?>", "<html>");
        t_str = t_str.replaceFirst("(?i)<head[\\s\\S]+?</head[^>]*>", "");
        t_str = Tool.regReplaceAll(t_str, "(?i)<(meta|link)(\\s[^>]*?/?\\s*>|>)", "");
        t_str = Tool.regReplaceAll(t_str, "(?i)</?[^apbiqu]\\s*>", "");
        t_str = Tool.regReplaceAll(t_str, "(?i)</?(br|p|rp|rt|nav|colgroup)(\\s[^>]*?>|>)", "");
        t_str = Tool.regReplaceAll(t_str, "&\\w+;", "");
        t_str = Tool.regReplaceAll(t_str, "(?i)<script[\\s\\S]*?</script>", "");
        t_str = Tool.regReplaceAll(t_str, "(?i)<noscript[\\s\\S]*?</noscript>", "");
        t_str = Tool.regReplaceAll(t_str, "\\s*<!\\-\\-[\\s\\S]*?\\-\\->\\s*", "");
        t_str = Tool.regReplaceAll(t_str, "<[^a-zA-Z/][^>]*>", "");
        t_str = Tool.regReplaceAll(t_str, "\\s[^\\s]*[\\+\\*/\\-\\.:;\\?,@\\^\\|='#\\$\\]\\[\\(\\)\\{\\}&%#!>\"<]=\"[^\"]*\"", " ");
        ArrayList<String> esq_list = CodeProcessor.escDQStrings2(t_str, "@@@@", 30);
        t_str = esq_list.get(0);
        t_str = Tool.regReplaceAll(t_str, "(<[a-zA-Z\\-]+\\s*[^>]*\\s[a-zA-Z\\-]+=)([^\\s\">]+)([\\s>])", "$1\"$2\"$3");
        t_str = Tool.regReplaceAll(t_str, "(\"[\\s]+[a-zA-Z\\-]+)(\\s+[a-zA-Z]|\\s*[/>])", "$1=" + Matcher.quoteReplacement("\"?\"") + " $2");
        t_str = Tool.regReplaceAll(t_str, "(<[a-zA-Z\\-]+\\s+[a-zA-Z\\-]+)(\\s+[a-zA-Z]|\\s*[/>])", "$1=" + Matcher.quoteReplacement("\"?\"") + " $2");
        t_str = VCentral.tagsToLowerCase(t_str);
        t_str = VCentral.removeDupAttrsInTag(t_str);
        String tag_str = "(wbr|hr|img|col|base|link|meta|input|keygen|area|param|embed|source|track|command|frame)";
        t_str = Tool.regReplaceAll(t_str, "(?i)(<" + tag_str + ")(\\s[^>]*[^/]>|>)", "$1/>");
        t_str = Tool.regReplaceAll(t_str, "(?i)\\s*<input\\s*[^>]*?type=['\"]hidden[\"'][^>]*?>\\s*", "");
        if (t_str.matches("^.*<\\?xml.*?>.*$")) {
            t_str = "<?xml version=\"1.0\" encoding=\"Shift_JIS\" ?>" + t_str;
        }
        ArrayList<String> t_list = new ArrayList<String>();
        t_str = VCentral.adjustCloseTags(t_str, t_list, 0);
        int i = t_list.size() - 1;
        while (i >= 0) {
            t_str = Tool.replaceB(t_str, "<Z" + Integer.toString(i) + "/>", t_list.get(i));
            --i;
        }
        t_str = VCentral.repairAttrsDQT(t_str, esq_list);
        return t_str;
    }

    private static String tagsToLowerCase(String str) {
        String t_str = str;
        ArrayList<String> done_list = new ArrayList<String>();
        Pattern t_pat = Pattern.compile("</?[\\w\\-]+[\\s>]|\\s[\\w\\-]+=");
        Matcher t_m = t_pat.matcher(t_str);
        while (t_m.find()) {
            String t_val = t_m.group();
            if (done_list.contains(t_val)) continue;
            t_str = Tool.replaceB(t_str, t_val, t_val.toLowerCase());
            done_list.add(t_val);
        }
        return t_str;
    }

    private static String repairAttrsDQT(String str, ArrayList<String> esq_list) {
        int j = 1;
        while (j < esq_list.size()) {
            String t_val = esq_list.get(j);
            t_val = Tool.replaceB(t_val, "<", "!&lt;");
            t_val = Tool.replaceB(t_val, ">", "!&gt;");
            t_val = Tool.replaceB(t_val, "&", "!&amp;");
            esq_list.set(j, t_val);
            ++j;
        }
        str = CodeProcessor.restoreDQString(str, "@@@@", esq_list);
        return str;
    }

    private static String removeDupAttrsInTag(String str) {
        String t_str = str;
        Pattern t_pat1 = Pattern.compile("<[^/][\\w\\-]*\\s+([\\s\\S]+?)>");
        Matcher t_m = t_pat1.matcher(t_str);
        while (t_m.find()) {
            String n_part;
            ArrayList<String> t_list = new ArrayList<String>();
            String n_replaced = n_part = t_m.group();
            Pattern t_pat2 = Pattern.compile("([\\w\\-]+)(\\s*=\\s*\")([^\"]+)\"");
            Matcher t_m1 = t_pat2.matcher(t_m.group(1));
            while (t_m1.find()) {
                if (t_list.contains(t_m1.group(1))) {
                    n_replaced = Tool.replaceB(n_replaced, t_m1.group(), "");
                    continue;
                }
                t_list.add(t_m1.group(1));
            }
            if (n_replaced.length() >= n_part.length()) continue;
            t_str = Tool.replaceB(t_str, n_part, n_replaced);
        }
        return t_str;
    }

    private static String adjustCloseTags(String str, ArrayList<String> xlist, int pos) {
        boolean is_top = false;
        if (str.startsWith("<?xml = version=")) {
            is_top = true;
        }
        String t_str = str;
        int n = pos;
        while (s_tag_adjustmap.size() > n) {
            String[] cur_elm = s_tag_adjustmap.get(n);
            String regHead = cur_elm[0];
            String regTail = cur_elm[1];
            String regNG = cur_elm[2];
            ArrayList dups = new ArrayList();
            Pattern t_pat = Pattern.compile("(?i)<" + regHead + "(\\s*>|\\s[^z][^>]+>)([\\s\\S]*?)" + regTail);
            Matcher t_m0 = t_pat.matcher(t_str);
            if (t_m0.find()) {
                String next_part = t_m0.group();
                if (!t_m0.group(1).contains(" z_suppled=") && !dups.contains(next_part)) {
                    String next_replaced = "";
                    String htag = "<" + regHead + t_m0.group(1);
                    String inner_txt = String.valueOf(t_m0.group(2)) + t_m0.group(3);
                    String tag_tail = t_m0.group(3).toLowerCase();
                    String tag_tail2 = tag_tail.replaceFirst("^</?(.*)[\\s>]$", "<$1");
                    Pattern t_patNG = Pattern.compile("(?i)^([\\s\\S]*?)" + regNG + "([\\s\\S]*)" + regTail + "$");
                    Matcher t_m = t_patNG.matcher(inner_txt);
                    if (t_m.find()) {
                        String tag_ng = t_m.group(2).toLowerCase();
                        String tag_ng2 = tag_ng.replaceFirst("</?([a-zA-Z]+)[>\\s]?", "$1");
                        if (regHead.equals(tag_ng2)) {
                            if (next_part.matches("(?i)^<(" + regHead + "[\\s>][\\s\\S]*?<)(/" + regHead + "[\\s\\S]*)$")) {
                                next_replaced = next_part.replaceFirst("(?i)^(<" + regHead + ")(>|\\s[^>]*>)([\\s\\S]*</" + regHead + ")", "$1 z-suppled=\"true\"$2$3");
                                t_str = Tool.replaceB(t_str, next_part, next_replaced);
                            } else {
                                ++n;
                            }
                        } else if (tag_ng.contains("</")) {
                            ++n;
                        } else {
                            String sub_xml = Tool.getClosedBlock(t_str, t_m.end(1) + 1, "<" + tag_ng2, "</" + tag_ng2 + ">");
                            if (sub_xml != null && sub_xml.length() > 0) {
                                next_replaced = sub_xml;
                                int k = n;
                                if (!next_replaced.matches("^[\\s\\S]*<" + regHead + "(?!\\sz\\-suppled=)[\\s\\S]*$")) {
                                    ++k;
                                }
                                int i = k;
                                while (i < s_tag_adjustmap.size()) {
                                    String[] t_tags = s_tag_adjustmap.get(i);
                                    if (next_replaced.matches("^.*<" + t_tags[0] + "(>|\\s[^>]*>)")) {
                                        next_replaced = VCentral.adjustCloseTags(next_replaced, xlist, i);
                                        break;
                                    }
                                    ++i;
                                }
                                next_replaced = "<Z" + Integer.toString(xlist.size()) + "/>";
                                xlist.add(next_replaced);
                                t_str = t_str.replaceFirst("(?i)(" + Pattern.quote(String.valueOf(htag) + t_m.group(1)) + ")" + Pattern.quote(sub_xml), "$1" + next_replaced);
                                break;
                            }
                            Tool.alertMSG(null, "adjustCloseTags>>end of tag_ng2=" + tag_ng2 + "@(pos=" + Integer.toString(t_m.end(1) + 1) + ") not found.\n\nhtml=" + t_str);
                            ++n;
                        }
                    } else if (tag_tail.startsWith("</")) {
                        Pattern t_pat3 = Pattern.compile("(?i)" + tag_tail2 + "(>|\\s[^>]*>)" + "([\\s\\S]*?)" + tag_tail + "$");
                        Matcher t_m3 = t_pat3.matcher(t_str);
                        if (!t_m3.find()) {
                            t_pat3 = Pattern.compile(String.valueOf(tag_tail2) + "(>|\\s[^>]*>)" + "([\\s\\S]*?)" + Pattern.quote(next_part));
                            t_m3 = t_pat3.matcher(t_str);
                            if (t_m3.find()) {
                                next_part = t_m3.group();
                                Pattern t_pat4 = Pattern.compile("^(.*<" + regHead + ")(>|\\s[^>]*>)([\\s\\S]*)$");
                                Matcher t_m4 = t_pat4.matcher(next_part);
                                if (t_m4.find()) {
                                    String t_block = Tool.getClosedRange(t_m4.group(3));
                                    String t_reg = Pattern.quote(String.valueOf(t_m4.group(1)) + t_m4.group(2) + t_block);
                                    String t_repl = String.valueOf(t_m4.group(1)) + " z-suppled=\"true\"" + t_m4.group(2) + Matcher.quoteReplacement(t_block) + "</" + regHead + ">";
                                    next_replaced = next_part.replaceFirst(t_reg, t_repl);
                                } else {
                                    next_replaced = "";
                                }
                            } else {
                                next_replaced = "";
                            }
                        } else {
                            next_replaced = next_part = t_m3.group();
                        }
                        if (next_replaced.length() > 0) {
                            int k = n;
                            if (!next_replaced.matches("^[\\s\\S]*<" + regHead + "(?!\\sz\\-suppled=)[\\s\\S]*$")) {
                                // empty if block
                            }
                            int i = ++k;
                            while (i < s_tag_adjustmap.size()) {
                                String[] t_tags = s_tag_adjustmap.get(i);
                                if (next_replaced.matches("^.*<" + t_tags[0] + "(>|\\s[^>]*>)")) {
                                    next_replaced = VCentral.adjustCloseTags(next_replaced, xlist, i);
                                    break;
                                }
                                ++i;
                            }
                            xlist.add(next_replaced);
                            next_replaced = "<Z" + Integer.toString(xlist.size()) + "/>";
                            t_str = Tool.replaceB(t_str, next_part, next_replaced);
                        } else {
                            ++n;
                        }
                    } else {
                        String t_block = Tool.getClosedRange(t_m0.group(2));
                        next_replaced = next_part.replaceFirst("(?i)^(<" + regHead + ")(" + Pattern.quote(String.valueOf(t_m0.group(1)) + t_block) + ")([\\s\\S]*)", "$1 z-suppled=\"true\"$2</" + regHead + ">$3");
                        t_str = Tool.replaceB(t_str, next_part, next_replaced);
                    }
                }
            }
            ++n;
        }
        if (!is_top) {
            t_str = VCentral.suppled(t_str);
        }
        return t_str;
    }

    private static String suppled(String str) {
        String t_str = str;
        Pattern t_pat = Pattern.compile("^(<\\w+)([^>]*?>)");
        Matcher t_m = t_pat.matcher(t_str);
        if (t_m.find()) {
            t_str = t_m.replaceFirst("$1 z-suppled=\"true\"$2");
        }
        return t_str;
    }

    public static String pickNumber(String str) {
        if (str != null) {
            String t_str = "";
            t_str = str.replaceFirst("^[^0-9]*?([\\+0-9\\-\\.,]+)[\\s\\S]*$", "$1");
            if ((t_str = Tool.replaceB(t_str, ",", "")).matches("^[\\+\\-]?[0-9]+\\.?[0-9]*$")) {
                return t_str;
            }
        }
        return null;
    }

    public static boolean greaterThan(String strA, String strB, boolean b_eq, boolean b_big) {
        strA = VCentral.pickNumber(strA);
        if (strB.matches("^[\\+\\-]?[0-9]+$")) {
            if (b_big) {
                BigInteger t_i = (BigInteger)Tool.getObjectfromJSON(BigInteger.class, strA);
                BigInteger t_j = (BigInteger)Tool.getObjectfromJSON(BigInteger.class, strB);
                if (b_eq) {
                    return t_i.compareTo(t_j) >= 0;
                }
                return t_i.compareTo(t_j) > 0;
            }
            Long t_i = (Long)Tool.getObjectfromJSON(Long.class, strA);
            Long t_j = (Long)Tool.getObjectfromJSON(Long.class, strB);
            if (b_eq) {
                return t_i >= t_j;
            }
            return t_i > t_j;
        }
        if (strB.matches("[\\+\\-]?[0-9]+\\.?[0-9]+")) {
            if (b_big) {
                BigDecimal t_i = (BigDecimal)Tool.getObjectfromJSON(BigDecimal.class, strA);
                BigDecimal t_j = (BigDecimal)Tool.getObjectfromJSON(BigDecimal.class, strB);
                if (b_eq) {
                    return t_i.compareTo(t_j) >= 0;
                }
                return t_i.compareTo(t_j) > 0;
            }
            Double t_i = (Double)Tool.getObjectfromJSON(Double.class, strA);
            Double t_j = (Double)Tool.getObjectfromJSON(Double.class, strB);
            if (b_eq) {
                return t_i >= t_j;
            }
            return t_i > t_j;
        }
        return false;
    }

    public static boolean lessThan(String strA, String strB, boolean b_eq, boolean b_big) {
        strA = VCentral.pickNumber(strA);
        if (strB.matches("^[\\+\\-]?[0-9]+$")) {
            if (b_big) {
                BigInteger t_i = (BigInteger)Tool.getObjectfromJSON(BigInteger.class, strA);
                BigInteger t_j = (BigInteger)Tool.getObjectfromJSON(BigInteger.class, strB);
                if (b_eq) {
                    return t_i.compareTo(t_j) <= 0;
                }
                return t_i.compareTo(t_j) < 0;
            }
            Long t_i = (Long)Tool.getObjectfromJSON(Long.class, strA);
            Long t_j = (Long)Tool.getObjectfromJSON(Long.class, strB);
            if (b_eq) {
                return t_i <= t_j;
            }
            return t_i < t_j;
        }
        if (strB.matches("[\\+\\-]?[0-9]+\\.?[0-9]+")) {
            if (b_big) {
                BigDecimal t_i = (BigDecimal)Tool.getObjectfromJSON(BigDecimal.class, strA);
                BigDecimal t_j = (BigDecimal)Tool.getObjectfromJSON(BigDecimal.class, strB);
                if (b_eq) {
                    return t_i.compareTo(t_j) <= 0;
                }
                return t_i.compareTo(t_j) < 0;
            }
            Double t_i = (Double)Tool.getObjectfromJSON(Double.class, strA);
            Double t_j = (Double)Tool.getObjectfromJSON(Double.class, strB);
            if (b_eq) {
                return t_i < t_j;
            }
            return t_i < t_j;
        }
        return false;
    }

    public static boolean equalN(String strA, String strB, boolean b_big) {
        String xstrA = VCentral.pickNumber(strA);
        if (strB.matches("^[\\+\\-]?[0-9]+$")) {
            if (b_big) {
                BigInteger t_i = (BigInteger)Tool.getObjectfromJSON(BigInteger.class, xstrA);
                BigInteger t_j = (BigInteger)Tool.getObjectfromJSON(BigInteger.class, strB);
                return t_i.equals(t_j);
            }
            Long t_i = (Long)Tool.getObjectfromJSON(Long.class, xstrA);
            Long t_j = (Long)Tool.getObjectfromJSON(Long.class, strB);
            return t_i.equals(t_j);
        }
        if (strB.matches("[\\+\\-]?[0-9]+\\.?[0-9]+")) {
            if (b_big) {
                BigDecimal t_i = (BigDecimal)Tool.getObjectfromJSON(BigDecimal.class, xstrA);
                BigDecimal t_j = (BigDecimal)Tool.getObjectfromJSON(BigDecimal.class, strB);
                return t_i.equals(t_j);
            }
            Double t_i = (Double)Tool.getObjectfromJSON(Double.class, xstrA);
            Double t_j = (Double)Tool.getObjectfromJSON(Double.class, strB);
            return t_i.equals(t_j);
        }
        return strA.equals(strB);
    }
}

