package com.ftinc.si.assist.test.web;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

import com.ftinc.si.assist.test.Tool;


public class Clock extends PageAction {
	private static long s_start_time = 0; //System.currentTimeMillis();で取得した計測開始時間

	//optionsにより、開始"start"か終了"end"かを判定する。
	//ログ：現在のTestCaseはToolから取得。arg_mapにmessageがあり、それで計測対象を識別する。

	//画面の準備ができるまで待つ。Actionごとに待ち方が異なる。
	protected WebElement waitUntil(WebDriver drv) {
		return null;
	}

	//Action実行の本体
	protected void doCore(WebDriver drv, WebElement elm) {
		//elmがクリック可能になった瞬間が計測開始、終了のタイミング。
		if (options.length() == 0) {
			//計測開始
			s_start_time = System.currentTimeMillis();
		} else if ("end".equals(options)) {
			//計測終了
			long t_end = System.currentTimeMillis();

			String t_msg = (String)arg_map.get("value");
			if (t_msg == null) {
				t_msg = (String)arg_map.get("message");
			}
			if (t_msg == null) {
				t_msg = "";
			} else {
				t_msg = " name=\"" + t_msg + "\"";
			}

			//<ftClock millisecs="ミリ秒" name="名前：endClockの引数"/>>
			Tool.logForTesting(null, "<ftClock millisecs=\"" + Long.toString(t_end - s_start_time) + t_msg + "/>");
		}
	}
}
