package com.ftinc.si.assist.test.web;

import java.util.ArrayList;

import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.interactions.Actions;

public class Drag extends PageAction {

	//操作の実行。返却値はScript実行や要素取得などのアクションの場合には結果文字列、通常のアクションはnullが返る。
	public ArrayList<String> doAction(WebDriver drv) {
		try {
			WebElement fromElm = waitUntil(drv);
			if (getArg("X") != null || getArg("Y") != null) {
				//単なるマウスドラグ
				int x = 0;int y = 0;
				if (getArg("X") != null) {
					x = Integer.parseInt(getArg("X").toString());
				}
				if (getArg("Y") != null) {
					x = Integer.parseInt(getArg("Y").toString());
				}

				Actions move = new Actions(drv);
				Action action  = move.dragAndDropBy(fromElm, x, y).build();
				action.perform();
			} else {
				Actions drag = new Actions(drv);
				drag.clickAndHold(fromElm).build().perform();
			}
		} catch (TimeoutException e) {
			//実際はタイムアウトではなく見つからなかった。
			String target = getXpath();
			if (arg_map.containsKey("itemID")) {
				target += " itemID=" + arg_map.get("itemID").toString();
			}
			throw new NotFoundException("\t\tdrag " + e.getMessage() + " ,where " + target); //$NON-NLS-1$
		}
		return null;
	}
}
