package com.ftinc.si.assist.test.gui;

import java.util.HashMap;

import javax.swing.JMenuItem;

import com.ftinc.si.assist.test.ArgumentIF;
import com.ftinc.si.assist.test.AssertIF;
import com.ftinc.si.assist.test.TestCaseIF;
import com.ftinc.si.assist.test.TestCommandIF;

public interface Plugin {
	//Plugin独自のメニューアイテム（サブメニューを含む）を追加する
	//引数は呼ばれる場面を示す。
	//addCommand：新規コマンド追加、addArg:可変長引数の場合、引数の追加、editArg:引数の編集、editAssert：判定条件の編集
	public JMenuItem getMenuItem(String cmd);
	
	
	//追加・編集メニューアイテム作成にあたり、
	//0：関係なし、1:追加希望、2：独占的要求(他を排除)を主張する。
	//要求が認められると、独占的にメニューアイテムを作れる。あるいは、メニューを空にして表示しないこともできる。
	//recとstackにより、どんなオブジェクトを編集しようとしているか判定して、要求の強さを決める。
	//getMenuItemの処理内容と同期を取ることがポイント。
	//引数（テストケース、テストコマンド(コマンド追加の際はサンプルとして先頭コマンドがくる)、 "$n"/"ASSERT"）により判定
	public int getPriority(TestCaseIF cs, TestCommandIF rec, String stack);

	
	//新規追加（addArg）
	//argsの属性（主にメソッド）をセットし、S0,$1,..の数を返す。
	public int initCommand(TestCommandIF args);
	
	//上で指定した数だけ、ツールが生成して渡してくるので、セットする。
	//セットするクラス名は定義された引数の型と一致すること。
	public void initArguments(ArgumentIF[] a);
	
	//可変長引数のための追加用、初期状態（編集前）をセットする。セットするクラス名は引数の型と一致すること。第二引数は補足。
	public void initArgument(ArgumentIF a, String opt);

	//可変長引数の位置を示す。可変長引数がなければ-1
	public int varArgsPos();
	
	//作成するコマンドが持つメソッドがstaticかどうか。
	public boolean hasSubject();
	
	//作成するコマンドがAssertをもつかどうか。判定対象かどうか。
	public boolean hasAssert();
	
	//編集
	//$nを編集する。第二引数は任意の補足情報。
	//optはサブメニューを見分けるため。、getMenuItemの中で、TestCaseEditor#getMenuItem()を呼ぶ際に、第三引数に指定しする文字列。
	//AssertIFがあるのは、Argumentを構成する過程で、AssertIFも構成する可能性があるため。
	public void editArgument(ArgumentIF a, AssertIF ast, String opt);
	
	//TestCommandRecordの実行時挙動の拡張用
	public TestCommandIF extendCommand(TestCommandIF a);

	//Assertの内容を設定する。
	public void initAssert(AssertIF ast);

	//Assertの内容を編集する。
	public void editAssert(AssertIF ast, TestCommandIF a);

	//プラグイン固有のプロパティを登録、編集する。
	public void editProperties(HashMap<String, String> map);

	//プラグインに割り当てられたプロパティを（システムなどに）セットする。
	public void initProperties(HashMap<String, String> map);
	
	//実行時の最後のお掃除。必要に応じて実装すること。
	public void destroy();
}
