package com.ftinc.si.assist.test;

import java.util.ArrayList;


//Assertでテスト対象のオブジェクトの内部を参照するための親クラス。
public class Inspector {
	public Inspector() {
	}

	//コードを短くするための便利関数。
	protected Object getFieldValue(Object obj, String fname) {
		try {
			return Tool.getFieldValue(obj, fname);
		} catch (NoSuchFieldException e) {
			e.printStackTrace();;
		}
		return null;
	}
	
	//コードを短くするための便利関数。$n取得用
	protected Object getInstance(String key) {
		return Tool.getInstance(key);
	}

	//結果の入れ物
	public ArrayList<Object> results = new ArrayList<Object>();
	
	//上記の入れ物にセットする。
	//指定位置が入れ物より大きかったら、自動的に$nullで埋めて拡大する。
	//第二引数がnullの場合、$nullに変換する。
	public void asserting(int i, String obj) {
		if (i >= results.size()) {
			int n = i - results.size();
			for (int j = 0; j < n; j++) {
				results.add("$null");
			}
			if (obj != null) {
				results.add(obj);
			} else {
				results.add("$null");
			}
		} else {
			if (obj != null) {
				results.set(i, obj);
			} else {
				results.set(i, "$null");
			}
		}
	}
	
	//オブジェクト内部を参照するコードはAssertRecordのtargetObjで指定されている。
	//動的にサブクラスを作ろ、setBodyで埋め込む。
	public void inspect() {}
	
}