package com.ftinc.si.assist.test.web;

import java.util.ArrayList;

import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import org.openqa.selenium.WebDriver;

import com.ftinc.si.assist.test.Tool;

public class Verify extends PageAction {
	public final ArrayList<String> doAction(WebDriver drv) {
		ArrayList<String> result = new ArrayList<String>();
		
		if (PagePlayer.isRemote()) {
			Tool.alertAndStop("Verify not supported on Grid");
			return result;
		}
		
		String t_msg = (String)arg_map.get("message");
		if (t_msg != null && t_msg.length() > 0) {
			//文字数の制限をなくすためにJTextAreaとJScrollPaneを使う。
			JTextArea t_area = new JTextArea(6, 40);
			t_area.setText(t_msg);
			t_area.setEditable(false);

			JScrollPane s_pane = new JScrollPane(t_area);
			
			//yesならメッセージに表示されたことが確認されているはず。
			JOptionPane optionPane = new JOptionPane(s_pane, JOptionPane.QUESTION_MESSAGE, JOptionPane.YES_NO_OPTION, null, new Object[]{"YES", "NO"}, "YES");
			JDialog t_dialog = optionPane.createDialog(null, "Verification");
			t_dialog.setLocation(0, 0);
			t_dialog.setVisible(true);
			Object res = optionPane.getValue();
			
			if(res.toString().equals("YES")) {
				result.add("true");
			} else {
				result.add("false");
			}
		}
		return result;
	}
	
	//Assert判定する
	protected boolean assertable() {
		//これによりarg_map.valueとdoActionの返り値を比較する。
		return true;
	}
	
	//通常のPageActionは全自動だが、これは手動。
	public boolean isAutomatic() {
		return false;
	}

}
