package com.ftinc.si.assist.test.gui;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.JSONRecord;
import com.ftinc.si.assist.test.Tool;

public class JSONChooser extends JDialog { 
	private ArrayList<JSONRecord> js_data;
	public String m_json;
	public String m_name;
	public boolean is_ok;
	private JTextField cnameField;
	
	public JSONChooser(JDialog owner, ArrayList<JSONRecord> jdata) {
		super(owner, true);
		setResizable(false);
		js_data = jdata;
		is_ok = false;
		
		setTitle(Messages.getString("JSONChooser.0")); //$NON-NLS-1$
		getContentPane().setLayout(null);
		setBounds(130,130, 700, 404);
		
		JLabel lblNewLabel = new JLabel(Messages.getString("JSONChooser.2")); //$NON-NLS-1$
		lblNewLabel.setBounds(12, 12, 50, 13);
		getContentPane().add(lblNewLabel);
		
		JButton btnOk = new JButton(Messages.getString("JSONChooser.3")); //$NON-NLS-1$
		btnOk.setBounds(466, 344, 91, 21);
		getContentPane().add(btnOk);
		
		JButton btnCancel = new JButton(Messages.getString("JSONChooser.4")); //$NON-NLS-1$
		btnCancel.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				setVisible(false);
			}
		});
		btnCancel.setBounds(569, 344, 91, 21);
		getContentPane().add(btnCancel);
		
		
		JLabel lblJsonData = new JLabel(Messages.getString("JSONChooser.5")); //$NON-NLS-1$
		lblJsonData.setBounds(205, 63, 85, 13);
		getContentPane().add(lblJsonData);
		
		JScrollPane scrollPane = new JScrollPane();
		scrollPane.setBounds(205, 86, 477, 248);
		getContentPane().add(scrollPane);
		
		final JTextArea textArea = new JTextArea();
		scrollPane.setViewportView(textArea);
		textArea.setEditable(false);
		
		JScrollPane scrollPane_1 = new JScrollPane();
		scrollPane_1.setBounds(12, 35, 178, 299);
		getContentPane().add(scrollPane_1);
		
		final DefaultListModel<String> l_model = new DefaultListModel<String>();
		final JList<String> list = new JList<String>(l_model);
		scrollPane_1.setViewportView(list);
		
		list.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				int i = list.getSelectedIndex();
				if (i >= 0) {
					String t_str = js_data.get(i).content;
					textArea.setText(t_str);
					cnameField.setText(js_data.get(i).className);
					m_name = js_data.get(i).name;
				}
			}
		});
		for (int i = 0; js_data.size() > i; i++) {
			l_model.addElement(js_data.get(i).name);
		}
	
		JButton btnEdit = new JButton(Messages.getString("JSONChooser.btnEdit.text")); //$NON-NLS-1$
		btnEdit.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				int i = list.getSelectedIndex();
				if (i >= 0 && list.getComponentCount() > i) {
					JDialog me_dialog = (JDialog)Tool.getParent((Component)e.getSource(), "JDialog"); //$NON-NLS-1$
					JSONEditor t_ed = new JSONEditor(me_dialog, js_data.get(i).className, js_data.get(i).name, null);
					t_ed.setVisible(true);
					
					textArea.setText(t_ed.getJson());
				}
			}
		});
		btnEdit.setBounds(12, 344, 91, 21);
		getContentPane().add(btnEdit);
		
		JButton btnRemove = new JButton(Messages.getString("JSONChooser.btnRemove.text")); //$NON-NLS-1$
		btnRemove.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				int i = list.getSelectedIndex();
				if (i >= 0 && list.getComponentCount() > i) {
					js_data.get(i).removed = true;
					int t_res = JOptionPane.showConfirmDialog((JDialog)Tool.getParent((Component)e.getSource(), "JDialog"), "Removing the record, OK?");
					if(t_res == JOptionPane.YES_OPTION) {
						try {
							Tool._db().updateRecordBySQL(js_data.get(i).getUpdateSQL(), true);
						} catch (SQLException e1) {
							Tool.alertMSG(null, Messages.getString("JSONChooser.7") + e1.getMessage()); //$NON-NLS-1$
						}
					}
					l_model.removeElementAt(i);;
				}
			}
		});
		btnRemove.setBounds(124, 344, 91, 21);
		getContentPane().add(btnRemove);
		
		JLabel lblClassName = new JLabel(Messages.getString("JSONChooser.lblClassName.text")); //$NON-NLS-1$
		lblClassName.setBounds(205, 12, 85, 13);
		getContentPane().add(lblClassName);
		
		cnameField = new JTextField();
		cnameField.setText(""); //$NON-NLS-1$
		cnameField.setBounds(205, 34, 477, 19);
		getContentPane().add(cnameField);
		cnameField.setColumns(10);

		btnOk.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				is_ok = true;
				m_json = textArea.getText();
				setVisible(false);
			}
		});

	}
}
