package com.ftinc.si.assist.test;

import java.sql.ResultSet;
import java.sql.SQLException;

public class TestCaseRecord extends Record implements TestCaseIF{
	public TestCaseRecord() {
		super(0);
		groupCode = Tool.group_code;
		version = Tool.version;
	}

	public TestCaseRecord(int i) {
		super(i);
		
		groupCode = Tool.group_code;
		version = Tool.version;
		if (i == 2) {
			//newの時、デフォルトを設定
			name = "NEW";
			description = "To Be Filled.";
			loggable = true;
			snapshot = 0;//snapshot
			include = "NONE";
		}
	}
	
	public TestCaseRecord(int i, String[] rec) {
		super(i);
		groupCode = Tool.group_code;
		version = Tool.version;

		//name,description,begin,end,loggable,snapshot,include,groupCode
		if (rec.length > 0) name = rec[0].trim();
		if (rec.length > 1) description = rec[1].trim();
		if (rec.length > 2) begin = new Integer(rec[2].trim());
		if (rec.length > 3) end = new Integer(rec[3].trim());
		if (rec.length > 4) loggable = new Boolean(rec[4].trim());
		if (rec.length > 5) snapshot = new Integer(rec[5].trim());
		if (rec.length > 6) include = rec[6].trim();
		if (rec.length > 7) groupCode = rec[7].trim();
		if (rec.length > 8) version = rec[8].trim();
	}
	
	public boolean isEquivalentTo(TestCaseRecord rec) {
		if (!name.equals(rec.name)) {
			return false;
		}
		if (!description.equals(rec.description)) {
			return false;
		}
		if (!include.equals(rec.include)) {
			return false;
		}
		if (!version.equals(rec.version)) {
			return false;
		}
		if (!groupCode.equals(rec.groupCode)) {
			return false;
		}
		if (begin != rec.begin) {
			return false;
		}
		if (end != rec.end) {
			return false;
		}
		if (loggable != rec.loggable) {
			return false;
		}
		if (loggable != rec.loggable) {
			return false;
		}
		if (snapshot != rec.snapshot) {
			return false;
		}
		return true;
	}
	
	
	//コマンドのオプション形式:TestCommander.runCaseで使用している。
	public String getCmdArgsStyle() {
		String t_result = "[";
		t_result += "\"" +  name + "\"";
		t_result += ",\"" + description + "\"";
		t_result += ",\"" + Integer.toString(begin) + "\"";
		t_result += ",\"" + Integer.toString(end) + "\"";
		t_result += ",\"" + Boolean.toString(loggable) + "\"";
		t_result += ",\"" + Integer.toString(snapshot) + "\"";
		t_result += ",\"" + include + "\"";
		t_result += ",\"" + groupCode + "\"";
		t_result += ",\"" + version + "\"";
		return t_result + "]";
	}
	
	public String name;
	public String description;
	public int begin; //このTestCaseに割り当てられたIDの帯域の初期値。Versionを考慮するとTestCommandRecordは一意であった方がよい??
	public int end;   //TestIDの上限値
	public int snapshot = 0;
	public String include = "NONE";//name={json}がある。
	public boolean loggable = true;
	public String groupCode = "";
	public String version = "";
	
	//DBの結果を読み込む
	public void read(ResultSet r) throws SQLException {
		name = r.getString("Name");
		description = r.getString("Description");
		begin = r.getInt("Begin");
		end = r.getInt("End");
		loggable = r.getBoolean("Loggable");
		snapshot = r.getInt("Snapshot");
		include = r.getString("Include");
		groupCode = r.getString("GroupCode");
		version = r.getString("Version");
	}
	
	public static int s_unitSize = 100;
	
	public ObjectRecord[] snapshot_Args;//TestCaseEditor用
	public AssertRecord snapshot_Assert; //TestCaseEditor用
	
	//複製を作る。
	public TestCaseRecord _dup() {
		TestCaseRecord t_rec = new TestCaseRecord(0);
		t_rec.name = name;
		t_rec.description = description;
		t_rec.begin = begin;
		t_rec.end = end;
		t_rec.loggable = loggable;
		t_rec.snapshot = snapshot;
		t_rec.include = include;
		t_rec.groupCode = groupCode;
		t_rec.version = version;
		return t_rec;
	}

	public String getUpdateSQL() {
		if (removed && isNew()) {
			return null;//DBに未登録のまま削除
		}
		
		//group_codeがあるとき条件に付ける。
		String str_conds = "";
		if (Tool.group_code.length() != 0) {
			str_conds = " and \"GroupCode\"='" + esq(groupCode) +"'";
		}
		if (version != null && version.length() > 0) {
			str_conds += " and \"Version\"='" + version +"'";
		}

		if (removed) {
			if (begin > 0 && end > 0) {
				return "delete from \"tbl_TestCaseRecord\" where \"Begin\"='" + Integer.toString(begin) 
						+ "' and \"End\"='" + Integer.toString(end) + "' and \"Name\"='" + name + "'" + str_conds;
			} else {
				return "delete from \"tbl_TestCaseRecord\" where \"Name\"='" + name + "'" + str_conds;
			}
		}

		if (isNew()) {
			return "insert into \"tbl_TestCaseRecord\" (\"Name\", \"Description\", \"Begin\", \"End\", \"Snapshot\", \"Include\", \"Loggable\","
					+ " \"GroupCode\", \"Version\") " 
					+ "values ('" + name + "','" + description + "','" + Integer.toString(begin) + "','" + Integer.toString(end) 
					+ "','0','" + esq(include) + "','" + Boolean.toString(loggable) + "','" + esq(groupCode) + "','" + version + "')" ;
		} else if (isUpdated()) {
			return "update \"tbl_TestCaseRecord\" set  \"Description\"='" + description + "', \"Loggable\"='" + Boolean.toString(loggable)
					+ "', \"Snapshot\"='" + Integer.toString(snapshot) + "', \"Include\"='" + esq(include) 
					+ "' where \"Name\"='" + name + "' and \"Begin\"='" + Integer.toString(begin) 
					+ "' and \"End\"='" + Integer.toString(end) + "'" + str_conds;
		}
		return null;
	}

	@Override
	public String getCaseName() {
		return name;
	}

	@Override
	public String getIncludeCase() {
		return include;
	}

	@Override
	public String getGroupCode() {
		return groupCode;
	}
	
}
