package com.ftinc.si.assist.run.plugins;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.TestCaseRecord;
import com.ftinc.si.assist.test.Tool;

//ExcelからTestCase一式を生成するためのインタフェース
public class TestCaseCreator {
	//各種コマンドを実装する。
	public int command(HashMap<String, Object> map) {
		String cmd = map.get("verb").toString();
		if (cmd.endsWith("update")) {
			//VBAから固定名ファイル渡しでデータを受け取り文字列にする。第二引数がTestCreatorのクラス名
			File t_f = Tool._libfile("$LIBDIR\\_newcase.save"); //$NON-NLS-1$
			if (!t_f.exists()) {
				Tool.alertMSG(null, Messages.getString("TestMain.15") + t_f.getAbsolutePath()); //$NON-NLS-1$
				return -1;
			}
			
			if (Tool.group_code != null && Tool.group_code.length() > 0 && (Tool.version == null || Tool.version.length() == 0)) {
				Tool.alertMSG(null, Messages.getString("TestMain.16")); //$NON-NLS-1$
				return -1;
			}
			
			String buf, t_xml;
			t_xml = ""; //$NON-NLS-1$
			try {
				BufferedReader t_br = new BufferedReader(new InputStreamReader(new FileInputStream(t_f),Tool.charset));
				while((buf = t_br.readLine()) != null){
					t_xml += buf + "\n"; //$NON-NLS-1$
				}
				t_br.close();
			} catch (IOException e1) {
				Tool.logForTesting(null, e1.getMessage());
				return -1;
			}

			Tool.logIfDebug(null, "invoking creator in main.");
			int t_ret = createTestRecords(t_xml);
			if (t_ret == 0) {
				//成功!
				//名前変更されたファイルが既にあるならば、消去u
				String saved_name = t_f.getAbsolutePath();
				saved_name = saved_name.replaceFirst(".save$", ".done");
				File c_f = new File(saved_name);
				if (c_f.exists()) {
					c_f.delete();
				}
				//処理が終わった証拠に名前を変える。
				t_f.renameTo(new File(saved_name));
			}
			return t_ret;
		}
		return 0;
	}
	
	//生成するための文字列を読込み、結果をintで返す。
	protected int createTestRecords(String s) {
		return 0;
	}
	

	//要素は一つもしくは二つ。キー=0:クリア。1：新規
	protected HashMap<Integer, TestCaseRecord> lookupTestCaseWithLength(String name, int len) {
		HashMap<Integer, TestCaseRecord> t_map = new HashMap<Integer, TestCaseRecord>();
		
		ArrayList<TestCaseRecord> t_list = Tool._db().getTestCaseList(name, 0, 0, Tool.group_code, Tool.version);
		
		if (len < TestCaseRecord.s_unitSize) {
			len = TestCaseRecord.s_unitSize;//最低限のTestCaseの範囲
		} else {
			return null;
		}
		
		TestCaseRecord t_rec = null;
		if (t_list.size() > 0) {
			//既存である。
			t_rec = t_list.get(0);
			if (t_rec.end - t_rec.begin + 1 < len) {
				//既存だが収まりきらない。
				t_map.put(-1, t_rec);//この後、配下のオブジェクトを削除する。

				t_rec = Tool._db().getNewTestCase(Tool.version);
				t_rec.name = name;
				t_rec.end = t_rec.begin + len;
				t_map.put(1, t_rec);
			} else {
				t_map.put(0, t_rec);
			}
			return t_map;
		}
		
		TestCaseRecord t_rec2 = null;
		t_list = Tool._db().getTestCaseList("%", 0, 0, Tool.group_code, Tool.version); //$NON-NLS-1$
		for (int i = 0; i < t_list.size() - 1; i++) {
			if (t_list.get(i + 1).begin - t_list.get(i).end > len) {
				t_rec2 = new TestCaseRecord(2);
				t_rec2.begin = t_list.get(i).end + 1;
				t_rec2.end = t_rec2.begin + len - 1;
				t_rec2.name = name;
				t_map.put(0, t_rec2);//空きがあれば利用する。
				break;
			}
		}
		if (t_rec2 == null) {
			//空きがないので最後尾に新規に作る。
			t_rec2 = Tool._db().getNewTestCase(Tool.version);
			t_rec2.name = name;
			t_rec2.end = t_rec2.begin + len;
			t_map.put(1, t_rec2);
		}
		return t_map;
	}
}
