package com.ftinc.si.assist.run;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map.Entry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.JFrame;
import javax.swing.JOptionPane;

import com.ftinc.si.assist.test.TestCaseRecord;
import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.gui.EnvironmentData;
import com.ftinc.si.assist.test.gui.TestCaseBrowser;

//TestCommanderの制御
public final class TestMain {

	public static void main(String[] args) {
		if (args.length > 0) {
			//DB接続などの環境情報の初期化。
			EnvironmentData t_env = Tool.readEnvironment();

			//SystermPropertyの上書き。
			HashMap<String, Object> t_map = parseArgs(args);
//			Tool.alertAndExit(Tool.getJSONfromObject(args), null, 0);
			if (!t_map.containsKey("verb")) {
				Tool.alertMSG(null, "verb option not specified"); //$NON-NLS-1$
				exitingFromFaceless(-1);
			} else if ("execCase".equals(t_map.get("verb"))) { //$NON-NLS-1$ //$NON-NLS-2$
				//TestMain#execProcessModeからjar実行の形で呼ばれる。自動的にプロセスモードになる。
				//-execCase  -editmode:boolean -caseName:"Hello World__[001]"
				// option: -v 版数指定。  -$ 大域変数をJsonで指定 -properties
				//※TestCaseはユニークなことが前提として処理される。
				
				if (t_map.containsKey("$")) { //$NON-NLS-1$
					//大域変数への初期状態登録が必要なら行う。例：ブラウザのコマンドラインからの指定。
					@SuppressWarnings("unchecked")
					HashMap<String, Object> t_gvar = (HashMap<String, Object>)Tool.getObjectfromJSON(HashMap.class, t_map.get("$").toString()); //$NON-NLS-1$
					VCentral.prepare(t_gvar);
				}

				//child_modeかどうかはoptionで指定済み。
				TestCommander.runCase(t_map);
			} else if ("exec&wait".equals(t_map.get("verb"))) { //$NON-NLS-1$ //$NON-NLS-2$
				//TestCaseBrowserから呼ばれた場合の初期化。テスト終了後も編集するため、プロセスを継続する。
				execProcessMode(t_map, "close&ContMode"); //$NON-NLS-1$
			} else if ("display".equals(t_map.get("verb"))) { //$NON-NLS-1$ //$NON-NLS-2$
				//外部から呼ばれた場合。ログ表示画面を閉じれば終了する。
				execProcessMode(t_map, "close&ExitMode"); //$NON-NLS-1$
			} else if ("nodisplay".equals(t_map.get("verb"))) { //$NON-NLS-1$ //$NON-NLS-2$
				//バッチによるテスト。ログ表示画面はない。そのまま終わる。
				execProcessMode(t_map, "logonly"); //実際には、silentModeの判定条件はない。単に、他のモードではないというだけ。 //$NON-NLS-1$
			} else if (t_map.get("verb").toString().startsWith("#")) { //$NON-NLS-1$ //$NON-NLS-2$
				//#始まりはcreatorに処理を委任。
				Class<?> x_c;
				try {
					Tool.logIfDebug(null,  "<ftmsg msg=\"invoking creator in main.\"/>");
					x_c = Tool.forName(t_map.get("creator").toString());//creatorクラス名 //$NON-NLS-1$
					Method x_m = x_c.getMethod("command", new Class[] {HashMap.class}); //$NON-NLS-1$
					
					//TestCaseを作り、DBに格納する。
					Object t_ret = x_m.invoke(Tool.newObject(x_c, null, null), new Object[]{t_map});
					if ((Integer)t_ret != 5) {
						//5以外なら終わる。
						exitingFromFaceless((Integer)t_ret);
					}
				} catch (ClassNotFoundException | NoSuchMethodException | SecurityException | IllegalAccessException | IllegalArgumentException 
						| InvocationTargetException | InstantiationException e) {
					//登録時にエラーが起きたら、できるだけ手がかりを残す。
					String e_msg = "msg=" + e.getMessage() + "\nstack=" + Tool.getStackMessage(e, 0, 10); //$NON-NLS-1$ //$NON-NLS-2$
					Tool.alertMSG(null, e_msg);
					exitingFromFaceless(-1);//失敗
				}
			} else if ("delete".equals(t_map.get("verb"))) { //$NON-NLS-1$ //$NON-NLS-2$
				//TestCaseの削除
				//削除する資格を確認
				String t_name = t_map.get("caseName").toString();
				int t_res = JOptionPane.showConfirmDialog(null, t_name + Messages.getString("TestCaseBrowser.53")); //$NON-NLS-1$
				if(t_res == JOptionPane.YES_OPTION) {
					try {
						Tool._db().removeCase(t_name, Tool.version);
						JOptionPane.showMessageDialog(null, Messages.getString("TestCaseBrowser.38")); //$NON-NLS-1$
					} catch (SQLException e) {
						Tool.alertMSG(null, Messages.getString("TestCaseBrowser.51")+ e.getMessage()); //$NON-NLS-1$
					}
				}
			} else if ("env".equals(t_map.get("verb"))) { //$NON-NLS-1$ //$NON-NLS-2$
				t_env = Tool.openEnvironmentDialog(null, t_env);
				if (t_env != null) {
					Tool.saveEnvironment(t_env);
				}
				exitingFromFaceless(0);//成功
			} else if ("remoteDB".equals(t_map.get("verb"))) { //$NON-NLS-1$ //$NON-NLS-2$
				//DBアクセスのためだけの子プロセス
				//connectStr,uid,pwd
				DBMediator t_db = new DBMediator();
				t_db.execMain(t_map);
			}
		} else {
			TestCaseBrowser mFrame = new TestCaseBrowser();
			mFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
			mFrame.setLocationRelativeTo(null);
			mFrame.setBounds(12, 12, 800, 480);
			mFrame.setVisible(true); 
		}
	}
	
	//verbの書式：       -verb
	//パラメータの書式:  -paramName:value
	private static HashMap<String, Object> parseArgs(String[] args) {
		HashMap<String, Object> t_map = new HashMap<String, Object>();
		
		Pattern t_pat = Pattern.compile("^\\-([^:\\s]+?):(.*)$"); //$NON-NLS-1$
		for (int i = 0; i < args.length; i++) {
			Matcher t_m = t_pat.matcher(args[i]);
			if (t_m.find()) {
				String t_key = t_m.group(1);
				String t_val = t_m.group(2);
				t_val = t_val.replaceFirst("^(')(.*)(')$", "\"$2\""); //''で囲まれている場合には""に変える。
				
				//エスケープ処理の回復:testcaseは除く。
				if (!t_key.equals("testcase")) {
					t_val = Tool.rest4CMD(t_val);
				}
				
				if (t_key.equals("properties") && t_val.startsWith("{") && t_val.endsWith("}")) { //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					//-properties:{key:value}　ならばSystem.propertyにセットする。
					
					@SuppressWarnings("unchecked")
					HashMap<String, String> p_map = (HashMap<String, String>)Tool.getObjectfromJSON(HashMap.class, t_val);
					for(Entry<String, String> entry : p_map.entrySet()) {
						if (entry.getValue().startsWith("$LIBDIR")) {
							File t_path = Tool._libfile(entry.getValue());
							System.setProperty(entry.getKey(), t_path.getAbsolutePath());
						} else {
							System.setProperty(entry.getKey(), entry.getValue());
						}
					}
				}
				t_map.put(t_key, Tool.getObjectfromJSON(null, t_val));//-option:パラメータ
			} else if (args[i].startsWith("-")) { //$NON-NLS-1$
				//引数を指定する「-\w+:」の形ではないので、動作を規定するオプションである。
				if (!t_map.containsKey("verb")) { //$NON-NLS-1$
					t_map.put("verb", args[i].substring(1));//引数がないオプションは動作を規定する。 //$NON-NLS-1$
				}
			}
		}
		Tool.logIfDebug(null,  "<ftmsg msg=\"end of the parsing arguments.\"/>");
		return t_map;
	}

	//コマンド実行で処理を行った後で、終了するためのメソッド
	private static void exitingFromFaceless(int status) {
		Tool.logIfDebug(null,  "<ftmsg msg=\"exiting now.\"/>");
		Tool.destroy();
		System.exit(status);
	}
	
	//TestCaseBrowserのメニューからのみ呼ばれる。第二引数は、状況ダイアログを閉じたときExitするかどうか。
	//第二引数：close&ExitMode：結果画面を閉じると終了、close&ContMode：閉じても終了しない, exitNoWin：画面なし(バッチ用)
	private static void execProcessMode(HashMap<String, Object> args, String mode) {
		Tool.logIfDebug(null,  "<ftmsg msg=\"start in execProcessMode. mode=" + mode + "\"/>");

		// java -jar jarfile  //jar実行形式により、別プロセスでも、起動以後のパスの心配は少なくなる。
		String j_path = Tool.s_userdir;
		
		ArrayList<TestCaseRecord> t_cases = null;
		String logfile_name = "log.txt"; //$NON-NLS-1$
		String t_version = Tool.version;
		String casename = "";
		if (args.containsKey("v")) { //$NON-NLS-1$
			t_version = args.get("v").toString(); //$NON-NLS-1$
		}
		
		if (args.containsKey("testcase")) { //$NON-NLS-1$
			//実行するTestCaseが指定されている。
			//書式：［name, logfilename, begin, end, logabble=true］
			Object t_array = args.get("testcase");
			String[] t_strs = null;
			if (java.util.List.class.isAssignableFrom(t_array.getClass())) {
				@SuppressWarnings("unchecked")
				ArrayList<Object> temp_list = (ArrayList<Object>)t_array;
				t_strs = new String[temp_list.size()];
				for (int i = 0; i < t_strs.length; i++) {
					t_strs[i] = temp_list.get(i).toString();
				}
			} else {
				t_strs = (String[]) Tool.getObjectfromJSON(String[].class, t_array.toString()); //$NON-NLS-1$
			}

			TestCaseRecord t_rec = new TestCaseRecord(0, t_strs);
			casename = t_rec.name;
			t_cases = Tool._db().getTestCaseList(t_rec.name, t_rec.begin, t_rec.end, "", t_version); //$NON-NLS-1$

			if (t_rec.description != null && t_rec.description.length() > 0) {
				//ファイル名から禁止文字を除く
				logfile_name = t_rec.description;//コマンドラインで指定しやすい（安直だが）ので、descriptionを利用する。
			}
			if (logfile_name.indexOf(".") < 0) {
				logfile_name += ".txt";
			}
			if (t_cases.size() == 0) {
				Tool.alertMSG(null, args.get("testcase").toString() + "の検索結果は0でした。");
				Tool.destroy();
				System.exit(1);
			}
		} else if (args.containsKey("caseName")) { //$NON-NLS-1$
			//Case名だけ指定されている。
			casename = args.get("caseName").toString(); //$NON-NLS-1$
			t_cases = Tool._db().getTestCaseList(casename, 0, 0, "", t_version); //$NON-NLS-1$
			
			if (t_cases.size() == 0) {
				Tool.alertMSG(null, casename + "の検索結果は0でした。");
				Tool.destroy();
				System.exit(1);
			}
		} else {
			//testcaseのキーがなければ全実行
			t_cases = Tool._db().getTestCaseList("%", 0, 0, "", t_version); //$NON-NLS-1$ //$NON-NLS-2$
			casename = "all";
			if (t_cases.size() == 0) {
				Tool.alertMSG(null, "casename=*の検索結果は0でした。");
				Tool.destroy();
				System.exit(1);
			}
		}
		
		//exit&waitの時、ログ表示画面は出さない。（コマンドラインだと、夜間バッチなので人手は介さない）
		if ("close&ExitMode".equals(mode)) { //$NON-NLS-1$
			Tool.initStatusWin(true);//外部から呼ばれた場合。結果画面を閉じれば終了する。
		} else if ("close&ContMode".equals(mode)) { //$NON-NLS-1$
			Tool.initStatusWin(false);//TestCaseBrowserから呼ばれた場合の初期化
		}
		//フォルダが指定されていないならば、設定のログフォルダを使用する。
		if (logfile_name.indexOf("\\") < 0) {
			logfile_name = Tool.logFolder + "\\" + logfile_name;
		}
		
		File f_log = new File(logfile_name); //$NON-NLS-1$
		PrintStream t_log = null;
		try {
			if (!f_log.exists()) {
				f_log.createNewFile();
			}

			//真っ新のファイルに書く。
			//printStackTraceからは出力しない。
			t_log = new PrintStream(new FileOutputStream(f_log, false));
		} catch (IOException e) {
			Tool.alertMSG(null, "filename=" + logfile_name + " msg=" + e.getMessage());
			e.printStackTrace();
			return;
		}
		//logfileの先頭を書く
		String t_head = "<?xml version=\"1.0\" ?>"; //$NON-NLS-1$
		t_head += "<testsuites disabled=\"$DISABLED\" skipped=\"$SKIPPED\" assertions=\"$ASSERTIONS\" errors=\"$ERRORS\" failures=\"$FAILURES\" name=\"" + casename + "\" tests=\"$TESTS\">";
	
		String options = "";//コマンドオプション //$NON-NLS-1$
		if (args.containsKey("$")) { //$NON-NLS-1$
			//VCentralに登録する引数がある。第二引数はisself=true（自分用）。
			options = "-$:" + Tool.esq4CMD(Tool.getJSONfromObject(args.get("$"))); //$NON-NLS-1$ //$NON-NLS-2$
		}
		if (args.containsKey("v")) { //$NON-NLS-1$
			//version指定
			if (options.length() > 0) {
				options += " "; //$NON-NLS-1$
			}
			options += "-v:" + args.get("v"); //$NON-NLS-1$ //$NON-NLS-2$
		}
		if (args.containsKey("properties")) { //$NON-NLS-1$
			//properties指定. 別プロセスにproperiesを渡さねばならないので再構成する。
			if (options.length() > 0) {
				options += " "; //$NON-NLS-1$
			}
			//第二引数はisself=true（自分用）。
			options += "-properties:" + Tool.esq4CMD(Tool.getJSONfromObject(args.get("properties"))); //$NON-NLS-1$ //$NON-NLS-2$
		}
		if (Tool.process_mode || "close&ExitMode".equals(mode) || "logonly".equals(mode)) { //$NON-NLS-1$
			//子プロセスでテストを実行する。
			if (options.length() > 0) {
				options += " "; //$NON-NLS-1$
			}
			options += "-child_mode:true"; //$NON-NLS-1$
		}
		int n_error = 0;
		int n_fail = 0;
		int n_skip = 0;
		int n_disabled = 0;
		int n_assert = 0;
		int n_all = 0;

		//ArrayList<TestCaseRecord> t_cases;
		String t_result = ""; //$NON-NLS-1$
		for (int i = 0; i < t_cases.size(); i++) {
			String str_rec = t_cases.get(i).name;	//テストケース検索語
			
			//エスケープ処理。第二引数はisself=true（自分用）。
			str_rec = Tool.esq4CMD(str_rec);

			StringBuilder str_b = new StringBuilder();
			if (Tool.process_mode || "close&ExitMode".equals(mode) || "logonly".equals(mode)) { //$NON-NLS-1$
				String cmd = Tool.s_jarname + ".jar";//実行形式のjarはftesting.jar //$NON-NLS-1$
				
				//外部コマンドを起動する。
				String eMode = (String)args.get("editmode"); //$NON-NLS-1$
				if (eMode == null) {
					eMode = "false"; //$NON-NLS-1$
				}
				Tool.logIfDebug(null, "execCase in execProcessMode. cmd=" + cmd + " " + str_rec);
				int t_res = Tool.executeCommand(str_b, j_path, "java", "-jar", cmd, "-execCase", "-editmode:" + eMode, "-caseName:" + str_rec, options); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$

				if (t_res > 1000) {
					//t_res はTestCommandID+1000。だから1000超になる。
					Tool.alertMSG(null, Messages.getString("TestCaseBrowser.56") + Integer.toString(t_res - 1000) + "!"); //$NON-NLS-1$ //$NON-NLS-2$
				} else if (t_res > 0) {
					Tool.alertMSG(null, cmd + " failed in " + j_path + ".(ExitCode=" + Integer.toString(t_res) + ")\n" + str_b); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				}
				if (str_b.length() > 0) {
					//途中経過のログ表示：ファイルへの出力は、子プロセスで行う。
					t_log.append(str_b);
					
					//テストの結果集計
					final Pattern t_pat = Pattern.compile("(errors|tests|failures|skipped|disabled|assertions)=\"(\\d+)\"");
					Matcher t_m = t_pat.matcher(str_b);
					while (t_m.find()) {
						int num = new Integer(t_m.group(2));
						switch (t_m.group(1)) {
							case "errors": n_error += num;break;
							case "tests": n_all += num;break;
							case "failures": n_fail += num;break;
							case "assertions": n_assert += num;break;
							case "disabled": n_disabled += num;break;
							case "skipped": n_skip += num;break;
						}
					}
					if (!mode.equals("logonly")) {
						t_result += str_b;
						Tool.displayResult(t_result);//結果表示.第二引数は強制表示（process_mode=trueだと、logonlyでなくても表示しないため。）
					}
				}
			} else {
				//Tool.displayResultはTestCommander.execute()の中で実行済み。（非processmode）
				TestCommander.runCase(args);
			}
		}
		Tool.logIfDebug(null, "ending in execProcessMode. ");
		//ログ出力ストリームの終了処理:processモードの時だけストリームが生成される。
		if (t_log != null) {
			//ログの出力：このメソッド専用（バッチ型テスト用）
			t_log.append("</testsuites>");
			t_log.close();
			
			//先頭にヘッダを書き込む。
			t_head = t_head .replace("$SKIPPED", Integer.toString(n_skip));
			t_head = t_head .replace("$DISABLED", Integer.toString(n_disabled));
			t_head = t_head .replace("$TESTS", Integer.toString(n_all));
			t_head = t_head .replace("$ASSERTIONS", Integer.toString(n_assert / 2)); //assertionsはTestCaseとTestSuiteで二重にカウントするため。
			t_head = t_head .replace("$FAILURES", Integer.toString(n_fail));
			t_head = t_head .replace("$ERRORS", Integer.toString(n_error));
			
			BufferedReader next_in = null;
			BufferedWriter next_out = null;
			try {
				next_in = new BufferedReader(new FileReader(logfile_name));
				next_out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(logfile_name + "2")));
				next_out.write(t_head); 
				
				String t_buff;
				while ((t_buff = next_in.readLine()) != null) { 
					next_out.write(t_buff); 
				}
				next_in.close();
				next_out.close();
			} catch (IOException e) {
				e.printStackTrace();
			} 
			File temp_f = new File(logfile_name);
			temp_f.delete();
			
			File t_f = new File(logfile_name + "2");
			t_f.renameTo(new File(logfile_name));
		}
		//commandline起動の場合、後始末。
		if (!mode.equals("close&ContMode")) {
			if ("close&ExitMode".equals(mode)) { //$NON-NLS-1$
				//結果画面が閉じるのを待って、このプロセスが終わる場合、secondaryloopを作る。
				Tool.waitDisplayEvent();
			} else {
				//logonlymode
			}
			Tool.destroy();
			System.exit(0);
		}
	}
}
