###############################################################################
#
# <p>ФˤRSSưɽޤ</p>
# <pre>
# {{rss RSSURL}}
# </pre>
#
###############################################################################
package plugin::rss::RSS;
use strict;
#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class = shift;
	my $self = {};
	return bless $self,$class;
}

#==============================================================================
# ѥ饰ե᥽å
#==============================================================================
sub paragraph {
	my $self = shift;
	my $wiki = shift;
	my $url  = shift;
	
	if($url eq ""){
		return &Util::paragraph_error("RSSURLꤵƤޤ");
	}
	
	# åեιå
	my $filename = $url;
	my $cache = $wiki->config('log_dir')."/".&Util::url_encode($filename).".rss";
	my $readflag = 0;
	if(-e $cache){
		my @status = stat($cache);
		if($status[9]+(60*60) > time()){
			$readflag = 1;
		}
	}
	
	my $content = "";
	if($readflag==0){
		# URLRSS
		$content = &Util::get_response($wiki,$url) or return &Util::paragraph_error($!);
		
		# EUCѴʽϤȤѴΤȡ
		#&Jcode::convert(\$content, "euc");
		
		# å
		open(RSS,">$cache") or return &Util::error($!);
		print RSS $content;
		close(RSS);
		
	} else {
		# 뤫RSS
		open(RSS,$cache) or return &Util::error($!);
		while(<RSS>){ $content .= $_; }
		close(RSS);
	}
	# XMLե뤫ɤå
	if(index($content,"<?xml version")!=0){
		return &Util::paragraph_error("XMLեǤϤޤ");
	}
	my @status = stat($cache);
	
	# ѡɽ
	return $self->parse_rss(\$content);
}

#==============================================================================
# RSSѡHTML
#==============================================================================
sub parse_rss {
	my $self    = shift;
	my $content = shift;
	my $charset = $self->get_charset($content);
	my $buf     = "<ul>\n";
	
	my $version = "1.0";
	if(index($$content,"<rss version=\"0.91\">")!=-1){
		$version = "0.91";
	}
	
	if($version eq "1.0"){
		$$content =~ m#(/channel>|/language>)#gsi;
	}
	
	my $count=0;
	
	while ($$content =~ m|<item[ >](.+?)</item|gsi) {
		
		my $item = $1;
		
		my $link  = "";
		my $title = "";
		my $date  = "";
		
		$item =~ m#title>([^<]+)</#gs;
		$title = $1;
		
		$item =~ m#link>([^<]+)</#gs;
		$link = $1;
		$link =~ s/\s".*//g; # ֥륯ơʹߤڤȤ
		
		if ($version eq "1.0") {
			if ($item =~ m#(description|dc\:date)>([^<]+)</#gs) {
				$date = $2;
			}
		} elsif ($version eq "0.91") {
			if($item =~ m#description>([^<]+)</#gs){
				$date = $1;
			}
		}
		
		# ʸɤѴ
		&Jcode::convert(\$title,'euc',$charset);
		&Jcode::convert(\$date ,'euc',$charset);
		
		$buf .= "<li><a href=\"$link\">$title</a>";
		if($date ne ""){
			$buf .= " - $date";
		}
		$buf .= "</li>\n";
		
		$count++;
		if($count>50){ last; }
	}
	
	return $buf."</ul>\n";
}

#==============================================================================
# XMLե뤫饭饯åȤJcode.pmǻǽʸֵѡ
# ꤵƤʤäundef֤ޤ
#==============================================================================
sub get_charset {
	my $self    = shift;
	my $content = shift;
	my $charset = undef;
	
	# 󥳡ǥ󥰤ꤵƤ
	if($$content =~ /encoding="(.+?)"/){
		# ȤꤢʸѴ
		my $encode = uc($1);
		
		# Shift_JISξsjis
		if($encode eq "SHIFT_JIS" || $encode eq "SJIS" ||
		   $encode eq "WINDOWS-31J" || $encode eq "MS932" || $encode eq "CP932"){
			$charset = "sjis";
			
		# EUC-JPξeuc
		} elsif($encode eq "EUC-JP"){
			$charset = "euc";
			
		# UTF-8ξutf8
		} elsif($encode eq "UTF-8"){
			$charset = "utf8";
			
		# JISξjis
		} elsif($encode eq "ISO-2022-JP" || $encode eq "JIS"){
			$charset = "jis";
		}
	}
	
	return $charset;
}

1;
