#!/usr/bin/perl
###############################################################################
#
# FreeStyleWiki եȥCGIץ
#
###############################################################################
BEGIN {
	if(exists $ENV{MOD_PERL}){
		# ȥǥ쥯ȥѹ
		use Cwd;
		chdir("C:/Apache/htdocs/fswiki/");
		
		# exitؿξ
		use subs 'exit';
		require Apache;
		*exit = \&Apache::exit;
		$| = 1;
	}
}
#==============================================================================
# ⥸塼Υ󥯥롼
#==============================================================================
use lib './lib';
#use strict;
use CGI::Carp qw(fatalsToBrowser);
use CGI2;
use Wiki;
use Util;
use Jcode;
use HTML::Template;
#==============================================================================
# CGIWikiΥ󥹥󥹲
#==============================================================================
my $cgi  = CGI2->new();
my $wiki = Wiki->new($cgi);

#==============================================================================
# FarmȤư
#==============================================================================
my $path_info  = $cgi->path_info();
my $path_count = 0;
if(length($path_info) > 0){
	# ȤꤢPATH_INFOκǸ"/"Ϲͤʤ褦ˤ
	$path_info =~ m</([^/]+)$>;
	$wiki->config('script_name', $1);
	$wiki->config('data_dir'   , $wiki->config('data_dir'  ).$path_info);
	$wiki->config('config_dir' , $wiki->config('config_dir').$path_info);
	$wiki->config('backup_dir' , $wiki->config('backup_dir').$path_info);
	$wiki->config('log_dir'    , $wiki->config('log_dir'   ).$path_info);
	
	if(!($wiki->config('theme_uri') =~ /^(http:|https:|ftp:)/)){
		my @paths = split(/\//,$path_info);
		$path_count = $#paths;
		for(my $i=0;$i<$path_count;$i++){
			$wiki->config('theme_uri','../'.$wiki->config('theme_uri'));
		}
	}
}

#==============================================================================
# ȿ
#==============================================================================
my $config = &Util::load_config_hash($wiki,$wiki->config('config_file'));

$wiki->config('site_title'           ,$config->{site_title});
$wiki->config('css'                  ,$wiki->config('theme_uri')."/".$config->{theme}."/".$config->{theme}.".css");
$wiki->config('use_sidebar'          ,$config->{use_sidebar});
$wiki->config('accept_edit'          ,$config->{accept_edit});
$wiki->config('wikiname'             ,$config->{wikiname});
$wiki->config('pagelist'             ,$config->{pagelist});
$wiki->config('admin_name'           ,$config->{admin_name});
$wiki->config('admin_mail'           ,$config->{admin_mail});
$wiki->config('admin_mail_pub'       ,$config->{admin_mail_pub});
$wiki->config('br_mode'              ,$config->{br_mode});
$wiki->config('auto_keyword_page'    ,$config->{auto_keyword_page});
$wiki->config('keyword_slash_page'   ,$config->{keyword_slash_page});
$wiki->config('accept_attach_delete' ,$config->{accept_attach_delete});
$wiki->config('session_limit'        ,$config->{session_limit});
$wiki->config('site_tmpl'            ,$wiki->config('tmpl_dir')."/site/".$config->{site_tmpl_theme}."/".$config->{site_tmpl_theme}.".tmpl");
$wiki->config('site_handyphone_tmpl' ,$wiki->config('tmpl_dir')."/site/".$config->{site_tmpl_theme}."/".$config->{site_tmpl_theme}."_handyphone.tmpl");
$wiki->config('outer_css'            ,$config->{outer_css});

#==============================================================================
# ॢȤƤ륻å˴
#==============================================================================
$cgi->remove_session($wiki);

#==============================================================================
# 桼ɤ߹
#==============================================================================
my $users = &Util::load_config_hash($wiki,$wiki->config('userdat_file'));
foreach my $id (keys(%$users)){
	my ($pass,$type) = split(/\t/,$users->{$id});
	$wiki->add_user($id,$pass,$type);
}

#==============================================================================
# ץ饰Υ󥹥ȡȽ
#==============================================================================
my @plugins = split(/\n/,&Util::load_config_text($wiki,$wiki->config('plugin_file')));
foreach(sort(@plugins)){
	$wiki->install_plugin($_);
}
# ץ饰󤴤Ȥνư
$wiki->do_hook("initialize");

#==============================================================================
# ϥɥθƤӽФ
#==============================================================================
my $action  = $cgi->param("action");
my $content = $wiki->call_handler($action);

#==============================================================================
# 쥹ݥ
#==============================================================================
my $output        = "";
my $is_handyphone = &Util::handyphone();
my $template_name = "";

if ($is_handyphone) {
	$template_name = 'site_handyphone_tmpl';
} else {
	$template_name = 'site_tmpl';
}

# ȥåץڡɤȽ
my $top  = 0;
if($cgi->param("page") eq "FrontPage"){
	$top = 1;
}

# ڡΥȥ
my $title = "";
if($cgi->param('action') eq "" && $wiki->page_exists($cgi->param('page'))){
	$title = "<a href=\"?action=SEARCH&amp;word=".Util::url_encode($wiki->get_title())."\">".
	       &Util::escapeHTML($wiki->get_title())."</a>";
} else {
	$title = &Util::escapeHTML($wiki->get_title());
}

#------------------------------------------------------------------------------
# إå
#------------------------------------------------------------------------------
my $header_tmpl = HTML::Template->new(filename=>$wiki->config('tmpl_dir')."/header.tmpl",
                                      die_on_bad_params => 0);
# ˥塼
my @menu = ();
foreach(sort {$b->{weight}<=>$a->{weight}} @{$wiki->{menu}}){
	if($_->{href} ne ""){
		push(@menu,$_);
	}
}
$header_tmpl->param(MENU       => \@menu,
                    FRONT_PAGE => $top);
my $header = $header_tmpl->output();

#------------------------------------------------------------------------------
# եå
#------------------------------------------------------------------------------
my $footer_tmpl = HTML::Template->new(filename=>$wiki->config('tmpl_dir')."/footer.tmpl",
                                      die_on_bad_params => 0);

# ԡ饤Ȥɽ뤫ɤ
my $admin_name = $wiki->config('admin_name');
my $admin_mail = $wiki->config('admin_mail_pub');
my $out_copyright  = 1;
if($admin_name eq ""){ $admin_name = $admin_mail; }
if($admin_name eq "" && $admin_mail eq ""){ $out_copyright = 0; }

$footer_tmpl->param(ADMIN_NAME    => $admin_name,
                    ADMIN_MAIL    => $admin_mail,
                    OUT_COPYRIGHT => $out_copyright,
                    FRONT_PAGE    => $top);

my $footer = $footer_tmpl->output();

#------------------------------------------------------------------------------
# ȥƥץ졼Ȥν
#------------------------------------------------------------------------------
# ƥץ졼Ȥɤ߹
my $template = HTML::Template->new(filename=>$wiki->config($template_name),
                                   die_on_bad_params => 0);

$template->param(SITE_TITLE  => &Util::escapeHTML($wiki->get_title()." - ".$wiki->config('site_title')),
                 MENU        => $header,
                 TITLE       => $title,
                 CONTENT     => $content,
                 FRONT_PAGE  => $top,
                 FOOTER      => $footer,
                 EDIT_MODE   => $action);

if ($is_handyphone) {
	# ѽ
	$output = $template->output;
	&Jcode::convert(\$output,"sjis");
} else {
	# ѥѽ
	my $usercss = &Util::load_config_text($wiki,$wiki->config('usercss_file'));
	
	if($config->{'theme'} eq ''){
		# ơޤѤƤ餺CSSꤵƤϤ
		if($config->{'outer_css'} ne ''){
			$wiki->config('css',$config->{'outer_css'});
		# ơޤ⳰CSSꤵƤʤϥ륷ȤѤʤ
		} else {
			$wiki->config('css','');
		}
	}
	# ѥ᡼򥻥å
	$template->param(HAVE_USER_CSS => $usercss ne "",
	                 THEME_CSS     => $wiki->config('css'),
	                 USER_CSS      => &Util::escapeHTML($usercss));
	
	# ڡ̾EXIST_PAGE_ڡ̾Ȥѥ᡼˥å
	# åޤڡ̾ϥåȤʤ
	my @pagelist = $wiki->get_page_list();
	foreach my $page (@pagelist){
		if(index($page,"/")==-1){
			$template->param("EXIST_PAGE_".$page=>1);
		}
	}
	
	$output = $template->output;
	
	# 󥯥롼̿
	# <!--FSWIKI_INCLUDE PAGE="ڡ̾"-->
	# ڡ̾WikiNameꤹ롣
	my $fswiki_include_tag = '<!--\s*FSWIKI_INCLUDE\s+PAGE\s*=\s*"([^"]*)"\s*-->';
	while ($output =~ /$fswiki_include_tag/o) {
		if ($wiki->page_exists($1)) {
			$output =~ s/$fswiki_include_tag/$wiki->process_wiki($wiki->get_page($1))/oe;
		} else {
			$output =~ s/$fswiki_include_tag//o;
		}
	}
}

#------------------------------------------------------------------------------
# Ͻ
#------------------------------------------------------------------------------
# إåν
if($is_handyphone){
	print "Content-Type: text/html;charset=Shift_JIS\n";
} else {
	print "Content-Type: text/html;charset=EUC-JP\n";
}
print "Pragma: no-cache\n";
print "Cache-Control: no-cache\n\n";
 
# HTMLν
print $output;

print $ENV{'PATH_INFO'} = undef;
