###############################################################################
#
# PDF륢ϥɥʥեå˥ץ饰
#
###############################################################################
package plugin::pdf::PDFMaker;
#use strict;
use plugin::pdf::PDFParser;
#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class = shift;
	my $self = {};
	return bless $self,$class;
}

#==============================================================================
# ϥɥPDF˥塼
#==============================================================================
sub do_action {
	my $self = shift;
	my $wiki = shift;
	$self->{dir} = $wiki->config('pdf_dir');
	my $cgi = $wiki->get_CGI;
	
	my $pagename = $cgi->param("page");
	if($pagename eq ""){
		$pagename = "FrontPage";
	}
	
	my $filename = $self->{dir}."/".&Util::url_encode($pagename).".pdf";
	
	if(!-e $filename){
		$self->make_pdf($pagename,$wiki->get_page($pagename),$wiki);
	} else {
		# դΥå
		my $pdftime = (stat($filename))[9];
		my $wikitime = $wiki->get_last_modified($pagename);
		if($pdftime < $wikitime){
			$self->make_pdf($pagename,$wiki->get_page($pagename),$wiki);
		}
	}
	
	$pagename =~ s/\//-/g; # Ȥꤢ/򥨥
	
	print "Pragma: no-cache\n";
	print "Cache-Control: no-cache\n";
	print "Content-Type: application/pdf\n";
	print "Content-Disposition: inline;filename=\"".&Jcode::convert("$pagename.pdf",'sjis')."\"\n\n";
	open(DATA,$filename) or die $!;
	binmode(DATA);
	while(<DATA>){
		print $_;
	}
	close(DATA);
	exit;
}

#==============================================================================
# ڡ
#==============================================================================
sub make_pdf {
	my $self   = shift;
	my $page   = shift;
	my $source = shift;
	my $wiki   = shift;
	my $parser = plugin::pdf::PDFParser->new($wiki,$page);
	$parser->parse($source);
	$parser->save_file($self->{"dir"}."/".Util::url_encode($page).".pdf");
}

1;
