###############################################################################
#
# ե⥸塼
#
###############################################################################
package plugin::admin::AdminLogHandler;
#use strict;
#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class = shift;
	my $self = {};
	return bless $self,$class;
}

#==============================================================================
# ϥɥ᥽å
#==============================================================================
sub do_action {
	my $self  = shift;
	my $wiki  = shift;
	my $cgi   = $wiki->get_CGI;
	my $login = $wiki->get_login_info();
	
	if($cgi->param("delete")){
		return $self->delete_log($wiki);
	} elsif($cgi->param("download")){
		$self->download_log($wiki);
	} else {
		return $self->log_info($wiki);
	}
}

#==============================================================================
# եξɽ
#==============================================================================
sub log_info {
	my $self = shift;
	my $wiki = shift;
	my $buf  = "";
	
	$wiki->set_title("եδ");
	
	$buf .= $self->make_log_form($wiki,"","access");
	$buf .= $self->make_log_form($wiki,"źեեΥ","attach");
	$buf .= $self->make_log_form($wiki,"ڡΥ","freeze");
	$buf .= "ΥեƤΥڡ뤬ޤ\n";
	
	return $buf;
}

#==============================================================================
# եξɽԤեϤؿ
#==============================================================================
sub make_log_form {
	my $self   = shift;
	my $wiki   = shift;
	my $name   = shift;
	my $target = shift;
	my $file   = $self->get_filename_from_target($wiki,$target);
	
	my $buf .= "<h2>".&Util::escapeHTML($name)."</h2>\n";
	
	if(-e $wiki->config('log_dir')."/$file"){
		my @status = stat($wiki->config('log_dir')."/$file");
		my $size = @status[7] / 1024;
		# ڤ夲
		$size = ($size==int($size) ? $size : int($size + 1));
		$buf .= "<p>".&Util::escapeHTML($file)."(".$size."KB)</p>\n".
		        "<form action=\"".$wiki->config('script_name')."\" method=\"POST\">\n".
		        "  <input type=\"submit\" name=\"download\" value=\"\">\n".
		        "  <input type=\"submit\" name=\"delete\" value=\"ե\">\n".
		        "  <input type=\"hidden\" name=\"target\" value=\"$target\">\n".
		        "  <input type=\"hidden\" name=\"action\" value=\"ADMINLOG\">\n".
		        "</form>\n";
	} else {
		$buf .= "<p>եϤޤ</p>\n";
	}
	
	return $buf;
}

#==============================================================================
# ե
#==============================================================================
sub delete_log {
	my $self = shift;
	my $wiki = shift;
	my $target = $wiki->get_CGI->param("target");
	my $file   = $self->get_filename_from_target($wiki,$target);
	
	if($file eq ""){
		return $wiki->error("ѥ᡼Ǥ");
	}
	
	unlink($wiki->config('log_dir')."/$file") or die $!;
	
	$wiki->set_title("եδ");
	return "<p>եޤ</p>\n".
	       "<p>[<a href=\"".$wiki->config('script_name')."?action=ADMINLOG\"></a>]</p>\n";
}

#==============================================================================
# ե
#==============================================================================
sub download_log {
	my $self = shift;
	my $wiki = shift;
	my $target = $wiki->get_CGI->param("target");
	my $file   = $self->get_filename_from_target($wiki,$target);
	
	if($file eq ""){
		return $wiki->error("ѥ᡼Ǥ");
	}
	
	print "Content-Type: text/plain\n";
	print "Content-Disposition: inline;filename=\"".&Jcode::convert($file,"sjis")."\"\n\n";
	open(LOG,$wiki->config('log_dir')."/$file") or die $!;
	binmode(LOG);
	while(<LOG>){ print $_; }
	close(LOG);
	
	exit;
}

#==============================================================================
# եΥե̾ؿ
#==============================================================================
sub get_filename_from_target {
	my $self   = shift;
	my $wiki   = shift;
	my $target = shift;
	if($target eq "access"){
		return $wiki->config('access_log_file');
	} elsif($target eq "attach"){
		return $wiki->config('attach_log_file');
	} elsif($target eq "freeze"){
		return $wiki->config('freeze_file');
	} else {
		return "";
	}
}

1;
