<?php

// (Shirai075): fs_moodleの設定を表示するメニューをサイト管理に追加 (2008/07/21)

// ------------------------------------------------------------
pagecheck();
// ------------------------------------------------------------

function fsconfig_check_blogSettings()
{
    global $CFG, $fsCFG;

    print_section_header('ブログ全般に関する設定');

    print_subsection_header_fs_switch('FS_ENABLE_RESTRICT_IMAGESIZE');
    echo '　ブログ／フォーラム投稿に添付する画像の（ファイルサイズではなく）解像度のサイズ制限がありません．';
    echo '非常に高解像度なカメラ（近頃の携帯電話は...）で撮影した画像を添付すると画面全体を占めてしまいます．';
    echo 'しかしアップロード制限内であるならば高精細な画像ファイルはアップロードしたい．';
    echo '本機能は以下の'.color_blue('$fsCFG->blogimagemax_x').'と'.color_blue('$fsCFG->blogimagemax_y');
    echo 'の制限を越える画像を縮小表示します．';
    print_fs_switch_condition('FS_ENABLE_RESTRICT_IMAGESIZE');
    print_subsection_footer();

    print_subsection_header('横幅と縦幅の制限値');
    echo '　現在，'.color_blue('FS_ENABLE_RESTRICT_IMAGESIZE').'は';
    if (fs_function_enable('FS_ENABLE_RESTRICT_IMAGESIZE')) {
        echo color_blue('有効').'なので以下の設定値にしたがって縮小表示します．';
    } else {
        echo color_red('無効').'なので以下の設定値は利用されません．';
    }
    print_subsubsection_header_fs_cfg('blogimagemax_x');
    echo '　横方向の幅の制限値（単位：ピクセル）です．';
    echo '最小値は念のために100としています．';
    echo 'ただし，0以下の値が設定された場合は制限を行いません．';
    echo '現在，'.color_blue('$fsCFG->blogimagemax_x').'は';
    if (!isset($fsCFG->blogimagemax_x)) echo color_red('設定されていません').'．';
      else {
        echo color_blue('設定されています').'．設定値は'.color_blue($fsCFG->blogimagemax_x).'です．';
        if ($fsCFG->blogimagemax_x <= 0) echo '設定値は0以下ですので，横方向の大きさは制限しません．';
    }
    print_fs_cfg_condition('blogimagemax_x');
    print_subsubsection_footer();
    print_subsubsection_header_fs_cfg('blogimagemax_y');
    echo '　縦方向の幅の制限値（単位：ピクセル）です．';
    echo '最小値は念のために100としています．';
    echo 'ただし，0以下の値が設定された場合は制限を行いません．';
    echo '現在，'.color_blue('$fsCFG->blogimagemax_y').'は';
    if (!isset($fsCFG->blogimagemax_y)) echo color_red('設定されていません').'．';
      else {
        echo color_blue('設定されています').'．設定値は'.color_blue($fsCFG->blogimagemax_y).'です．';
        if ($fsCFG->blogimagemax_y <= 0) echo '設定値は0以下ですので，縦方向の大きさは制限しません．';
    }
    print_fs_cfg_condition('blogimagemax_y');
    print_subsubsection_footer();
    print_subsection_footer();

    print_subsection_header_fs_switch('FS_DISABLE_BLOGREPLY');
    echo '　Moodleのブログには返信，コメント，トラックバックといった機能がありません．';
    echo 'Moodle2.0ではコメントを付ける機能が搭載される予定です．';
    echo '本機能はfs_moodle独自の機能です．ブログ閲覧画面に，標準のMoodleには存在しない”返信”を追加します．';
    echo '返信を押すと，新しいブログエントリの追加画面になると同時に，Subject，タグをコピーし，さらに';
    echo '本文に参照元のブログへのパーマネントリンクを自動的に埋め込みます．';
    echo '残念ながら双方向のリンクではなく一方向のリンクではありますが，';
    echo 'そのブログが誰のブログにインスパイアされて記述されたのかが分かることで，';
    echo '標準のMoodleのブログでは一つ一つ孤立していたブログ間に関係性を持たせることが可能になります．';
    print_fs_switch_condition('FS_DISABLE_BLOGREPLY');
    print_subsection_footer();

    // (Shirai161): ブログをエクスポートする機能の追加 (2009/07/25)
    print_subsection_header_fs_switch('FS_ENABLE_BLOGEXPORT');
    echo '　Moodle上のブログがあまり活用されない，という悩みを頻繁に耳にします．';
    echo 'fs_moodleは標準のMoodleには存在しない'.color_blue('ブログの返信機能').'を装備することで活発な意見交換を可能としています．';
    echo 'また，サードパーティ製のLastUpdatedblogブロックの使用もお勧めします．';
    echo 'これらの方策を取ることでMoodle上のブログが活発に利用されるようになるのですが，別の問題が浮上してきました．';
    echo '学生が学校を卒業してあなたの管理するMoodle上からアカウントが消されると，もう編集（場合によっては閲覧も）できなくなります．';
    newline();
    echo '　本機能はMoodle上のブログデータを外部に出力する機能です．';
    echo color_blue('HTML形式（単一ページ）').'，'.
         color_blue('HTML形式（表形式）').'，'.
         color_blue('テキストデータ形式').'の３つの形式での出力が可能です（組み合わせ可能）．';
    echo 'ブログ表示画面の下に［ブログエクスポート］のボタンが表示されたらブログをエクスポート可能です．';
    echo 'エクスポートされたデータを用いて外部ブログへデータ形式を変換してインポートしたり，';
    echo '静的なWebページとして学生時代の思い出を自分の管理するWebサイトに公開することが可能になります．';
    print_fs_switch_condition('FS_ENABLE_BLOGEXPORT');
    echo '　ただし誰もがあなたのブログデータを一括ダウンロードできてしまうのは気持ちの良いものではないでしょう．';
    echo 'そこでサイト単位でこの機能を使うことができる者を制限できます．';
    echo '権限は以下の'.color_blue('$fsCFG->blogexport_capability').'で指定します．';
    newline();
    newline();

    print_subsubsection_header_fs_cfg('blogexport_capability');
    echo '　この機能は（１）管理者のみ，（２）本人のみ，（３）管理者と本人のみ，が利用可能です．';
    echo '　この変数には以下の選択肢があります．';
    table_of_select_data('blogexport_capability');
/*  echo '権限の設定はfsconfig.phpにて'.color_blue('$fsCFG->blogexport_capability').'を指定することで設定します．';
    echo color_blue('$fsCFG->blogexport_capability').'の値によって以下のように権限が決まります．';
    newline();
    newline();
    echo '<ul>';
    echo '<li> '.color_blue('1').'：管理者のみ可能 </li>';
    echo '<li> '.color_blue('2').'：本人のみ可能 </li>';
    echo '<li> '.color_blue('3').'：管理者と本人のみ可能 </li>';
    echo '</ul>';
    newline();
*/
    echo 'なお，管理者や本人以外の者が他人のブログをエクスポートすることは想定していません．';
    echo '誤って設定した場合の危険を考慮した結果です．';
    echo 'また，'.color_blue('0').'を設定した場合は，本機能が有効でも，誰もブログをエクスポートできません．';
    newline();
    if (fs_function_enable('FS_ENABLE_BLOGEXPORT')) {
        if (!isset($fsCFG->blogexport_capability)) {
            echo '現在，'.color_blue($fsCFG->blogexport_capability).'は設定されていません．本来はこのようなことはありえません．';
        } else {
            echo '　現在，'.color_blue('$fsCFG->blogexport_capability='.$fsCFG->blogexport_capability).'が設定されています．';
            switch ($fsCFG->blogexport_capability) {
                case 0: echo 'したがって，'.color_blue('誰もブログエクスポートを実行できません．');                 break;
                case 1: echo 'したがって，'.color_blue('管理者のみ').'がブログエクスポートを実行可能です．';        break;
                case 2: echo 'したがって，'.color_blue('本人のみ').'がブログエクスポートを実行可能です．';          break;
                case 3: echo 'したがって，'.color_blue('管理者と本人のみ').'がブログエクスポートを実行可能です．';  break;
                default: echo '0, 1, 2, 3以外の値が設定されています．本来このようなことはありえません．';           break;
            }
        }
    }
    print_fs_cfg_condition('blogexport_capability');
    print_subsubsection_footer();
    print_subsection_footer();

    print_section_footer();
}

// (Shirai187): 電子メールでブログを投稿する機能 (2010/05/12)
function fsconfig_check_mail2blogSettings()
{
    global $CFG, $fsCFG;

    print_section_header('電子メールでブログを投稿する機能に関する設定');

    echo '　電子メールでブログを投稿する機能を有効にするには，以下のさまざまな設定を正しく設定する必要があります．';
    newline();
    newline();

    print_subsection_header_fs_switch('FS_ENABLE_MAIL2BLOGFUNCTION');
    echo '　まず，'.color_blue('FS_ENABLE_MAIL2BLOGFUNCTION').'を有効にする必要があります．';
    echo 'この設定が有効ではない場合，いくら電子メールで投稿ブログを送信してもブログ投稿されません．';
    echo 'もし一時的に機能を無効にしたい場合も，このスイッチを無効にして下さい．';
    print_notice_message('注意', 'あまり長時間，機能を無効にした後に急に機能を有効にすると，メールボックスに溜まっていた投稿ブログが一斉にブログ投稿されてしまいます．利用者は投稿されなかったブログが急に投稿されるため混乱するでしょう．先にメールボックスに溜まっているメールを全て削除してから機能を有効に戻すことを勧めます．');
    print_fs_switch_condition('FS_ENABLE_MAIL2BLOGFUNCTION');
    echo '　実際にこの機能を正常に使うための最低限の設定が行われているかを調べます．';
    newline();
    if (fs_mail2blog_enable()) echo color_blue('　最低限の設定は行われています').'．';
        else echo color_red('　最低限の設定が整っていませんので，電子メールでブログを投稿する機能はまだ使えません').'．';
    newline();
    newline();

    print_subsubsection_header('PEARライブラリのチェック');
    echo '　PEAR/MailとPEAR/Mail_mimeDecodeが必要です．';
    newline();
    echo '　'.color_blue('PEAR/Mail').'は';
    if (!class_exists('Mail')) {
        echo color_red('インストールされていません！').'　したがって電子メールでブログを投稿する機能は利用できません．';
    } else {
        echo color_blue('インストールされています').'．';
    }
    newline();
    echo '　'.color_blue('PEAR/Mail_mimeDecode').'は';
    if (!class_exists('Mail_mimeDecode')) {
        echo color_red('インストールされていません！').'　したがって電子メールでブログを投稿する機能は利用できません．';
    } else {
        echo color_blue('インストールされています').'．';
    }
    print_subsection_footer();

    print_subsection_header('メールサーバ（POP3）に関する設定');
    echo '　メールサーバに関する設定を行います．';
    echo 'この設定が正しくないと電子メールを受信できてもブログに自動投稿できません．';
    echo '現在，対応しているメールサーバは'.color_blue('POP3').'のみです．';
    newline();
    newline();

    print_subsubsection_header_fs_cfg('m2b_host');
    echo '　メール受信サーバのURIを設定して下さい．';
    echo '現在，'.color_blue('$fsCFG->m2b_host').'は';
    if (empty($fsCFG->m2b_host)) echo color_red('設定されていません').'．このままでは電子メールによるブログ投稿機能は利用できません．';
        else                     echo color_blue('設定されています').'．設定値は'.color_blue($fsCFG->m2b_host).'です．';
    print_fs_cfg_condition('m2b_host');
    print_subsubsection_footer();

    print_subsubsection_header_fs_cfg('m2b_port');
    echo '　メール受信サーバのポート番号を設定して下さい．';
    echo '現在，'.color_blue('$fsCFG->m2b_port').'は';
    if (empty($fsCFG->m2b_port)) echo color_red('設定されていません').'．このままでは電子メールによるブログ投稿機能は利用できません．';
        else                     echo color_blue('設定されています').'．設定値は'.color_blue($fsCFG->m2b_port).'です．';
    print_fs_cfg_condition('m2b_port');
    print_subsubsection_footer();

    print_subsubsection_header_fs_cfg('m2b_user');
    echo '　ブログ投稿受信用メールアカウント名を設定して下さい．';
    echo '現在，'.color_blue('$fsCFG->m2b_user').'は';
    if (empty($fsCFG->m2b_user)) echo color_red('設定されていません').'．このままでは電子メールによるブログ投稿機能は利用できません．';
        else                     echo color_blue('設定されています').'．設定値は'.color_blue($fsCFG->m2b_user).'です．';
    print_fs_cfg_condition('m2b_user');
    print_subsubsection_footer();

    print_subsubsection_header_fs_cfg('m2b_pass');
    echo '　ブログ投稿受信用メールアカウントのパスワードを設定して下さい．';
    print_notice_message('警告', 'ここで設定したパスワードは'.color_blue('fsconfig.php').'ファイルに暗号化されずに保存されますので取り扱いに注意して下さい．');
    echo '現在，'.color_blue('$fsCFG->m2b_pass').'は';
    if (empty($fsCFG->m2b_pass)) echo color_red('設定されていません').'．このままでは電子メールによるブログ投稿機能は利用できません．'; 
        else                     echo color_blue('設定されています').'．設定値は'.color_blue($fsCFG->m2b_pass).'です．';
    print_fs_cfg_condition('m2b_pass');
    print_subsubsection_footer();
    print_subsection_footer();

    print_subsection_header('次に重要な設定');
    print_subsubsection_header_fs_cfg('m2b_confirmlevel');
    echo '　電子メールで投稿されたブログの送信元のユーザを確認するための手段について設定します．';
    newline();
    echo '　この変数には以下の選択肢があります．';
    table_of_select_data('m2b_confirmlevel');
    echo '　現在，'.color_blue('$fsCFG->m2b_confirmlevel').'は';
    switch ($fsCFG->m2b_confirmlevel) {
        case 1 :
        case 2 :
        case 3 :
        case 4 :
        case 5 :
            echo color_blue($fsCFG->m2b_confirmlevel.':'.get_fs_cfg_select_description('m2b_confirmlevel', $fsCFG->m2b_confirmlevel));
            echo 'が設定されています．';
            break;
        default :
            echo color_red('正しく設定されていません！');
            break;
    }
    newline();
    newline();
    echo '　'.color_blue('4').'と'.color_blue('5').'を選択するにはユーザプロファイルフィールドにフィールド（短縮名'.color_blue('MAIL2BLOGKEY').'）を追加する必要があります．';
    echo '現在，'.color_blue('MAIL2BLOGKEY').'は';
    if (is_exist_userProfileField(M2B_USERFIELDNAME_KEY)) {
        echo color_blue('登録されています').'．';
    } else {
        echo color_red('登録されていません').'．';
        if (($fsCFG->m2b_confirmlevel  == 4) or ($fsCFG->m2b_confirmlevel  == 5)) {
            echo color_red('このままでは電子メールでブログを投稿する機能は使用できません！');
        }
    }
    newline();
    echo '　'.color_blue('MAIL2BLOGKEY').'について詳しくは';
    echo link2fs_wiki('電子メールでブログを投稿する機能を利用する準備', '', false).'を参照して下さい．';
    print_fs_cfg_condition('m2b_confirmlevel');
    print_subsubsection_footer();

    print_subsubsection_header_fs_cfg('m2b_pubstate');
    echo '　電子メールで投稿されたブログの公開範囲を指定します．';
    echo 'この設定はサイト単位でしか指定できません．';
    echo 'この変数には以下の選択肢があります．';
    table_of_select_data('m2b_pubstate');
    echo '　現在，'.color_blue('$fsCFG->m2b_pubstate').'は';
    switch ($fsCFG->m2b_pubstate) {
        case 'draft' :
        case 'site' :
        case 'public' :
            echo color_blue($fsCFG->m2b_pubstate.':'.get_fs_cfg_select_description('m2b_pubstate', $fsCFG->m2b_pubstate));
            echo 'が設定されています．';
            break;
        default :
            echo color_red('正しく設定されていません！');
            break;
    }
    print_fs_cfg_condition('m2b_pubstate');
    print_subsubsection_footer();

    print_subsubsection_header_fs_cfg('m2b_textformat');
    echo '　電子メールで投稿されたブログ本文のフォーマットを指定します．';
    echo 'この設定はサイト単位でしか指定できません．';
    echo 'この変数には以下の選択肢があります．';
    table_of_select_data('m2b_textformat');
    echo '　現在，'.color_blue('$fsCFG->m2b_textformat').'は';
    switch ($fsCFG->m2b_textformat) {
        case 0 :
        case 1 :
        case 2 :
        case 4 :
        case 9 :
            echo color_blue($fsCFG->m2b_textformat.':'.get_fs_cfg_select_description('m2b_textformat', $fsCFG->m2b_textformat));
            echo 'が設定されています．';
            break;
        default :
            echo color_red('正しく設定されていません！');
            break;
    }
    print_fs_cfg_condition('m2b_textformat');
    print_notice_message('注意', 'MoodleオートフォーマットはHTMLタグが使えたり，URLが自動的にリンクになったりするなど便利なのですが，本文中に < の記号があるとそれ以降が削除されるといった問題も生じます．');
    print_subsubsection_footer();

    print_subsubsection_header_fs_cfg('m2b_codeseparator');
    echo '　現在，'.color_blue('$fsCFG->m2b_codeseparator').'は';
    echo color_blue('設定されています').'．設定値は'.color_blue($fsCFG->m2b_codeseparator).'です．';
    newline();
    echo '　今，'.color_blue('$fsCFG->m2b_confirmlevel').'には'.color_blue($fsCFG->m2b_confirmlevel).'が設定されています．';
    switch ($fsCFG->m2b_confirmlevel) {
        case 1 :
            echo 'この場合は'.color_blue('$fsCFG->m2b_codeseparator').'の設定は必要ありません．';
            break;
        case 2 :
        case 3 :
            echo 'この場合は，あなたのユーザ名が'.color_blue('shirai').'ならば，';
            echo color_blue($fsCFG->m2b_codeseparator.'shirai'.$fsCFG->m2b_codeseparator).'が，あなたのユーザ識別IDです．';
            break;
        case 4 :
        case 5 :
            echo 'この場合は，あなたのユーザ名が'.color_blue('shirai').'かつユーザ識別キーが'.color_blue('hogehoge').'ならば，';
            echo color_blue($fsCFG->m2b_codeseparator.'shirai:hogehoge'.$fsCFG->m2b_codeseparator).'が，あなたのユーザ識別IDです．';
            break;
        default :
            echo color_red('$fsCFG->m2b_confirmlevelが正しく設定されていません！');
            break;
    }
    print_fs_cfg_condition('m2b_codeseparator');
    print_subsubsection_footer();
    print_subsection_footer();

    print_subsection_header('添付ファイルに関する設定');
    print_subsubsection_header_fs_cfg('m2b_maxfilesize');
    echo '　ブログ投稿されたメールに添付されたファイルサイズの制限値を設定します．';
    echo 'この設定値を超える添付ファイルはブログに添付されません．';
    echo 'ただし，画像ファイルについては例外があります．';
    echo 'もし，'.color_blue('FS_ENABLE_MAIL2BLOGRESIZEPICTURE').'が設定されている場合は，';
    echo '画像をリサイズ（縮小）して添付します．';
    newline();
    echo '　現在，'.color_blue('$fsCFG->m2b_maxfilesize').'は';
    if ($fsCFG->m2b_maxfilesize <= 0) {
        echo color_blue('無効に指定されています').'．つまりファイルサイズがいくら大きくてもブログに添付します．';
    } else {
        echo color_blue(display_size($fsCFG->m2b_maxfilesize)).'が設定されています．';
        echo color_blue('FS_ENABLE_MAIL2BLOGRESIZEPICTURE').'が';
        if (fs_function_enable('FS_ENABLE_MAIL2BLOGRESIZEPICTURE')) {
            echo color_blue('有効').'なので画像ファイルは縮小されます．';
        } else {
            echo color_blue('無効').'なので制限されたサイズを越える画像ファイルは他の添付ファイル同様に';
            echo color_red('添付されません').'．';
        }
    }
    print_fs_cfg_condition('m2b_maxfilesize');
    print_subsubsection_footer();

    print_subsubsection_header_fs_switch('FS_ENABLE_MAIL2BLOGRESIZEPICTURE');
    echo '　上記の'.color_blue('$fsCFG->m2b_maxfilesize').'に関わるスイッチです．';
    echo 'このスイッチが有効な場合は制限を超える大きさのファイルが添付された場合に，';
    echo 'その添付ファイルが画像ファイルの場合のみ縮小して添付します．';
    print_fs_switch_condition('FS_ENABLE_MAIL2BLOGRESIZEPICTURE');
    print_subsubsection_footer();
    print_subsection_footer();

    print_subsection_header('投稿結果の報告に関する設定');
    print_subsubsection_header_fs_switch('FS_ENABLE_MAIL2BLOGREPLYMAIL');
    echo '　このスイッチが有効な場合，電子メールによるブログ投稿の結果を';
    echo 'メール送信元へ返信します．';
    print_fs_switch_condition('FS_ENABLE_MAIL2BLOGREPLYMAIL');
    print_subsubsection_footer();

    print_subsubsection_header_fs_cfg('m2b_replytiming');
    echo '　'.color_blue('FS_ENABLE_MAIL2BLOGREPLYMAIL').'が有効な場合，電子メールで送信されたブログの自動投稿処理の結果を送信元のユーザに返信可能になります．';
    newline();
    echo '　この変数には以下の選択肢があります．';
    table_of_select_data('m2b_replytiming');
/*
    echo '　設定値は以下の中から選べます．';
    newline();
    echo '<ul>';
    for ($i = 0; $i <= 3; $i++) {
        echo '<li>'.$i.'：'.get_fs_cfg_select_description('m2b_replytiming', $i).'</li>';
    }
    echo '</ul>';
*/
    echo '　現在，'.color_blue('$fsCFG->m2b_replytiming').'は';
    switch ($fsCFG->m2b_replytiming) {
        case 0 :
        case 1 :
        case 2 :
        case 3 :
            echo color_blue($fsCFG->m2b_replytiming.':'.get_fs_cfg_select_description('m2b_replytiming', $fsCFG->m2b_replytiming));
            echo 'が設定されています．';
            break;
        default :
            echo color_red('正しく設定されていません！');
            break;
    }
    newline();
    print_fs_cfg_condition('m2b_replytiming');
    print_subsubsection_footer();

    print_subsubsection_header_fs_switch('FS_ENABLE_MAIL2BLOGLOG');
    echo '　このスイッチが有効な場合，電子メールによるブログ投稿の結果を';
    echo 'サーバ上にログファイルに保存します．．';
    echo '保存されるファイル名については以下の'.color_blue('$fsCFG->m2b_log_filenameformat').'の設定をご覧下さい．';
    print_fs_switch_condition('FS_ENABLE_MAIL2BLOGLOG');
    print_subsubsection_footer();

    print_subsubsection_header_fs_cfg('m2b_log_filenameformat');
    echo '　'.color_blue('FS_ENABLE_MAIL2BLOGLOG').'が有効な場合，電子メールで送信されたブログの自動投稿処理のログがログファイルに記録されます．';
    echo 'ログファイルのファイル名は'.color_blue('$fsCFG->m2b_log_filenameformat').'を変更することで自由に設定できます．';
    newline();
    echo '　例えば，'.color_blue('$fsCFG->m2b_log_filenameformat'." = \"'mail2blog'.date('Ymd').'.log'\";").'ならば，';
    echo color_blue('mail2blog20081212.log').'のような一日単位のファイルに保存されます．';
    echo color_blue('$fsCFG->m2b_log_filenameformat').'はeval()によってPHPのコードとして実行されます．';
    echo '具体的には，頭に"return "，お尻に";"が追加されます．このことを理解して自由なコードを記述して結構です．';
    echo 'なお，月単位，年単位，固定ファイル名の例はを以下に示します．';
    echo '<dl>';
    echo '<dt>月単位</dt><dd> $fsCFG->m2b_log_filenameformat = "'."'mail2blog'.date('Ym').'.log'".'";</dd>';
    echo '<dt>年単位</dt><dd> $fsCFG->m2b_log_filenameformat = "'."'mail2blog'.date('Y').'.log'".'";</dd>';
    echo '<dt>固定ファイル名</dt><dd> $fsCFG->m2b_log_filenameformat = "'."mail2blog.log".'";</dd>';
    echo '</dl>';
    echo '　現在の設定値は，'.color_blue('$fsCFG->m2b_log_filenameformat = "'.$fsCFG->m2b_log_filenameformat.'"').'なので，';
    echo '送信ログファイル名は'.color_blue(get_detaillog_filename('m2b_log_filenameformat')).'です．';
    newline();
    print_fs_cfg_condition('m2b_log_filenameformat');
    print_subsubsection_footer();
    print_subsection_footer();

    print_subsection_header('メールボックスの表示と操作');
    if (fs_mail2blog_enable(true)) {
        echo '　もしメールボックスへのログインチェックや受信済みメールの表示と削除を行いたいのであれば，';
        echo '<a href="fsc_blog_mailcheck.php">こちらをクリック</a>して下さい．';
    } else {
        echo color_red('　最低限の設定が完了していません！');
    }
    print_subsubsection_footer();

    print_subsection_footer();

    print_section_footer();
}

fsconfig_check_blogSettings();
fsconfig_check_mail2blogSettings();

?>