<?php

// 【書式】
// [0]: 説明
// [1]: ヘルプ（Wiki）のインデックス
// [2]: 入力書式（array）
// [3]: 属性（array）
// 【入力書式】
// [0]: タイプ（select, bool, string, int）
// [1]: タイプ別データ
// [2]: Windowsのデフォルト値
// [3]: Windows以外のデフォルト値（Windowsと異なる場合のみ指定）

// 【タイプ別データ】
// （Selectの場合）: array
// [0]...: array（値，説明のペア）
// （boolの場合）array
// [0]: false時の説明
// [1]: true時の説明
// （stringの場合）：なし（＝''）
// （intの場合）   ：なし（＝''）

// 【属性】
// yetMoodle2    : Moodle2への対応が未完
// readyMoodle2  : Moodle2以降も対応
// afterMoodle2  : Moodle2以降のみ対応
// afterMoodle24 : Moodle2.4以降のみ対応

// 現在のファイルシステムの文字コード選択
$fs_cfg_strings['fsCharset'] =
    array(
        '現在のファイルシステムの文字コード',
        'fsCharset',
        array(
            'select',
            array(
                array('SJIS-WIN', '日本語Windows(Server含む)の場合'),
                array('false',    'Windows以外の場合（変換しない）'),
                array('UTF-8',    'Windows以外の場合（変換しない）'),
                array('WINDOWS',  '日本語版以外のWindowsで問題が生じた場合のみ'),
                array('EUC-JP',   '（実験用）'),
                array('UTF-16',   '（実験用）'),
                array('RAWURL',   '（実験用）')
            ),
            'SJIS-WIN', 'false'
        ),
        array('readyMoodle2')
    );

// 以前のファイルシステムの文字コード選択]: 環境移行用
$fs_cfg_strings['oldfsCharset'] =
    array(
        '以前のファイルシステムの文字コード（環境移行用）',
        'oldfsCharset',
        array(
            'select',
            array(
                array('UTF-8',    '多くの場合はこちらで結構です'),
                array('SJIS-WIN', 'Linux等でシフトJISで保存してしまった場合'),
                array('EUC-JP',   '（Linux等でEUC-JPで保存してしまった場合'),
                array('WINDOWS',  '日本語版以外のWindowsで問題が生じた場合のみ'),
                array('UTF-16',   '（実験用）'),
                array('RAWURL',   '（実験用）')
                ),
            'UTF-8'
        ),
        array('readyMoodle2')
    );

//  fs_moodle独自のpathinfo(), basename(), dirname()を使用するか？
$fs_cfg_strings['USEfsPathinfo'] =
    array(
        'fs_moodle独自のpathinfo(), basename(), dirname()を使用するか？',
        'USEfsPathinfo',
        array(
            'bool',
            array(
                '無効（PHPオリジナルの関数を利用）',
                '有効（Windows版PHPの場合は特に推奨）'
            ),
            true
        ),
        array('readyMoodle2')
    );

//  カッコなど，moodleで使用を認めていない記号（a-zA-Z0-9,-,_以外の文字）もファイル名として使用可能とする
$fs_cfg_strings['USEextChars'] =
    array(
        'moodleで使用を認めていない記号もファイル名として使用可能とするか？ ',
        'USEextChars',
        array(
            'bool',
            array(
                '無効（a-zA-Z0-9,-のみ認める）',
                '有効（特殊文字以外は認める）'
            ),
            false
        ),
        array('readyMoodle2')
    );

// 全角空白文字をHTMLエディタ内で有効とするか(URL含む)：無効時は１個の半角空白文字に変換される
$fs_cfg_strings['AllowZenkakuSPC'] =
    array(
        '全角空白文字をHTMLエディタ内で有効とするか(URL含む)',
        'AllowZenkakuSPC',
        array(
            'bool',
            array(
                '無効（全角空白は半角空白と同様に扱われます）',
                '有効（全角空白文字によるインデントなどが可能になる）'
            ),
            false
        ),
        array('yetMoodle2')
    );

// Windowsの文字コード
$fs_cfg_strings['fswincharset'] =
    array(
        'Windowsのファイルシステム文字コードの設定',
        'fswincharset',
        array(
            'string',
            '',
            'SJIS-WIN'
        ),
        array('readyMoodle2')
    );

// URIにフォルダを指定されたときに呼び出すデフォルトファイル
$fs_cfg_strings['defaultindex'] =
    array(
        'URIにフォルダを指定されたときに呼び出すデフォルトファイル',
        'defaultindex',
        array(
            'string',
            '',
            ''
        ),
        array('yetMoodle2')
    );

// セキュアなRSSリンクアドレスのセキュリティレベル
$fs_cfg_strings['rss_secure_level'] =
    array(
        'セキュアなRSSリンクアドレスのセキュリティレベル',
        'rss_secure_level',
        array(
            'select',
            array(
                array(0, '旧アドレス形式を出力，全アドレス形式を受け入れる（オリジナルに近い，安全性最低）'),
                array(1, '共通鍵アドレス形式を出力，全アドレス形式を受け入れる（過渡期向け，安全性低い）'),
                array(2, 'コース別暗号化形式を出力，全アドレス形式を受け入れる（過渡期向け，安全性低い'),
                array(3, '共通鍵アドレス形式を出力，暗号化アドレス形式（共通鍵／コース別）のみ受け入れる（過渡期向け，安全性中）'),
                array(4, 'コース別アドレス形式を出力，暗号化アドレス形式（共通鍵／コース別）のみ受け入れる（安全性高い）'),
                array(5, 'コース別アドレス形式を出力，コース別アドレス形式のみ受け入れる（安全性最高）')
            ),
            5
        ),
        array('yetMoodle2')
    );

// セキュアなRSS共通秘密鍵A/B
$fs_cfg_strings['rssCryptKeyA'] =
    array(
        'セキュアなRSS共通秘密鍵A',
        'rssCryptKeyA',
        array(
            'string',
            '',
            'abc'
        ),
        array('yetMoodle2')
    );

$fs_cfg_strings['rssCryptKeyB'] =
    array(
        'セキュアなRSS共通秘密鍵B',
        'rssCryptKeyB',
        array(
            'string',
            '',
            'def'
        ),
        array('yetMoodle2')
    );

// サーバはIISか？（$_SERVERをUTF-8に変換するか？)
$fs_cfg_strings['convUTF8serverVariable'] =
    array(
        'サーバはIISか？（$_SERVERをUTF-8に変換するか？)',
        'convUTF8serverVariable',
        array(
            'bool',
            array(
                '無効（変換しない）',
                '有効（IISの場合はこちらを選択して下さい）'
            ),
            false
        ),
        array('yetMoodle2')
    );

// チャットでfirstnameの代わりに表示するのは？
$fs_cfg_strings['chatName'] =
    array(
        'チャットでfirstnameの代わりに表示するのは？',
        'chatName',
        array(
            'select',
            array(
                array(1, 'ファーストネーム（名）：Moodle標準の設定'),
                array(2, 'ラストネーム（姓）'),
                array(3, 'フルネーム（姓名）'),
                array(4, 'ハンドルネームかファーストネーム'),
                array(5, 'ハンドルネームかラストネーム'),
                array(6, 'ハンドルネームかフルネーム')
            ),
            6
        ),
        array('yetMoodle2')
    );


// Ghostscriptの実行コマンド名（PDF2JPEG変換出力機能有効時）
$fs_cfg_strings['gsexec'] =
    array(
        'Ghostscriptの実行コマンド名（PDF2JPEG変換出力機能有効時）',
        'gsexec',
        array(
            'string',
            '',
            'gswin32c.exe',
            'gs'
        ),
        array('yetMoodle2')
    );

// ewikiでアップロード可能な画像ファイルのサイズの上限を変更
$fs_cfg_strings['ewiki_image_maxsize'] =
    array(
        'ewikiでアップロード可能な画像ファイルのサイズの上限を変更',
        'ewiki_image_maxsize',
        array(
            'int',
            '',
            64 * 1024
        ),
        array('yetMoodle2')
    );

// 電子メール送信時の詳細なログを残す機能を追加（デフォルトで無効） (Shirai105)
$fs_cfg_strings['email_report_lowlevel_log'] =
    array(
        '電子メール送信時のログに下位レベルの関数のレスポンスも記録',
        'Shirai105',
        array(
            'bool',
            array(
                '無効（下位レベルのログは記録しない）',
                '有効（下位レベルのログも記録する）'
            ),
            false
        ),
        array('yetMoodle2')
    );

// 電子メール送信時の詳細なログファイル名のフォーマット
$fs_cfg_strings['email_detaillog_filenameformat'] =
    array(
        '電子メール送信時の詳細なログファイル名のフォーマット',
        'Shirai105',
        array(
            'string',
            '',
            "'email'.date('Ymd').'.log'"
        ),
        array('yetMoodle2')
    );

// 電子メール送信時のエラーログファイル名のフォーマット
$fs_cfg_strings['email_detaillog_errorfilenameformat'] =
    array(
        '電子メール送信時のエラーログファイル名のフォーマット',
        'Shirai105',
        array(
            'string',
            '',
            "'error'.date('Ymd').'.log'"
        ),
        array('yetMoodle2')
    );

// 電子メール送信時のログファイルに電子メールアドレスを含める
$fs_cfg_strings['email_detaillog_includingaddress'] =
    array(
        '電子メール送信時のログファイルに電子メールアドレスを含める',
        'Shirai105',
        array(
            'bool',
            array(
                '無効（電子メールアドレス，ユーザIDなど個人を特定できる情報は記録しません）',
                '有効（誰から誰宛に送ったメールかを詳細に記録します）'
            ),
            false
        ),
        array('yetMoodle2')
    );


// 電子メール送信時の自動ワードラップ処理の文字数指定 (Shirai106)
$fs_cfg_strings['email_wordwrapwidth'] = 
    array(
        '電子メール送信時の自動ワードラップ処理の文字数指定',
        'Shirai106',
        array(
            'int',
            '',
            0
        ),
        array('yetMoodle2')
    );

// グローバルサーチにおいて検索キーワードがどのようにトークン化されたのかを表示する機能 (Shirai150)
// トークンの表示レベル（権限による制限）
$fs_cfg_strings['gsDisplayTokenLevel'] =
    array(
        'トークンの表示レベル（権限による制限）',
        'Shirai150',
        array(
            'select',
            array(
                array(1, '管理者のみ表示'),
                array(2, 'コース編集権限をもつ者のみ表示'),
                array(4, 'ゲスト以外に対して表示'),
                array(8, '全ての利用者に対して表示（お勧めしません）')
            ),
            2
        ),
        array('yetMoodle2')
    );

// 表示するトークンの長さの制限
$fs_cfg_strings['gsDisplayTokenLength'] =
    array(
        '表示するトークンの長さの制限',
        'Shirai150',
        array(
            'int',
            '',
            -1
        ),
        array('yetMoodle2')
    );

// 表示するトークンの数の制限
$fs_cfg_strings['gsDisplayTokenNumber'] =
    array(
        '表示するトークンの数の制限',
        'Shirai150',
        array(
            'int',
            '',
            -1
        ),
        array('yetMoodle2')
    );

// ブログをエクスポートする機能の権限 (Shirai161)
$fs_cfg_strings['blogexport_capability'] =
    array(
        'ブログをエクスポートする機能の権限',
        'Shirai161',
        array(
            'select',
            array(
                array(1, '管理者のみ可能'),
                array(2, '本人のみ可能'),
                array(3, '管理者と本人のみ可能'),
                array(0, '誰もエクスポートできない（参考：もし動的に可否を変更したい場合のためのみ）')
            ),
            3
        ),
        array('yetMoodle2')
    );

// インターネットに接続していない状況でfs_moodle情報のWiki（ローカルなHTML形式）へアクセスする設定 (Shirai176)
$fs_cfg_strings['officialWikiURI'] =
    array(
        'fs_moodle本家サイトのWikiドキュメントの基準URI',
        'officialWikiURI',
        array(
            'string',
            '',
            'http://www.suzuka-ct.ac.jp/mech/moodle/mod/wiki/view.php?id=320'
        ),
        array('yetMoodle2')
    );

// インターネットに接続していない状況でfs_moodle情報のWiki（ローカルなHTML形式）へアクセスする設定 (Shirai176)
$fs_cfg_strings['localWikiURI'] =
    array(
        'インターネットに接続していない状況でfs_moodle情報のWiki（ローカルなHTML形式）へアクセスする設定',
        'localWikiURI',
        array(
            'string',
            '',
            ''
        ),
        array('yetMoodle2')
    );

// (Shirai178): グループのユーザを追加/削除するにおいてユーザ名などでソーティング可能（＋表示）とする改良 (2010/01/22)
$fs_cfg_strings['groupmembersortby'] =
    array(
        'FS_DISABLE_GROUPMEMBERSORTBYでソートを有効にした際の項目指定',
        'groupmembersortby',
        array(
            'select',
            array(
                array('username',   'ログインユーザ名'),
                array('id',         'ユーザID（登録順）'),
                array('idnumber',   '必須入力項目ではありません'),
                array('firstname',  '名'),
                array('lastname',   '姓（標準と同じ）'),
                array('email',      '電子メールアドレス'),
                array('city',       '都道府県名')
            ),
            'username'
        ),
        array('yetMoodle2')
    );

// (Shirai182): 二つのURLから一つのMoodleにアクセスしているシステムにおいて外部に供給するURLのベースアドレス（通常は$CFG->wwwroot）を統一できる改良 (2010/03/21) : Moodle1.9まで
// (Shirai018): プロキシを利用しているコース（wwwrootと実際のURLが異なる）で発生する諸問題への対処 (2014/04/21) : Moodle2.5以降
$fs_cfg_strings['publicwwwroot'] =
    array(
        '複数のURLを持つMoodleサイトでFS_ENABLE_USEPUBLICWWWROOTを有効にした際の設定項目',
        'publicwwwroot',
        array(
            'string',
            '',
            ''
        ),
        array('afterMoodle25')
    );

// (Shirai187): 電子メールでブログを投稿する機能 (2010/05/12)
$fs_cfg_strings['m2b_host'] =
    array(
        'メールサーバ（受信：POP3）のURI',
        'm2b_host',
        array(
            'string',
            '',
            ''
        ),
        array('yetMoodle2')
    );
$fs_cfg_strings['m2b_port'] =
    array(
        'メールサーバ（受信：POP3）のポート番号',
        'm2b_port',
        array(
            'int',
            '',
            110    // デフォルトポート
        ),
        array('yetMoodle2')
    );
$fs_cfg_strings['m2b_user'] =
    array(
        'メールサーバ（受信：POP3）のユーザ名',
        'm2b_user',
        array(
            'string',
            '',
            ''
        ),
        array('yetMoodle2')
    );
$fs_cfg_strings['m2b_pass'] =
    array(
        'メールサーバ（受信：POP3）のパスワード',
        'm2b_pass',
        array(
            'string',
            '',
            ''
        ),
        array('yetMoodle2')
    );
$fs_cfg_strings['m2b_confirmlevel'] =
    array(
        '電子メールでブログを投稿する機能のセキュリティ設定',
        'm2b_confirmlevel',
        array(
            'select',
            array(
                array(1, '送信元メールアドレスのみで認証（簡単だが非常に危険）'),
                array(2, '簡単なユーザ識別コードのみで認証（中途半端に便利だが最も危険）'),
                array(3, '簡単なユーザ識別コードと送信元メールアドレスで認証（２よりは安全だがやはり危険）'),
                array(4, '少し複雑なユーザ識別コードのみで認証（デフォルト）'),
                array(5, '少し複雑なユーザ識別コードと送信元メールアドレスで認証（最も安全）')
            ),
            4
        ),
        array('yetMoodle2')
    );
$fs_cfg_strings['m2b_pubstate'] =
    array(
        '電子メールで投稿するブログの公開範囲（サイト単位の指定）',
        'm2b_pubstate',
        array(
            'select',
            array(
                array('draft',  'あなたのみ閲覧可 (下書き)'),
                array('site',   'このサイトの誰でも閲覧可'),
                array('public', '世界中の誰でも閲覧可')
            ),
            'site'
        ),
        array('yetMoodle2')
    );
$fs_cfg_strings['m2b_textformat'] =
    array(
        '電子メールによるブログ投稿のテキストフォーマットの設定',
        'm2b_textformat',
        array(
            'select',
            array(
                array(0, 'Moodleオートフォーマット'),
                array(1, 'HTMLフォーマット'),
                array(2, 'プレインテキストフォーマット'),
                array(4, 'Markdownフォーマット'),
                array(9, 'ユーザがHTMLエディタを使う設定ならばMoodleオートフォーマット，それ以外はプレインテキスト')
            ),
            9
        ),
        array('yetMoodle2')
    );
$fs_cfg_strings['m2b_maxfilesize'] =
    array(
        '電子メールによるブログ投稿の添付ファイルのサイズ制限',
        'm2b_maxfilesize',
        array(
            'int',
            '',
            1 * 1024 * 1024    // 1MB
        ),
        array('yetMoodle2')
    );
$fs_cfg_strings['m2b_log_filenameformat'] =
    array(
        '電子メールによるブログ投稿のログファイル名のフォーマット',
        'm2b_log_filenameformat',
        array(
            'string',
            '',
            "'mail2blog'.date('Ymd').'.log'"
        ),
        array('yetMoodle2')
    );
$fs_cfg_strings['m2b_codeseparator'] =
    array(
        '電子メールによるブログ投稿のユーザ識別コードの識別子',
        'm2b_codeseparator',
        array(
            'string',
            '',
            '#!#'
        ),
        array('yetMoodle2')
    );
$fs_cfg_strings['m2b_replytiming'] =
    array(
        '電子メールによるブログ投稿の結果メールの送信タイミングに関する設定',
        'm2b_replytiming',
        array(
            'select',
            array(
                array(0, '返信メールを送信しません'),
                array(1, 'ブログの登録に成功した時のみ返信'),
                array(2, 'ブログの登録に失敗した時のみ返信'),
                array(3, 'ブログの登録に成功した時も失敗した時も返信')
            ),
            0
        ),
        array('yetMoodle2')
    );

// (Shirai188): ブログの貼付画像のサイズを制限する機能の追加 (2010/05/20)
$fs_cfg_strings['blogimagemax_x'] =
    array(
        'ブログ添付画像の最大サイズ（横幅）',
        'blogimagemax_x',
        array(
            'int',
            '',
            640    // VGA
        ),
        array('yetMoodle2')
    );
$fs_cfg_strings['blogimagemax_y'] =
    array(
        'ブログ添付画像の最大サイズ（縦幅）',
        'blogimagemax_y',
        array(
            'int',
            '',
            480    // VGA
        ),
        array('yetMoodle2')
    );

// (Shirai189): フォーラムの貼付画像のサイズを制限する機能の追加 (2010/05/20)
$fs_cfg_strings['forumimagemax_x'] =
    array(
        'フォーラム添付画像の最大サイズ（横幅）',
        'forumimagemax_x',
        array(
            'int',
            '',
            640    // VGA
        ),
        array('yetMoodle2')
    );
$fs_cfg_strings['forumimagemax_y'] =
    array(
        'フォーラム添付画像の最大サイズ（縦幅）',
        'forumimagemax_y',
        array(
            'int',
            '',
            480    // VGA
        ),
        array('yetMoodle2')
    );

// (Shirai190): ユーザ画像の表示範囲を制限可能とする機能の追加 (2010/06/01)
$fs_cfg_strings['userpict_level'] =
    array(
        'ユーザ画像の表示範囲を制限するレベル',
        'userpict_level',
        array(
            'select',
            array(
                array(1,  '標準のMoodle同様に制限しない'),
                array(2,  '学生のユーザ画像をログインしたユーザのみに表示可能（ゲストも閲覧可能）'),
                array(3,  '学生のユーザ画像をログインしたユーザのみに表示可能（ゲストは除く）'),
                array(4,  '学生のユーザ画像を教師のみ表示可能'),
                array(5,  '学生のユーザ画像を管理者のみ表示可能'),
                array(12, '全ユーザのユーザ画像をログインしたユーザのみに表示可能（ゲストも閲覧可能）'),
                array(13, '全ユーザのユーザ画像をログインしたユーザのみに表示可能（ゲストは除く）'),
                array(14, '全ユーザのユーザ画像を教師のみ表示可能'),
                array(15, '全ユーザのユーザ画像を管理者のみ表示可能'),
                array(99, '全ユーザのユーザ画像を誰にも表示しない')
            ),
            3
        ),
        array('yetMoodle2')
    );

// (Shirai192): Wikiなどのコンテンツに更新があったことをコースの画面上に表示する機能を追加 (2010/08/03)
$fs_cfg_strings['ra_link_customattribute'] =
    array(
        'Wikiなどの更新情報を表示する際の属性',
        'ra_link_customattribute',
        array(
            'string',
            '',
            'color:#555555;background-color:#EEEEEE'
        ),
        array('yetMoodle2')
    );
$fs_cfg_strings['ra_wiki_numberofdays'] =
    array(
        'Wikiの更新有無を遡ってチェックする日数',
        'ra_wiki_numberofdays',
        array(
            'int',
            '',
            7
        ),
        array('yetMoodle2')
    );
$fs_cfg_strings['ra_wiki_maxnum'] =
    array(
        'Wikiの更新リストに表示する最大の項目数',
        'ra_wiki_maxnum',
        array(
            'int',
            '',
            10
        ),
        array('yetMoodle2')
    );
$fs_cfg_strings['ra_glossary_numberofdays'] =
    array(
        '用語集（Glossary）の更新有無を遡ってチェックする日数',
        'ra_glossary_numberofdays',
        array(
            'int',
            '',
            7
        ),
        array('yetMoodle2')
    );
$fs_cfg_strings['ra_glossary_maxnum'] =
    array(
        '用語集（Glossary）の更新リストに表示する最大の項目数',
        'ra_glossary_maxnum',
        array(
            'int',
            '',
            10
        ),
        array('yetMoodle2')
    );

// (Shirai198): 課題の通知メールにコメントを挿入する改善 (2010/09/25)
$fs_cfg_strings['gradingnotificationcommentlength'] =
    array(
        '通知メールに挿入するコメントの最大文字数',
        'gradingnotificationcommentlength',
        array(
            'int',
            '',
            0
        ),
        array('yetMoodle2')
    );

// --- Moodle2以降
// (Shirai019): 4GBを超えるバックアップファイルを正常にリストアするのにJARなどの外部コマンドを利用可能とする改良 (2014/04/23)
$fs_cfg_strings['unzipcmd4courserestore'] =
    array(
        'コースリストア時のコースバックアップファイル解凍に用いる外部コマンド名',
        'unzipcmd4courserestore',
        array(
            'string',
            '',
            'jar xf'
        ),
        array('afterMoodle2')
    );


// ----------------------- Library ---------------------------

function print_section_header_fs_cfg($cfgname)
{
    print_section_header(title_fs_cfg($cfgname, false), link2fs_cfg($cfgname));
}

function print_subsection_header_fs_cfg($cfgname)
{
    print_subsection_header(title_fs_cfg($cfgname, false), link2fs_cfg($cfgname));
}

function print_subsubsection_header_fs_cfg($cfgname)
{
    print_subsubsection_header(title_fs_cfg($cfgname, false), link2fs_cfg($cfgname));
}

function link2fs_cfg($cfgname)
{
    global $fs_cfg_strings;
    if (empty($fs_cfg_strings[$cfgname])) return '(No link)';
    $cfg_string = $fs_cfg_strings[$cfgname];
    if (empty($cfg_string[1])) return '(No link)';
    return link2fs_wiki($cfg_string[1], $cfg_string[0]);
}

// 設定値の説明の頭に追加する属性に基づく文字列を返す
function attribute_strings_fs_cfg($cfg_string)
{
    // 属性未設定
    if (!isset($cfg_string[3]))    return '';
    $attribute = $cfg_string[3];

    return attribute_strings($attribute);
}

// セクション等に設定値の説明を表示するための文字列を返す
function title_fs_cfg($cfgname, $notag = true)
{
    global $titleonly, $page, $CFG;
    global $fs_cfg_strings;

    if (empty($fs_cfg_strings[$cfgname])) return '(No Title)';
    $cfg_string = $fs_cfg_strings[$cfgname];

    // 整形出力の場合はリンクを生成しない
    if ($notag) return $cfg_string[0].'($fsCFG->'.$cfgname.')';

    // 属性に基づいて文字列を頭に追加する
    $title  = attribute_strings_fs_cfg($cfg_string);
    if (!empty($title)) $title .= ':';
    $title .= $cfg_string[0].'<a name="'.$cfgname.'"></a>';

    // タイトル一覧表示の場合はタイトルにダイレクトリンクを設定する
    if (empty($titleonly)) {
        $title .= '($fsCFG->'.$cfgname.')';
    } else {
        $title .= '<a href="'.$CFG->wwwroot.'/lib/fs_moodle/fs_status/index.php?page='.$page.'#'.urlencode($cfgname).'">'.'($fsCFG->'.$cfgname.')'.'</a>';
    }
    return $title;
}

function get_datatype($cfgname)
{
    global $fs_cfg_strings;
    if (!isset($fs_cfg_strings[$cfgname])) return false;
    return $fs_cfg_strings[$cfgname][2][0];
}

// select型のデータの指定された項目の説明文を返す．
// エラーの場合はfalseを返す．
function get_fs_cfg_select_description($cfgname, $value)
{
    global $fs_cfg_strings;
    $cfg_string = $fs_cfg_strings[$cfgname];
    if (empty($cfg_string)) return false;
    $cfg_data = $cfg_string[2];
    if ($cfg_data[0] != 'select') return false;
    $cfg_select = $cfg_data[1];
    foreach ($cfg_select as $selected) {
        if ($value == $selected[0]) return $selected[1];
    }
    return false;
}

// select型データの全候補を説明つきでリスト表示する．
function table_of_select_data($cfgname, $display = true)
{
    global $fs_cfg_strings;
    $cfg_string = $fs_cfg_strings[$cfgname];
    if (empty($cfg_string)) return '';
    $cfg_data = $cfg_string[2];
    if ($cfg_data[0] != 'select') return '';
    $cfg_select = $cfg_data[1];
    $ret = "<ul>\n";
    foreach ($cfg_select as $selected) {
        $ret .= '<li>'.$selected[0].'&nbsp;:&nbsp;'.$selected[1]."</li>\n";
    }
    $ret .= "</ul>\n";
    if ($display) echo $ret;
    return $ret;
}

//------------------------------
function print_setting_value($cfgtype, $cfgtypedata, $value, $color = 'normal', $return = false)
{
    switch ($cfgtype) {
      case 'select':
        if ($value === false) $value = 'false';
        $str1 = $value;
        $str2 = '&nbsp;（';
        foreach ($cfgtypedata as $key=>$data) {
            if ($data[0] == $value) break;
        }
        $str2 .= $cfgtypedata[$key][1];
        $str2 .= '）&nbsp;';
        break;
      case 'bool':
        $str1 = $value ? 'true' : 'false';
        $str2 = '&nbsp;（'.$cfgtypedata[$value].'）&nbsp;';
        break;
      case 'string':
        $str1 = empty($value) ? '（空）' : $value;
        $str2 = '';
        break;
      case 'int':
        if ($value === false) $str1 = 'false'; else $str1 = $value;
        $str2 = '';
        break;
      default:
        echo '<br /><b>システムエラー</b>：';
        echo 'fs_cfg_strings.phpの記述が正しくありません．<br />'; 
        die;
    }
    $ret = '';
    switch ($color) {
      case 'blue': $ret .= color_blue($str1); break;
      case 'red' : $ret .= color_red($str1);  break;
      default:     $ret .= $str1;
    }
    $ret .= $str2;
    if ($return) return $ret;
    echo $ret;
}

// OSの種類に基づいて初期値を定義ファイルから取得する
function get_fs_cfg_default($cfgname)
{
    global $fs_cfg_strings;

    $iswindows = ostype_is_windows();

    $cfgformat = $fs_cfg_strings[$cfgname][2];
    if (isset($cfgformat[3]) and !$iswindows) $cfgdefault = $cfgformat[3];
        else                                  $cfgdefault = $cfgformat[2];
    return $cfgdefault;
}

function set_fs_cfg_default($cfgname)
{
    global $fsCFG;
    $fsCFG->$cfgname = get_fs_cfg_default($cfgname);
}

// 初期値，設定値，変更値を表示する
function print_fs_cfg_condition($cfgname)
{
    global $fs_cfg_strings, $fsCFG;
    global $SESSION;

    if (empty($SESSION->fscfgedit)) return;
    // fs_cfg_strings.phpのチェック
    if (empty($fs_cfg_strings[$cfgname])) {
        echo '<br /><b>システムエラー</b>：';
        echo 'fs_cfg_strings.php中に$fs_switch_strings['.$cfgname.']の記述がありません．<br />'; 
        die;
    }
    if (count($cfg_string = $fs_cfg_strings[$cfgname]) < 3) {
        echo '<br /><b>システムエラー</b>：';
        echo 'fs_cfg_strings.phpの記述が正しくありません．<br />'; 
        die;
    }
    $cfgdescription = $cfg_string[0];
    $cfgindex       = $cfg_string[1];
    $cfgformat      = $cfg_string[2];
    if (count($cfgformat) < 3) {
        echo '<br /><b>システムエラー</b>：';
        echo 'fs_cfg_strings.phpの記述が正しくありません．<br />'; 
        die;
    }

    $cfgtype     = $fs_cfg_strings[$cfgname][2][0];
    $cfgtypedata = $fs_cfg_strings[$cfgname][2][1];
    $cfgdefault  = get_fs_cfg_default($cfgname);

    $out = $tbl = $def = $cur = $chg = $stv = $upd = '';
    $out .= '<div style="padding-left:1em; padding-top:5px; padding-bottom:5px;">';
    $tbl = '<table ';
    if (isset($SESSION->fscfg->$cfgname)) $tbl .= 'bordercolor="#ff0000"';
        else                              $tbl .= 'bordercolor="#ccccff"';
    $tbl .= ' cellpadding="6" style="border:solid 1px">';
    $tbl .= '<tr bgcolor="#ccccff">';
    $tbl .= '<th>';
    $tbl .= '［パラメータ変更メニュー］'.attribute_strings_fs_cfg($cfg_string);
    $tbl .= '</th>';
    $tbl .= '</tr>';
    $tbl .= '<tr>';
    // デフォルト値の表示
    $def .= '<td>';
    $def .= '　デフォルト値は';
    $def .= print_setting_value($cfgtype, $cfgtypedata, $cfgdefault, 'blue', true);
    $def .= 'です．';
    $def .= newline(false);
    $tbl .= $def;
    $cur .= '　現在の設定値は';
    $cur .= print_setting_value($cfgtype, $cfgtypedata, $fsCFG->$cfgname, 'blue', true);
    $cur .= 'です．';
    $cur .= newline(false);
    $tbl .= $cur;
    if (isset($SESSION->fscfg->$cfgname)) {
        $chg .= '　変更された設定値は';
        $chg .= print_setting_value($cfgtype, $cfgtypedata, $SESSION->fscfg->$cfgname, 'red', true);
        $chg .= 'です．';
        $chg .= newline(false);
        $tbl .= $cur;
    }
    // 設定値の変更
    $stv .= '<form method="POST" action="#'.$cfgname.'">';
    $stv .= '　設定の変更：';
    switch ($cfgtype) {
      case 'select':
        $stv .= '<select name="'.$cfgname.'">';
        foreach ($cfgtypedata as $no=>$element) {
            if (empty($element[0]) and ($element[0] !== 0)) $element[0] = 'false';
            $stv .= '<option value="'.$element[0].'"';
            if (!isset($SESSION->fscfg->$cfgname)) {
                if ($element[0] == $cfgdefault)               $stv .= ' selected';
            } else {
                if ($element[0] == $SESSION->fscfg->$cfgname) $stv .= ' selected';
            }
            $stv .= '>'.$element[0].':'.$element[1].'</option>';
        }
        $stv .= '</select>';
        break;
      case 'bool':
        $stv .= '<input type="radio" name="'.$cfgname.'" value="1"';
        if (!isset($SESSION->fscfg->$cfgname)) {
            if ($cfgdefault)                $stv .= ' checked';
        } else {
            if ($SESSION->fscfg->$cfgname)  $stv .= ' checked';
        }
        $stv .= ' /> true &nbsp;';
        $stv .= '<input type="radio" name="'.$cfgname.'" value="0"';
        if (!isset($SESSION->fscfg->$cfgname)) {
            if (!$cfgdefault)               $stv .= ' checked';
        } else {
            if (!$SESSION->fscfg->$cfgname) $stv .= ' checked';
        }
        $stv .= ' /> false &nbsp;&nbsp;';
        break;
      case 'string':
      case 'int':
        $stv .= '<input type="text" name="'.$cfgname.'" value="';
        if (!isset($SESSION->fscfg->$cfgname)) {
            $stv .= $cfgdefault;
        } else {
            $stv .= $SESSION->fscfg->$cfgname;
        }
        $stv .= '"/>';
        break;
      default:
        echo '<br /><b>システムエラー</b>：';
        echo 'fs_cfg_strings.phpの記述が正しくありません．<br />'; 
        die;
    }
    $tbl .= $stv;
    // 更新／変更取り消し
    $upd .= '<input type="hidden" name="cfgname" value="'.$cfgname.'" />';
    $upd .= '<input type="submit" value="更新" />';
    if (isset($SESSION->fscfg->$cfgname)) {
        $upd .= '<input type="submit" name="clear" value="変更取消" />';
    }
    $upd .= '</form>';
    $tbl .= $upd;

    $tbl .= '</tr></td>';
    $tbl .= '</table>';
    $out .= $tbl;
    $out .= '</div>';
    echo $out;
}

// (13) MIMETYPEを追加
// 引数は順番に，拡張子，mimetype，アイコンファイル名(moodle/pix/fフォルダ内）です．
// ここで追加した拡張子と同じ拡張子のmimetype/iconの情報がMoodle標準の設定にも存在する場合，
// ここで指定した値で上書きされます（できます）．
// Moodle標準のmimetypeの情報はlib/filelib.phpのfunction get_mimetypes_array()を参照するか，
// lib/fs_mooldeフォルダ内のmimetype_list.xls(pdf)を参照して下さい．
// 以下は例です．複数の設定を追加する場合は以下書式の行を追加すればOKです．
// fs_add_mimetype('bas', 'text/plain', 'text.gif');

// MAKE SURE WHEN YOU EDIT THIS FILE THAT THERE ARE NO SPACES, BLANK LINES,
// RETURNS, OR ANYTHING ELSE AFTER THE TWO CHARACTERS ON THE NEXT LINE.
?>