//*****************************************************************************//
//fgraph.c
//Copyright (C) 2006 K.Tsuchiya all rights reserved.
//2006/08/29
//... fridge object relation graph.
//*****************************************************************************//
#include <string.h>
#include <stdlib.h>
#include <dlfcn.h>
#include "fgraph.h"
#include "fgsysobj.h"

/*function define*/
static int fgMapStrKey(void*key);
static int fgMapStrCnd(void* a,void*b);
static int fgMapIntKey(void*key);
static int fgMapIntCnd(void* a,void*b);

//==============================================================================
//ask to root
//==============================================================================
//defautl ask---------------------------------------------------------
fgData fgAskDef(fgHandle fhdl,char*objname,int super){
    fgData data={fgDataTypeInt,0};
    return data;
}
//set askRoot---------------------------------------------------------
int fgAskSet(fgHandle fhdl,fgData (*func)(fgHandle,char*,int)){
    fhdl->ask=(void*)func;
    return 0;
}
//==============================================================================
//map define
//==============================================================================
//hash  key table 1
static const int fgKeymap1[]={
#include "fgKeymap1.def"
};
//hash key table 2
static const int fgKeymap2[]={
#include "fgKeymap2.def"
};
//map key <string>-----------------------------------------
static int fgMapStrKey(void*key){
      if(cioVoid(key,char*)[0]==CIO_ES) return CIO_ES;
      return fgKeymap1[cioVoid(key,char*)[0]]+
          fgKeymap2[cioVoid(key,char*)[1]];
}
//map cond <fgData>----------------------------------------
static int fgMapStrCnd(void* a,void*b){
    return !strcmp(cioVoid(a,char*),cioVoid(b,char*));
}
//map key <int>---------------------------------------------
static int fgMapIntKey(void*key){
    return cioVoid(key,int);
}
//map cond <int>--------------------------------------------
static int fgMapIntCnd(void* a,void*b){
    return cioVoid(a,int)==cioVoid(b,int);
}
//==============================================================================
//fgraph access
//==============================================================================
// regist key object------------------------------------------------
static fgHandle fgGraphIniKey(fgHandle fhdl){
    int i;
    static char* keytbl[]={
        fgDataflow, fgOpeAss, fgOpeInc, fgOpeDec,
        fgDefIf, fgDefWhile, fgDefFor, fgDefBreak,
        fgDefContinue, fgOpeMin, fgOpeNot, fgOpeBnot,
        fgOpePow  ,    fgOpeMod  ,  fgOpeDiv   , fgOpeMul  , 
        fgOpeSub  ,    fgOpeAdd  ,  fgOpeLsf   , fgOpeRsf  , 
        fgOpeGree ,    fgOpeLese ,  fgOpeGre   , fgOpeLes  , 
        fgOpeNeq  ,    fgOpeEq   ,  fgOpeAnd   , fgOpeXor  ,  
        fgOpeOr   ,    fgOpeAndand, fgOpeOror  , fgOpeMuleq , 
        fgOpeDiveq ,   fgOpeModeq , fgOpeAddeq , fgOpeSubeq , 
        fgOpeLsfeq ,   fgOpeRsfeq , fgOpeAndeq , fgOpeOreq  , 
        fgOpeXoreq ,   fgDefArry,   fgOpePoweq , fgOpeDot,
        fgDefArgini,   fgDefArgval, fgDefReturn, fgDefDef,
    };
    for(i=0;i<(sizeof(keytbl)/sizeof(char*));i++){
        cmapUpdate(fhdl->ktbl,
	    cioAddr(keytbl[i]),cioAddr(keytbl[i]));
    }
    return fhdl;
}
//init graph------------------------------------------------------
fgHandle fgGraphIni(char*name){
    fgHandle fhdl;
    static cMsgTbl msgtbl[]={
        #include "fgmsg.def"
    };
    cstrMakeBuf(fhdl,1,FG_HANDLE,exit(-1));
    fhdl->size=1;
    fhdl->gbg=cvectIni(sizeof(int),100);
    fhdl->obj=cmapIni(sizeof(int),sizeof(fgObj),
        (*fgMapIntKey),(*fgMapIntCnd));
    fhdl->msg=cmsgIni(msgtbl,cmsgTblSize(msgtbl));
    fhdl->inq =cqueueIni(sizeof(fgData));
    fhdl->outq=cqueueIni(sizeof(fgData));
    fhdl->ntbl=cmapIni(sizeof(char*),sizeof(char*),
        (*fgMapStrKey),(*fgMapStrCnd));
    fhdl->nlst=cvectIni(sizeof(char*),100);
    fhdl->ktbl=cmapIni(sizeof(char*),sizeof(char*),
        (*fgMapStrKey),(*fgMapStrCnd));
    fgGraphIniKey(fhdl);
    fhdl->olst=cvectIni(sizeof(fgObj*),100);
    if(name) fhdl->name=fgGraphGetName(fhdl,name);
    else fhdl->name=fgGraphGetName(fhdl,"");
    fhdl->ask=(void*)fgAskDef;
    fgTmpBuffer("",0);
    fgStdMethod(NULL,0x00,NULL);
    fgPath(NULL,0x00,NULL);
    return fhdl;
}
//destruct graph-------------------------------------------------
fgHandle fgGraphDes(fgHandle fhdl){
    int i;
    char*n;
    if(!fhdl) return fhdl;
    for(i=0;i<fhdl->size;i++)
        if(cmapFind(fhdl->obj,&i)) fgDelObj(fhdl,i);
    cvectDes(fhdl->gbg);
    cmapDes(fhdl->obj);
    cmsgDes(fhdl->msg);
    cqueueDes(fhdl->inq);
    cqueueDes(fhdl->outq);
    for(i=0;i<cvectGetSize(fhdl->nlst);i++){
        n=cioVoid(cvectFind(fhdl->nlst,i),char*);
	cstrFree(n);
    }
    cmapDes(fhdl->ntbl);
    cvectDes(fhdl->nlst);
    cvectDes(fhdl->olst);
    cmapDes(fhdl->ktbl);
    free(fhdl);
    fgPath(NULL,0x03,NULL);
    fgStdMethod(NULL,0x03,NULL);
    fgSysObjFileObj(NULL,NULL);
    fgSysFreeMem();
    return NULL;
}
//get name pointer--------------------------------------------
char* fgGraphGetName(fgHandle fhdl,char*name){
    char**tmpp;
    char* instance;
    if(!fhdl) return NULL;
    tmpp=cmapFind(fhdl->ntbl,&name);
    if(!tmpp){
        cstrSet(instance,name,exit(-1));
	cmapInst(fhdl->ntbl,&instance,&instance);
	cvectPush(fhdl->nlst,&instance);
    }else instance=*tmpp;
    return instance;
}
//==============================================================================
//object access
//==============================================================================
//init object-----------------------------------------------------------
int fgMakeObj(fgHandle fhdl,char*insname,int super){
   int    index;
   fgObj  obj;
   fgData data;
   fgObj* tmpobj;
   fgData*tmpdata;
   char* tmpstr;
   if(!strcmp(insname,fgDefSelf)) return super;
   tmpobj=cmapFind(fhdl->obj,&super);
   if(tmpobj){
       tmpdata=cmapFind(tmpobj->map,&insname);
       if(tmpdata){
           if((tmpdata->type==fgDataTypeObj)&&
               (!cmapFind(fhdl->ktbl,&insname)))
               return tmpdata->elm.i;
       }
   }
   obj.name=fgGraphGetName(fhdl,insname);
   obj.map=cmapIni(sizeof(char*),sizeof(fgData),
        (*fgMapStrKey),(*fgMapStrCnd));
   obj.meth=(*fgMethDef); 
   obj.cnst=0;
   obj.cnstp=NULL;
   obj.nextp=NULL;
   obj.prevp=NULL;
   obj.cash1p=NULL;
   obj.cash2p=NULL;
   if(cstackGetSize(fhdl->gbg)!=0)
       index=cioVoid(cstackPop(fhdl->gbg),int);
   else{
       index=fhdl->size;
       fhdl->size++;
   }
   obj.id=index;
   data.type=fgDataTypeObj;
   data.elm.i=super;
   tmpstr=fgGraphGetName(fhdl,fgDefSuper);
   cmapInst(obj.map,&tmpstr,&data);
   data.elm.i=index;
   tmpstr=fgGraphGetName(fhdl,fgDefSelf);
   cmapInst(obj.map,&tmpstr,&data);
   if(super) fgSetObj(fhdl,super,insname,data);
   data.type=fgDataTypeInt;
   data.elm.i=0;
   tmpstr=fgGraphGetName(fhdl,fgDefValue);
   cmapInst(obj.map,&tmpstr,&data);
   obj.valp=cmapFind(obj.map,&tmpstr);
   tmpobj=cmapInst(fhdl->obj,&index,&obj);
   cvectInst(fhdl->olst,index,&tmpobj);
   return index;
}
//making object pointer-----------------------------------------------
//2006/10/06 Had changed how to access a object pointer(hash->list)
fgObj* fgMakeObjLow(fgHandle fhdl,char*insname,int super){
    int index;
    index=fgMakeObj(fhdl,insname,super);
    return fgGetObjLow(fhdl,index);
}
//delete object-------------------------------------------------------
int fgDelObj(fgHandle fhdl,int index){
    fgObj* obj;
    if(!fhdl) return -1;
    obj=cmapFind(fhdl->obj,&index);
    if(!obj) return -1;
    cmapDes(obj->map);
    cmapDel(fhdl->obj,&index);
    cstackPush(fhdl->gbg,&index);
    return -1;
}
//set data------------------------------------------------------------
fgData fgSetObj(fgHandle fhdl,int index,
    char*elmname,fgData data){
    char*name;
    fgObj* obj;
    if(!fhdl) return data;
    obj=cmapFind(fhdl->obj,&index);
    if(!obj) return data;
    name=fgGraphGetName(fhdl,elmname);
    cmapUpdate(obj->map,&name,&data);
    return data;
}
//get data----------------------------------------------------------------
fgData fgGetObj(fgHandle fhdl,int index,char* elmname){
    fgObj*  obj;
    fgData* datap;
    fgData  data={fgDataTypeInt,0};
    if((!fhdl)||(index<=0)) return fhdl->ask(fhdl,elmname,index);
    obj=cmapFind(fhdl->obj,&index);
    if(!obj) return fhdl->ask(fhdl,elmname,index);
    datap=cmapFind(obj->map,&elmname);
    if(!datap) return fhdl->ask(fhdl,elmname,index);
    
    return *datap;
}
//default method----------------------------------------------------------
fgData fgMethDef(fgHandle fhdl,int index){
    fgData  data={fgDataTypeObj,index};
    return data;
}
//run method--------------------------------------------------------------
fgData fgMethod(fgHandle fhdl,int index){
    fgObj*  obj;
    fgData  data={fgDataTypeInt,0};
    if(!index) return data;
    obj=cmapFind(fhdl->obj,&index);
    if(!obj) return data;
    return obj->meth(fhdl,index); 
}
//setting method-----------------------------------------------------------
int fgSetMeth(fgHandle fhdl,int index,
    fgData (*meth)(fgHandle,int)){
    fgObj*  obj;
    if(!fhdl) return -1;
    obj=cmapFind(fhdl->obj,&index);
    if(!obj) return -1;
    obj->meth=meth;
    return index; 
}
//getting name-------------------------------------------------------------
char* fgGetName(fgHandle fhdl,int index){
    fgObj* obj;
    obj=cmapFind(fhdl->obj,&index);
    if(!obj) return "";
    return obj->name;
}
//==============================================================================
//fgPath (getting library file path)
//==============================================================================
char* fgPath(char*name,int flg,int*type){
    static cVector path=NULL;
    static char* suf[]={".fg",".so",".so.1",".so.2",".so.3",".so.4",".dll"};
    static char* def[]={"/usr/local/fridge/lib/", "./",};
    switch(flg){
    case 0x0 :{// init
        int i,size;
        if(path) break;
        path=cvectIni(sizeof(char*),5);
        size=sizeof(def)/sizeof(char*);
        for(i=0;i<size;i++) cvectPush(path,&(def[i]));
    }break;
    case 0x1 :{// get
        int i,j;
        int sufsize;
        char* dir;
        char* buf;
        FILE* tmpfp;
        sufsize=sizeof(suf)/sizeof(char*);
        for(i=cvectGetSize(path)-1;i>=0;i--){
            dir=cioVoid(cvectFind(path,i),char*);
            for(j=0;j<sufsize;j++){
                cstrSet(buf,dir,exit(-1));
                if(buf[strlen(buf)-1]!='/') cstrCat(buf,"/",exit(-1));
                cstrCat(buf,name,exit(-1));
                cstrCat(buf,suf[j],exit(-1));
                tmpfp=fopen(buf,"r");
                if(tmpfp){
                    *type=j;
                    fclose(tmpfp);
                    return buf;
                }
                free(buf);
            }
        }
        return NULL;
    }break;
    case 0x2 :{// set
        if(!path){
            int i,size;
            path=cvectIni(sizeof(char*),5);
            size=sizeof(def)/sizeof(char*);
            for(i=0;i<size;i++) cvectPush(path,&(def[i]));
        }
        cvectPush(path,&(name));
        return name;
    }break;
    case 0x3 :{// des
        cvectDes(path);
    }break;
    default : break;
    }
    return NULL;
}
//==============================================================================
//fgSysObjFileObj (loading dynamic link library)
//==============================================================================
int fgSysObjFileObj(char*name,char*path){
   void* lib;
   char* objname;
   fgData (*meth)(fgHandle,int);
   static cMap tbl=NULL;
   if((!name)&&(!path)){
       int i;
       cVector liblist;
       if(!tbl) return 0;
       liblist=tbl->elmlist;
       for(i=0;i<cvectGetSize(liblist);i++){
           lib=cioVoid(cmapFind(tbl,cvectFind(liblist,i)),void*);
           dlclose(lib);
       }
       cmapDes(tbl);
       return 0;
   }
   if(!tbl) tbl=cmapIni(sizeof(char*),
       sizeof(void*),(*cmapStrKey),(*cmapStrCmp));
   if(cmapFind(tbl,&name)) return 0;
   lib=dlopen(path,RTLD_LAZY);
   if(!lib) return -1;
   meth=dlsym(lib,name);
   if(!meth) return -1;
   cstrSet(objname,name,exit(-1));
   fgStdMethod(objname,0x02,(*meth));
   cmapUpdate(tbl,&objname,&lib);
   return 0;
}

