//*****************************************************************************//
//fish.c
//Copyright (C) 2006 K.Tsuchiya ltd.
//2006/08/29
//... fridge/shell .
//*****************************************************************************//
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "fridge.h"
#include "calg.h"
/*const define*/
#define fishDefCommand "..command.."
/*function define*/
fgData fishAsk(fgHandle fhdl,char* name,int super);

/*struct arguments*/
typedef struct{
   char*   infile;
   int     flg_usage;
   int     flg_version;
   cVector arg;
}fishArgs;
//==============================================================================
//check args 
//==============================================================================
static fishArgs checkArgs(int argc,char**argv){
    int i;
    fishArgs arg={NULL,0,0,NULL};
    arg.arg=cvectIni(sizeof(char*),5);
    for(i=1;i<argc;i++){
        if(arg.infile==NULL){
            if(argv[i][0]=='-'){
                if(!strcmp(argv[i],"-h")) arg.flg_usage=1;
                else if(!strcmp(argv[i],"--h")) arg.flg_usage=1;
                else if(!strcmp(argv[i],"-help")) arg.flg_usage=1;
                else if(!strcmp(argv[i],"--help")) arg.flg_usage=1;
                else if(!strcmp(argv[i],"-v")) arg.flg_version=1;
                else if(!strcmp(argv[i],"--v")) arg.flg_version=1;
                else if(!strcmp(argv[i],"-ver")) arg.flg_version=1;
                else if(!strcmp(argv[i],"--ver")) arg.flg_version=1;
                else if(!strcmp(argv[i],"-version")) arg.flg_version=1;
                else if(!strcmp(argv[i],"--version")) arg.flg_version=1;
                else if(!strcmp(argv[i],"-l")){
                    if((++i)<argc) fgPath(argv[i],0x02,NULL);
                }else fprintf(stderr,"warning:'%s' no such option\n",argv[i]);
            }
            else{
                arg.infile=argv[i];
                cvectPush(arg.arg,&(argv[i]));
            }
        }else cvectPush(arg.arg,&(argv[i]));
    }
    return arg;
}
//==============================================================================
//displaying version 
//==============================================================================
static int displayVer(void){
    printf("\n*+.Fridge/Shell --Version %s--\n",fgVersion);
    printf("*+.Copyright (C) 2006 K.Tsuchiya ltd.\n\n");
}
//==============================================================================
//displaying usage 
//==============================================================================
static int displayUsage(void){
    printf("*+.usage:fridge [option(s)] <fg-file> [argment(s)] ... \n");
    printf("    option(s):\n");
    printf("    -l <path>:adding library path.\n");
    printf("    --version:displaying version.\n");
    printf("    --help:displaying usage.\n\n");
}
//==============================================================================
//fish main
//==============================================================================
int main(int argc,char**argv){
    fishArgs arg;
    fgHandle fhdl;
    arg=checkArgs(argc,argv);
    fhdl=fgIni(arg.infile);
    fgAskSet(fhdl,(*fishAsk));
    if(arg.flg_version) displayVer();
    if(arg.flg_usage) displayUsage();
    if((!arg.flg_usage && !arg.flg_version)|| arg.infile) 
        fgMain(fhdl,cvectGetSize(arg.arg),arg.arg->mainArray);
    if(arg.infile) fgMethod(fhdl,1);
    fgDes(fhdl);
    return 0;
}
//==============================================================================
//fish object method 
//==============================================================================
//int 
static char* fishMethInt(fgHandle fhdl,fgData data,char*buf){
    cstrRemakeBuf(buf,1024,char,exit(-1));
    sprintf(buf,"%d",data.elm.i);
    return buf;
}
//float
static char* fishMethFlt(fgHandle fhdl,fgData data,char*buf){
    cstrRemakeBuf(buf,1024,char,exit(-1));
    sprintf(buf,"%f",data.elm.f);
    return buf;
}
//str
static char* fishMethStr(fgHandle fhdl,fgData data,char*buf){
    if(buf) free(buf);
    cstrSet(buf,data.elm.s,exit(-1))
    return buf;
}
//object
static char* fishMethObj(fgHandle fhdl,fgData data,char*buf){
    static char* (*func[])(fgHandle,fgData,char*)={
        fishMethInt,fishMethFlt,
        fishMethStr,fishMethObj,
    };
    data=fgGetObj(fhdl,data.elm.i,fgDefValue);
    return func[data.type](fhdl,data,buf);
}
//fish method
static fgData fishMeth(fgHandle fhdl,int self){
    int i;
    int flag;
    int arg;
    int argsize;
    char* buf=NULL;
    char* tmpbuf=NULL;
    fgData data;
    fgData argelm;
    static char* (*func[])(fgHandle,fgData,char*)={
        fishMethInt,fishMethFlt,
        fishMethStr,fishMethObj,
    };
    data=fgGetObj(fhdl,self,fishDefCommand);
    if(data.type!=fgDataTypeStr){
        data.type=fgDataTypeInt;
        data.elm.i=self;
        return data;
    }
    cstrSet(buf,data.elm.s,exit(-1));
    cstrSet(tmpbuf,"",exit(-1));
    //arg
    arg=fgMakeObj(fhdl,fgDefArg,self);
    argsize=fgMakeObj(fhdl,fgDefSize,arg);
    argsize=fgGetObj(fhdl,argsize,fgDefValue).elm.i;
    /*cd*/
    if(!strcmp(buf,"cd")){
        char*s;
        char*e;
        free(buf);
        cstrSet(buf,"",exit(-1));
        for(i=0;i<argsize;i++){
            data.type=fgDataTypeInt;
            data.elm.i=i;
            argelm=fgGetArry(fhdl,arg,data);
            tmpbuf=func[argelm.type](fhdl,argelm,tmpbuf);
            cstrCat(buf,tmpbuf,exit(-1));
        }
        for(s=buf;isspace(*s);s++)
            if(*s==CIO_ES) break;
        for(e=s;!isspace(*e);e++)
            if(*e==CIO_ES) break;
        *e=CIO_ES;
        flag=chdir(s);
    }
    /*else*/
    else{
        for(i=0;i<argsize;i++){
            data.type=fgDataTypeInt;
            data.elm.i=i;
            argelm=fgGetArry(fhdl,arg,data);
            tmpbuf=func[argelm.type](fhdl,argelm,tmpbuf);
            cstrCat(buf," ",exit(-1));
            cstrCat(buf,tmpbuf,exit(-1));
        }
        flag=system(buf);
    }
    free(tmpbuf);
    free(buf);
    data.type=fgDataTypeInt;
    data.elm.i=flag;
    fgSetObj(fhdl,self,fgDefValue,data);
    data.type=fgDataTypeObj;
    data.elm.i=self;
    return data;
}
//==============================================================================
//fish ask 
//==============================================================================
fgData fishAsk(fgHandle fhdl,char* name,int super){
    void* meth;
    char* buf;
    int   obj;
    int   flag;
    fgData data;
    data.type=fgDataTypeObj;
   
    /*standard library*/
    meth=fgStdMethod(name,0x01,NULL);
    if(meth){
        data.elm.i=fgMakeObj(fhdl,name,super);
        fgSetMeth(fhdl,data.elm.i,meth);
        return data;
    }
    /*else call*/
    cstrSet(buf,"type ",exit(-1));
    cstrCat(buf,name,exit(-1));
    cstrCat(buf," >& /dev/null",exit(-1));
    flag=system(buf);
    free(buf);
    data.type=fgDataTypeInt;
    if(flag){
        data.elm.i=flag;
	return data;
    }
    cstrSet(buf,name,exit(-1));
    cstrCat(buf," ",exit(-1));
    obj=fgMakeObj(fhdl,name,super);
    data.type=fgDataTypeStr;
    data.elm.s=fgGraphGetName(fhdl,name);
    fgSetObj(fhdl,obj,fishDefCommand,data);
    fgSetMeth(fhdl,obj,fishMeth);
    data.type=fgDataTypeObj;
    data.elm.i=obj;
    return data;
}

