//*****************************************************************************//
//fgsysobj.h
//Copyright (C) 2006 K.Tsuchiya ltd.
//2006/08/29
//... fridge system object .
//*****************************************************************************//

#ifndef __FGSYSOBJ__HEAD
#define __FGSYSOBJ__HEAD

/*functions*/
/*fgSysTmpBuffer*/
extern char* fgTmpBuffer(char* str,int flg);
extern void fgSysFreeMem(void);
//echo data
extern fgData fgSysEchoData(fgHandle fhdl,fgData data);
//sys const
extern int fgSysObjConstInt(fgHandle fhdl,int val,int super);
extern int fgSysObjConstFlt(fgHandle fhdl,double val,int super);
extern int fgSysObjConstStr(fgHandle fhdl,char* val,int super);
//sys increment
extern int fgSysObjInc(fgHandle fhdl,int super,int right);
//sys decrement
extern int fgSysObjInc(fgHandle fhdl,int super,int right);
//sys assign
extern int fgSysObjAss(fgHandle fhdl,int lindex,int super,int rindex);
//sys dataflow
extern int fgSysObjDf(fgHandle fhdl,int super,int ope);
//sys ID
extern int fgSysObjId(fgHandle fhdl,char* name,int super);
//sys array
extern int fgSysObjArry(fgHandle fhdl,int left,int right,int super);
extern fgData fgSetArry(fgHandle fhdl,int self,fgData num,fgData data);
extern fgData fgGetArry(fgHandle fhdl,int self,fgData num);
extern int fgMakeArry(fgHandle fhdl,int self,fgData num);
/*sys argument*/
extern int fgSysObjArg(fgHandle fhdl,int ope,int super);
extern int fgSysObjArgIni(fgHandle fhdl,int left,int right,int super);
extern inline fgData fgSysGetArgElm(fgHandle fhdl,int self,int index);
extern inline int fgSysGetArgSize(fgHandle fhdl,int self);
#define fgGetArgElm fgSysGetArgElm
#define fgGetArgSize fgSysGetArgSize
/*sys if*/
extern int fgSysObjIf(fgHandle fhdl,int cond,int then,int es,int super);
/*sys set next*/
extern int fgSysSetNext(fgHandle fhdl,int index,int next);
/*sys get head*/
extern int fgSysGetHead(fgHandle fhdl,int index);
/*sys while*/
extern int fgSysObjWhile(fgHandle fhdl,int index,
    int cond,int block,int super);
/*sys for*/
extern int fgSysObjFor(fgHandle fhdl,int index,
    int loop,int cond,int block,int super);
/*sys cond control*/
extern int fgSysCondBreak(fgHandle fhdl,fgData data);
extern int fgSysCondContinue(fgHandle fhdl,fgData data);
extern int fgSysCondReturn(fgHandle fhdl,fgData data);
/*sys return*/
extern int fgSysObjReturn(fgHandle fhdl,int index,int block);
/*sys def*/
extern int fgSysObjDef(fgHandle fhdl,int index,int block,int super);
/*sys not*/
extern int fgSysObjNot(fgHandle fhdl,int super,int left);
/*sys min*/
extern int fgSysObjMin(fgHandle fhdl,int super,int left);
/*sys bit not*/
extern int fgSysObjBnot(fgHandle fhdl,int super,int left);
/*sys cast*/
extern fgData fgSysCast(fgHandle hdl,fgData data,int type);
/*sys pow*/
extern int fgSysObjPow(fgHandle fhdl,int super,int left,int right);
/*sys mod*/
extern int fgSysObjMod(fgHandle fhdl,int super,int left,int right);
/*sys div*/
extern int fgSysObjDiv(fgHandle fhdl,int super,int left,int right);
/*sys mul*/
extern int fgSysObjMul(fgHandle fhdl,int super,int left,int right);
/*sys sub*/
extern int fgSysObjSub(fgHandle fhdl,int super,int left,int right);
/*sys add*/
extern int fgSysObjAdd(fgHandle fhdl,int super,int left,int right);
/*sys rsh*/
extern int fgSysObjRsh(fgHandle fhdl,int super,int left,int right);
/*sys lsh*/
extern int fgSysObjLsh(fgHandle fhdl,int super,int left,int right);
/*sys gree*/
extern int fgSysObjGree(fgHandle fhdl,int super,int left,int right);
/*sys lese*/
extern int fgSysObjLese(fgHandle fhdl,int super,int left,int right);
/*sys gre*/
extern int fgSysObjGre(fgHandle fhdl,int super,int left,int right);
/*sys les*/
extern int fgSysObjLes(fgHandle fhdl,int super,int left,int right);
/*sys neq*/
extern int fgSysObjNeq(fgHandle fhdl,int super,int left,int right);
/*sys eq*/
extern int fgSysObjEq(fgHandle fhdl,int super,int left,int right);
/*sys and*/
extern int fgSysObjAnd(fgHandle fhdl,int super,int left,int right);
/*sys or*/
extern int fgSysObjOr(fgHandle fhdl,int super,int left,int right);
/*sys xor*/
extern int fgSysObjXor(fgHandle fhdl,int super,int left,int right);
/*sys andand*/
extern int fgSysObjAndand(fgHandle fhdl,int super,int left,int right);
/*sys muleq*/
extern int fgSysObjMule(fgHandle fhdl,int super,int left,int right);
/*sys subeq*/
extern int fgSysObjSube(fgHandle fhdl,int super,int left,int right);
/*sys addeq*/
extern int fgSysObjAdde(fgHandle fhdl,int super,int left,int right);
/*sys diveq*/
extern int fgSysObjDive(fgHandle fhdl,int super,int left,int right);
/*sys modeq*/
extern int fgSysObjMode(fgHandle fhdl,int super,int left,int right);
/*sys poweq*/
extern int fgSysObjPowe(fgHandle fhdl,int super,int left,int right);
/*sys rsfeq*/
extern int fgSysObjRsfe(fgHandle fhdl,int super,int left,int right);
/*sys lsfeq*/
extern int fgSysObjLsfe(fgHandle fhdl,int super,int left,int right);
/*sys andeq*/
extern int fgSysObjAnde(fgHandle fhdl,int super,int left,int right);
/*sys oreq*/
extern int fgSysObjOre(fgHandle fhdl,int super,int left,int right);
/*sys xoreq*/
extern int fgSysObjXore(fgHandle fhdl,int super,int left,int right);
/*sys dot*/
extern int fgSysObjDot(fgHandle fhdl,int left ,char* right,int super);
/*sys global args*/
int fgSysObjGlobalArgs(fgHandle fhdl,int argc,char**argv,int super);
/*value*/
#define fgDefSuper  "super"
#define fgDefSelf   "SLF."
#define fgDefSize   "size"
#define fgDefArg    "arg"
#define fgDefArgini "ARG."
#define fgDefArgval "ARGV."
#define fgDefArry   "ARR."
#define fgDefValue  "V."
/*control flow*/
#define fgDefDef      "DEF."
#define fgDefIf       "IF."
#define fgDefLoop     "LOP."
#define fgDefCond     "CND."
#define fgDefThen     "THN."
#define fgDefElse     "ELS."
#define fgDefNext     "NEX."
#define fgDefPrev     "PRE."
#define fgDefWhile    "WHL."
#define fgDefFor      "FOR."
#define fgDefBlock    "BLK."
#define fgDefBreak    "BRK."
#define fgDefContinue "CNTN."
#define fgDefReturn   "RET."
/*for operater*/
#define fgDefLeft  "LE."
#define fgDefRight "RI."
#define fgDefOpe   "OPT."
/*operator name*/
#define fgDataflow "DF."
#define fgOpeDot   ".."
#define fgOpeInc   "++."
#define fgOpeDec   "--."
#define fgOpeMin   "_."
#define fgOpeNot   "!."
#define fgOpeBnot  "~."
#define fgOpeAss   "=."
#define fgOpePow   "**."
#define fgOpeMod   "%."
#define fgOpeDiv   "/."
#define fgOpeMul   "*."
#define fgOpeSub   "-."
#define fgOpeAdd   "+."
#define fgOpeLsf   "<<."
#define fgOpeRsf   ">>."
#define fgOpeGree  ">=."
#define fgOpeLese  "<=."
#define fgOpeGre   ">."
#define fgOpeLes   "<."
#define fgOpeNeq   "!=."
#define fgOpeEq    "==."
#define fgOpeAnd   "&."
#define fgOpeXor   "^."
#define fgOpeOr    "|."
#define fgOpeAndand "&&."
#define fgOpeOror   "||."
#define fgOpeMuleq  "*=."
#define fgOpeDiveq  "/=."
#define fgOpeModeq  "%=."
#define fgOpeAddeq  "+=."
#define fgOpeSubeq  "-=."
#define fgOpeLsfeq  "<<=."
#define fgOpeRsfeq  ">>=."
#define fgOpeAndeq  "&=."
#define fgOpeOreq   "|=."
#define fgOpeXoreq  "^=."
#define fgOpePoweq  "**=."

#define FG_BUFSIZE 254

#ifndef USECIOMEM
#define USECIOMEM /*use cio malloc*/
#endif

#endif

