%{
//*****************************************************************************//
//fridge.y
//Copyright (C) 2006 K.Tsuchiya ltd.
//2006/08/29
//... fridge parser.
//*****************************************************************************//
#include <stdio.h>
#include "fridge.tab.h"
#include "calg.h"
#include "fgraph.h"
#include "fgsysobj.h"
extern FILE* yyin;
extern int   fgLine;    /*line number*/
extern char* fgFile;    /*file name*/
static int   fgErr;     /*error code*/
static fgHandle fhdl;   /*fgraph handle*/
static int fgSuper;     /*current super object*/
static cStack stkSuper; /*super id stack*/
static int dfflag;      /*data flow control flag*/
static int stdinFlag;   /*Flag of yyin is stdin or else.*/
static int elflag;      /*get endline flag*/
static int    fgArgc;   /*global argc*/
static char** fgArgv;   /*global argv*/
static int fgSysImport(fgHandle fhdl,char*name,int super);//sys import
extern int fgLexChangeBuf(fgHandle fhdl,char*name,int super);
#define FG_SHELL
%}
%union{
    int    i;
    double f;
    char*  s;
}

%expect 1
%token fg_import
%token fg_def
%token fg_while
%token fg_for
%token fg_in
%token fg_if
%token fg_else
%token fg_return
%token fg_break
%token fg_continue

%token fg_dot2   // ".."
%token fg_ass    // OPE'=' OPE11
%token fg_muleq  // OPE "*=" OPE
%token fg_diveq  // OPE "/=" OPE
%token fg_modeq  // OPE "%=" OPE
%token fg_addeq  // OPE "+=" OPE
%token fg_subeq  // OPE "-=" OPE
%token fg_lsfeq  // OPE "<<="OPE 
%token fg_rsheq  // OPE ">>="OPE
%token fg_andeq  // OPE "&=" OPE
%token fg_oreq   // OPE "|=" OPE
%token fg_xoreq  // OPE "^=" OPE
%token fg_oror   // OPE "||" OPE
%token fg_andand // OPE "&&" OPE
%token fg_or     // OPE "|"  OPE
%token fg_xor    // OPE "^"  OPE
%token fg_and    // OPE "&"  OPE
%token fg_eq     // OPE "==" OPE
%token fg_neq    // OPE "!=" OPE
%token fg_les    // OPE "<"  OPE
%token fg_gre    // OPE ">"  OPE
%token fg_leseq  // OPE "<=" OPE
%token fg_greeq  // OPE ">=" OPE
%token fg_lsf    // OPE "<<" OPE
%token fg_rsf    // OPE ">>" OPE
%token fg_add    // OPE "+"  OPE
%token fg_sub    // OPE "-"  OPE
%token fg_mul    // OPE "*"  OPE
%token fg_div    // OPE "/"  OPE
%token fg_mod    // OPE "%"  OPE
%token fg_pow    // OPE "**" OPE
%token fg_not    // OPE "!"  OPE
%token fg_bnot   // OPE "~"  OPE
%token fg_min    // OPE "_"  OPE
%token fg_inc    // OPE "++" OPE
%token fg_dec    // OPE "--" OPE

%token FG_CHR
%token FG_NUM
%token FG_FLT
%token FG_STR
%token FG_ID

%type<i> FG_NUM
%type<f> FG_FLT
%type<s> FG_STR
%type<s> FG_ID

%type<i> CTRLLIST
%type<i> CTRLFLOW
%type<i> DATAFLOW
%type<i> BLOCK
%type<i> ELSE

%type<i> VAL
%type<i> OPE00
%type<i> OPE0
%type<i> OPE1
%type<i> OPE2
%type<i> OPE3
%type<i> OPE4
%type<i> OPE5
%type<i> OPE6
%type<i> OPE7
%type<i> OPE8
%type<i> OPE9
%type<i> OPE10
%type<i> OPE11
%type<i> OPE12
%type<i> OPE13
%type<i> ARGS

%right fg_ass    // OPE '='  OPE
%right fg_muleq  // OPE "*=" OPE
%right fg_diveq  // OPE "/=" OPE
%right fg_modeq  // OPE "%=" OPE
%right fg_addeq  // OPE "+=" OPE
%right fg_subeq  // OPE "-=" OPE
%right fg_lsfeq  // OPE "<<="OPE 
%right fg_rsheq  // OPE ">>="OPE
%right fg_andeq  // OPE "&=" OPE
%right fg_oreq   // OPE "|=" OPE
%right fg_xoreq  // OPE "^=" OPE
%right fg_poweq  // OPE "**="OPE

%start ROOTOBJ

%%


ROOTOBJ :{fgSuper=fgMakeObj(fhdl,fgFile,fgSuper);
          fgSysObjGlobalArgs(fhdl,fgArgc,fgArgv,fgSuper);}
         CTRLLIST
         {fgSysObjDef(fhdl,fgSuper,fgSysGetHead(fhdl,$2),0);}
        ;

CTRLLIST : /*empty*/ {$$=0;}
         | CTRLLIST CTRLFLOW {
           $$=fgSysSetNext(fhdl,$1,$2);
           if($2) $$=$2;
           else   $$=$1;
           #ifdef FG_SHELL
           if(!dfflag) fgMethod(fhdl,$2);
           #endif
           }
         ;

CTRLFLOW : /*data flow------------------------------*/
           BLOCK {$$=$1;} 
         | /*def------------------------------------*/
          fg_def FG_ID {
          $$=fgSysObjId(fhdl,$2,fgSuper);
          cstackPush(stkSuper,&fgSuper);
          cstackPush(stkSuper,&$$);
          fgSuper=$$;
          #ifdef FG_SHELL
          dfflag++;
          #endif
          }
          CTRLFLOW {
          #ifdef FG_SHELL
          dfflag--;
          #endif
          $$=cioVoid(cstackPop(stkSuper),int);
          fgSuper=cioVoid(cstackPop(stkSuper),int);
          $$=fgSysObjDef(fhdl,$$,$4,fgSuper);
          }
        | /*while----------------------------------*/
          fg_while OPE12 {
          #ifdef FG_SHELL
          dfflag++;
          #endif
          }
          CTRLFLOW {
          #ifdef FG_SHELL
          dfflag--;
          #endif
          $$=fgMakeObj(fhdl,fgDefWhile,fgSuper);
          fgSysObjWhile(fhdl,$$,$2,$4,fgSuper);
          }
        | /*for-------------------------------------*/
          fg_for{
          #ifdef FG_SHELL
          dfflag++;
          #endif
          }
          OPE0 fg_in OPE12 CTRLFLOW {
          #ifdef FG_SHELL
          dfflag--;
          #endif
          $$=fgMakeObj(fhdl,fgDefFor,fgSuper);
          fgSysObjFor(fhdl,$$,$3,$5,$6,fgSuper);
          }
        | /*if--------------------------------------*/
          fg_if{
          #ifdef FG_SHELL
          dfflag++;
          #endif
          }
          OPE12 CTRLFLOW ELSE {
          #ifdef FG_SHELL
          dfflag--;
          #endif
          $$=fgSysObjIf(fhdl,$3,$4,$5,fgSuper);
          }
       | /*return----------------------------------*/
         fg_return DATAFLOW 
         {$$=fgMakeObj(fhdl,fgDefReturn,fgSuper);
         fgSysObjReturn(fhdl,$$,$2);
         }
       | /*break-----------------------------------*/
         fg_break
         {$$=fgMakeObj(fhdl,fgDefBreak,fgSuper);
         }
       | /*contune---------------------------------*/
         fg_continue
         {$$=fgMakeObj(fhdl,fgDefContinue,fgSuper);
         }
       | /*import----------------------------------*/
         fg_import FG_ID
         {$$=fgLexChangeBuf(fhdl,$2,fgSuper);
         }
       ;

BLOCK : DATAFLOW  {$$=$1; }
      | ':' CTRLLIST '.' ENDLINE {$$=fgSysGetHead(fhdl,$2);}
      ;

ELSE : /*empty*/ {$$=0;}
     | fg_else CTRLFLOW {$$=$2;}
     ;

ENDLINE : '\n' {elflag=0;}
        | fg_dot2;
        ;

DATAFLOW : ENDLINE    {$$=0}
         | OPE13 ENDLINE {$$=fgSysObjDf(fhdl,fgSuper,$1); }
         ;

ARGS :/*empty*/   {$$=0;}
     | ARGS  {cstackPush(stkSuper,&fgSuper);
              fgSuper=fgMakeObj(fhdl,fgDefSuper,fgSuper);}
       OPE12 {fgSuper=cioVoid(cstackPop(stkSuper),int); 
              $$=fgSysObjArg(fhdl,$3,fgSuper);
              fgSysSetNext(fhdl,$1,$$);
             }
     ;

OPE13    :OPE12
          {cstackPush(stkSuper,&fgSuper);
           cstackPush(stkSuper,&$1);
           fgSuper=$1;}
          ARGS 
          {$1=cioVoid(cstackPop(stkSuper),int);
           fgSuper=cioVoid(cstackPop(stkSuper),int);
           $$=fgSysObjArgIni(fhdl,$1,$3,fgSuper); } 
         ;

OPE12    : OPE11 {$$=$1;}
         | OPE1 fg_ass   SPACE OPE12{$$=fgSysObjAss(fhdl,$1,fgSuper,$4);}
         | OPE1 fg_muleq SPACE OPE12{$$=fgSysObjMule(fhdl,fgSuper,$1,$4);}
         | OPE1 fg_subeq SPACE OPE12{$$=fgSysObjSube(fhdl,fgSuper,$1,$4);}
         | OPE1 fg_addeq SPACE OPE12{$$=fgSysObjAdde(fhdl,fgSuper,$1,$4);}
         | OPE1 fg_diveq SPACE OPE12{$$=fgSysObjDive(fhdl,fgSuper,$1,$4);}
         | OPE1 fg_modeq SPACE OPE12{$$=fgSysObjMode(fhdl,fgSuper,$1,$4);}
         | OPE1 fg_poweq SPACE OPE12{$$=fgSysObjPowe(fhdl,fgSuper,$1,$4);}
         | OPE1 fg_lsfeq SPACE OPE12{$$=fgSysObjLsfe(fhdl,fgSuper,$1,$4);}
         | OPE1 fg_rsheq SPACE OPE12{$$=fgSysObjRsfe(fhdl,fgSuper,$1,$4);}
         | OPE1 fg_andeq SPACE OPE12{$$=fgSysObjAnde(fhdl,fgSuper,$1,$4);}
         | OPE1 fg_oreq  SPACE OPE12{$$=fgSysObjOre(fhdl,fgSuper,$1,$4);}
         | OPE1 fg_xoreq SPACE OPE12{$$=fgSysObjXore(fhdl,fgSuper,$1,$4);}
         ;

OPE11    : OPE10{$$=$1;}
         | OPE11 fg_oror SPACE OPE10 {$$=fgSysObjOror(fhdl,fgSuper,$1,$4);}
         ;

OPE10    : OPE9{$$=$1;}
         | OPE10 fg_andand SPACE OPE9 {$$=fgSysObjAndand(fhdl,fgSuper,$1,$4);}
         ;

OPE9     : OPE8{$$=$1;}
         | OPE9 fg_or SPACE OPE8 {$$=fgSysObjOr(fhdl,fgSuper,$1,$4);}
         ;

OPE8     : OPE7{$$=$1;}
         | OPE8 fg_xor SPACE OPE7 {$$=fgSysObjXor(fhdl,fgSuper,$1,$4);}
         ;

OPE7     : OPE6{$$=$1;}
         | OPE7 fg_and SPACE OPE6 {$$=fgSysObjAnd(fhdl,fgSuper,$1,$4);}
         ;

OPE6     : OPE5{$$=$1;}
         | OPE6 fg_eq  SPACE OPE5 {$$=fgSysObjEq(fhdl,fgSuper,$1,$4);}
         | OPE6 fg_neq SPACE OPE5 {$$=fgSysObjNeq(fhdl,fgSuper,$1,$4);}
         ;

OPE5     : OPE4{$$=$1;}
         | OPE5 fg_les SPACE OPE4 {$$=fgSysObjLes(fhdl,fgSuper,$1,$4);}
         | OPE5 fg_gre SPACE OPE4 {$$=fgSysObjGre(fhdl,fgSuper,$1,$4);}
         | OPE5 fg_leseq SPACE OPE4 {$$=fgSysObjLese(fhdl,fgSuper,$1,$4);}
         | OPE5 fg_greeq SPACE OPE4 {$$=fgSysObjGree(fhdl,fgSuper,$1,$4);}
         ;

OPE4     : OPE3{$$=$1;}
         | OPE4 fg_lsf SPACE OPE3 {$$=fgSysObjLsf(fhdl,fgSuper,$1,$4);}
         | OPE4 fg_rsf SPACE OPE3 {$$=fgSysObjRsf(fhdl,fgSuper,$1,$4);}
         ;

OPE3     : OPE2{$$=$1;}
         | OPE3 fg_add SPACE OPE2 {$$=fgSysObjAdd(fhdl,fgSuper,$1,$4);}
         | OPE3 fg_sub SPACE OPE2 {$$=fgSysObjSub(fhdl,fgSuper,$1,$4);}
         ;

OPE2     : OPE1{$$=$1;}
         | OPE2 fg_mul SPACE OPE1 {$$=fgSysObjMul(fhdl,fgSuper,$1,$4);}
         | OPE2 fg_div SPACE OPE1 {$$=fgSysObjDiv(fhdl,fgSuper,$1,$4);}
         | OPE2 fg_mod SPACE OPE1 {$$=fgSysObjMod(fhdl,fgSuper,$1,$4);}
         | OPE2 fg_pow SPACE OPE1 {$$=fgSysObjPow(fhdl,fgSuper,$1,$4);}
         ;

OPE1     : OPE0 {$$=$1;}
         | fg_min   OPE0 {$$=fgSysObjMin(fhdl,fgSuper,$2);}
         | fg_not   OPE0 {$$=fgSysObjNot(fhdl,fgSuper,$2);}
         | fg_bnot  OPE0 {$$=fgSysObjBnot(fhdl,fgSuper,$2);}
         ;

OPE0     : OPE00
         | fg_inc OPE00  {$$=fgSysObjInc(fhdl,fgSuper,$2);}
         | fg_dec OPE00  {$$=fgSysObjDec(fhdl,fgSuper,$2);}
         ;
         
OPE00    : VAL {$$=$1;}
         | '(' SPACE OPE13 SPACE ')'  {$$=$3;}
         | '{' SPACE OPE13 SPACE '}'  {$$=$3;}
         | OPE00 '[' SPACE OPE13 SPACE ']' {$$=fgSysObjArry(fhdl,$1,$4,fgSuper);}
         | OPE00 '.' FG_ID {$$=fgSysObjDot(fhdl,$1,$3,fgSuper);}
         ;

VAL      : FG_NUM {$$=fgSysObjConstInt(fhdl,$1,fgSuper);}
         | FG_FLT {$$=fgSysObjConstFlt(fhdl,$1,fgSuper);}
         | FG_STR {$$=fgSysObjConstStr(fhdl,$1,fgSuper);}
         | FG_ID  {$$=fgSysObjId(fhdl,$1,fgSuper);}
         ;

SPACE : /*empty*/
      | '\n'
      ;
%%
//===========================================================================//
//                                                                           //
//                               functions                                   //
//                                                                           //
//===========================================================================//
//error message
int yyerror(char*token){
    cmsgEcho(fhdl->msg,fgErr,fgFile,fgLine,token);
    return -1;
}
//fgParseIni
static fgHandle fgParseIni(fgHandle inhdl,int argc,char**argv){
    fgLine=1;
    fgErr=0;
    fgSuper=0;
    elflag=0;
    stkSuper=cstackIni(sizeof(int));
    if(!inhdl->name){
        stdinFlag=1;
        dfflag=0;
        fgFile="..stdin..";
    }else if(!strcmp(inhdl->name,"")){
        stdinFlag=1;
        dfflag=0;
        fgFile="..stdin..";
    }else {
        stdinFlag=0;
        dfflag=1;
        fgFile=inhdl->name;
        cioOpen(yyin,fgFile,"r",return NULL);
    }
    if(argc>0){
        fgArgc=argc;
        fgArgv=argv;
    }else{
        fgArgc=1;
        cstrMakeBuf(fgArgv,1,char*,exit(-1));
        fgArgv[0]=fgFile;
    }
    fhdl=inhdl;
    return fhdl;
}
//parse main
int fgParse(fgHandle fhdl,int argc,char**argv){
    int flg;
    if(!fgParseIni(fhdl,argc,argv)) return -1;
    while(flg=yyparse()){
        if(strcmp(fgFile,"..stdin..")) break;
    }
    cstackDes(stkSuper);
    return flg;
}

