%{
//*****************************************************************************//
//fridge.l
//Copyright (C) 2006 K.Tsuchiya ltd.
//2006/08/29
//... fridge lexer.
//*****************************************************************************//
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <readline/readline.h>
#include "calg.h"
#include "fridge.tab.h"
#include "fridge.h"
/*input wrapper*/
#undef  YY_INPUT
#define YY_INPUT(buf,result,max) (result=fgInput(buf,max))
static int fgInput(char*buf,int max){
    if((!yyin) || (yyin==stdin)){
        int i;
        char* val;
        val=readline("fridge # ");
        if(val[0]!=CIO_ES) add_history(val);
        for(i=0;i<max;i++){
            buf[i]=val[i];
            if(val[i]==CIO_ES){
                buf[i]=CIO_EL;
                i++;
                if(i<max) buf[i]=CIO_ES;
                else buf[i-1]=CIO_ES;
                break;
            }
            if(val[i]==EOF)    break;  
        }
        free(val);
        return i;
    }
    else return fread(buf,sizeof(char),max,yyin);
}

//char
static int frLexSetChar(int token);
//str
static int frLexSetStr(int token);
//line
static int frLexSetLine(int token);
//doc
static int frLexSetDoc(int token);
//Id
static int frLexSetId(int token);
//float
static int frLexSetFloat(int token);
//num
static int frLexSetNum(int token);
//endline
static int frLexEndLine(void);
//else
static int frLexSetElse(int token);
int    fgLine;
char*  fgFile; /*file name*/
static cVector impstk=NULL;
%}

%option outfile="fridge.yy.c"


%%
[\t\r ]+   ;
"#".*\n    ;
"//".*\n   ;
"/*"([^*]*([*][^/])*)*"*/" ;
exit     return EOF;
import   return fg_import;
def      return fg_def;
while    return fg_while; 
for      return fg_for;
in       return fg_in;
if       return fg_if;
else     return fg_else;
return   return fg_return;
break    return  fg_break;
continue return fg_continue;
".."  return fg_dot2;//..
"="   return fg_ass;    // OPE "=" OPE
"**=" return fg_poweq;  // OPE "**="OPE
"*="  return fg_muleq;  // OPE "*=" OPE
"/="  return fg_diveq;  // OPE "/=" OPE
"%="  return fg_modeq;  // OPE "%=" OPE
"+="  return fg_addeq;  // OPE "+=" OPE
"-="  return fg_subeq;  // OPE "-=" OPE
"<<=" return fg_lsfeq;  // OPE "<<=" OPE
">>=" return fg_rsheq;  // OPE ">>=" OPE
"&="  return fg_andeq;  // OPE "&=" OPE
"|="  return fg_oreq;   // OPE "|=" OPE
"^="  return fg_xoreq;  // OPE "^=" OPE
"||"  return fg_oror;   // OPE "||" OPE
"&&"  return fg_andand; // OPE "&&" OPE
"|"   return fg_or;     // OPE "|"  OPE
"^"   return fg_xor;    // OPE "^"  OPE
"&"   return fg_and;    // OPE "&"  OPE
"=="  return fg_eq;     // OPE "=="  OPE
"!="  return fg_neq;    // OPE "!="  OPE
"<"   return fg_les;    // OPE "<"  OPE
">"   return fg_gre;    // OPE ">"  OPE
"<="  return fg_leseq;  // OPE "<="  OPE
">="  return fg_greeq;  // OPE ">="  OPE
"<<"  return fg_lsf;    // OPE "<<"  OPE
">>"  return fg_rsf;    // OPE ">>"  OPE
"+"   return fg_add;    // OPE "+"  OPE
"-"   return fg_sub;    // OPE "-"  OPE
"*"   return fg_mul;    // OPE "*"  OPE
"/"   return fg_div;    // OPE "/"  OPE
"%"   return fg_mod;    // OPE "%"  OPE
"**"  return fg_pow;    // OPE "**"  OPE
"!"   return fg_not;    // OPE "!"  OPE
"~"   return fg_bnot;   // OPE "~"  OPE
"_"   return fg_min;    // OPE "_"  OPE
"++"  return fg_inc;    // OPE "++"  OPE
"--"  return fg_dec;    // OPE "--"  OPE
["]["]["][\n]+([^"]*(\"{1,2}[^"])*)+["]["]["] {
                          return frLexSetDoc(FG_STR);}
[,].*                     return frLexSetLine(FG_STR);
[']([^'\n])*[']           return frLexSetStr(FG_STR);
["]([^"\n])*["]           return frLexSetStr(FG_STR);
[a-zA-Z][a-zA-Z0-9]*      return frLexSetId(FG_ID);
[0-9]+[.][0-9]+           return frLexSetFloat(FG_FLT);
[0-9]+                    return frLexSetNum(FG_NUM);
[\n]                      return frLexEndLine();
.                         return frLexSetElse(yytext[0]);

%%
/******function**********/
//wrap
int yywrap(void){
    if(impstk){
        if(cvectGetSize(impstk)){
            YY_BUFFER_STATE buffer;
            yy_delete_buffer(YY_CURRENT_BUFFER);
            buffer=cioVoid(cvectPop(impstk),YY_BUFFER_STATE);
            yy_switch_to_buffer(buffer);
            return 0;
        }else{
            cvectDes(impstk);
            impstk=NULL;
        }
    }
    return 1;
}
//change buffer
int fgLexChangeBuf(fgHandle fhdl,char*name,int super){
    int type;
    char*path;
    path=fgPath(name,0x01,&type);
    if(!path){
        cmsgEcho(fhdl->msg,0x1,fgFile,fgLine,name);
        return 0;
    }
    if(!strcmp(path,fgFile)) return 0;
    switch(type){
    case 0x00:{//fgfile
        YY_BUFFER_STATE buffer;
        if(!impstk) impstk=cvectIni(sizeof(YY_BUFFER_STATE),10);
        buffer=YY_CURRENT_BUFFER;
        cvectPush(impstk,&buffer);
        yyin=fopen(path,"r");
        buffer=yy_create_buffer(yyin,YY_BUF_SIZE);
        yy_switch_to_buffer(buffer);
    }break;
    default :
    fgSysObjFileObj(name,path);
    break;
    }
    free(path);
    return 0;
}
//end line
static int frLexEndLine(void){
    fgLine++;
    return '\n';
}
//char
static int frLexSetChar(int token){
    yylval.i=yytext[1];
    return token;
}
//Line
static int frLexSetLine(int token){
    cstrSet(yylval.s,(yytext+1),exit(-1));
    return token;
}
//str
static int frLexSetStr(int token){
    yytext[yyleng-1]=CIO_ES;
    cstrSet(yylval.s,(yytext+1),exit(-1));
    return token;
}
//doc
static int frLexSetDoc(int token){
    yytext[yyleng-3]=CIO_ES;
    cstrSet(yylval.s,(yytext+4),exit(-1));
    return token;
}
//Id
static int frLexSetId(int token){
    cstrSet(yylval.s,yytext,exit(-1));
    return token;
}
//float
static int frLexSetFloat(int token){
    yylval.f=atof(yytext);
    return token;
}
//num
static int frLexSetNum(int token){
    yylval.i=atoi(yytext);
    return token;
}
//else
static int frLexSetElse(int token){
    return token;
}



