//*****************************************************************************//
//fgsysobj.c
//Copyright (C) 2006 K.Tsuchiya ltd.
//2006/08/29
//... fridge system object .
//*****************************************************************************//
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "fridge.h"
#include "fgraph.h"
#include "fgsysobj.h"
#include "calg.h"
/*garbage memory map*/
cMap __cioMemMap=NULL;
//==============================================================================
//set global args
//==============================================================================
int fgSysObjGlobalArgs(fgHandle fhdl,int argc,char**argv,int super){
    int i,index,arg;
    fgData data={fgDataTypeObj,0};
    fgData num ={fgDataTypeInt,0};
    arg=fgMakeObj(fhdl,fgDefArg,super);
    for(i=0;i<argc;i++){
        index=fgSysObjConstStr(fhdl,argv[i],super);
        data.elm.i=index;
        num.elm.i=i;
        fgSetArry(fhdl,arg,num,data);
    }
    return index;          
}
//==============================================================================
//__DEF__ object
//==============================================================================
//method
static fgData fgSysObjMethDef(fgHandle fhdl,int self){
    fgData data;
    data=fgGetObj(fhdl,self,fgDefBlock);
    if(data.type!=fgDataTypeObj){
        data.type=fgDataTypeObj;
        data.elm.i=self;
        return data;
    }
    data=fgMethod(fhdl,data.elm.i);
    if(fgSysCondReturn(fhdl,data))
        return fgGetObj(fhdl,data.elm.i,fgDefValue);
    data.type=fgDataTypeObj;
    data.elm.i=self;
    return data;
}
//method def
static fgData fgSysObjMethDefDef(fgHandle fhdl,int self){
    fgData next;
    next=fgGetObj(fhdl,self,fgDefNext);
    if((next.type!=fgDataTypeObj) ||
       !next.elm.i){
       next.type=fgDataTypeInt;
       next.elm.i=0;
       return next;
    }
    return fgMethod(fhdl,next.elm.i);
}
//sys def
int fgSysObjDef(fgHandle fhdl,int index,int block,int super){
    fgData data;
    data.type=fgDataTypeObj;
    if(block) data.elm.i=block;
    fgSetObj(fhdl,index,fgDefBlock,data);
    fgSetMeth(fhdl,index,(*fgSysObjMethDef));
    index=fgMakeObj(fhdl,fgDefDef,super);
    fgSetMeth(fhdl,index,(*fgSysObjMethDefDef));
    return index;
}
//==============================================================================
//__RETURN__ object
//==============================================================================
//meth
static fgData fgSysObjMethReturn(fgHandle fhdl,int self){
    fgData data;
    data=fgGetObj(fhdl,self,fgDefBlock);
    if(data.type==fgDataTypeObj)
        data=fgMethod(fhdl,data.elm.i);
    fgSetObj(fhdl,self,fgDefValue,data);
    data.type =fgDataTypeObj;
    data.elm.i=self;
    return data;
}
//sys return 
int fgSysObjReturn(fgHandle fhdl,int index,int block){
    fgData data;
    data.type=fgDataTypeObj;
    if(block){
        data.elm.i=block;
        fgSetObj(fhdl,index,fgDefBlock,data);
    }
    fgSetMeth(fhdl,index,(*fgSysObjMethReturn));
    return index;
}
//==============================================================================
//sys get head
//==============================================================================
int fgSysGetHead(fgHandle fhdl,int index){
    fgData data;
    data=fgGetObj(fhdl,index,fgDefPrev);
    while((data.elm.i)&&(data.type==fgDataTypeObj)){
        index=data.elm.i;
        data=fgGetObj(fhdl,index,fgDefPrev);
    }
    return index;
}
//==============================================================================
//sys set next
//==============================================================================
int fgSysSetNext(fgHandle fhdl,int index,int next){
    fgData data;
    if(!next)  return next;
    if(!index) return next;
    data.type=fgDataTypeObj;
    data.elm.i=next;
    fgSetObj(fhdl,index,fgDefNext,data);
    data.elm.i=index;
    fgSetObj(fhdl,next,fgDefPrev,data);
    return next;
}
//==============================================================================
//__IF__ object
//==============================================================================
//def
static int fgSysObjIfMethInt(fgHandle fhdl,fgData data){
    return data.elm.i?1:0;
}
//float
static int fgSysObjIfMethFlg(fgHandle fhdl,fgData data){
    return data.elm.f?1:0;
}
//str
static int fgSysObjIfMethStr(fgHandle fhdl,fgData data){
    return data.elm.s?1:0;
}
//obj
static int fgSysObjIfMethObj(fgHandle fhdl,fgData data){
    static int (*func[])(fgHandle,fgData)={
        (*fgSysObjIfMethInt),(*fgSysObjIfMethFlg),
        (*fgSysObjIfMethStr),(*fgSysObjIfMethObj),
    };
    data=fgGetObj(fhdl,data.elm.i,fgDefValue);
    return func[data.type](fhdl,data);
}
//method
static fgData fgSysObjMethIf(fgHandle fhdl,int self){
    fgData data;
    fgData retdata;
    data=fgGetObj(fhdl,self,fgDefCond);
    data=fgMethod(fhdl,data.elm.i);
    data.type=fgDataTypeInt;
    data.elm.i=fgSysObjIfMethObj(fhdl,data);
    if(data.elm.i) data=fgGetObj(fhdl,self,fgDefThen);
    else data=fgGetObj(fhdl,self,fgDefElse);
    retdata=fgMethod(fhdl,data.elm.i);
    if(fgSysCondReturn(fhdl,retdata))   return retdata;
    if(fgSysCondBreak(fhdl,retdata))    return retdata;
    if(fgSysCondContinue(fhdl,retdata)) return retdata;
    data=fgGetObj(fhdl,self,fgDefNext);
    if((data.type!=fgDataTypeObj)|| (!data.elm.i)) return retdata;
    return data=fgMethod(fhdl,data.elm.i);
}
//if
int fgSysObjIf(fgHandle fhdl,int cond,
    int then,int es,int super){
    int ifindex;
    fgData data;
    ifindex=fgMakeObj(fhdl,fgDefIf,super);
    fgSetMeth(fhdl,ifindex,(*fgSysObjMethIf));
    data.type=fgDataTypeObj;
    data.elm.i=cond;
    if(data.elm.i) fgSetObj(fhdl,ifindex,fgDefCond,data);
    data.elm.i=then;
    if(data.elm.i) fgSetObj(fhdl,ifindex,fgDefThen,data);
    data.elm.i=es;
    if(data.elm.i) fgSetObj(fhdl,ifindex,fgDefElse,data);
    return ifindex;
}
//==============================================================================
//cond __RETURN__ object
//==============================================================================
int fgSysCondReturn(fgHandle fhdl,fgData data){
    if(data.type!=fgDataTypeObj) return 0;
    return !strcmp(fgGetName(fhdl,data.elm.i),fgDefReturn);
}
//==============================================================================
//cond __BREAK__ object
//==============================================================================
int fgSysCondBreak(fgHandle fhdl,fgData data){
    if(data.type!=fgDataTypeObj) return 0;
    return !strcmp(fgGetName(fhdl,data.elm.i),fgDefBreak);
}
//==============================================================================
//cond __CONTINUE__ object
//==============================================================================
int fgSysCondContinue(fgHandle fhdl,fgData data){
    if(data.type!=fgDataTypeObj) return 0;
    return !strcmp(fgGetName(fhdl,data.elm.i),fgDefContinue);
}
//==============================================================================
//__FOR__ object
//==============================================================================
//int
static double fgSysObjMethForInt(fgHandle fhdl,fgData data){
    return (double)data.elm.i;
}
//float
static double fgSysObjMethForFlt(fgHandle fhdl,fgData data){
    return data.elm.f;
}
//str
static double fgSysObjMethForStr(fgHandle fhdl,fgData data){
    if(!data.elm.s) return 0.0;
    return (double)strlen(data.elm.s);
}
//obj
static double fgSysObjMethForObj(fgHandle fhdl,fgData data){
    fgData value;
    static double (*func[])(fgHandle,fgData)={
        fgSysObjMethForInt, fgSysObjMethForFlt,
        fgSysObjMethForStr, fgSysObjMethForObj,
    };
    value=fgGetObj(fhdl,data.elm.i,fgDefValue);
    return func[value.type](fhdl,value);
}
//method
static fgData fgSysObjMethFor(fgHandle fhdl,int self){
    fgData loop;
    fgData cond;
    fgData block;
    fgData flgdata;
    fgData retdata;
    fgData val={fgDataTypeInt,0};
    fgData data={fgDataTypeInt,0};
    loop=fgGetObj(fhdl,self,fgDefLoop);
    if(loop.type!=fgDataTypeObj) return data;
    fgSetObj(fhdl,loop.elm.i,fgDefValue,val);
    fgSetMeth(fhdl,loop.elm.i,(*fgMethDef));
    cond=fgGetObj(fhdl,self,fgDefCond);
    flgdata=fgMethod(fhdl,cond.elm.i);
    block=fgGetObj(fhdl,self,fgDefBlock);
    while(((double)val.elm.i)<fgSysObjMethForObj(fhdl,flgdata)){
        data=fgMethod(fhdl,block.elm.i);
        if(fgSysCondBreak(fhdl,data)) break;
        else if(fgSysCondReturn(fhdl,data)) return data;
        val.elm.i++;
        fgSetObj(fhdl,loop.elm.i,fgDefValue,val);
        flgdata=fgMethod(fhdl,cond.elm.i);
    }
    retdata=data;
    data=fgGetObj(fhdl,self,fgDefNext);
    if(data.type!=fgDataTypeObj) return retdata;
    else data=fgMethod(fhdl,data.elm.i);
    return data;
}
//sys for
int fgSysObjFor(fgHandle fhdl,int index,
    int loop,int cond,int block,int super){
    fgData data;
    data.type = fgDataTypeObj;
    if(loop){
        data.elm.i=loop;
        fgSetObj(fhdl,index,fgDefLoop,data);
    }
    if(cond){
        data.elm.i=cond;
        fgSetObj(fhdl,index,fgDefCond,data);
    }
    if(block){
        data.elm.i=block;
        fgSetObj(fhdl,index,fgDefBlock,data);
    }
    fgSetMeth(fhdl,index,(*fgSysObjMethFor));
    return index;
}
//==============================================================================
//__WHILE__ object
//==============================================================================
//method
static fgData fgSysObjMethWhile(fgHandle fhdl,int self){
    fgData block;
    fgData cond;
    fgData conddata;
    fgData retdata;
    register fgData data;
    cond=fgGetObj(fhdl,self,fgDefCond);
    conddata=fgMethod(fhdl,cond.elm.i);
    conddata.type=fgDataTypeInt;
    conddata.elm.i=fgSysObjIfMethObj(fhdl,conddata);
    block=fgGetObj(fhdl,self,fgDefBlock);
    while(conddata.elm.i){
        retdata=fgMethod(fhdl,block.elm.i); 
        if(fgSysCondBreak(fhdl,retdata)) break;
        else if(fgSysCondReturn(fhdl,retdata)) return retdata;
        conddata=fgMethod(fhdl,cond.elm.i);
        conddata.type=fgDataTypeInt;
        conddata.elm.i=fgSysObjIfMethObj(fhdl,conddata);
    }
    data=fgGetObj(fhdl,self,fgDefNext);
    return fgMethod(fhdl,data.elm.i);
}
//sys while
int fgSysObjWhile(fgHandle fhdl,int index,
    int cond,int block,int super){
    fgData data;
    data.type = fgDataTypeObj;
    if(cond){
        data.elm.i=cond;
        fgSetObj(fhdl,index,fgDefCond,data);
    }
    if(block){
        data.elm.i=block;
        fgSetObj(fhdl,index,fgDefBlock,data);
    }
    fgSetMeth(fhdl,index,(*fgSysObjMethWhile));
    return index;
}
//==============================================================================
//__ARG__ object
//==============================================================================
//method
static fgData fgSysObjArginiMeth(fgHandle fhdl,int self){
    int i,arg,size;
    fgData left;
    fgData right;
    fgData value;
    fgData ope;
    char*name;
    left =fgGetObj(fhdl,self,fgDefLeft);
    name=fgGetName(fhdl,left.elm.i);
    if(cmapFind(fhdl->ktbl,&name)) left=fgMethod(fhdl,left.elm.i);
    right=fgGetObj(fhdl,self,fgDefRight);
    arg=fgMakeObj(fhdl,fgDefArg,left.elm.i);
    value.type=fgDataTypeInt;
    for(i=0;(right.type==fgDataTypeObj) && right.elm.i;i++){
        ope=fgGetObj(fhdl,right.elm.i,fgDefOpe);
        ope=fgMethod(fhdl,ope.elm.i);
        value.elm.i=i;
        fgSetArry(fhdl,arg,value,ope);
        right=fgGetObj(fhdl,right.elm.i,fgDefNext);
    }
    size=fgMakeObj(fhdl,fgDefSize,arg);
    value.elm.i=i;
    fgSetObj(fhdl,size,fgDefValue,value);
    return fgMethod(fhdl,left.elm.i);
}
//init arg
int fgSysObjArgIni(fgHandle fhdl,int left,int right,int super){
    int index;
    fgData data;
    index=fgMakeObj(fhdl,fgDefArgini,super);
    fgSetMeth(fhdl,index,(*fgSysObjArginiMeth));
    data.type=fgDataTypeObj;
    data.elm.i=left;
    fgSetObj(fhdl,index,fgDefLeft,data);
    data.elm.i=fgSysGetHead(fhdl,right);
    fgSetObj(fhdl,index,fgDefRight,data);
    return index;
}
//args
int fgSysObjArg(fgHandle fhdl,int ope,int super){
    int index;
    fgData data;
    index=fgMakeObj(fhdl,fgDefArgval,super);
    data.type=fgDataTypeObj;
    data.elm.i=ope;
    fgSetObj(fhdl,index,fgDefOpe,data);
    return index;
}
//get argelm
inline fgData fgSysGetArgElm(fgHandle fhdl,int self,int index){
    int arg;
    fgData data={fgDataTypeInt,index};
    arg=fgMakeObj(fhdl,fgDefArg,self);
    return fgGetArry(fhdl,arg,data);
}
//get argsize
inline int fgSysGetArgSize(fgHandle fhdl,int self){
    int arg;
    int sizeobj;
    fgData data;
    arg=fgMakeObj(fhdl,fgDefArg,self);
    sizeobj=fgMakeObj(fhdl,fgDefSize,arg);
    data=fgGetObj(fhdl,sizeobj,fgDefValue);
    if(data.type==fgDataTypeInt) return data.elm.i;
    return 0;
}
//==============================================================================
//__ASSIGN__ object
//==============================================================================
//int,float 
static fgData fgSysObjAssMethDef(fgHandle fhdl,
    fgData data,char*name,int super){
    return data;
}
//string
static fgData fgSysObjAssMethStr(fgHandle fhdl,
    fgData data,char*name,int super){
    fgData tmpdata;
    tmpdata.type=data.type;
    cstrSet(tmpdata.elm.s,data.elm.s,exit(-1));
    return tmpdata;
}
//object copy
static fgData fgSysObjAssMethObjCopy(fgHandle fhdl,
    int left,int right){
    int i;
    char*objname;
    int vctsize;
    fgData  leftindex;
    fgData  ldata;
    fgObj*  lobj;
    fgObj*  robj;
    fgData* rdata;
    cMap    rmap;
    cVector rvct;
    cMap    loopMap;
    static fgData (*meth[])(fgHandle,fgData,char*,int)={
        (*fgSysObjAssMethDef),
        (*fgSysObjAssMethDef),
        (*fgSysObjAssMethStr),
        (*fgSysObjAssMethDef),
    };
    leftindex.type=fgDataTypeObj;
    leftindex.elm.i=left;
    if(left==right) return leftindex; 
    robj=cmapFind(fhdl->obj,&right);
    lobj=cmapFind(fhdl->obj,&left);
    if((!robj)||(!lobj)) return leftindex;
    rmap=robj->map;
    rvct=rmap->elmlist;
    vctsize=cvectGetSize(rvct);
    for(i=0;i<vctsize;i++){
        objname=cioVoid(cvectFind(rvct,i),char*);
        if(!strcmp(objname,fgDefSuper)) continue;
	if(!strcmp(objname,fgDefSelf))  continue;
        rdata=cmapFind(rmap,&objname);
	if(!rdata)continue;
        ldata=meth[rdata->type](fhdl,*rdata,objname,left);
        fgSetObj(fhdl,left,objname,ldata);
    }
    leftindex.type=fgDataTypeObj;
    leftindex.elm.i=left;
    return leftindex;
}
//method
static fgData fgSysObjAssMeth(fgHandle fhdl,int self){
    fgData  left;
    fgData  right;
    int vctsize;
    left =fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    if(left.type !=fgDataTypeObj)  return left;
    if(right.type!=fgDataTypeObj)  return left;
    right=fgMethod(fhdl,right.elm.i);
    left=fgMethod(fhdl,left.elm.i);
    left=fgSysObjAssMethObjCopy(fhdl,left.elm.i,right.elm.i);
    return left;
}
//assign
int fgSysObjAss(fgHandle fhdl,int lindex,int super,int rindex){
    int index;
    fgData data;
    char* tmpstr;
    index=fgMakeObj(fhdl,fgOpeAss,super);
    fgSetMeth(fhdl,index,(*fgSysObjAssMeth));
    data.type=fgDataTypeObj;
    data.elm.i=lindex;
    fgSetObj(fhdl,index,fgDefLeft,data);
    data.elm.i=rindex;
    fgSetObj(fhdl,index,fgDefRight,data);
    
    return index;
}
//==============================================================================
//__CONST__ object
//==============================================================================
//method
static fgData fgSysObjConstMeth(fgHandle fhdl,int self){
    fgData data;
    data.type=fgDataTypeObj;
    data.elm.i=self;
    return data;
}
//int
int fgSysObjConstInt(fgHandle fhdl,int val,int super){
    int self;
    static char buf[256];
    fgData data;
    fgObj superObj;
    sprintf(buf,"%d",val);
    self=fgMakeObj(fhdl,buf,super);
    data.type=fgDataTypeInt;
    data.elm.i=val;
    fgSetObj(fhdl,self,fgDefValue,data);
    fgSetMeth(fhdl,self,(*fgSysObjConstMeth));
    return self; 
}
//float
int fgSysObjConstFlt(fgHandle fhdl,double val,int super){
    int self;
    static char buf[256];
    fgData data;
    fgObj superObj;
    sprintf(buf,"%f",val);
    self=fgMakeObj(fhdl,buf,super);
    data.type=fgDataTypeFlt;
    data.elm.f=val;
    fgSetObj(fhdl,self,fgDefValue,data);
    fgSetMeth(fhdl,self,(*fgSysObjConstMeth));
    return self; 
}
//string
int fgSysObjConstStr(fgHandle fhdl,char* val,int super){
    int self;
    static char *buf;
    fgData data;
    fgObj superObj;
    cstrMakeBuf(buf,strlen(val)+3,char,exit(-1));
    sprintf(buf,"\"%s\"",val);
    self=fgMakeObj(fhdl,buf,super);
    free(buf);
    buf=fgStdEscape(val);
    data.type=fgDataTypeStr;
    data.elm.s=fgGraphGetName(fhdl,buf);
    fgSetObj(fhdl,self,fgDefValue,data);
    fgSetMeth(fhdl,self,(*fgSysObjConstMeth));
    free(buf);
    return self; 
}
//==============================================================================
//__OROR__ object
//==============================================================================
//valtype int
static fgData fgSysObjOrorInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=(left.elm.i||value.elm.i);
    return value;
}
//valtype float
static fgData fgSysObjOrorFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=(left.elm.f||value.elm.f);
    return value;
}
//valtype string
static fgData fgSysObjOrorStr(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeStr);
    value.type=fgDataTypeInt;
    value.elm.i=(left.elm.s||value.elm.s);
    return value;
}
//valtype object
static fgData fgSysObjOrorObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjOrorInt), (*fgSysObjOrorFlt),
        (*fgSysObjOrorStr), (*fgSysObjOrorObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjOrorMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjOrorObj(fhdl,left,right);
    fgSetObj(fhdl,self,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=self;
    return value;
}
//sys oror
int fgSysObjOror(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeOror,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjOrorMeth));
   return self;
}
//==============================================================================
//__ANDAND__ object
//==============================================================================
//valtype int
static fgData fgSysObjAndandInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=(left.elm.i&&value.elm.i);
    return value;
}
//valtype float
static fgData fgSysObjAndandFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=(left.elm.f&&value.elm.f);
    return value;
}
//valtype string
static fgData fgSysObjAndandStr(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeStr);
    value.type=fgDataTypeInt;
    value.elm.i=(left.elm.s&&value.elm.s);
    return value;
}
//valtype object
static fgData fgSysObjAndandObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjAndandInt), (*fgSysObjAndandFlt),
        (*fgSysObjAndandStr), (*fgSysObjAndandObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjAndandMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjAndandObj(fhdl,left,right);
    fgSetObj(fhdl,self,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=self;
    return value;
}
//sys andand
int fgSysObjAndand(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeAndand,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjAndandMeth));
   return self;
}
//==============================================================================
//__XORE__ object
//==============================================================================
//valtype int
static fgData fgSysObjXoreInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=(left.elm.i^value.elm.i);
    return value;
}
//valtype float
static fgData fgSysObjXoreFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    fgData tmpvalue;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    tmpvalue=fgSysCast(fhdl,left,fgDataTypeInt);
    value.elm.i=(left.elm.i^value.elm.i);
    return value;
}
//valtype string
static fgData fgSysObjXoreStr(fgHandle fhdl,fgData left,fgData right){
    char*tmpbuf;
    int i,size1,size2;
    fgData value;
    fgData tmpvalue;
    value=fgSysCast(fhdl,right,fgDataTypeStr);
    tmpbuf=fgTmpBuffer(left.elm.s,0);
    size1=strlen(tmpbuf);
    size2=strlen(value.elm.s);
    for(i=0;(i<size1)&&(i<size2);i++){
        if(tmpbuf[i]==value.elm.s[i]) tmpbuf[i]=' ';
        else if(isspace(tmpbuf[i])) tmpbuf[i]=value.elm.s[i];
    }
    if(size1<size2) cstrCat(tmpbuf,(value.elm.s+size1),exit(-1));
    cstrRemakeBuf(left.elm.s,strlen(tmpbuf)+1,char,exit(-1));
    strcpy(left.elm.s,tmpbuf);
    value.elm.s=left.elm.s;
    fgTmpBuffer(tmpbuf,0x1);
    return value;
}
//valtype object
static fgData fgSysObjXoreObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjXoreInt), (*fgSysObjXoreFlt),
        (*fgSysObjXoreStr), (*fgSysObjXoreObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjXoreMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjXoreObj(fhdl,left,right);
    fgSetObj(fhdl,left.elm.i,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=left.elm.i;
    return value;
}
//sys xor
int fgSysObjXore(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeXoreq,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjXoreMeth));
   return self;
}
//==============================================================================
//__XOR__ object
//==============================================================================
//valtype int
static fgData fgSysObjXorInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=(left.elm.i^value.elm.i);
    return value;
}
//valtype float
static fgData fgSysObjXorFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    fgData tmpvalue;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    tmpvalue=fgSysCast(fhdl,left,fgDataTypeInt);
    value.elm.i=(left.elm.i^value.elm.i);
    return value;
}
//valtype string
static fgData fgSysObjXorStr(fgHandle fhdl,fgData left,fgData right){
    char*tmpbuf;
    int i,size1,size2;
    fgData value;
    fgData tmpvalue;
    value=fgSysCast(fhdl,right,fgDataTypeStr);
    tmpbuf=fgTmpBuffer(left.elm.s,0);
    size1=strlen(tmpbuf);
    size2=strlen(value.elm.s);
    for(i=0;(i<size1)&&(i<size2);i++){
        if(tmpbuf[i]==value.elm.s[i]) tmpbuf[i]=' ';
        else if(isspace(tmpbuf[i])) tmpbuf[i]=value.elm.s[i];
    }
    if(size1<size2) cstrCat(tmpbuf,(value.elm.s+size1),exit(-1));
    value.elm.s=tmpbuf;
    fgTmpBuffer(tmpbuf,0x1);
    return value;
}
//valtype object
static fgData fgSysObjXorObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjXorInt), (*fgSysObjXorFlt),
        (*fgSysObjXorStr), (*fgSysObjXorObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjXorMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjXorObj(fhdl,left,right);
    fgSetObj(fhdl,self,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=self;
    return value;
}
//sys xor
int fgSysObjXor(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeXor,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjXorMeth));
   return self;
}
//==============================================================================
//__ORE__ object
//==============================================================================
//valtype int
static fgData fgSysObjOreInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=(left.elm.i|value.elm.i);
    return value;
}
//valtype float
static fgData fgSysObjOreFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    fgData tmpvalue;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    tmpvalue=fgSysCast(fhdl,left,fgDataTypeInt);
    value.elm.i=(left.elm.i|value.elm.i);
    return value;
}
//valtype string
static fgData fgSysObjOreStr(fgHandle fhdl,fgData left,fgData right){
    char*tmpbuf;
    int i,size1,size2;
    fgData value;
    fgData tmpvalue;
    value=fgSysCast(fhdl,right,fgDataTypeStr);
    tmpbuf=left.elm.s;
    size1=strlen(tmpbuf);
    size2=strlen(value.elm.s);
    for(i=0;(i<size1)&&(i<size2);i++)
        if(isspace(tmpbuf[i])) tmpbuf[i]=value.elm.s[i];
    if(size1<size2) cstrCat(tmpbuf,(value.elm.s+size1),exit(-1));
    value.elm.s=tmpbuf;
    return value;
}
//valtype object
static fgData fgSysObjOreObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjOreInt), (*fgSysObjOreFlt),
        (*fgSysObjOreStr), (*fgSysObjOreObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjOreMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjOreObj(fhdl,left,right);
    fgSetObj(fhdl,left.elm.i,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=left.elm.i;
    return value;
}
//sys orq
int fgSysObjOre(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeOreq,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjOreMeth));
   return self;
}
//==============================================================================
//__OR__ object
//==============================================================================
//valtype int
static fgData fgSysObjOrInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=(left.elm.i|value.elm.i);
    return value;
}
//valtype float
static fgData fgSysObjOrFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    fgData tmpvalue;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    tmpvalue=fgSysCast(fhdl,left,fgDataTypeInt);
    value.elm.i=(left.elm.i|value.elm.i);
    return value;
}
//valtype string
static fgData fgSysObjOrStr(fgHandle fhdl,fgData left,fgData right){
    char*tmpbuf;
    int i,size1,size2;
    fgData value;
    fgData tmpvalue;
    value=fgSysCast(fhdl,right,fgDataTypeStr);
    tmpbuf=fgTmpBuffer(left.elm.s,0);
    size1=strlen(tmpbuf);
    size2=strlen(value.elm.s);
    for(i=0;(i<size1)&&(i<size2);i++)
        if(isspace(tmpbuf[i])) tmpbuf[i]=value.elm.s[i];
    if(size1<size2) cstrCat(tmpbuf,(value.elm.s+size1),exit(-1));
    value.elm.s=tmpbuf;
    fgTmpBuffer(tmpbuf,0x1);
    return value;
}
//valtype object
static fgData fgSysObjOrObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjOrInt), (*fgSysObjOrFlt),
        (*fgSysObjOrStr), (*fgSysObjOrObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjOrMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjOrObj(fhdl,left,right);
    fgSetObj(fhdl,self,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=self;
    return value;
}
//sys or
int fgSysObjOr(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeOr,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjOrMeth));
   return self;
}
//==============================================================================
//__ANDE__ object
//==============================================================================
//valtype int
static fgData fgSysObjAndeInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=(left.elm.i&value.elm.i);
    return value;
}
//valtype float
static fgData fgSysObjAndeFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    fgData tmpvalue;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    tmpvalue=fgSysCast(fhdl,left,fgDataTypeInt);
    value.elm.i=(left.elm.i&value.elm.i);
    return value;
}
//valtype string
static fgData fgSysObjAndeStr(fgHandle fhdl,fgData left,fgData right){
    char*tmpbuf;
    int i,size1,size2;
    fgData value;
    fgData tmpvalue;
    value=fgSysCast(fhdl,right,fgDataTypeStr);
    tmpbuf=left.elm.s;
    size1=strlen(tmpbuf);
    size2=strlen(value.elm.s);
    for(i=0;(i<size1)&&(i<size2);i++)
        if(tmpbuf[i]!=value.elm.s[i]) tmpbuf[i]=' ';
    for(;i<size1;i++) tmpbuf[i]=' ';
    value.elm.s=left.elm.s;
    return value;
}
//valtype object
static fgData fgSysObjAndeObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjAndeInt), (*fgSysObjAndeFlt),
        (*fgSysObjAndeStr), (*fgSysObjAndeObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjAndeMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjAndeObj(fhdl,left,right);
    fgSetObj(fhdl,left.elm.i,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=left.elm.i;
    return value;
}
//sys ande
int fgSysObjAnde(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeAndeq,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjAndeMeth));
   return self;
}

//==============================================================================
//__AND__ object
//==============================================================================
//valtype int
static fgData fgSysObjAndInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=(left.elm.i&value.elm.i);
    return value;
}
//valtype float
static fgData fgSysObjAndFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    fgData tmpvalue;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    tmpvalue=fgSysCast(fhdl,left,fgDataTypeInt);
    value.elm.i=(left.elm.i&value.elm.i);
    return value;
}
//valtype string
static fgData fgSysObjAndStr(fgHandle fhdl,fgData left,fgData right){
    char*tmpbuf;
    int i,size1,size2;
    fgData value;
    fgData tmpvalue;
    value=fgSysCast(fhdl,right,fgDataTypeStr);
    tmpbuf=fgTmpBuffer(left.elm.s,0);
    size1=strlen(tmpbuf);
    size2=strlen(value.elm.s);
    for(i=0;(i<size1)&&(i<size2);i++)
        if(tmpbuf[i]!=value.elm.s[i]) tmpbuf[i]=' ';
    for(;i<size1;i++) tmpbuf[i]=' ';
    value.elm.s=tmpbuf;
    fgTmpBuffer(tmpbuf,0x1);
    return value;
}
//valtype object
static fgData fgSysObjAndObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjAndInt), (*fgSysObjAndFlt),
        (*fgSysObjAndStr), (*fgSysObjAndObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjAndMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjAndObj(fhdl,left,right);
    fgSetObj(fhdl,self,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=self;
    return value;
}
//sys and
int fgSysObjAnd(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeAnd,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjAndMeth));
   return self;
}

//==============================================================================
//__EQ__ object
//==============================================================================
//valtype int
static fgData fgSysObjEqInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=(left.elm.i==value.elm.i);
    return value;
}
//valtype float
static fgData fgSysObjEqFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=(left.elm.f==value.elm.f);
    return value;
}
//valtype string
static fgData fgSysObjEqStr(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeStr);
    value.type=fgDataTypeInt;
    value.elm.i=!strcmp(left.elm.s,value.elm.s);
    return value;
}
//valtype object
static fgData fgSysObjEqObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjEqInt), (*fgSysObjEqFlt),
        (*fgSysObjEqStr), (*fgSysObjEqObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjEqMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjEqObj(fhdl,left,right);
    fgSetObj(fhdl,self,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=self;
    return value;
}
//sys eq
int fgSysObjEq(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeEq,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjEqMeth));
   return self;
}
//==============================================================================
//__NEQ__ object
//==============================================================================
//valtype int
static fgData fgSysObjNeqInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=(left.elm.i!=value.elm.i);
    return value;
}
//valtype float
static fgData fgSysObjNeqFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=(left.elm.f!=value.elm.f);
    return value;
}
//valtype string
static fgData fgSysObjNeqStr(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeStr);
    value.type=fgDataTypeInt;
    value.elm.i=strcmp(left.elm.s,value.elm.s);
    return value;
}
//valtype object
static fgData fgSysObjNeqObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjNeqInt), (*fgSysObjNeqFlt),
        (*fgSysObjNeqStr), (*fgSysObjNeqObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjNeqMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjNeqObj(fhdl,left,right);
    fgSetObj(fhdl,self,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=self;
    return value;
}
//sys neq
int fgSysObjNeq(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeNeq,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjNeqMeth));
   return self;
}
//==============================================================================
//__LES__ object
//==============================================================================
//valtype int
static fgData fgSysObjLesInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=(left.elm.i<value.elm.i);
    return value;
}
//valtype float
static fgData fgSysObjLesFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=(left.elm.f<value.elm.f);
    return value;
}
//valtype string
static fgData fgSysObjLesStr(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    fgData tmpvalue;
    value=fgSysCast(fhdl,left,fgDataTypeInt);
    tmpvalue=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=(value.elm.i<tmpvalue.elm.i);
    return value;
}
//valtype object
static fgData fgSysObjLesObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjLesInt), (*fgSysObjLesFlt),
        (*fgSysObjLesStr), (*fgSysObjLesObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjLesMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjLesObj(fhdl,left,right);
    fgSetObj(fhdl,self,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=self;
    return value;
}
//sys les
int fgSysObjLes(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeLes,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjLesMeth));
   return self;
}
//==============================================================================
//__GRE__ object
//==============================================================================
//valtype int
static fgData fgSysObjGreInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=(left.elm.i>value.elm.i);
    return value;
}
//valtype float
static fgData fgSysObjGreFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=(left.elm.f>value.elm.f);
    return value;
}
//valtype string
static fgData fgSysObjGreStr(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    fgData tmpvalue;
    value=fgSysCast(fhdl,left,fgDataTypeInt);
    tmpvalue=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=(value.elm.i>tmpvalue.elm.i);
    return value;
}
//valtype object
static fgData fgSysObjGreObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjGreInt), (*fgSysObjGreFlt),
        (*fgSysObjGreStr), (*fgSysObjGreObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjGreMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjGreObj(fhdl,left,right);
    fgSetObj(fhdl,self,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=self;
    return value;
}
//sys gre
int fgSysObjGre(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeGre,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjGreMeth));
   return self;
}
//==============================================================================
//__LESE__ object
//==============================================================================
//valtype int
static fgData fgSysObjLeseInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=(left.elm.i<=value.elm.i);
    return value;
}
//valtype float
static fgData fgSysObjLeseFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=(left.elm.f<=value.elm.f);
    return value;
}
//valtype string
static fgData fgSysObjLeseStr(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    fgData tmpvalue;
    value=fgSysCast(fhdl,left,fgDataTypeInt);
    tmpvalue=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=(value.elm.i<=tmpvalue.elm.i);
    return value;
}
//valtype object
static fgData fgSysObjLeseObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjLeseInt), (*fgSysObjLeseFlt),
        (*fgSysObjLeseStr), (*fgSysObjLeseObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjLeseMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjLeseObj(fhdl,left,right);
    fgSetObj(fhdl,self,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=self;
    return value;
}
//sys lese
int fgSysObjLese(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeLese,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjLeseMeth));
   return self;
}
//==============================================================================
//__GREE__ object
//==============================================================================
//valtype int
static fgData fgSysObjGreeInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=(left.elm.i>=value.elm.i);
    return value;
}
//valtype float
static fgData fgSysObjGreeFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=(left.elm.f>=value.elm.f);
    return value;
}
//valtype string
static fgData fgSysObjGreeStr(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    fgData tmpvalue;
    value=fgSysCast(fhdl,left,fgDataTypeInt);
    tmpvalue=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=(value.elm.i>=tmpvalue.elm.i);
    return value;
}
//valtype object
static fgData fgSysObjGreeObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjGreeInt), (*fgSysObjGreeFlt),
        (*fgSysObjGreeStr), (*fgSysObjGreeObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjGreeMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjGreeObj(fhdl,left,right);
    fgSetObj(fhdl,self,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=self;
    return value;
}
//sys gree
int fgSysObjGree(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeGree,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjGreeMeth));
   return self;
}
//==============================================================================
//__LSFE__ object
//==============================================================================
//valtype int
static fgData fgSysObjLsfeInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=left.elm.i<<value.elm.i;
    return value;
}
//valtype float
static fgData fgSysObjLsfeFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=ldexp(left.elm.f,(int)value.elm.f);
    return value;
}
//valtype string
static fgData fgSysObjLsfeStr(fgHandle fhdl,fgData left,fgData right){
    int i,size;
    char* tmpbuf;
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    if(value.elm.i<0) value.elm.i=0;
    tmpbuf=left.elm.s;
    size=strlen(tmpbuf);
    for(i=value.elm.i;i<size;i++)
        tmpbuf[i-value.elm.i]=tmpbuf[i];
    for(i=size-value.elm.i;i<size;i++) tmpbuf[i]=' ';
    value.type=fgDataTypeStr;
    value.elm.s=left.elm.s;
    return value;
}
//valtype object
static fgData fgSysObjLsfeObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjLsfeInt), (*fgSysObjLsfeFlt),
        (*fgSysObjLsfeStr), (*fgSysObjLsfeObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjLsfeMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjLsfeObj(fhdl,left,right);
    fgSetObj(fhdl,left.elm.i,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=left.elm.i;
    return value;
}
//sys rsf
int fgSysObjLsfe(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeLsfeq,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjLsfeMeth));
   return self;
}
//==============================================================================
//__LSF__ object
//==============================================================================
//valtype int
static fgData fgSysObjLsfInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=left.elm.i<<value.elm.i;
    return value;
}
//valtype float
static fgData fgSysObjLsfFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=ldexp(left.elm.f,(int)value.elm.f);
    return value;
}
//valtype string
static fgData fgSysObjLsfStr(fgHandle fhdl,fgData left,fgData right){
    int i,size;
    char* tmpbuf;
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    if(value.elm.i<0) value.elm.i=0;
    tmpbuf=fgTmpBuffer(left.elm.s,0);
    size=strlen(tmpbuf);
    for(i=value.elm.i;i<size;i++)
        tmpbuf[i-value.elm.i]=tmpbuf[i];
    for(i=size-value.elm.i;i<size;i++) tmpbuf[i]=' ';
    value.type=fgDataTypeStr;
    value.elm.s=tmpbuf;
    fgTmpBuffer(tmpbuf,0x1);
    return value;
}
//valtype object
static fgData fgSysObjLsfObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjLsfInt), (*fgSysObjLsfFlt),
        (*fgSysObjLsfStr), (*fgSysObjLsfObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjLsfMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjLsfObj(fhdl,left,right);
    fgSetObj(fhdl,self,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=self;
    return value;
}
//sys rsf
int fgSysObjLsf(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeLsf,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjLsfMeth));
   return self;
}
//==============================================================================
//__RSFE__ object
//==============================================================================
//valtype int
static fgData fgSysObjRsfeInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=left.elm.i>>value.elm.i;
    return value;
}
//valtype float
static fgData fgSysObjRsfeFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=ldexp(left.elm.f,-((int)value.elm.f));
    return value;
}
//valtype string
static fgData fgSysObjRsfeStr(fgHandle fhdl,fgData left,fgData right){
    int i,size;
    char* tmpbuf;
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    if(value.elm.i<0) value.elm.i=0;
    tmpbuf=left.elm.s;
    size=strlen(tmpbuf);
    for(i=size-1;i>=(value.elm.i);i--)
        tmpbuf[i]=tmpbuf[i-value.elm.i];
    for(i=0;i<value.elm.i;i++) tmpbuf[i]=' ';
    value.type=fgDataTypeStr;
    value.elm.s=left.elm.s;
    return value;
}
//valtype object
static fgData fgSysObjRsfeObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjRsfeInt), (*fgSysObjRsfeFlt),
        (*fgSysObjRsfeStr), (*fgSysObjRsfeObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjRsfeMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjRsfeObj(fhdl,left,right);
    fgSetObj(fhdl,left.elm.i,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=left.elm.i;
    return value;
}
//sys rsf
int fgSysObjRsfe(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeRsfeq,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjRsfeMeth));
   return self;
}
//==============================================================================
//__RSF__ object
//==============================================================================
//valtype int
static fgData fgSysObjRsfInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=left.elm.i>>value.elm.i;
    return value;
}
//valtype float
static fgData fgSysObjRsfFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=ldexp(left.elm.f,-((int)value.elm.f));
    return value;
}
//valtype string
static fgData fgSysObjRsfStr(fgHandle fhdl,fgData left,fgData right){
    int i,size;
    char* tmpbuf;
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    if(value.elm.i<0) value.elm.i=0;
    tmpbuf=fgTmpBuffer(left.elm.s,0);
    size=strlen(tmpbuf);
    for(i=size-1;i>=(value.elm.i);i--)
        tmpbuf[i]=tmpbuf[i-value.elm.i];
    for(i=0;i<value.elm.i;i++) tmpbuf[i]=' ';
    value.type=fgDataTypeStr;
    value.elm.s=tmpbuf;
    fgTmpBuffer(tmpbuf,0x1);
    return value;
}
//valtype object
static fgData fgSysObjRsfObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjRsfInt), (*fgSysObjRsfFlt),
        (*fgSysObjRsfStr), (*fgSysObjRsfObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjRsfMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjRsfObj(fhdl,left,right);
    fgSetObj(fhdl,self,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=self;
    return value;
}
//sys rsf
int fgSysObjRsf(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeRsf,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjRsfMeth));
   return self;
}
//==============================================================================
//__ADDE__ object
//==============================================================================
//valtype int
static fgData fgSysObjAddeInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=left.elm.i+value.elm.i;
    return value;
}
//valtype float
static fgData fgSysObjAddeFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=left.elm.f+value.elm.f;
    return value;
}
//valtype string
static fgData fgSysObjAddeStr(fgHandle fhdl,fgData left,fgData right){
    int i;
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeStr);
    value.elm.s=fgTmpBuffer(value.elm.s,0);
    cstrCat(left.elm.s,value.elm.s,exit(-1));
    value.type=fgDataTypeStr;
    value.elm.s=left.elm.s;
    return value;
}
//valtype object
static fgData fgSysObjAddeObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjAddeInt), (*fgSysObjAddeFlt),
        (*fgSysObjAddeStr), (*fgSysObjAddeObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjAddeMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjAddeObj(fhdl,left,right);
    fgSetObj(fhdl,left.elm.i,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=left.elm.i;
    return value;
}
//sys adde
int fgSysObjAdde(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeAddeq,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjAddeMeth));
   return self;
}
//==============================================================================
//__ADD__ object
//==============================================================================
//valtype int
static fgData fgSysObjAddInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=left.elm.i+value.elm.i;
    return value;
}
//valtype float
static fgData fgSysObjAddFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=left.elm.f+value.elm.f;
    return value;
}
//valtype string
static fgData fgSysObjAddStr(fgHandle fhdl,fgData left,fgData right){
    int i;
    char* tmpbuf;
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeStr);
    tmpbuf=fgTmpBuffer(left.elm.s,0);
    cstrCat(tmpbuf,value.elm.s,exit(-1));
    value.type=fgDataTypeStr;
    value.elm.s=tmpbuf;
    fgTmpBuffer(tmpbuf,0x1);
    return value;
}
//valtype object
static fgData fgSysObjAddObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjAddInt), (*fgSysObjAddFlt),
        (*fgSysObjAddStr), (*fgSysObjAddObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjAddMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjAddObj(fhdl,left,right);
    fgSetObj(fhdl,self,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=self;
    return value;
}
//sys add
int fgSysObjAdd(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeAdd,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjAddMeth));
   return self;
}
//==============================================================================
//__SUBE__ object
//==============================================================================
//valtype int
static fgData fgSysObjSubeInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=left.elm.i-value.elm.i;
    return value;
}
//valtype float
static fgData fgSysObjSubeFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=left.elm.f-value.elm.f;
    return value;
}
//valtype string
static fgData fgSysObjSubeStr(fgHandle fhdl,fgData left,fgData right){
    int i,size;
    char* tmpbuf;
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    tmpbuf=left.elm.s;
    size=strlen(tmpbuf);
    if(size<value.elm.i) value.elm.i=size;
    tmpbuf+=value.elm.i;
    for(i=0;i<(size-value.elm.i);i++) left.elm.s[i]=tmpbuf[i];
    left.elm.s[i]=CIO_ES;
    value.type=fgDataTypeStr;
    value.elm.s=left.elm.s;
    return value;
}
//valtype object
static fgData fgSysObjSubeObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjSubeInt), (*fgSysObjSubeFlt),
        (*fgSysObjSubeStr), (*fgSysObjSubeObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjSubeMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjSubeObj(fhdl,left,right);
    fgSetObj(fhdl,left.elm.i,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=left.elm.i;
    return value;
}
//sys sube
int fgSysObjSube(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeSubeq,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjSubeMeth));
   return self;
}
//==============================================================================
//__SUB__ object
//==============================================================================
//valtype int
static fgData fgSysObjSubInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=left.elm.i-value.elm.i;
    return value;
}
//valtype float
static fgData fgSysObjSubFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=left.elm.f-value.elm.f;
    return value;
}
//valtype string
static fgData fgSysObjSubStr(fgHandle fhdl,fgData left,fgData right){
    int   size;
    char* tmpbuf;
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    tmpbuf=fgTmpBuffer(left.elm.s,0);
    size=strlen(tmpbuf);
    if(size<value.elm.i) value.elm.i=size;
    tmpbuf+=value.elm.i;
    value.type=fgDataTypeStr;
    value.elm.s=tmpbuf;
    return value;
}
//valtype object
static fgData fgSysObjSubObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjSubInt), (*fgSysObjSubFlt),
        (*fgSysObjSubStr), (*fgSysObjSubObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjSubMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjSubObj(fhdl,left,right);
    fgSetObj(fhdl,self,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=self;
    return value;
}
//sys sub
int fgSysObjSub(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeSub,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjSubMeth));
   return self;
}
//==============================================================================
//__MULE__ object
//==============================================================================
//valtype int
static fgData fgSysObjMuleInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=left.elm.i*value.elm.i;
    cioPintl(value.elm.i);
    return value;
}
//valtype float
static fgData fgSysObjMuleFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=left.elm.f*value.elm.f;
    return value;
}
//valtype string
static fgData fgSysObjMuleStr(fgHandle fhdl,fgData left,fgData right){
    int i;
    char* tmpbuf;
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    tmpbuf=fgTmpBuffer("",0);
    for(i=0;i<value.elm.i;i++) cstrCat(tmpbuf,left.elm.s,exit(-1));
    cstrRemakeBuf(left.elm.s,strlen(tmpbuf),char,exit(-1));
    strcpy(left.elm.s,tmpbuf);
    value.type=fgDataTypeStr;
    value.elm.s=left.elm.s;
    fgTmpBuffer(tmpbuf,0x1);
    return value;
}
//valtype object
static fgData fgSysObjMuleObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjMuleInt), (*fgSysObjMuleFlt),
        (*fgSysObjMuleStr), (*fgSysObjMuleObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjMuleMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjMuleObj(fhdl,left,right);
    fgSetObj(fhdl,left.elm.i,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=left.elm.i;
    return value;
}
//sys mul
int fgSysObjMule(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeMuleq,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjMuleMeth));
   return self;
}
//==============================================================================
//__MUL__ object
//==============================================================================
//valtype int
static fgData fgSysObjMulInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=left.elm.i*value.elm.i;
    return value;
}
//valtype float
static fgData fgSysObjMulFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=left.elm.f*value.elm.f;
    return value;
}
//valtype string
static fgData fgSysObjMulStr(fgHandle fhdl,fgData left,fgData right){
    int i;
    char* tmpbuf;
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    tmpbuf=fgTmpBuffer("",0);
    for(i=0;i<value.elm.i;i++) cstrCat(tmpbuf,left.elm.s,exit(-1));
    value.type=fgDataTypeStr;
    value.elm.s=tmpbuf;
    fgTmpBuffer(tmpbuf,0x1);
    return value;
}
//valtype object
static fgData fgSysObjMulObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjMulInt), (*fgSysObjMulFlt),
        (*fgSysObjMulStr), (*fgSysObjMulObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjMulMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjMulObj(fhdl,left,right);
    fgSetObj(fhdl,self,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=self;
    return value;
}
//sys mul
int fgSysObjMul(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeMul,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjMulMeth));
   return self;
}
//==============================================================================
//__DIVE__ object
//==============================================================================
//valtype int
static fgData fgSysObjDiveInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=left.elm.i/value.elm.i;
    return value;
}
//valtype float
static fgData fgSysObjDiveFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=left.elm.f/value.elm.f;
    return value;
}
//valtype string
static fgData fgSysObjDiveStr(fgHandle fhdl,fgData left,fgData right){
    int i,size;
    char* tmpbuf;
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    tmpbuf=left.elm.s;
    size=strlen(tmpbuf);
    if(value.elm.i) size/=value.elm.i;
    left.elm.s[size]=CIO_ES;
    value.type=fgDataTypeStr;
    value.elm.s=left.elm.s;
    return value;
}
//valtype object
static fgData fgSysObjDiveObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjDiveInt), (*fgSysObjDiveFlt),
        (*fgSysObjDiveStr), (*fgSysObjDiveObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjDiveMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjDiveObj(fhdl,left,right);
    fgSetObj(fhdl,left.elm.i,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=left.elm.i;
    return value;
}
//sys diveq
int fgSysObjDive(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeDiveq,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjDiveMeth));
   return self;
}

//==============================================================================
//__DIV__ object
//==============================================================================
//valtype int
static fgData fgSysObjDivInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=left.elm.i/value.elm.i;
    return value;
}
//valtype float
static fgData fgSysObjDivFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=left.elm.f/value.elm.f;
    return value;
}
//valtype string
static fgData fgSysObjDivStr(fgHandle fhdl,fgData left,fgData right){
    int i,size;
    char* tmpbuf;
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    tmpbuf=fgTmpBuffer(left.elm.s,0x0);
    size=strlen(tmpbuf);
    if(value.elm.i) size/=value.elm.i;
    tmpbuf[size]=CIO_ES;
    value.type=fgDataTypeStr;
    value.elm.s=tmpbuf;
    return value;
}
//valtype object
static fgData fgSysObjDivObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjDivInt), (*fgSysObjDivFlt),
        (*fgSysObjDivStr), (*fgSysObjDivObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjDivMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjDivObj(fhdl,left,right);
    fgSetObj(fhdl,self,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=self;
    return value;
}
//sys div
int fgSysObjDiv(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeDiv,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjDivMeth));
   return self;
}
//==============================================================================
//__MODE__ object
//==============================================================================
//valtype int
static fgData fgSysObjModeInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=left.elm.i%value.elm.i;
    return value;
}
//valtype float
static fgData fgSysObjModeFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=fmod(left.elm.f,value.elm.f);
    return value;
}
//valtype string
static fgData fgSysObjModeStr(fgHandle fhdl,fgData left,fgData right){
    int i;
    int size;
    char* tmpbuf;
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    tmpbuf=left.elm.s;
    if(!value.elm.i){
        value.type=fgDataTypeStr;
        value.elm.s=tmpbuf;
        return value;
    }
    size=strlen(tmpbuf)%value.elm.i;
    if(size<0) size=0;
    tmpbuf[size]=CIO_ES;
    value.type=fgDataTypeStr;
    value.elm.s=left.elm.s;
    return value;
}
//valtype object
static fgData fgSysObjModeObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjModeInt), (*fgSysObjModeFlt),
        (*fgSysObjModeStr), (*fgSysObjModeObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjModeMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjModeObj(fhdl,left,right);
    fgSetObj(fhdl,left.elm.i,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=left.elm.i;
    return value;
}
//sys mod
int fgSysObjMode(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeModeq,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjModeMeth));
   return self;
}
//==============================================================================
//__MOD__ object
//==============================================================================
//valtype int
static fgData fgSysObjModInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=left.elm.i%value.elm.i;
    return value;
}
//valtype float
static fgData fgSysObjModFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=fmod(left.elm.f,value.elm.f);
    return value;
}
//valtype string
static fgData fgSysObjModStr(fgHandle fhdl,fgData left,fgData right){
    int i;
    int size;
    char* tmpbuf;
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    tmpbuf=fgTmpBuffer(left.elm.s,0);
    if(!value.elm.i){
        value.type=fgDataTypeStr;
        value.elm.s=tmpbuf;
        return value;
    }
    size=strlen(tmpbuf)%value.elm.i;
    if(size<0) size=0;
    tmpbuf[size]=CIO_ES;
    value.type=fgDataTypeStr;
    value.elm.s=tmpbuf;
    fgTmpBuffer(tmpbuf,0x1);
    return value;
}
//valtype object
static fgData fgSysObjModObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjModInt), (*fgSysObjModFlt),
        (*fgSysObjModStr), (*fgSysObjModObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjModMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjModObj(fhdl,left,right);
    fgSetObj(fhdl,self,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=self;
    return value;
}
//sys mod
int fgSysObjMod(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeMod,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjModMeth));
   return self;
}
//==============================================================================
//__POWE__ object
//==============================================================================
//valtype int
static fgData fgSysObjPoweInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=pow((double)left.elm.i,(double)value.elm.i);
    return value;
}
//valtype float
static fgData fgSysObjPoweFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=pow(left.elm.f,value.elm.f);
    return value;
}
//valtype string
static fgData fgSysObjPoweStr(fgHandle fhdl,fgData left,fgData right){
    int i;
    char* tmpbuf;
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    tmpbuf=fgTmpBuffer(left.elm.s,0);
    for(i=0;i<value.elm.i;i++) cstrCat(tmpbuf,left.elm.s,exit(-1));
    cstrRemakeBuf(left.elm.s,(strlen(tmpbuf)+1),char,exit(-1));
    strcpy(left.elm.s,tmpbuf);
    value.type=fgDataTypeStr;
    value.elm.s=left.elm.s;
    fgTmpBuffer(tmpbuf,0x1);
    return value;
}
//valtype object
static fgData fgSysObjPoweObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjPoweInt), (*fgSysObjPoweFlt),
        (*fgSysObjPoweStr), (*fgSysObjPoweObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjPoweMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjPoweObj(fhdl,left,right);
    fgSetObj(fhdl,left.elm.i,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=left.elm.i;
    return value;
}
//sys powe
int fgSysObjPowe(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpePoweq,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjPoweMeth));
   return self;
}

//==============================================================================
//__POW__ object
//==============================================================================
//valtype int
static fgData fgSysObjPowInt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    value.elm.i=pow((double)left.elm.i,(double)value.elm.i);
    return value;
}
//valtype float
static fgData fgSysObjPowFlt(fgHandle fhdl,fgData left,fgData right){
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeFlt);
    value.elm.f=pow(left.elm.f,value.elm.f);
    return value;
}
//valtype string
static fgData fgSysObjPowStr(fgHandle fhdl,fgData left,fgData right){
    int i;
    char* tmpbuf;
    fgData value;
    value=fgSysCast(fhdl,right,fgDataTypeInt);
    tmpbuf=fgTmpBuffer(left.elm.s,0);
    for(i=0;i<value.elm.i;i++) cstrCat(tmpbuf,left.elm.s,exit(-1));
    value.type=fgDataTypeStr;
    value.elm.s=tmpbuf;
    fgTmpBuffer(tmpbuf,0x1);
    return value;
}
//valtype object
static fgData fgSysObjPowObj(fgHandle fhdl,fgData left,fgData right){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData,fgData)={
        (*fgSysObjPowInt), (*fgSysObjPowFlt),
        (*fgSysObjPowStr), (*fgSysObjPowObj),
    };
    tmpval=fgGetObj(fhdl,left.elm.i,fgDefValue);
    return meth[tmpval.type](fhdl,tmpval,right);
}
//method
static fgData fgSysObjPowMeth(fgHandle fhdl,int self){
    fgData left;
    fgData right;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    right=fgGetObj(fhdl,self,fgDefRight);
    left=fgMethod(fhdl,left.elm.i);
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjPowObj(fhdl,left,right);
    fgSetObj(fhdl,self,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=self;
    return value;
}
//sys pow
int fgSysObjPow(fgHandle fhdl,int super,int left,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpePow,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjPowMeth));
   return self;
}
//==============================================================================
//__BNOT__ object
//==============================================================================
//valtype int
static fgData fgSysObjBnotInt(fgHandle fhdl,fgData value){
    value.type=fgDataTypeInt;
    value.elm.i=~value.elm.i;
    return value;
}
//valtype float
static fgData fgSysObjBnotFlt(fgHandle fhdl,fgData value){
    value.type=fgDataTypeInt;
    value.elm.i=~((int)value.elm.f);
    return value;
}
//valtype string
static fgData fgSysObjBnotStr(fgHandle fhdl,fgData value){
    int i,j;
    char tmpc;
    value.elm.s=fgTmpBuffer(value.elm.s,0);
    j=(strlen(value.elm.s)-1);
    for(i=0;i<j;i++,j--){
        tmpc=value.elm.s[i];
        value.elm.s[i]=value.elm.s[j];
        value.elm.s[j]=tmpc;
    }
    return value;
}
//valtype object
static fgData fgSysObjBnotObj(fgHandle fhdl,fgData value){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData)={
        (*fgSysObjBnotInt), (*fgSysObjBnotFlt),
        (*fgSysObjBnotStr), (*fgSysObjBnotObj),
    };
    tmpval=fgGetObj(fhdl,value.elm.i,fgDefValue);
    tmpval=meth[tmpval.type](fhdl,tmpval);
    return tmpval;
}
//method
static fgData fgSysObjBnotMeth(fgHandle fhdl,int self){
    fgData left;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    if(left.type!=fgDataTypeObj) return value;
    left=fgMethod(fhdl,left.elm.i);
    value=fgSysObjBnotObj(fhdl,left);
    fgSetObj(fhdl,self,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=self;
    return value;
}
//sys bnot
int fgSysObjBnot(fgHandle fhdl,int super,int left){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeBnot,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   fgSetMeth(fhdl,self,(*fgSysObjBnotMeth));
   return self;
}
//==============================================================================
//__NOT__ object
//==============================================================================
//valtype int
static fgData fgSysObjNotInt(fgHandle fhdl,fgData value){
    value.type=fgDataTypeInt;
    value.elm.i=!value.elm.i;
    return value;
}
//valtype float
static fgData fgSysObjNotFlt(fgHandle fhdl,fgData value){
    value.type=fgDataTypeInt;
    value.elm.i=!value.elm.f;
    return value;
}
//valtype string
static fgData fgSysObjNotStr(fgHandle fhdl,fgData value){
    value.type=fgDataTypeInt;
    value.elm.i=!value.elm.s;
    return value;
}
//valtype object
static fgData fgSysObjNotObj(fgHandle fhdl,fgData value){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData)={
        (*fgSysObjNotInt), (*fgSysObjNotFlt),
        (*fgSysObjNotStr), (*fgSysObjNotObj),
    };
    tmpval=fgGetObj(fhdl,value.elm.i,fgDefValue);
    tmpval=meth[tmpval.type](fhdl,tmpval);
    return tmpval;
}
//method
static fgData fgSysObjNotMeth(fgHandle fhdl,int self){
    fgData left;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    if(left.type!=fgDataTypeObj) return value;
    left=fgMethod(fhdl,left.elm.i);
    value=fgSysObjNotObj(fhdl,left);
    fgSetObj(fhdl,self,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=self;
    return value;
}
//sys not
int fgSysObjNot(fgHandle fhdl,int super,int left){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeNot,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   fgSetMeth(fhdl,self,(*fgSysObjNotMeth));
   return self;
}
//==============================================================================
//__MIN__ object
//==============================================================================
//valtype int
static fgData fgSysObjMinInt(fgHandle fhdl,fgData value){
    value.elm.i=-value.elm.i;
    return value;
}
//valtype float
static fgData fgSysObjMinFlt(fgHandle fhdl,fgData value){
    value.elm.f=-value.elm.f;
    return value;
}
//valtype string
static fgData fgSysObjMinStr(fgHandle fhdl,fgData value){
    int i,j;
    char tmpc;
    value.elm.s=fgTmpBuffer(value.elm.s,0);
    j=(strlen(value.elm.s)-1);
    for(i=0;i<j;i++,j--){
        tmpc=value.elm.s[i];
        value.elm.s[i]=value.elm.s[j];
        value.elm.s[j]=tmpc;
    }
    return value;
}
//valtype object
static fgData fgSysObjMinObj(fgHandle fhdl,fgData value){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData)={
        (*fgSysObjMinInt), (*fgSysObjMinFlt),
        (*fgSysObjMinStr), (*fgSysObjMinObj),
    };
    tmpval=fgGetObj(fhdl,value.elm.i,fgDefValue);
    tmpval=meth[tmpval.type](fhdl,tmpval);
    return tmpval;
}
//method
static fgData fgSysObjMinMeth(fgHandle fhdl,int self){
    fgData left;
    fgData value={fgDataTypeInt,0};
    left=fgGetObj(fhdl,self,fgDefLeft);
    if(left.type!=fgDataTypeObj) return value;
    left=fgMethod(fhdl,left.elm.i);
    value=fgSysObjMinObj(fhdl,left);
    fgSetObj(fhdl,self,fgDefValue,value);
    value.type=fgDataTypeObj;
    value.elm.i=self;
    return value;
}
//sys min
int fgSysObjMin(fgHandle fhdl,int super,int left){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeMin,super);
   data.type=fgDataTypeObj;
   data.elm.i=left;
   fgSetObj(fhdl,self,fgDefLeft,data);
   fgSetMeth(fhdl,self,(*fgSysObjMinMeth));
   return self;
}
//==============================================================================
//__INC__ object
//==============================================================================
//valtype int
static fgData fgSysObjIncInt(fgHandle fhdl,fgData value){
    value.elm.i++;
    return value;
}
//valtype float
static fgData fgSysObjIncFlt(fgHandle fhdl,fgData value){
    value.elm.f+=1.0;
    return value;
}
//valtype string
static fgData fgSysObjIncStr(fgHandle fhdl,fgData value){
    cstrCat(value.elm.s," ",exit(-1));
    return value;
}
//valtype object
static fgData fgSysObjIncObj(fgHandle fhdl,fgData value){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData)={
        (*fgSysObjIncInt), (*fgSysObjIncFlt),
        (*fgSysObjIncStr), (*fgSysObjIncObj),
    };
    tmpval=fgGetObj(fhdl,value.elm.i,fgDefValue);
    tmpval=meth[tmpval.type](fhdl,tmpval);
    fgSetObj(fhdl,value.elm.i,fgDefValue,tmpval);
    return value;
}
//method
static fgData fgSysObjIncMeth(fgHandle fhdl,int self){
    fgData right;
    fgData value={fgDataTypeInt,0};
    right=fgGetObj(fhdl,self,fgDefRight);
    if(right.type!=fgDataTypeObj) return value;
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjIncObj(fhdl,right);
    return value;
}
//increment
int fgSysObjInc(fgHandle fhdl,int super,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeInc,super);
   data.type=fgDataTypeObj;
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjIncMeth));
   return self;
}
//==============================================================================
//__DEC__ object
//==============================================================================
//valtype int
static fgData fgSysObjDecInt(fgHandle fhdl,fgData value){
    value.elm.i--;
    return value;
}
//valtype float
static fgData fgSysObjDecFlt(fgHandle fhdl,fgData value){
    value.elm.f-=1.0;
    return value;
}
//valtype string
static fgData fgSysObjDecStr(fgHandle fhdl,fgData value){
    if(!value.elm.s) return value;
    else if(strlen(value.elm.s)<=0) return value;
    value.elm.s[strlen(value.elm.s)-1]=CIO_ES;
    return value;
}
//valtype object
static fgData fgSysObjDecObj(fgHandle fhdl,fgData value){
    fgData tmpval;
    static fgData (*meth[])(fgHandle,fgData)={
        (*fgSysObjDecInt), (*fgSysObjDecFlt),
        (*fgSysObjDecStr), (*fgSysObjDecObj),
    };
    tmpval=fgGetObj(fhdl,value.elm.i,fgDefValue);
    tmpval=meth[tmpval.type](fhdl,tmpval);
    fgSetObj(fhdl,value.elm.i,fgDefValue,tmpval);
    return value;
}
//method
static fgData fgSysObjDecMeth(fgHandle fhdl,int self){
    fgData right;
    fgData value={fgDataTypeInt,0};
    right=fgGetObj(fhdl,self,fgDefRight);
    if(right.type!=fgDataTypeObj) return value;
    right=fgMethod(fhdl,right.elm.i);
    value=fgSysObjDecObj(fhdl,right);
    return value;
}
//decrement
int fgSysObjDec(fgHandle fhdl,int super,int right){
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgOpeDec,super);
   data.type=fgDataTypeObj;
   data.elm.i=right;
   fgSetObj(fhdl,self,fgDefRight,data);
   fgSetMeth(fhdl,self,(*fgSysObjDecMeth));
   return self;
}
//==============================================================================
//__DATAFLOW__ object
//==============================================================================
//meth
static fgData fgSysObjDfMeth(fgHandle fhdl,int self){
    fgData data;
    fgData retdata;
    data=fgGetObj(fhdl,self,fgDefOpe);
    retdata=fgMethod(fhdl,data.elm.i);
    data=fgGetObj(fhdl,self,fgDefNext);
    if(data.type!=fgDataTypeObj) return retdata;
    else data=fgMethod(fhdl,data.elm.i);
    return data;
}
//dataflow
int fgSysObjDf(fgHandle fhdl,int super,int ope){
   static char buf[FG_BUFSIZE];
   int self;
   fgData data;
   self=fgMakeObj(fhdl,fgDataflow,super);
   data.type=fgDataTypeObj;
   data.elm.i=ope;
   fgSetObj(fhdl,self,fgDefOpe,data);
   fgSetMeth(fhdl,self,(*fgSysObjDfMeth));
   return self;
}
//==============================================================================
//__DOT__ obj
//==============================================================================
//method
fgData fgSysObjDotMeth(fgHandle fhdl,int self){
    char*tmpname;
    char*name;
    int super;
    int ssuper;
    fgData left;
    fgData right;
    fgData data={fgDataTypeInt,0};
    right=fgGetObj(fhdl,self,fgDefRight);
    if(right.type!=fgDataTypeObj) return data;
    left=fgGetObj(fhdl,self,fgDefLeft);
    if(left.type!=fgDataTypeObj) return data;
    super=fgMakeObj(fhdl,fgDefSuper,self);
    ssuper=fgMakeObj(fhdl,fgDefSuper,super);
    if((left.elm.i!=self) && 
       (left.elm.i!=super)&&
       (left.elm.i!=ssuper))
        left=fgMethod(fhdl,left.elm.i);
    right=fgGetObj(fhdl,right.elm.i,fgDefValue);
    if(right.type!=fgDataTypeStr){
        data.type=fgDataTypeInt;
        data.elm.i=0;
        return data;
    }
    name=right.elm.s;
    data.type=fgDataTypeObj;
    data.elm.i=fgMakeObj(fhdl,name,left.elm.i);
    return data;
}
//sys dot
int fgSysObjDot(fgHandle fhdl,int left ,char* right,int super){
   int index;
   fgData data;
   index=fgMakeObj(fhdl,fgOpeDot,super);
   data.type=fgDataTypeObj;
   if(left){
       data.elm.i=left;
       fgSetObj(fhdl,index,fgDefLeft,data);
   }
   if(right){
       data.elm.i=fgSysObjConstStr(fhdl,right,super);
       fgSetObj(fhdl,index,fgDefRight,data);
   }
   fgSetMeth(fhdl,index,(*fgSysObjDotMeth));
   return index; 
}
//==============================================================================
//__ARRAY__ obj
//==============================================================================
//int
static char* fgSysObjArryInt(fgHandle fhdl,fgData data,char* buf,int super){
    int    sizeindex;
    fgData sizedata;
    sprintf(buf,"%d$",data.elm.i);
    sizeindex=fgMakeObj(fhdl,fgDefSize,super);
    fgSetMeth(fhdl,sizeindex,(*fgMethDef));
    sizedata=fgGetObj(fhdl,sizeindex,fgDefValue);
    if(sizedata.type!=fgDataTypeInt){
        sizedata.type=fgDataTypeInt;
        sizedata.elm.i=data.elm.i+1;
    }else if(sizedata.elm.i<(data.elm.i+1)) sizedata.elm.i=(data.elm.i+1);
    fgSetObj(fhdl,sizeindex,fgDefValue,sizedata);
    sizedata.type=fgDataTypeObj;
    sizedata.elm.i=sizeindex;
    fgSetObj(fhdl,super,fgDefSize,sizedata);
    return buf;
}
//float
static char* fgSysObjArryFlt(fgHandle fhdl,fgData data,char* buf,int super){
    sprintf(buf,"%f$$",data.elm.f);
    return buf;
}
//str
static char* fgSysObjArryStr(fgHandle fhdl,fgData data, char* buf,int super){
    return data.elm.s;
}
//obj
static char* fgSysObjArryObj(fgHandle fhdl,fgData data,char* buf,int super){
    char*name;
    fgData value;
    static char* (*meth[])(fgHandle,fgData,char*,int)={
        fgSysObjArryInt, fgSysObjArryFlt,
        fgSysObjArryStr, fgSysObjArryObj,
    };
    value=fgGetObj(fhdl,data.elm.i,fgDefValue);
    name=meth[value.type](fhdl,value,buf,super);
    fgMakeObj(fhdl,name,data.elm.i);
    return name;
}
//meth
static fgData fgSysObjArryMeth(fgHandle fhdl,int self){
    static char buf[FG_BUFSIZE];
    char* name;
    fgData left;
    fgData right;
    fgData data={fgDataTypeInt,0};
    right=fgGetObj(fhdl,self,fgDefRight);
    if(right.type!=fgDataTypeObj) return data;
    left=fgGetObj(fhdl,self,fgDefLeft);
    if(left.type!=fgDataTypeObj) return data;
    data=fgMethod(fhdl,right.elm.i);
    name=fgSysObjArryObj(fhdl,data,buf,left.elm.i);
    data=fgGetObj(fhdl,left.elm.i,name);
    if(data.type!=fgDataTypeObj){
        fgData value;
        value=data;
        data.type=fgDataTypeObj;
        data.elm.i=fgMakeObj(fhdl,name,left.elm.i);
        fgSetObj(fhdl,data.elm.i,fgDefValue,value);
    }
    return data;
}
//sys arry
int fgSysObjArry(fgHandle fhdl,int left,int right,int super){
   int index;
   fgData data;
   index=fgMakeObj(fhdl,fgDefArry,super);
   data.type=fgDataTypeObj;
   if(left){
       data.elm.i=left;
       fgSetObj(fhdl,index,fgDefLeft,data);
   }
   if(right){
       data.elm.i=right;
       fgSetObj(fhdl,index,fgDefRight,data);
   }
   fgSetMeth(fhdl,index,(*fgSysObjArryMeth));
   return index; 
}
//set arry object
fgData fgSetArry(fgHandle fhdl,int self,fgData num,fgData data){
   char*name;
   static char buf[FG_BUFSIZE];
   static char* (*meth[])(fgHandle,fgData,char*,int)={
        fgSysObjArryInt, fgSysObjArryFlt,
        fgSysObjArryStr, fgSysObjArryObj,
   };
   name=meth[num.type](fhdl,num,buf,self);
   fgSetObj(fhdl,self,name,data);
   return data;
}
//get arry object
fgData fgGetArry(fgHandle fhdl,int self,fgData num){
   fgData data;
   char*name;
   static char buf[FG_BUFSIZE];
   static char* (*meth[])(fgHandle,fgData,char*,int)={
        fgSysObjArryInt, fgSysObjArryFlt,
        fgSysObjArryStr, fgSysObjArryObj,
   };
   name=meth[num.type](fhdl,num,buf,self);
   data=fgGetObj(fhdl,self,name);
   return data;
}
//make arry object
int fgMakeArry(fgHandle fhdl,int self,fgData num){
   char*name;
   static char buf[FG_BUFSIZE];
   static char* (*meth[])(fgHandle,fgData,char*,int)={
        fgSysObjArryInt, fgSysObjArryFlt,
        fgSysObjArryStr, fgSysObjArryObj,
   };
   name=meth[num.type](fhdl,num,buf,self);
   return fgMakeObj(fhdl,name,self);;
}
//==============================================================================
//get Id
//==============================================================================
int fgSysObjId(fgHandle fhdl,char* name,int super){
    fgData data;
    data=fgGetObj(fhdl,super,name);
    if(data.type==fgDataTypeObj) return data.elm.i;
    return fgMakeObj(fhdl,name,super);
}
//==============================================================================
//print data (for debug)
//==============================================================================
fgData fgSysEchoData(fgHandle fhdl,fgData data){
    fgObj* obj;
    fgData value;
    switch(data.type){
    case fgDataTypeInt:
        printf("%d\n",data.elm.i);
	break;
    case fgDataTypeFlt:
        printf("%f\n",data.elm.f);
        break;
    case fgDataTypeStr:
        printf("\"%s\"\n",data.elm.s);
        break;
    case fgDataTypeObj:
        obj=cmapFind(fhdl->obj,&(data.elm.i));
	if(!obj)  printf("'%d' object not found\n",data.elm.i);
        else{
            printf("object:%s:",obj->name);
            value=fgGetObj(fhdl,data.elm.i,fgDefValue);
            fgSysEchoData(fhdl,value);
        }
        break;
    }
    return data;
}
//==============================================================================
//CAST DATA
//==============================================================================
//def
static fgData fgSysCastDef(fgHandle fhdl,fgData data){
    return data;
}
//int -> floag
static fgData fgSysCastIntFlt(fgHandle fhdl,fgData data){
    data.type=fgDataTypeFlt;
    data.elm.f=(double)data.elm.i;
    return data;
}
//int -> str
static fgData fgSysCastIntStr(fgHandle fhdl,fgData data){
    static char buf[FG_BUFSIZE];
    data.type=fgDataTypeStr;
    sprintf(buf,"%d",data.elm.i);
    data.elm.s=buf;
    return data;
}
//float->int
static fgData fgSysCastFltInt(fgHandle fhdl,fgData data){
    data.type=fgDataTypeInt;
    data.elm.i=(int)data.elm.f;
    return data;
}
//float -> str
static fgData fgSysCastFltStr(fgHandle fhdl,fgData data){
    static char buf[FG_BUFSIZE];
    data.type=fgDataTypeStr;
    sprintf(buf,"%f",data.elm.f);
    data.elm.s=buf;
    return data;
}
//str -> int
static fgData fgSysCastStrInt(fgHandle fhdl,fgData data){
    data.type=fgDataTypeInt;
    data.elm.i=atoi(data.elm.s);
    return data;
}
//str -> float
static fgData fgSysCastStrFlt(fgHandle fhdl,fgData data){
    data.type=fgDataTypeFlt;
    data.elm.f=atof(data.elm.s);
    return data;
}
//obj -> int
static fgData fgSysCastObjInt(fgHandle fhdl,fgData data){
    fgData value;
    value=fgGetObj(fhdl,data.elm.i,fgDefValue);
    return fgSysCast(fhdl,value,fgDataTypeInt);
}
//obj -> flt
static fgData fgSysCastObjFlt(fgHandle fhdl,fgData data){
    fgData value;
    value=fgGetObj(fhdl,data.elm.i,fgDefValue);
    return fgSysCast(fhdl,value,fgDataTypeFlt);
}
//obj -> str
static fgData fgSysCastObjStr(fgHandle fhdl,fgData data){
    fgData value;
    value=fgGetObj(fhdl,data.elm.i,fgDefValue);
    return fgSysCast(fhdl,value,fgDataTypeStr);
}
//cast data
fgData fgSysCast(fgHandle fhdl,fgData data,int type){
    static fgData (*func[])(fgHandle,fgData)={
    /*int -> int*/ fgSysCastDef, 
    /*    -> flt*/ fgSysCastIntFlt, 
    /*    -> str*/ fgSysCastIntStr, 
    /*    -> obj*/ fgSysCastDef, 
    /*flt -> int*/ fgSysCastFltInt, 
    /*    -> flt*/ fgSysCastDef, 
    /*    -> str*/ fgSysCastFltStr, 
    /*    -> obj*/ fgSysCastDef, 
    /*str -> int*/ fgSysCastStrInt, 
    /*    -> flt*/ fgSysCastStrFlt, 
    /*    -> str*/ fgSysCastDef, 
    /*    -> obj*/ fgSysCastDef, 
    /*obj -> int*/ fgSysCastObjInt, 
    /*    -> flt*/ fgSysCastObjFlt, 
    /*    -> str*/ fgSysCastObjStr, 
    /*    -> obj*/ fgSysCastDef, 
    };
    return func[data.type*fgDataTypeSize+type](fhdl,data);
}
//==============================================================================
/*static buffer for operators*/
//==============================================================================
void fgSysFreeMem(void){
    fgTmpBuffer(NULL,0x02);
    cioDesMem();
}
//==============================================================================
/*static buffer for operators*/
//==============================================================================
char* fgTmpBuffer(char* str,int flg){
    static char* buf=NULL;
    static int size=0;
    int tmpsize;
    if(flg==0x1){ //set mode
        buf=str;
        size=strlen(buf);
    }
    if(flg==0x2){ //free buffer
        if(buf) free(buf);
        buf=NULL;
        size=0;
    }
    if(!flg){//default
        if(!str){
            if(buf) free(buf);
            buf=NULL;
            size=0;
            return NULL;
        }
        tmpsize=strlen(str);
        if(!buf) cstrSet(buf,"",exit(-1));
        if(size<tmpsize){
            cstrRemakeBuf(buf,(tmpsize+1),char,exit(-1));
            size=tmpsize;
        }
        strcpy(buf,str);
    }
    return buf;
}


