//*****************************************************************************//
//fgstd.c
//Copyright (C) 2006 K.Tsuchiya ltd.
//2006/09/4
//... fridge standard object library.
//*****************************************************************************//
#include <stdio.h>
#include <fcntl.h>
#include <regex.h>
#include "fridge.h"
#ifndef O_BINARY
#define O_BINARY 0
#endif 
/*------------------------------------------------------------------------------*/
/*                                                                              */
/*                       standard library access API                            */
/*                                                                              */
/*------------------------------------------------------------------------------*/


//===============================================================================
//access function
//===============================================================================
typedef struct{
    char*name;
    fgData (*meth)(fgHandle,int self);
}fgStdFuncList;
//access
void* fgStdMethod(char*name,int flg,void*val){
    int i,size;
    void*p;
    /*default*/
    static cMap tbl;
    static fgStdFuncList list[]={
        {"sys"    ,(*fgStdObjSystem)},
        {"echo"   ,(*fgStdObjEcho)},
        {"open"   ,(*fgStdObjOpen)},
        {"close"  ,(*fgStdObjClose)},
        {"write"  ,(*fgStdObjWrite)},
        {"read"   ,(*fgStdObjRead)},
        {"readln" ,(*fgStdObjReadln)},
        {"split"  ,(*fgStdObjSplit)},
        {"slice"  ,(*fgStdObjSlice)},
        {"len"    ,(*fgStdObjLen)},
    };
    switch(flg){
    case 0x0 : /*init*/
        tbl=cmapIni(sizeof(char*),sizeof(void*),(*cmapStrKey),(*cmapStrCmp));
        size=sizeof(list)/sizeof(fgStdFuncList);
        for(i=0;i<size;i++) cmapUpdate(tbl,&(list[i].name),&(list[i].meth));
        return tbl;
    case 0x1 : /*get*/
        p=cmapFind(tbl,&name);
        if(p) p=cioVoid(p,void*);
        return p;
    case 0x2 : /*set*/
        return cmapUpdate(tbl,&name,&val);
    case 0x3 : /*destruct*/ 
        return cmapDes(tbl);
    default : return NULL;
    }
}
/*------------------------------------------------------------------------------*/
/*                                                                              */
/*                             standard library                                 */
/*                                                                              */
/*------------------------------------------------------------------------------*/

//===============================================================================
//escape
//===============================================================================
char* fgStdEscape(char* str){
    int i,j,size;
    char*buf;
    size=strlen(str);
    cstrMakeBuf(buf,size+1,char,exit(-1));
    for(i=0,j=0;i<size;i++,j++){
        if(str[i]=='\\'){
            i++;
            if(i>=size) break;
            switch(str[i]){
            case '\\' : buf[j]='\\'; break;
            case 'a'  : buf[j]='\a'; break;
            case 'b'  : buf[j]='\b'; break;
            case 'f'  : buf[j]='\f'; break;
            case 'n'  : buf[j]='\n'; break;
            case 'r'  : buf[j]='\r'; break;
            case 't'  : buf[j]='\t'; break;
            case 'v'  : buf[j]='\v'; break;
            }
        }else buf[j]=str[i];
    }
    buf[i]=CIO_ES;
    return buf;
}
//===============================================================================
//staring length
//===============================================================================
fgData fgStdObjLen(fgHandle fhdl,int self){
    int length;
    int i,argsize;
    fgData data;
    argsize=fgSysGetArgSize(fhdl,self);
    if(!argsize) return fgSetValTypeInt(0);
    for(i=0,length=0;i<argsize;i++){
        data=fgGetArgElm(fhdl,self,i);
        data=fgSysCast(fhdl,data,fgDataTypeStr);
        length+=strlen(fgGetValStr(data));
    }
    data=fgSetValTypeInt(length);
    fgSetObj(fhdl,self,fgDefValue,data);
    return fgSetValTypeObj(self);
}
//===============================================================================
//slice string
//===============================================================================
fgData fgStdObjSlice(fgHandle fhdl,int self){
    int i,argsize;
    int index,size,tmpsize;
    char*str;
    fgData data;
    static int bufsize=0;
    static char*buf=NULL;
    argsize=fgGetArgSize(fhdl,self);
    if(!argsize) return fgSetValTypeObj(self);
    else if(argsize==1){
        data=fgGetObj(fhdl,self,fgDefValue);
        if(fgGetType(data)==fgDataTypeStr){
            cstrSet(str,fgGetValStr(data),exit(-1));
        }else cstrSet(str,"",exit(-1));
        data=fgGetArgElm(fhdl,self,0);
        fgSetObj(fhdl,fgGetValObj(data),fgDefValue,fgSetValTypeStr(str));
        return data;
    }else if(argsize==2){
        data=fgGetArgElm(fhdl,self,0);
        str=fgGetValStr(fgSysCast(fhdl,data,fgDataTypeStr));
        data=fgGetArgElm(fhdl,self,1);
        index=fgGetValInt(fgSysCast(fhdl,data,fgDataTypeInt));
        size=1;
    }else if(argsize>=3){
        data=fgGetArgElm(fhdl,self,0);
        str=fgGetValStr(fgSysCast(fhdl,data,fgDataTypeStr));
        data=fgGetArgElm(fhdl,self,1);
        index=fgGetValInt(fgSysCast(fhdl,data,fgDataTypeInt));
        data=fgGetArgElm(fhdl,self,2);
        size=fgGetValInt(fgSysCast(fhdl,data,fgDataTypeInt));
    }
    tmpsize=strlen(str);
    if(tmpsize<index) index=tmpsize;
    while(index+size>tmpsize) size--;
    if(bufsize<=size) cstrRemakeBuf(buf,size+1,char,exit(-1));
    memcpy(buf,str+index,size);
    buf[size]=CIO_ES;
    data=fgSetValTypeStr(buf);
    fgSetObj(fhdl,self,fgDefValue,data);
    for(i=3;i<argsize;i++){
        fgData outdata;
        outdata=fgGetArgElm(fhdl,self,i);
        if(fgGetType(outdata)==fgDataTypeObj){
            int obj;
            obj=fgGetValObj(outdata);
            cstrSet(str,buf,exit(-1));
            data=fgSetValTypeStr(str);
            fgSetObj(fhdl,obj,fgDefValue,data);
        }
    }
    return fgSetValTypeObj(self);
}
//===============================================================================
//split string
//===============================================================================
fgData fgStdObjSplit(fgHandle fhdl,int self){
    char*str;
    char*token;
    char**spdata;
    int i,argsize;
    fgData outobj;
    fgData num;
    fgData data={fgDataTypeInt,0};
    argsize=fgSysGetArgSize(fhdl,self);
    if(argsize<1) return data;
    else if(argsize<2){
        outobj=fgSysGetArgElm(fhdl,self,0);
        str=fgSysCast(fhdl,outobj,fgDataTypeStr).elm.s;
        token=" \t\n";
    }
    else if(argsize<3){
        outobj=fgSysGetArgElm(fhdl,self,0);
        str=fgSysCast(fhdl,fgSysGetArgElm(fhdl,self,1),fgDataTypeStr).elm.s;
        cstrSet(token,str,exit(-1));
        str=fgSysCast(fhdl,outobj,fgDataTypeStr).elm.s;
    }
    else{
        outobj=fgSysGetArgElm(fhdl,self,0);
        str=fgSysCast(fhdl,fgSysGetArgElm(fhdl,self,2),fgDataTypeStr).elm.s;
        cstrSet(token,str,exit(-1));
        str=fgSysCast(fhdl,fgSysGetArgElm(fhdl,self,1),fgDataTypeStr).elm.s;
    }
    spdata=cstrSplit(str,token);
    num.type=fgDataTypeInt;
    data.type=fgDataTypeStr;
    for(i=0;spdata[i]!=NULL;i++){
        num.elm.i=i;
        data.elm.s=spdata[i];
        fgSetArry(fhdl,outobj.elm.i,num,data);
    }
    if(argsize>2)free(token);
    data.type=fgDataTypeObj;
    data.elm.i=outobj.elm.i;
    return data;
}
//===============================================================================
//system # == system(<args>)
//===============================================================================
fgData fgStdObjSystem(fgHandle fhdl,int self){
    int i,flg,arg;
    int argsize;
    char*buf;
    fgData num;
    fgData data;
    arg=fgMakeObj(fhdl,fgDefArg,self);
    argsize=fgMakeObj(fhdl,fgDefSize,arg);
    argsize=fgGetObj(fhdl,argsize,fgDefValue).elm.i;
    cstrSet(buf,"",exit(-1));
    num.type=fgDataTypeInt;
    for(i=0;i<argsize;i++){
       num.elm.i=i;
       data=fgGetArry(fhdl,arg,num);
       data=fgSysCast(fhdl,data,fgDataTypeStr);
       cstrCat(buf,data.elm.s,exit(-1));
       cstrCat(buf," ",exit(-1));
    }
    flg=system(buf);
    free(buf);
    data.type=fgDataTypeInt;
    data.elm.i=flg;
    fgSetObj(fhdl,self,fgDefValue,data);
    data.type=fgDataTypeObj;
    data.elm.i=self;
    return data;
}
//===============================================================================
//echo
//===============================================================================
fgData fgStdObjEcho(fgHandle fhdl,int self){
    int i,flg,arg;
    int argsize;
    char*buf;
    fgData num;
    fgData data;
    arg=fgMakeObj(fhdl,fgDefArg,self);
    argsize=fgMakeObj(fhdl,fgDefSize,arg);
    argsize=fgGetObj(fhdl,argsize,fgDefValue).elm.i;
    cstrSet(buf,"",exit(-1));
    num.type=fgDataTypeInt;
    for(i=0;i<argsize;i++){
       num.elm.i=i;
       data=fgGetArry(fhdl,arg,num);
       data=fgSysCast(fhdl,data,fgDataTypeStr);
       cstrCat(buf,data.elm.s,exit(-1));
       cstrCat(buf," ",exit(-1));
    }
    flg=puts(buf);
    free(buf);
    data.type=fgDataTypeInt;
    data.elm.i=flg;
    fgSetObj(fhdl,self,fgDefValue,data);
    data.type=fgDataTypeObj;
    data.elm.i=self;
    return data;
}
//===============================================================================
//read
//===============================================================================
/*function define*/
static int fgStdObjReadData(fgHandle fhdl,int fd,fgData* data);
//str
static int fgStdObjReadDataDef(fgHandle fhdl,int fd,fgData* data){
    int i,flg=0;
    int size=0;
    int bufsize=FG_BUFSIZE*4;
    if(data->type !=fgDataTypeStr){
        data->type=fgDataTypeStr;
        data->elm.s=NULL;
    }
    do{
        size+=bufsize;
        cstrRemakeBuf(data->elm.s,size,char,exit(-1));
        flg=read(fd,(data->elm.s+size-bufsize),sizeof(char)*bufsize);
    }while(flg);
    return flg;
}
//obj
static int fgStdObjReadDataObj(fgHandle fhdl,int fd,fgData* data){
    int flg;
    fgData tmpdata;
    tmpdata=fgGetObj(fhdl,data->elm.i,fgDefValue);
    flg=fgStdObjReadData(fhdl,fd,&tmpdata);
    fgSetObj(fhdl,data->elm.i,fgDefValue,tmpdata);
    return flg;
}
//getdata
static int fgStdObjReadData(fgHandle fhdl,int fd,fgData* data){
    static int (*func[])(fgHandle,int,fgData*)={
        fgStdObjReadDataDef, fgStdObjReadDataDef,
        fgStdObjReadDataDef, fgStdObjReadDataObj,
    };
    return func[data->type](fhdl,fd,data); 
}
//method
fgData fgStdObjRead(fgHandle fhdl,int self){
    int i,fd,arg,flg;
    int argsize;
    fgData data,num;
    arg=fgMakeObj(fhdl,fgDefArg,self);
    //get argsize
    data=fgGetObj(fhdl,arg,fgDefSize);
    if(data.type!=fgDataTypeObj) argsize=0;
    argsize=fgGetObj(fhdl,data.elm.i,fgDefValue).elm.i;
    if(argsize<2){
        data.type=fgDataTypeInt;
        data.elm.i=-1;
        fgSetObj(fhdl,self,fgDefValue,data);
        data.type=fgDataTypeObj;
        data.elm.i=self;
        return data;
    }
    //get arg 0(file const)
    data.type=fgDataTypeInt;
    data.elm.i=0;
    data=fgGetArry(fhdl,arg,data);
    fd=fgSysCast(fhdl,data,fgDataTypeInt).elm.i;
    //read data
    num.type=fgDataTypeInt;
    for(i=1,flg=0;i<argsize;i++){
        num.elm.i=i;
        data=fgGetArry(fhdl,arg,num);
        flg|=fgStdObjReadData(fhdl,fd,&data);
        fgSetArry(fhdl,arg,num,data);
    }
    //return
    data.type=fgDataTypeInt;
    data.elm.i=flg;
    fgSetObj(fhdl,self,fgDefValue,data);
    data.type=fgDataTypeObj;
    data.elm.i=self;
    return data;
}
//===============================================================================
//readln
//===============================================================================
/*function define*/
static int fgStdObjReadlnData(fgHandle fhdl,int fd,fgData* data);
//int
static int fgStdObjReadlnDataInt(fgHandle fhdl,int fd,fgData* data){
    return read(fd,&(data->elm.i),sizeof(int));
}
//flt
static int fgStdObjReadlnDataFlt(fgHandle fhdl,int fd,fgData* data){
    return read(fd,&(data->elm.f),sizeof(double));
}
//str
static int fgStdObjReadlnDataStr(fgHandle fhdl,int fd,fgData* data){
    int i,flg=0;
    int bufsize=FG_BUFSIZE;
    cstrRemakeBuf(data->elm.s,bufsize,char,exit(-1));
    for(i=0;i<(bufsize-1);i++){
        flg|=read(fd,&(data->elm.s[i]),sizeof(char));
        if(flg<1) break;
        if(data->elm.s[i]==CIO_EL){i++;break;}
        if(i>=(bufsize-2)){
            bufsize*=2;
            cstrRemakeBuf(data->elm.s,bufsize,char,exit(-1));
        }
    }
    data->elm.s[i]=CIO_ES;
    return flg;
}
//obj
static int fgStdObjReadlnDataObj(fgHandle fhdl,int fd,fgData* data){
    int flg;
    fgData tmpdata;
    tmpdata=fgGetObj(fhdl,data->elm.i,fgDefValue);
    flg=fgStdObjReadlnData(fhdl,fd,&tmpdata);
    fgSetObj(fhdl,data->elm.i,fgDefValue,tmpdata);
    return flg;
}
//getdata
static int fgStdObjReadlnData(fgHandle fhdl,int fd,fgData* data){
    static int (*func[])(fgHandle,int,fgData*)={
        fgStdObjReadlnDataInt, fgStdObjReadlnDataFlt,
        fgStdObjReadlnDataStr, fgStdObjReadlnDataObj,
    };
    return func[data->type](fhdl,fd,data); 
}
//method
fgData fgStdObjReadln(fgHandle fhdl,int self){
    int i,fd,arg,flg;
    int argsize;
    fgData data,num;
    arg=fgMakeObj(fhdl,fgDefArg,self);
    //get argsize
    data=fgGetObj(fhdl,arg,fgDefSize);
    if(data.type!=fgDataTypeObj) argsize=0;
    argsize=fgGetObj(fhdl,data.elm.i,fgDefValue).elm.i;
    if(argsize<2){
        data.type=fgDataTypeInt;
        data.elm.i=-1;
        fgSetObj(fhdl,self,fgDefValue,data);
        data.type=fgDataTypeObj;
        data.elm.i=self;
        return data;
    }
    //get arg 0(file const)
    data.type=fgDataTypeInt;
    data.elm.i=0;
    data=fgGetArry(fhdl,arg,data);
    fd=fgSysCast(fhdl,data,fgDataTypeInt).elm.i;
    //read data
    num.type=fgDataTypeInt;
    for(i=1,flg=0;i<argsize;i++){
        num.elm.i=i;
        data=fgGetArry(fhdl,arg,num);
        flg|=fgStdObjReadlnData(fhdl,fd,&data);
        fgSetArry(fhdl,arg,num,data);
    }
    //return
    data.type=fgDataTypeInt;
    data.elm.i=flg;
    fgSetObj(fhdl,self,fgDefValue,data);
    data.type=fgDataTypeObj;
    data.elm.i=self;
    return data;
}
//===============================================================================
//write
//===============================================================================
/*function define*/
static int fgStdObjWriteData(fgHandle fhdl,int fd,fgData data);
//int
static int fgStdObjWriteDataInt(fgHandle fhdl,int fd,fgData data){
    return write(fd,data.elm.i,sizeof(int));
}
//flt
static int fgStdObjWriteDataFlt(fgHandle fhdl,int fd,fgData data){
    return write(fd,data.elm.f,sizeof(double));
}
//str
static int fgStdObjWriteDataStr(fgHandle fhdl,int fd,fgData data){
    int flg;
    char*buf;
    cstrSet(buf,data.elm.s,exit(-1));
    flg= write(fd,buf,(sizeof(char)*strlen(buf)));
    free(buf);
    return flg;
}
//obj
static int fgStdObjWriteDataObj(fgHandle fhdl,int fd,fgData data){
    data=fgGetObj(fhdl,data.elm.i,fgDefValue);
    return fgStdObjWriteData(fhdl,fd,data);
}
//getdata
static int fgStdObjWriteData(fgHandle fhdl,int fd,fgData data){
    static int (*func[])(fgHandle,int,fgData)={
        fgStdObjWriteDataInt, fgStdObjWriteDataFlt,
        fgStdObjWriteDataStr, fgStdObjWriteDataObj,
    };
    return func[data.type](fhdl,fd,data); 
}
//method
fgData fgStdObjWrite(fgHandle fhdl,int self){
    int i,fd,arg,flg;
    int argsize;
    fgData data;
    arg=fgMakeObj(fhdl,fgDefArg,self);
    //get argsize
    data=fgGetObj(fhdl,arg,fgDefSize);
    if(data.type!=fgDataTypeObj) argsize=0;
    argsize=fgGetObj(fhdl,data.elm.i,fgDefValue).elm.i;
    if(argsize<2){
        data.type=fgDataTypeInt;
        data.elm.i=-1;
        fgSetObj(fhdl,self,fgDefValue,data);
        data.type=fgDataTypeObj;
        data.elm.i=self;
        return data;
    }
    //get arg 0(file const)
    data.type=fgDataTypeInt;
    data.elm.i=0;
    data=fgGetArry(fhdl,arg,data);
    fd=fgSysCast(fhdl,data,fgDataTypeInt).elm.i;
    //write data
    for(i=1,flg=0;i<argsize;i++){
        data.type=fgDataTypeInt;
        data.elm.i=i;
        data=fgGetArry(fhdl,arg,data);
        flg|=fgStdObjWriteData(fhdl,fd,data);
    }
    //return 
    data.type=fgDataTypeInt;
    data.elm.i=flg;
    fgSetObj(fhdl,self,fgDefValue,data);
    data.type=fgDataTypeObj;
    data.elm.i=self;
    return data;
}
//===============================================================================
//close
//===============================================================================
fgData fgStdObjClose(fgHandle fhdl,int self){
    int flg;
    int arg;
    int argsize;
    fgData data;
    arg=fgMakeObj(fhdl,fgDefArg,self);
    //get argsize
    data=fgGetObj(fhdl,arg,fgDefSize);
    if(data.type!=fgDataTypeObj) argsize=0;
    argsize=fgGetObj(fhdl,data.elm.i,fgDefValue).elm.i;
    if(!argsize){
        data.type=fgDataTypeInt;
        data.elm.i=-1;
        fgSetObj(fhdl,self,fgDefValue,data);
        data.type=fgDataTypeObj;
        data.elm.i=self;
        return data;
    }
    //get arg 0(file const)
    data.type=fgDataTypeInt;
    data.elm.i=0;
    data=fgGetArry(fhdl,arg,data);
    flg=fgSysCast(fhdl,data,fgDataTypeInt).elm.i;
    data.elm.i=close(flg);
    data.type=fgDataTypeInt;
    fgSetObj(fhdl,self,fgDefValue,data);
    data.type=fgDataTypeObj;
    data.elm.i=self;
    return data;
}
//===============================================================================
//open
//===============================================================================
//method
fgData fgStdObjOpen(fgHandle fhdl,int self){
    int arg;
    int argsize;
    int flg;
    char*name;
    char*s;
    fgData data;
    arg=fgMakeObj(fhdl,fgDefArg,self);
    //get argsize
    data=fgGetObj(fhdl,arg,fgDefSize);
    if(data.type!=fgDataTypeObj) argsize=0;
    argsize=fgGetObj(fhdl,data.elm.i,fgDefValue).elm.i;
    if(!argsize){
        data.type=fgDataTypeInt;
        data.elm.i=fileno(stdout);
        fgSetObj(fhdl,self,fgDefValue,data);
        data.type=fgDataTypeObj;
        data.elm.i=self;
        return data;
    }
    //get arg 0(file name)
    data.type=fgDataTypeInt;
    data.elm.i=0;
    data=fgGetArry(fhdl,arg,data);
    cstrSet(name,fgSysCast(fhdl,data,fgDataTypeStr).elm.s,exit(-1));
    //get arg 1(open flag)
    if(argsize>1){
        int i;
        char*tmps;
        data.type=fgDataTypeInt;
        data.elm.i=1;
        data=fgGetArry(fhdl,arg,data);
        tmps=fgSysCast(fhdl,data,fgDataTypeStr).elm.s;
        for(i=0,flg=0;tmps[i]!=CIO_ES;i++){
            switch(tmps[i]){
            case 'w' :
                flg|=O_TRUNC;
                flg|=O_CREAT;
                flg|=O_WRONLY;
                break;
            case 'a' :
                flg|=O_CREAT;
                flg|=O_APPEND;
                break;
            case 'r' : flg|=O_RDONLY; break;
            case 'b' : flg|=O_BINARY; break;
            }
        }
    }else{
        flg|=O_CREAT;
        flg|=O_RDWR;
    }
    //open
    data.type=fgDataTypeInt;
    for(s=name;isspace(*s);s++) if(*s==CIO_ES) break;
    data.elm.i=open(s,flg);
    free(name);
    fgSetObj(fhdl,self,fgDefValue,data);
    data.type=fgDataTypeObj;
    data.elm.i=self;
    return data;
}

