<?php
/*
 * framework-spider
 * spider/tags/RewriteDocumentRoot.class.php
 * 
 * CopyRight(C)Framework-Spider Developer Team. 2010. All Right Reserved. 
 * URL         : http://sourceforge.jp/projects/frameworkspider/
 * Mail        : frameworkspider-dev@lists.sourceforge.jp
 * Auther      : Masanori Nakashima
 * Modifier    : Masanori Nakashima
 * Last Updated: 2010.06.23
 * 
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'TagBase.class.php');
require_once(dirname(dirname(dirname(__FILE__))).DIRECTORY_SEPARATOR.'util'.DIRECTORY_SEPARATOR.'CharUtility.class.php');
/**
 * HTML用変換タグ：ドキュメントルート自動変換タグ
 * 
 * {rewrite-document-root:[true/false]}
 * 
 * trueが指定された場合
 * 最終的に出力するHTML文字列内のhref="",src=""内のURIが/から始まっていた場合、
 * 自動的にアプリケーション設置ルートを前に付加するタグです。
 * 
 * デフォルトはtrueです。
 * 
 * 【要求する定数や変数】
 * SPIDER_ACCESS_URL_HTTP
 *  SSLページとHTTPページをサイト内で動的に切り替える場合にdefine定義してください
 * SPIDER_ACCESS_URL_SSL
 *  SSLページとHTTPページをサイト内で動的に切り替える場合にdefine定義してください
 * $GLOBALS['SPIDER_ACCESS_SSL_URI_ARRAY']	= array()
 *  SSLページとHTTPページをサイト内で動的に切り替えるSSLを強制するフォルダURIを要素として保持
 * 
 * @package spider spiderのコアパッケージ
 * @version 1.1.00
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
class spider_tags_RewriteDocumentRoot extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_RewriteDocumentRoot() {
		$this->priority	= 0;
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$build_information ){
		
		if( preg_match('/\\{rewrite\\-document\\-root\\:[fF][aA][lL][sS][eE]\\}/', $result_strings ) > 0
			|| preg_match('/\\{rewrite\\-document\\-root\\:[nN][oO]\\}/', $result_strings ) > 0 ) {
			// falseかnoが指定されているなら書き換えない
			$result_strings = preg_replace( '/\\{rewrite\\-document\\-root\\:[fF][aA][lL][sS][eE]\\}/'
				, "", $result_strings );
		} else {
			$process_code = '';
			// 明示的に否定していないなら暗黙的に書き換える
			$result_strings = preg_replace( '/\\{rewrite\\-document\\-root\\:[^\\}]*?\\}/'
				, "", $result_strings );

			// 現在のアクセスがSSLかどうか確認
			$process_code .= '$isSSL = false;'."\n";
			$process_code .= '$ps = strpos(SPIDER_URL_BASE,\'https://\');'."\n";
			$process_code .= 'if( $ps !== false && $ps == 0 ) {'."\n";
			$process_code .= '$isSSL = true;'."\n";
			$process_code .= '}'."\n";
			// アプリケーションベースURIから記述されているか確認の為の正規表現
			$regxUri	= str_replace('\\','\\\\',util_CharUtility::escapeRegxStr(SPIDER_URI_BASE));
			// 付加URIまたはURL部分の作成
			$replaceUri	= SPIDER_URI_BASE;
			if( preg_match('/\\/$/', $replaceUri) > 0 ) {
				$replaceUri	= preg_replace('/\\/$/','',$replaceUri);
			}
			$replaceUrlSSL	= SPIDER_ACCESS_URL_SSL;
			if( preg_match('/\\/$/', $replaceUrlSSL) > 0 ) {
				$replaceUrlSSL	= preg_replace('/\\/$/','',$replaceUrlSSL);
			}
			$replaceUrlNomal	= SPIDER_ACCESS_URL_HTTP;
			if( preg_match('/\\/$/', $replaceUrlNomal) > 0 ) {
				$replaceUrlNomal	= preg_replace('/\\/$/','',$replaceUrlNomal);
			}
			
			// href書き換え
			$process_code .= 'if( preg_match_all( \'/[hH][rR][eE][fF]\\\\=([\\\'"])(\\/([^\\\'"\\/][^\\\'"]*|))([\\\'"])/\'';
			$process_code .= ', $outstr';
			$process_code .= ', $output_array';
			$process_code .= ', PREG_PATTERN_ORDER ) > 0 ) { ';
			$process_code .= 'foreach ( $output_array[0] as $hNum => $target ) { ';
			$process_code .= 'if( SPIDER_URI_BASE == \'/\' || preg_match(\'/^[hH][rR][eE][fF]\\\\=([\\\'"])'.$regxUri.'/\', $target ) == 0 ) { '."\n";
			$process_code .= '$uri = $output_array[2][$hNum]; '."\n";
			$process_code .= '$sessParam = \'\';'."\n";
			$process_code .= 'if( strpos($uri,\'?\') === false ) {'."\n";
			$process_code .= '$sessParam = \'?\'.$GLOBALS[\'spider.session.name\'].\'=\'.$GLOBALS[\'spider.session.id\'];'."\n";
			$process_code .= '} else {'."\n";
			$process_code .= '$sessParam = \'&\'.$GLOBALS[\'spider.session.name\'].\'=\'.$GLOBALS[\'spider.session.id\'];'."\n";
			$process_code .= '}'."\n";
			$process_code .= 'if( !$isSSL && defined(\'SPIDER_ACCESS_URL_SSL\') && strlen(SPIDER_ACCESS_URL_SSL) > 0 && preg_match(\'/(\\\\.js|\\\\.css)$/\',$uri) == 0 && $request_object->isRequireSSL( $uri ) ) {'."\n";
				$process_code .= '$repstr = preg_replace(\'/[hH][rR][eE][fF]\\\\=([\\\'"])(\\/[^\\\'"]*)([\\\'"])/\',\'href=${1}'.$replaceUrlSSL.'${2}\'.$sessParam.\'${3}\',$target); '."\n";
				$process_code .= '$outstr = str_replace( $target, $repstr, $outstr );'."\n";
			$process_code .= '} else if( $isSSL && defined(\'SPIDER_ACCESS_URL_HTTP\') && strlen(SPIDER_ACCESS_URL_HTTP) > 0 && preg_match(\'/(\\\\.js|\\\\.css)$/\',$uri) == 0 && !$request_object->isRequireSSL( $uri ) ) {'."\n";
				$process_code .= '$repstr = preg_replace(\'/[hH][rR][eE][fF]\\\\=([\\\'"])(\\/[^\\\'"]*)([\\\'"])/\',\'href=${1}'.$replaceUrlNomal.'${2}\'.$sessParam.\'${3}\',$target); '."\n";
				$process_code .= '$outstr = str_replace( $target, $repstr, $outstr );'."\n";
			$process_code .= ' } else { '."\n";
				$process_code .= '$repstr = preg_replace(\'/[hH][rR][eE][fF]\\\\=([\\\'"])(\\/[^\\\'"]*)([\\\'"])/\',\'href=${1}'.$replaceUri.'${2}${3}\',$target); '."\n";
				$process_code .= '$outstr = str_replace( $target, $repstr, $outstr );'."\n";
			$process_code .= ' }'."\n";
			$process_code .= ' }'."\n";
			$process_code .= '}}';
			
			// action書き換え
			$process_code .= 'if( preg_match_all( \'/[aA][cC][tT][iI][oO][nN]\\\\=([\\\'"])(\\/([^\\\'"\\/]|)[^\\\'"]*)([\\\'"])/\'';
			$process_code .= ', $outstr';
			$process_code .= ', $output_array';
			$process_code .= ', PREG_PATTERN_ORDER ) > 0 ) { ';
			$process_code .= 'foreach ( $output_array[0] as $hNum => $target ) { ';
			$process_code .= 'if( SPIDER_URI_BASE == \'/\' || preg_match(\'/^[aA][cC][tT][iI][oO][nN]\\\\=([\\\'"])'.$regxUri.'/\', $target ) == 0 ) { '."\n";
			$process_code .= '$uri = $output_array[2][$hNum]; '."\n";
			$process_code .= '$sessParam = \'\';'."\n";
			$process_code .= 'if( strpos($uri,\'?\') === false ) {'."\n";
			$process_code .= '$sessParam = \'?\'.$GLOBALS[\'spider.session.name\'].\'=\'.$GLOBALS[\'spider.session.id\'];'."\n";
			$process_code .= '} else {'."\n";
			$process_code .= '$sessParam = \'&\'.$GLOBALS[\'spider.session.name\'].\'=\'.$GLOBALS[\'spider.session.id\'];'."\n";
			$process_code .= '}'."\n";
			$process_code .= 'if( !$isSSL && defined(\'SPIDER_ACCESS_URL_SSL\') && strlen(SPIDER_ACCESS_URL_SSL) > 0 && $request_object->isRequireSSL( $uri ) ) {'."\n";
				$process_code .= '$repstr = preg_replace(\'/[aA][cC][tT][iI][oO][nN]\\\\=([\\\'"])(\\/[^\\\'"]*)([\\\'"])/\',\'action=${1}'.$replaceUrlSSL.'${2}\'.$sessParam.\'${3}\',$target); '."\n";
				$process_code .= '$outstr = str_replace( $target, $repstr, $outstr );'."\n";
			$process_code .= '} else if( $isSSL && defined(\'SPIDER_ACCESS_URL_HTTP\') && strlen(SPIDER_ACCESS_URL_HTTP) > 0 && !$request_object->isRequireSSL( $uri ) ) {'."\n";
				$process_code .= '$repstr = preg_replace(\'/[aA][cC][tT][iI][oO][nN]\\\\=([\\\'"])(\\/[^\\\'"]*)([\\\'"])/\',\'action=${1}'.$replaceUrlNomal.'${2}\'.$sessParam.\'${3}\',$target); '."\n";
				$process_code .= '$outstr = str_replace( $target, $repstr, $outstr );'."\n";
			$process_code .= ' } else { '."\n";
				$process_code .= '$repstr = preg_replace(\'/[aA][cC][tT][iI][oO][nN]\\\\=([\\\'"])(\\/[^\\\'"]*)([\\\'"])/\',\'action=${1}'.$replaceUri.'${2}${3}\',$target); '."\n";
				$process_code .= '$outstr = str_replace( $target, $repstr, $outstr );'."\n";
			$process_code .= ' }'."\n";
			$process_code .= ' }'."\n";
			$process_code .= '}}';
			
			// window.open()書き換え
			$process_code .= 'if( preg_match_all( \'/window\\\\.open\\\\(([\\\'"])(\\/[^\\\'"]*)([\\\'"])/\'';
			$process_code .= ', $outstr';
			$process_code .= ', $output_array';
			$process_code .= ', PREG_PATTERN_ORDER ) > 0 ) { ';
			$process_code .= 'foreach ( $output_array[0] as $hNum => $target ) { ';
			$process_code .= 'if( SPIDER_URI_BASE == \'/\' || preg_match(\'/^window\\\\.open\\\\(([\\\'"])'.$regxUri.'/\', $target ) == 0 ) { '."\n";
			$process_code .= '$uri = $output_array[2][$hNum]; '."\n";
			$process_code .= 'if( !$isSSL && defined(\'SPIDER_ACCESS_URL_SSL\') && strlen(SPIDER_ACCESS_URL_SSL) > 0 && $request_object->isRequireSSL( $uri ) ) {'."\n";
				$process_code .= '$repstr = preg_replace(\'/window\\\\.open\\\\(([\\\'"])(\\/[^\\\'"]*)([\\\'"])/\',\'window.open(${1}'.$replaceUrlSSL.'${2}${3}\',$target); '."\n";
				$process_code .= '$outstr = str_replace( $target, $repstr, $outstr );'."\n";
			$process_code .= '} else if( $isSSL && defined(\'SPIDER_ACCESS_URL_HTTP\') && strlen(SPIDER_ACCESS_URL_HTTP) > 0 && !$request_object->isRequireSSL( $uri ) ) {'."\n";
				$process_code .= '$repstr = preg_replace(\'/window\\\\.open\\\\(([\\\'"])(\\/[^\\\'"]*)([\\\'"])/\',\'window.open(${1}'.$replaceUrlNomal.'${2}${3}\',$target); '."\n";
				$process_code .= '$outstr = str_replace( $target, $repstr, $outstr );'."\n";
			$process_code .= ' } else { '."\n";
				$process_code .= '$repstr = preg_replace(\'/window\\\\.open\\\\(([\\\'"])(\\/[^\\\'"]*)([\\\'"])/\',\'window.open(${1}'.$replaceUri.'${2}${3}\',$target); '."\n";
				$process_code .= '$outstr = str_replace( $target, $repstr, $outstr );'."\n";
			$process_code .= ' }'."\n";
			$process_code .= ' }'."\n";

			$process_code .= '}}';
	
			// src書き換え
			$process_code .= 'if( preg_match_all( \'/[sS][rR][cC]\\\\=([\\\'"])(\\/([^\\\'"\\/][^\\\'"]*|))([\\\'"])/\'';
			$process_code .= ', $outstr';
			$process_code .= ', $output_array';
			$process_code .= ', PREG_PATTERN_ORDER ) > 0 ) { ';
			$process_code .= '  foreach ( $output_array[0] as $srcNum => $target ) { '."\n";
			$process_code .= '    if( SPIDER_URI_BASE == \'/\' || preg_match(\'/^[sS][rR][cC]\\\\=([\\\'"])'.$regxUri.'/\', $target ) == 0 ) { '."\n";
			$process_code .= '      $repstr = preg_replace(\'/[sS][rR][cC]\\\\=([\\\'"])(\\/[^\\\'"]*)([\\\'"])/\',\'src=${1}'.$replaceUri.'${2}${3}\',$target); '."\n";
			$process_code .= '      $outstr = str_replace( $target, $repstr, $outstr );'."\n";
			$process_code .= '      $srcUri = $output_array[2][$srcNum]; ';
			$process_code .= '      if( preg_match(\'/\\\\.[sS][wW][fF]$/\',$srcUri) > 0 ) { '."\n";
			$process_code .= '        $srcUri = preg_replace(\'/\\\\.[sS][wW][fF]$/\',\'\',$srcUri);'."\n";
			$process_code .= '        $outstr = str_replace(\'\\\'\'.$srcUri.\'\\\'\',  \'\\\''.$replaceUri.'\'.$srcUri.\'\\\'\',  $outstr);'."\n";
			$process_code .= '        $outstr = str_replace(\'"\'.$srcUri.\'"\',  \'"'.$replaceUri.'\'.$srcUri.\'"\',  $outstr);'."\n";
			$process_code .= '      }'."\n";
			$process_code .= '    }'."\n";
			$process_code .= '  }'."\n";
			$process_code .= '}';
			
			// url()書き換え
			$process_code .= 'if( preg_match_all( \'/url\\\\(([\\\'"])(\\/[^\\\'"]*)([\\\'"])/\'';
			$process_code .= ', $outstr';
			$process_code .= ', $output_array';
			$process_code .= ', PREG_PATTERN_ORDER ) > 0 ) { ';
			$process_code .= 'foreach ( $output_array[0] as $target ) { ';
			$process_code .= 'if( SPIDER_URI_BASE == \'/\' || preg_match(\'/^'.$regxUri.'/\', $target ) == 0 ) { '."\n";
			$process_code .= '$repstr = preg_replace(\'/url\\\\(([\\\'"])(\\/[^\\\'"]*)([\\\'"])/\',\'url(${1}'.$replaceUri.'${2}${3}\',$target); '."\n";
			$process_code .= '$outstr = str_replace( $target, $repstr, $outstr );'."\n";
			$process_code .= ' }'."\n";
			$process_code .= '}}';
						
			if( !isset($build_information->convert_view_process_hash)
				|| !is_array($build_information->convert_view_process_hash) ){
				$build_information->convert_view_process_hash	= array();
			}
			if( !isset($build_information->convert_view_process_hash[$this->priority])
				|| !is_array($build_information->convert_view_process_hash[$this->priority]) ){
				$build_information->convert_view_process_hash[$this->priority]	= array();
			}
			array_push( $build_information->convert_view_process_hash[$this->priority], $process_code );
		}
		
	}
}
?>