<?php
/*
 * framework-spider
 * spider/tags/Charset.class.php
 * 
 * CopyRight(C)Framework-Spider Developer Team. 2010. All Right Reserved. 
 * URL         : http://sourceforge.jp/projects/frameworkspider/
 * Mail        : frameworkspider-dev@lists.sourceforge.jp
 * Auther      : Masanori Nakashima
 * Modifier    : Masanori Nakashima
 * Last Updated: 2010.06.23
 * 
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'TagBase.class.php');
/**
 * HTML用変換タグ:charsetタグクラス
 * 
 * {charset:[文字コード指定文字列]}で指定された文字コードでページを出力するよう変更します。
 * 
 * [文字コード指定文字列]にはPHPのmbstringによる文字コード指定方法を用いてください。
 * 例）Windows向けShift_JISの場合→SJIS-win
 * 
 * また出力時にHTMLタグ内の以下のメタタグ内の文字セットの書き換えも試みます。
 * <meta http-equiv="Content-type" content="text/html; charset=UTF-8">
 * 
 * 記述例）
 * {charset:SJIS-win}
 * 
 * ※本タグはテンプレート・ウィジェット・ページ全てあわせて1つのみ指定できます。
 * 複数のタグが記述されている場合、出力文字列の一番最後に記述されているcharset指定が有効になります。
 * 
 * @package spider spiderのコアパッケージ
 * @subpackage tags spiderのテンプレートタグ変換クラスパッケージ
 * @version 1.1.00
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
class spider_tags_Charset extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_Charset() {
		$this->priority	= 30;
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$build_information ){
		// charsetタグ内文字列
		$charsetStrings	= '';
		if ( preg_match_all( '/\\{charset\\:[^\\}]*?\\}/'
				, $result_strings
				, $output_array
				, PREG_PATTERN_ORDER ) > 0 ) {
			// charsetタグが明示的に指定されている場合、最後に書かれたものを適用
			foreach ( $output_array as $output ) {
				foreach ( $output as $target ) {
					$charsetStrings	= preg_replace( '/\\{charset\\:/','', $target );
					$charsetStrings	= preg_replace( '/\\}/','', $charsetStrings );
					// 空行にならないよう前後が改行も削除
					$result_strings 	= str_replace( "\n".$target."\n", "", $result_strings );
					$result_strings 	= str_replace( $target, "", $result_strings );
					$charsetStrings	= trim($charsetStrings);
				}
			}
		} else {
			// charsetタグがない場合はユーザーエージェント指定の文字コードがあるなら適用
			if( isset($GLOBALS['SPIDER_USER_AGENT_CLASS_OUTPUT_CHARSET'])
				&& isset($GLOBALS['SPIDER_USER_AGENT_CLASS_OUTPUT_CHARSET'][$build_information->agent_class])
				&& strlen($GLOBALS['SPIDER_USER_AGENT_CLASS_OUTPUT_CHARSET'][$build_information->agent_class]) > 0 ) {
				// 対象ユーザーエージェント分類の文字コードが指定されているなら適用
				$charsetStrings	= $GLOBALS['SPIDER_USER_AGENT_CLASS_OUTPUT_CHARSET'][$build_information->agent_class];
			} else {
				// 定義がないなら常にUTF-8で出力する
				$charsetStrings	= 'UTF-8';
			}
		}

		$charsetArray	= explode( ' ', $charsetStrings );
		// 最初の項は必ず文字コード
		$outputCharset			= trim(array_shift($charsetArray));
		$convert_kana		= '';
		$internal_charset	= 'UTF-8';
		$output_handler		= 'mb_output_handler';
		$detect_order		= 'UTF-8,EUC-JP,SJIS,SJIS-win,JIS,UTF-7';
		$language			= 'japanese';
		// 残りの項の解析
		foreach( $charsetArray as $str ) {
			if( strlen(trim($str)) > 0 ) {
				list( $key, $val )	= explode('=',trim($str));
				$key	= trim($key);
				$val	= trim($val);
				if( strlen($val) == 0 ) {
					// 単一項目ならconvert_kanaと判断する（下位互換）
					$convert_kana	= $key;
				} else if( 'internal_charset' == $key ){
					$internal_charset	= $val;
				} else if( 'output_handler' == $key ) {
					$output_handler		= $val;
				} else if( 'convert_kana' == $key ) {
					$convert_kana		= $val;
				} else if( 'detect_order' == $key ) {
					$detect_order		= $val;
				} else if( 'language' == $key ) {
					$language			= $val;
				}
			}
		}
		// 互換の為buil_informationにも設定
		$build_information->output_charset		= $outputCharset;
		$build_information->convert_kana		= $convert_kana;
		$build_information->output_handler		= $output_handler;
		$build_information->internal_charset	= $internal_charset;
		$build_information->detect_order		= $detect_order;
		$build_information->output_language		= $language;

		// 出力HTML内の文字コード指定変換
		$htmlReplaceCode = $outputCharset;
		if( isset($GLOBALS['DEF_SPIDER_CHARSET_REPLACE_ENCODINGS'][$outputCharset]) ) {
			// 変換文字が定義されているなら変換文字を使う(SJIS等の場合Shift_JISにするなどの為)
			$htmlReplaceCode = $GLOBALS['DEF_SPIDER_CHARSET_REPLACE_ENCODINGS'][$outputCharset];
		}
		// メタタグのcharsetを変更
		$result_strings	= preg_replace(
			'/(<[mM][eE][tT][aA][^>]*\\s[cC][oO][nN][tT][eE][nN][tT]\\=[\'"][^\'"]*[cC][hH][aA][rR][sS][eE][tT]\\=)([^\'"\\;]+)([^\'"]*[\'"][^>]*>)/',
			'$1'.$htmlReplaceCode.'$3',
			$result_strings
		);
		// XML宣言もあれば変更
		$result_strings	= preg_replace(
			'/(<\\?xml[^>]*\\s[eE][nN][cC][oO][dD][iI][nN][gG]\\=[\'"])([^\'"]*)([^\'"]*[\'"][^>]*>)/',
			'$1'.$htmlReplaceCode.'$3',
			$result_strings
		);

		// 前処理の文字コードフラッシュコードを追加
		$process_code = "ob_start('".$output_handler."');\n";
		$process_code .= "ob_implicit_flush( false );\n";
		$process_code .= "mb_language('".$language."');\n";
		$process_code .= "mb_detect_order('".$detect_order."');\n";
		$process_code .= "mb_internal_encoding('".$internal_charset."');\n";
		// 2009-07-01 DoCoMo XHTML対応 暫定 PHPheaderでセットしたContent-Typeの文字セットでob_get_cleanの取得文字コードを勝手に操作する為UTF-8で指定...
		if( preg_match('/\\<\\!DOCTYPE\\shtml\\sPUBLIC\\s\\"\\-\\/\\/i\\-mode group/',$result_strings) > 0 ) {
			$process_code .= 'if(preg_match(\'/^DoCoMo/\',$_SERVER[\'HTTP_USER_AGENT\']) > 0 ) {'."\n";
			$process_code .= '$request->setResponseHeader(\'Content-Type\',\'application/xhtml+xml;charset='.$htmlReplaceCode.'\');'."\n";
			$process_code .= '}'."\n";
		}
		
		if( !isset($build_information->processPreModuleHash)
			|| !is_array($build_information->processPreModuleHash) ){
			$build_information->processPreModuleHash	= array();
		}
		if( !isset($build_information->processPreModuleHash[$this->priority])
			|| !is_array($build_information->processPreModuleHash[$this->priority]) ){
			$build_information->processPreModuleHash[$this->priority]	= array();
		}
		array_push( $build_information->processPreModuleHash[$this->priority], $process_code );
		
		// 表示文字列に対する処理実行コードを記述
		if( !isset($build_information->convert_view_process_hash)
			|| !is_array($build_information->convert_view_process_hash) ){
			$build_information->convert_view_process_hash	= array();
		}
		if( !isset($build_information->convert_view_process_hash[$this->priority])
			|| !is_array($build_information->convert_view_process_hash[$this->priority]) ){
			$build_information->convert_view_process_hash[$this->priority]	= array();
		}
		if( strlen( trim( $convert_kana ) ) > 0 ) {
			$process_code = '$outstr = mb_convert_kana( $outstr, "' . $convert_kana . '" );'."\n";
			array_push( $build_information->convert_view_process_hash[$this->priority], $process_code );
		} else if ( 'docomo' == $build_information->agent_class || 'docomo2' == $build_information->agent_class || 'softbank' == $build_information->agent_class || 'au' == $build_information->agent_class ) {
			$process_code = '$outstr = mb_convert_kana( $outstr, "kna" );'."\n";
			array_push( $build_information->convert_view_process_hash[$this->priority], $process_code );
		}
	}
}
?>