/*
 * Decompiled with CFR 0.152.
 */
package org.cmc.music.myid3;

import java.io.IOException;
import org.cmc.music.myid3.MyID3v2Constants;

public abstract class UnicodeMetrics
implements MyID3v2Constants {
    public final int findEndWithTerminator(byte[] bytes, int index) throws IOException {
        return this.findEnd(bytes, index, true);
    }

    public final int findEndWithoutTerminator(byte[] bytes, int index) throws IOException {
        return this.findEnd(bytes, index, false);
    }

    protected abstract int findEnd(byte[] var1, int var2, boolean var3) throws IOException;

    public static UnicodeMetrics getInstance(int charEncodingCode) throws IOException {
        switch (charEncodingCode) {
            case 0: {
                return new UnicodeMetricsASCII();
            }
            case 3: {
                return new UnicodeMetricsUTF8();
            }
            case 1: {
                return new UnicodeMetricsUTF16WithBOM();
            }
            case 2: {
                return new UnicodeMetricsUTF16NoBOM();
            }
        }
        throw new IOException("Unknown char encoding code: " + charEncodingCode);
    }

    private static class UnicodeMetricsASCII
    extends UnicodeMetrics {
        private UnicodeMetricsASCII() {
        }

        public int findEnd(byte[] bytes, int index, boolean includeTerminator) throws IOException {
            int i = index;
            while (i < bytes.length) {
                if (bytes[i] == 0) {
                    return includeTerminator ? i + 1 : i;
                }
                ++i;
            }
            return bytes.length;
        }
    }

    private static abstract class UnicodeMetricsUTF16
    extends UnicodeMetrics {
        protected static final int BYTE_ORDER_BIG_ENDIAN = 0;
        protected static final int BYTE_ORDER_LITTLE_ENDIAN = 1;
        protected int byteOrder = 0;

        public UnicodeMetricsUTF16(int byteOrder) {
            this.byteOrder = byteOrder;
        }

        public int findEnd(byte[] bytes, int index, boolean includeTerminator) throws IOException {
            while (true) {
                int msb1;
                if (index == bytes.length) {
                    return bytes.length;
                }
                if (index > bytes.length - 1) {
                    throw new IOException("Terminator not found.");
                }
                int c1 = 0xFF & bytes[index++];
                int c2 = 0xFF & bytes[index++];
                int n = msb1 = this.byteOrder == 0 ? c1 : c2;
                if (c1 == 0 && c2 == 0) {
                    return includeTerminator ? index : index - 2;
                }
                if (msb1 < 216) continue;
                if (index > bytes.length - 1) {
                    throw new IOException("Terminator not found.");
                }
                int c3 = 0xFF & bytes[index++];
                int c4 = 0xFF & bytes[index++];
                int msb2 = this.byteOrder == 0 ? c3 : c4;
                if (msb2 < 220) break;
            }
            throw new IOException("Invalid code point.");
        }
    }

    private static class UnicodeMetricsUTF16NoBOM
    extends UnicodeMetricsUTF16 {
        public UnicodeMetricsUTF16NoBOM() {
            super(0);
        }
    }

    private static class UnicodeMetricsUTF16WithBOM
    extends UnicodeMetricsUTF16 {
        public UnicodeMetricsUTF16WithBOM() {
            super(0);
        }

        public int findEnd(byte[] bytes, int index, boolean includeTerminator) throws IOException {
            if (index >= bytes.length - 1) {
                throw new IOException("Missing BOM.");
            }
            int c1 = 0xFF & bytes[index++];
            int c2 = 0xFF & bytes[index++];
            if (c1 == 255 && c2 == 254) {
                this.byteOrder = 1;
            } else if (c1 == 254 && c2 == 255) {
                this.byteOrder = 0;
            } else {
                throw new IOException("Invalid byte order mark.");
            }
            return super.findEnd(bytes, index, includeTerminator);
        }
    }

    private static class UnicodeMetricsUTF8
    extends UnicodeMetrics {
        private UnicodeMetricsUTF8() {
        }

        public int findEnd(byte[] bytes, int index, boolean includeTerminator) throws IOException {
            block12: {
                while (true) {
                    int c4;
                    int c3;
                    int c2;
                    int c1;
                    if (index == bytes.length) {
                        return bytes.length;
                    }
                    if (index > bytes.length) {
                        throw new IOException("Terminator not found.");
                    }
                    if ((c1 = 0xFF & bytes[index++]) == 0) {
                        return includeTerminator ? index : index - 1;
                    }
                    if (c1 <= 127) continue;
                    if (c1 <= 223) {
                        if (index >= bytes.length) {
                            throw new IOException("Invalid unicode.");
                        }
                        if ((c2 = 0xFF & bytes[index++]) >= 128 && c2 <= 191) continue;
                        throw new IOException("Invalid code point.");
                    }
                    if (c1 <= 239) {
                        if (index >= bytes.length - 1) {
                            throw new IOException("Invalid unicode.");
                        }
                        if ((c2 = 0xFF & bytes[index++]) < 128 || c2 > 191) {
                            throw new IOException("Invalid code point.");
                        }
                        if ((c3 = 0xFF & bytes[index++]) >= 128 && c3 <= 191) continue;
                        throw new IOException("Invalid code point.");
                    }
                    if (c1 > 244) break block12;
                    if (index >= bytes.length - 2) {
                        throw new IOException("Invalid unicode.");
                    }
                    if ((c2 = 0xFF & bytes[index++]) < 128 || c2 > 191) {
                        throw new IOException("Invalid code point.");
                    }
                    if ((c3 = 0xFF & bytes[index++]) < 128 || c3 > 191) {
                        throw new IOException("Invalid code point.");
                    }
                    if ((c4 = 0xFF & bytes[index++]) < 128 || c4 > 191) break;
                }
                throw new IOException("Invalid code point.");
            }
            throw new IOException("Invalid code point.");
        }
    }
}

