/*
 * Decompiled with CFR 0.152.
 */
package org.cmc.music.myid3;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import org.cmc.music.common.ID3FrameType;
import org.cmc.music.common.ID3WriteException;
import org.cmc.music.common.ID3v1Genre;
import org.cmc.music.metadata.ImageData;
import org.cmc.music.metadata.MusicMetadata;
import org.cmc.music.metadata.MusicMetadataSet;
import org.cmc.music.myid3.ID3v2DataMapping;
import org.cmc.music.myid3.ID3v2FrameFlags;
import org.cmc.music.myid3.MyID3v2Constants;
import org.cmc.music.myid3.MyID3v2Frame;
import org.cmc.music.myid3.MyID3v2FrameData;
import org.cmc.music.myid3.MyID3v2FrameImage;
import org.cmc.music.myid3.MyID3v2FrameText;

public class MyID3v2Write
implements MyID3v2Constants {
    private final int id3v2_version = 3;
    private static final ID3v2DataMapping mapping = new ID3v2DataMapping();
    private static final Comparator FRAME_SORTER = new Comparator(){

        public int compare(Object o1, Object o2) {
            int fo2;
            Frame f1 = (Frame)o1;
            Frame f2 = (Frame)o2;
            int fo1 = f1.frame_order.intValue();
            if (fo1 != (fo2 = f2.frame_order.intValue())) {
                return fo1 - fo2;
            }
            return f1.longFrameID.compareTo(f2.longFrameID);
        }
    };

    private byte[] getHeaderFooter(int body_length, boolean is_footer) throws ID3WriteException {
        byte[] result = new byte[10];
        int index = 0;
        if (is_footer) {
            result[index++] = 51;
            result[index++] = 68;
            result[index++] = 73;
        } else {
            result[index++] = 73;
            result[index++] = 68;
            result[index++] = 51;
        }
        result[index++] = 3;
        result[index++] = 0;
        boolean flags = false;
        result[index++] = (byte)(flags ? 1 : 0);
        this.writeSynchSafeInt(result, index, body_length);
        return result;
    }

    private final void writeSynchSafeInt(byte[] bytes, int start, int value) throws ID3WriteException {
        bytes[start + 3] = (byte)(value & 0x7F);
        bytes[start + 2] = (byte)((value >>= 7) & 0x7F);
        bytes[start + 1] = (byte)((value >>= 7) & 0x7F);
        bytes[start + 0] = (byte)((value >>= 7) & 0x7F);
        if ((value >>= 7) != 0) {
            throw new ID3WriteException("Value to large for synch safe int: " + value);
        }
    }

    private Frame toFrameKey(Object key, Object value) throws UnsupportedEncodingException, IOException {
        return this.toFrameKey(key, value, null);
    }

    private Frame toFrameKey(Object key, Object value1, Object value2) throws UnsupportedEncodingException, IOException {
        ID3FrameType frame_type = mapping.getID3FrameType(key);
        if (frame_type == null) {
            return null;
        }
        return this.toFrame(frame_type, value1, value2);
    }

    private Frame toFrame(ID3FrameType frame_type, Object value1) throws UnsupportedEncodingException, IOException {
        return this.toFrame(frame_type.long_id, frame_type.getFrameOrder(), value1, null);
    }

    private Frame toFrame(ID3FrameType frame_type, Object value1, Object value2) throws UnsupportedEncodingException, IOException {
        return this.toFrame(frame_type.long_id, frame_type.getFrameOrder(), value1, value2);
    }

    private Frame toFrame(String longFrameID, Number frame_order, Object value1, Object value2) throws UnsupportedEncodingException, IOException {
        if (longFrameID.startsWith("T")) {
            return this.toFrameText(longFrameID, frame_order, value1, value2);
        }
        if (longFrameID.equals("COMM")) {
            return this.toFrameCOMM(longFrameID, frame_order, value1);
        }
        return null;
    }

    private boolean canEncodeStringInISO(String s) throws UnsupportedEncodingException {
        byte[] bytes = s.getBytes("ISO-8859-1");
        String check1 = new String(bytes, "ISO-8859-1");
        return check1.equals(s);
    }

    private byte[] encodeString(String s, boolean use_iso) throws UnsupportedEncodingException, IOException {
        if (use_iso) {
            return s.getBytes("ISO-8859-1");
        }
        byte[] bytes = s.getBytes("UTF-16");
        if ((0xFF & bytes[0]) == 254 && (0xFF & bytes[1]) == 255) {
            int i = 0;
            while (i < bytes.length) {
                byte temp = bytes[i];
                bytes[i] = bytes[i + 1];
                bytes[i + 1] = temp;
                i += 2;
            }
        }
        return bytes;
    }

    private Frame toFrameText(String longFrameID, Number frame_order, Object value1, Object value2) throws UnsupportedEncodingException, IOException {
        String s1;
        if (value1 instanceof String) {
            s1 = (String)value1;
        } else if (value1 instanceof Number) {
            s1 = value1.toString();
        } else {
            return null;
        }
        String s2 = null;
        if (value2 instanceof String) {
            s2 = (String)value2;
        } else if (value2 instanceof Number) {
            s2 = value2.toString();
        }
        boolean use_iso = this.canEncodeStringInISO(s1);
        if (s2 != null) {
            use_iso &= this.canEncodeStringInISO(s2);
        }
        boolean char_encoding_code = !use_iso;
        byte[] string_1_bytes = this.encodeString(s1, use_iso);
        byte[] string_2_bytes = null;
        if (s2 != null) {
            string_2_bytes = this.encodeString(s2, use_iso);
        }
        int result_length = string_1_bytes.length + 1;
        if (string_2_bytes != null) {
            result_length += string_2_bytes.length + 1;
        }
        byte[] result = new byte[result_length];
        int index = 0;
        result[index++] = (byte)(char_encoding_code ? 1 : 0);
        System.arraycopy(string_1_bytes, 0, result, index, string_1_bytes.length);
        index += string_1_bytes.length;
        if (string_2_bytes != null) {
            result[index++] = (byte)(char_encoding_code ? 1 : 0);
            System.arraycopy(string_2_bytes, 0, result, index, string_2_bytes.length);
        }
        return new Frame(longFrameID, frame_order, result);
    }

    private Frame toFrameImage(String longFrameID, Number frame_order, ImageData imageData) throws UnsupportedEncodingException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean use_iso = this.canEncodeStringInISO(imageData.description);
        int char_encoding_code = use_iso ? 0 : 1;
        baos.write(char_encoding_code);
        byte[] mimeTypeBytes = this.encodeString(imageData.mimeType, true);
        baos.write(mimeTypeBytes);
        baos.write(0);
        baos.write(0xFF & imageData.pictureType);
        byte[] descriptionBytes = this.encodeString(imageData.description, use_iso);
        baos.write(descriptionBytes);
        baos.write(0);
        baos.write(imageData.imageData);
        byte[] frameBytes = baos.toByteArray();
        return new Frame(longFrameID, frame_order, frameBytes);
    }

    private Frame toFrameCOMM(String longFrameID, Number frame_order, Object value) throws UnsupportedEncodingException, IOException {
        if (!(value instanceof String)) {
            return null;
        }
        String s = (String)value;
        boolean use_iso = this.canEncodeStringInISO(s);
        boolean char_encoding_code = !use_iso;
        byte[] string_bytes = this.encodeString(s, use_iso);
        int result_length = string_bytes.length + 1 + 3 + 1;
        byte[] result = new byte[result_length];
        int index = 0;
        result[index++] = (byte)(char_encoding_code ? 1 : 0);
        result[index++] = 0;
        result[index++] = 0;
        result[index++] = 0;
        result[index++] = 0;
        System.arraycopy(string_bytes, 0, result, index, string_bytes.length);
        return new Frame(longFrameID, frame_order, result);
    }

    private Vector toFrames(MusicMetadata values) throws UnsupportedEncodingException, IOException {
        Frame frame;
        Object value;
        Vector<Frame> result = new Vector<Frame>();
        Object track_count = values.get("track_count");
        Object track_number = values.get("track_number");
        if (track_count != null || track_number != null) {
            value = "";
            if (track_number != null) {
                value = String.valueOf(value) + track_number.toString();
            }
            if (track_count != null) {
                value = String.valueOf(value) + "/";
                value = String.valueOf(value) + track_count.toString();
            }
            result.add(this.toFrame(ID3FrameType.TRACKNUM, value));
        }
        values.remove("track_count");
        values.remove("track_number");
        String genreString = "";
        String genreIDString = null;
        value = values.get("genre");
        if (value != null) {
            genreString = value.toString();
            Number id = ID3v1Genre.get(genreString);
            if (id != null) {
                genreIDString = id.toString();
                genreString = "(" + id + ")" + genreString;
            }
        } else {
            value = values.get("genre_id");
            if (!(value == null || genreIDString != null && genreIDString.equals(value.toString()))) {
                genreString = "(" + genreIDString + ")" + genreString;
            }
        }
        if (genreString.length() > 0) {
            result.add(this.toFrame(ID3FrameType.CONTENTTYPE, genreString));
        }
        values.remove("genre");
        values.remove("genre_id");
        Object value2 = values.get("duration_seconds");
        if (value2 != null) {
            Number number = (Number)value2;
            number = new Long(number.intValue() * 1000);
            result.add(this.toFrame(ID3FrameType.SONGLEN, number.toString()));
        }
        values.remove("duration_seconds");
        value2 = values.get("comment");
        if (value2 != null && (frame = this.toFrame(ID3FrameType.COMMENT, value2.toString())) != null) {
            result.add(frame);
        }
        values.remove("comment");
        Vector keys = new Vector(values.keySet());
        int i = 0;
        while (i < keys.size()) {
            Object key = keys.get(i);
            Object value3 = values.get(key);
            if (key.equals("pictures")) {
                Vector images = (Vector)value3;
                int j = 0;
                while (j < images.size()) {
                    ImageData imageData = (ImageData)images.get(j);
                    String longFrameID = ID3FrameType.PICTURE.long_id;
                    Number frame_order = ID3FrameType.PICTURE.getFrameOrder();
                    Frame frame2 = this.toFrameImage(longFrameID, frame_order, imageData);
                    result.add(frame2);
                    ++j;
                }
            } else {
                Frame frame3 = this.toFrameKey(key, value3);
                if (frame3 != null) {
                    result.add(frame3);
                }
            }
            ++i;
        }
        return result;
    }

    private byte[] writeFrames(Filter filter, Vector v) throws ID3WriteException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Collections.sort(v, FRAME_SORTER);
        int i = 0;
        while (i < v.size()) {
            Frame frame = (Frame)v.get(i);
            String frame_id = frame.longFrameID;
            if (frame_id.length() != 4) {
                throw new ID3WriteException("frame_id has bad length: " + frame_id + " (" + frame_id.length() + ")");
            }
            if (filter == null || !filter.filter(frame_id)) {
                baos.write((byte)frame_id.charAt(0));
                baos.write((byte)frame_id.charAt(1));
                baos.write((byte)frame_id.charAt(2));
                baos.write((byte)frame_id.charAt(3));
                int length = frame.bytes.length;
                baos.write((byte)(0xFF & length >> 24));
                baos.write((byte)(0xFF & length >> 16));
                baos.write((byte)(0xFF & length >> 8));
                baos.write((byte)(0xFF & length));
                int flags = 0;
                if (frame.flags.getTagAlterPreservation()) {
                    flags |= 0x8000;
                }
                if (frame.flags.getFileAlterPreservation()) {
                    flags |= 0x4000;
                }
                if (frame.flags.getReadOnly()) {
                    flags |= 0x2000;
                }
                if (frame.flags.getGroupingIdentity()) {
                    flags |= 0x20;
                }
                if (frame.flags.getCompression()) {
                    flags |= 0x80;
                }
                if (frame.flags.getEncryption()) {
                    flags |= 0x40;
                }
                baos.write((byte)(0xFF & flags >> 8));
                baos.write((byte)(0xFF & flags));
                baos.write(frame.bytes);
            }
            ++i;
        }
        return baos.toByteArray();
    }

    private void checkTags(MusicMetadataSet set, Vector frames) throws UnsupportedEncodingException, IOException {
        if (set.id3v2Raw == null) {
            return;
        }
        Vector old_frames = set.id3v2Raw.frames;
        if (old_frames == null) {
            return;
        }
        Vector<String> new_frame_ids = new Vector<String>();
        int i = 0;
        while (i < frames.size()) {
            Frame frame = (Frame)frames.get(i);
            new_frame_ids.add(frame.longFrameID);
            ++i;
        }
        Vector<String> final_frame_ids = new Vector<String>(new_frame_ids);
        int i2 = 0;
        while (i2 < old_frames.size()) {
            block16: {
                Number frame_order;
                String longFrameID;
                MyID3v2Frame old_frame;
                block15: {
                    block14: {
                        old_frame = (MyID3v2Frame)old_frames.get(i2);
                        ID3FrameType frame_type = ID3FrameType.get(old_frame.frame_id);
                        if (frame_type == null) break block14;
                        longFrameID = frame_type.long_id;
                        frame_order = frame_type.getFrameOrder();
                        break block15;
                    }
                    if (old_frame.frame_id.length() != 4) break block16;
                    longFrameID = old_frame.frame_id;
                    frame_order = ID3FrameType.DEFAULT_FRAME_ORDER;
                }
                if (!new_frame_ids.contains(longFrameID)) {
                    Frame frame;
                    if (old_frame instanceof MyID3v2FrameText) {
                        MyID3v2FrameText text_frame = (MyID3v2FrameText)old_frame;
                        frame = this.toFrame(longFrameID, frame_order, text_frame.value, text_frame.value2);
                        if (frame != null) {
                            frames.add(frame);
                            final_frame_ids.add(frame.longFrameID);
                        }
                    } else if (old_frame instanceof MyID3v2FrameImage) {
                        MyID3v2FrameImage imageFrame = (MyID3v2FrameImage)old_frame;
                        frame = this.toFrameImage(longFrameID, frame_order, imageFrame.getImageData());
                        frames.add(frame);
                        final_frame_ids.add(frame.longFrameID);
                    } else {
                        MyID3v2FrameData data = (MyID3v2FrameData)old_frame;
                        if (!data.flags.getTagAlterPreservation() && data.frame_id.length() == 4) {
                            frame = new Frame(data.frame_id, data.data_bytes, data.flags);
                            frames.add(frame);
                            final_frame_ids.add(frame.longFrameID);
                        }
                    }
                }
            }
            ++i2;
        }
    }

    public byte[] toTag(MusicMetadataSet set, MusicMetadata values) throws Exception {
        return this.toTag(null, set, values);
    }

    public byte[] toTag(Filter filter, MusicMetadataSet set, MusicMetadata values) throws UnsupportedEncodingException, IOException, ID3WriteException {
        values = new MusicMetadata(values);
        Vector frames = this.toFrames(values);
        this.checkTags(set, frames);
        byte[] frame_bytes = this.writeFrames(filter, frames);
        byte[] extended_header = new byte[]{};
        byte[] padding = new byte[]{};
        int body_length = extended_header.length + frame_bytes.length + padding.length;
        byte[] header = this.getHeaderFooter(body_length, false);
        byte[] footer = null;
        int resultLength = header.length + extended_header.length + frame_bytes.length + padding.length;
        if (footer != null) {
            resultLength += footer.length;
        }
        byte[] result = new byte[resultLength];
        int index = 0;
        System.arraycopy(header, 0, result, index, header.length);
        System.arraycopy(frame_bytes, 0, result, index += header.length, frame_bytes.length);
        if (footer != null) {
            System.arraycopy(footer, 0, result, index += frame_bytes.length, footer.length);
        }
        return result;
    }

    public static interface Filter {
        public boolean filter(String var1);
    }

    private static class Frame {
        public final String longFrameID;
        public final Number frame_order;
        public final byte[] bytes;
        public final ID3v2FrameFlags flags;

        public Frame(String longFrameID, byte[] bytes) {
            this(longFrameID, ID3FrameType.DEFAULT_FRAME_ORDER, bytes, new ID3v2FrameFlags());
        }

        public Frame(String longFrameID, byte[] bytes, ID3v2FrameFlags flags) {
            this(longFrameID, ID3FrameType.DEFAULT_FRAME_ORDER, bytes, flags);
        }

        public Frame(String longFrameID, Number frame_order, byte[] bytes) {
            this(longFrameID, frame_order, bytes, new ID3v2FrameFlags());
        }

        public Frame(String longFrameID, Number frame_order, byte[] bytes, ID3v2FrameFlags flags) {
            this.longFrameID = longFrameID;
            this.frame_order = frame_order;
            this.bytes = bytes;
            this.flags = flags;
        }

        public String toString() {
            return "[frame: " + this.longFrameID + ": " + this.bytes.length + "]";
        }
    }
}

