/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.net.Uri;
import android.net.http.HttpResponseCache;
import android.os.Build;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.Utils;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class UrlConnectionDownloader
implements Downloader {
    static final String RESPONSE_SOURCE = "X-Android-Response-Source";
    private static final Object lock = new Object();
    static volatile Object cache;
    private final Context context;

    public UrlConnectionDownloader(Context context) {
        this.context = context.getApplicationContext();
    }

    protected HttpURLConnection openConnection(Uri path) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(path.toString()).openConnection();
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(20000);
        return connection;
    }

    @Override
    public Downloader.Response load(Uri uri, boolean localCacheOnly) throws IOException {
        int responseCode;
        if (Build.VERSION.SDK_INT >= 14) {
            UrlConnectionDownloader.installCacheIfNeeded(this.context);
        }
        HttpURLConnection connection = this.openConnection(uri);
        connection.setUseCaches(true);
        if (localCacheOnly) {
            connection.setRequestProperty("Cache-Control", "only-if-cached;max-age=2147483647");
        }
        if ((responseCode = connection.getResponseCode()) >= 300) {
            return null;
        }
        boolean fromCache = Utils.parseResponseSourceHeader(connection.getHeaderField(RESPONSE_SOURCE));
        return new Downloader.Response(connection.getInputStream(), fromCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installCacheIfNeeded(Context context) {
        if (cache == null) {
            try {
                Object object = lock;
                synchronized (object) {
                    if (cache == null) {
                        cache = ResponseCacheIcs.install(context);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class ResponseCacheIcs {
        private ResponseCacheIcs() {
        }

        static Object install(Context context) throws IOException {
            File cacheDir = Utils.createDefaultCacheDir(context);
            HttpResponseCache cache = HttpResponseCache.getInstalled();
            if (cache == null) {
                long maxSize = Utils.calculateDiskCacheSize(cacheDir);
                cache = HttpResponseCache.install((File)cacheDir, (long)maxSize);
            }
            return cache;
        }
    }
}

