/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.net.Uri;
import com.squareup.okhttp.HttpResponseCache;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.Utils;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.ResponseCache;
import java.net.URL;

public class OkHttpDownloader
implements Downloader {
    static final String RESPONSE_SOURCE_ANDROID = "X-Android-Response-Source";
    static final String RESPONSE_SOURCE_OKHTTP = "OkHttp-Response-Source";
    private final OkHttpClient client;

    public OkHttpDownloader(Context context) {
        this(Utils.createDefaultCacheDir(context));
    }

    public OkHttpDownloader(File cacheDir) {
        this(cacheDir, Utils.calculateDiskCacheSize(cacheDir));
    }

    public OkHttpDownloader(Context context, long maxSize) {
        this(Utils.createDefaultCacheDir(context), maxSize);
    }

    public OkHttpDownloader(File cacheDir, long maxSize) {
        this(new OkHttpClient());
        try {
            this.client.setResponseCache((ResponseCache)new HttpResponseCache(cacheDir, maxSize));
        }
        catch (IOException ignored) {
            // empty catch block
        }
    }

    public OkHttpDownloader(OkHttpClient client) {
        this.client = client;
    }

    protected HttpURLConnection openConnection(Uri uri) throws IOException {
        HttpURLConnection connection = this.client.open(new URL(uri.toString()));
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(20000);
        return connection;
    }

    protected OkHttpClient getClient() {
        return this.client;
    }

    @Override
    public Downloader.Response load(Uri uri, boolean localCacheOnly) throws IOException {
        int responseCode;
        HttpURLConnection connection = this.openConnection(uri);
        connection.setUseCaches(true);
        if (localCacheOnly) {
            connection.setRequestProperty("Cache-Control", "only-if-cached;max-age=2147483647");
        }
        if ((responseCode = connection.getResponseCode()) >= 300) {
            return null;
        }
        String responseSource = connection.getHeaderField(RESPONSE_SOURCE_OKHTTP);
        if (responseSource == null) {
            responseSource = connection.getHeaderField(RESPONSE_SOURCE_ANDROID);
        }
        boolean fromCache = Utils.parseResponseSourceHeader(responseSource);
        return new Downloader.Response(connection.getInputStream(), fromCache);
    }
}

