/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.xinclude;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Stack;
import java.util.StringTokenizer;
import mf.org.apache.xerces.impl.Constants;
import mf.org.apache.xerces.impl.XMLEntityManager;
import mf.org.apache.xerces.impl.XMLErrorReporter;
import mf.org.apache.xerces.impl.io.MalformedByteSequenceException;
import mf.org.apache.xerces.util.AugmentationsImpl;
import mf.org.apache.xerces.util.HTTPInputSource;
import mf.org.apache.xerces.util.IntStack;
import mf.org.apache.xerces.util.ParserConfigurationSettings;
import mf.org.apache.xerces.util.SecurityManager;
import mf.org.apache.xerces.util.SymbolTable;
import mf.org.apache.xerces.util.URI;
import mf.org.apache.xerces.util.XMLAttributesImpl;
import mf.org.apache.xerces.util.XMLChar;
import mf.org.apache.xerces.util.XMLLocatorWrapper;
import mf.org.apache.xerces.util.XMLResourceIdentifierImpl;
import mf.org.apache.xerces.util.XMLSymbols;
import mf.org.apache.xerces.xinclude.ObjectFactory;
import mf.org.apache.xerces.xinclude.XInclude11TextReader;
import mf.org.apache.xerces.xinclude.XIncludeMessageFormatter;
import mf.org.apache.xerces.xinclude.XIncludeNamespaceSupport;
import mf.org.apache.xerces.xinclude.XIncludeTextReader;
import mf.org.apache.xerces.xni.Augmentations;
import mf.org.apache.xerces.xni.NamespaceContext;
import mf.org.apache.xerces.xni.QName;
import mf.org.apache.xerces.xni.XMLAttributes;
import mf.org.apache.xerces.xni.XMLDTDHandler;
import mf.org.apache.xerces.xni.XMLDocumentHandler;
import mf.org.apache.xerces.xni.XMLLocator;
import mf.org.apache.xerces.xni.XMLResourceIdentifier;
import mf.org.apache.xerces.xni.XMLString;
import mf.org.apache.xerces.xni.XNIException;
import mf.org.apache.xerces.xni.parser.XMLComponent;
import mf.org.apache.xerces.xni.parser.XMLComponentManager;
import mf.org.apache.xerces.xni.parser.XMLConfigurationException;
import mf.org.apache.xerces.xni.parser.XMLDTDFilter;
import mf.org.apache.xerces.xni.parser.XMLDTDSource;
import mf.org.apache.xerces.xni.parser.XMLDocumentFilter;
import mf.org.apache.xerces.xni.parser.XMLDocumentSource;
import mf.org.apache.xerces.xni.parser.XMLEntityResolver;
import mf.org.apache.xerces.xni.parser.XMLInputSource;
import mf.org.apache.xerces.xni.parser.XMLParserConfiguration;
import mf.org.apache.xerces.xpointer.XPointerHandler;
import mf.org.apache.xerces.xpointer.XPointerProcessor;

public class XIncludeHandler
implements XMLComponent,
XMLDocumentFilter,
XMLDTDFilter {
    public static final String XINCLUDE_DEFAULT_CONFIGURATION = "mf.org.apache.xerces.parsers.XIncludeParserConfiguration";
    public static final String HTTP_ACCEPT = "Accept";
    public static final String HTTP_ACCEPT_LANGUAGE = "Accept-Language";
    public static final String XPOINTER = "xpointer";
    public static final String XINCLUDE_NS_URI = "http://www.w3.org/2001/XInclude".intern();
    public static final String XINCLUDE_INCLUDE = "include".intern();
    public static final String XINCLUDE_FALLBACK = "fallback".intern();
    public static final String XINCLUDE_PARSE_XML = "xml".intern();
    public static final String XINCLUDE_PARSE_TEXT = "text".intern();
    public static final String XINCLUDE_ATTR_HREF = "href".intern();
    public static final String XINCLUDE_ATTR_PARSE = "parse".intern();
    public static final String XINCLUDE_ATTR_ENCODING = "encoding".intern();
    public static final String XINCLUDE_ATTR_ACCEPT = "accept".intern();
    public static final String XINCLUDE_ATTR_ACCEPT_LANGUAGE = "accept-language".intern();
    public static final String XINCLUDE_INCLUDED = "[included]".intern();
    public static final String CURRENT_BASE_URI = "currentBaseURI";
    private static final String XINCLUDE_BASE = "base".intern();
    private static final QName XML_BASE_QNAME = new QName(XMLSymbols.PREFIX_XML, XINCLUDE_BASE, (String.valueOf(XMLSymbols.PREFIX_XML) + ":" + XINCLUDE_BASE).intern(), NamespaceContext.XML_URI);
    private static final String XINCLUDE_LANG = "lang".intern();
    private static final QName XML_LANG_QNAME = new QName(XMLSymbols.PREFIX_XML, XINCLUDE_LANG, (String.valueOf(XMLSymbols.PREFIX_XML) + ":" + XINCLUDE_LANG).intern(), NamespaceContext.XML_URI);
    private static final QName NEW_NS_ATTR_QNAME = new QName(XMLSymbols.PREFIX_XMLNS, "", String.valueOf(XMLSymbols.PREFIX_XMLNS) + ":", NamespaceContext.XMLNS_URI);
    private static final int STATE_NORMAL_PROCESSING = 1;
    private static final int STATE_IGNORE = 2;
    private static final int STATE_EXPECT_FALLBACK = 3;
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    protected static final String ALLOW_UE_AND_NOTATION_EVENTS = "http://xml.org/sax/features/allow-dtd-events-after-endDTD";
    protected static final String XINCLUDE_FIXUP_BASE_URIS = "http://apache.org/xml/features/xinclude/fixup-base-uris";
    protected static final String XINCLUDE_FIXUP_LANGUAGE = "http://apache.org/xml/features/xinclude/fixup-language";
    protected static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    protected static final String BUFFER_SIZE = "http://apache.org/xml/properties/input-buffer-size";
    protected static final String PARSER_SETTINGS = "http://apache.org/xml/features/internal/parser-settings";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/allow-dtd-events-after-endDTD", "http://apache.org/xml/features/xinclude/fixup-base-uris", "http://apache.org/xml/features/xinclude/fixup-language"};
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.TRUE};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/entity-resolver", "http://apache.org/xml/properties/security-manager", "http://apache.org/xml/properties/input-buffer-size"};
    private static final Object[] PROPERTY_DEFAULTS;
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLDocumentSource fDocumentSource;
    protected XMLDTDHandler fDTDHandler;
    protected XMLDTDSource fDTDSource;
    protected XIncludeHandler fParentXIncludeHandler;
    protected int fBufferSize = 2048;
    protected String fParentRelativeURI;
    protected XMLParserConfiguration fChildConfig;
    protected XMLParserConfiguration fXIncludeChildConfig;
    protected XMLParserConfiguration fXPointerChildConfig;
    protected XPointerProcessor fXPtrProcessor = null;
    protected XMLLocator fDocLocation;
    protected XMLLocatorWrapper fXIncludeLocator = new XMLLocatorWrapper();
    protected XIncludeMessageFormatter fXIncludeMessageFormatter = new XIncludeMessageFormatter();
    protected XIncludeNamespaceSupport fNamespaceContext;
    protected SymbolTable fSymbolTable;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityResolver fEntityResolver;
    protected SecurityManager fSecurityManager;
    protected XIncludeTextReader fXInclude10TextReader;
    protected XIncludeTextReader fXInclude11TextReader;
    protected final XMLResourceIdentifier fCurrentBaseURI;
    protected final IntStack fBaseURIScope;
    protected final Stack fBaseURI;
    protected final Stack fLiteralSystemID;
    protected final Stack fExpandedSystemID;
    protected final IntStack fLanguageScope;
    protected final Stack fLanguageStack;
    protected String fCurrentLanguage;
    protected String fHrefFromParent;
    protected ParserConfigurationSettings fSettings;
    private int fDepth = 0;
    private int fResultDepth;
    private static final int INITIAL_SIZE = 8;
    private boolean[] fSawInclude = new boolean[8];
    private boolean[] fSawFallback = new boolean[8];
    private int[] fState = new int[8];
    private final ArrayList fNotations;
    private final ArrayList fUnparsedEntities;
    private boolean fFixupBaseURIs = true;
    private boolean fFixupLanguage = true;
    private boolean fSendUEAndNotationEvents;
    private boolean fIsXML11;
    private boolean fInDTD;
    boolean fHasIncludeReportedContent;
    private boolean fSeenRootElement;
    private boolean fNeedCopyFeatures = true;
    private static final boolean[] gNeedEscaping;
    private static final char[] gAfterEscaping1;
    private static final char[] gAfterEscaping2;
    private static final char[] gHexChs;

    static {
        Object[] objectArray = new Object[4];
        objectArray[3] = new Integer(2048);
        PROPERTY_DEFAULTS = objectArray;
        gNeedEscaping = new boolean[128];
        gAfterEscaping1 = new char[128];
        gAfterEscaping2 = new char[128];
        gHexChs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] escChs = new char[]{' ', '<', '>', '\"', '{', '}', '|', '\\', '^', '`'};
        int len = escChs.length;
        int i = 0;
        while (i < len) {
            char ch = escChs[i];
            XIncludeHandler.gNeedEscaping[ch] = true;
            XIncludeHandler.gAfterEscaping1[ch] = gHexChs[ch >> 4];
            XIncludeHandler.gAfterEscaping2[ch] = gHexChs[ch & 0xF];
            ++i;
        }
    }

    public XIncludeHandler() {
        this.fSawFallback[this.fDepth] = false;
        this.fSawInclude[this.fDepth] = false;
        this.fState[this.fDepth] = 1;
        this.fNotations = new ArrayList();
        this.fUnparsedEntities = new ArrayList();
        this.fBaseURIScope = new IntStack();
        this.fBaseURI = new Stack();
        this.fLiteralSystemID = new Stack();
        this.fExpandedSystemID = new Stack();
        this.fCurrentBaseURI = new XMLResourceIdentifierImpl();
        this.fLanguageScope = new IntStack();
        this.fLanguageStack = new Stack();
        this.fCurrentLanguage = null;
    }

    @Override
    public void reset(XMLComponentManager componentManager) throws XNIException {
        Object value;
        this.fNamespaceContext = null;
        this.fDepth = 0;
        this.fResultDepth = this.isRootDocument() ? 0 : this.fParentXIncludeHandler.getResultDepth();
        this.fNotations.clear();
        this.fUnparsedEntities.clear();
        this.fParentRelativeURI = null;
        this.fIsXML11 = false;
        this.fInDTD = false;
        this.fSeenRootElement = false;
        this.fBaseURIScope.clear();
        this.fBaseURI.clear();
        this.fLiteralSystemID.clear();
        this.fExpandedSystemID.clear();
        this.fLanguageScope.clear();
        this.fLanguageStack.clear();
        int i = 0;
        while (i < this.fState.length) {
            this.fState[i] = 1;
            ++i;
        }
        i = 0;
        while (i < this.fSawFallback.length) {
            this.fSawFallback[i] = false;
            ++i;
        }
        i = 0;
        while (i < this.fSawInclude.length) {
            this.fSawInclude[i] = false;
            ++i;
        }
        try {
            if (!componentManager.getFeature(PARSER_SETTINGS)) {
                return;
            }
        }
        catch (XMLConfigurationException i2) {
            // empty catch block
        }
        this.fNeedCopyFeatures = true;
        try {
            this.fSendUEAndNotationEvents = componentManager.getFeature(ALLOW_UE_AND_NOTATION_EVENTS);
            if (this.fChildConfig != null) {
                this.fChildConfig.setFeature(ALLOW_UE_AND_NOTATION_EVENTS, this.fSendUEAndNotationEvents);
            }
        }
        catch (XMLConfigurationException i2) {
            // empty catch block
        }
        try {
            this.fFixupBaseURIs = componentManager.getFeature(XINCLUDE_FIXUP_BASE_URIS);
            if (this.fChildConfig != null) {
                this.fChildConfig.setFeature(XINCLUDE_FIXUP_BASE_URIS, this.fFixupBaseURIs);
            }
        }
        catch (XMLConfigurationException e) {
            this.fFixupBaseURIs = true;
        }
        try {
            this.fFixupLanguage = componentManager.getFeature(XINCLUDE_FIXUP_LANGUAGE);
            if (this.fChildConfig != null) {
                this.fChildConfig.setFeature(XINCLUDE_FIXUP_LANGUAGE, this.fFixupLanguage);
            }
        }
        catch (XMLConfigurationException e) {
            this.fFixupLanguage = true;
        }
        try {
            value = (SymbolTable)componentManager.getProperty(SYMBOL_TABLE);
            if (value != null) {
                this.fSymbolTable = value;
                if (this.fChildConfig != null) {
                    this.fChildConfig.setProperty(SYMBOL_TABLE, value);
                }
            }
        }
        catch (XMLConfigurationException e) {
            this.fSymbolTable = null;
        }
        try {
            value = (XMLErrorReporter)componentManager.getProperty(ERROR_REPORTER);
            if (value != null) {
                this.setErrorReporter((XMLErrorReporter)value);
                if (this.fChildConfig != null) {
                    this.fChildConfig.setProperty(ERROR_REPORTER, value);
                }
            }
        }
        catch (XMLConfigurationException e) {
            this.fErrorReporter = null;
        }
        try {
            value = (XMLEntityResolver)componentManager.getProperty(ENTITY_RESOLVER);
            if (value != null) {
                this.fEntityResolver = value;
                if (this.fChildConfig != null) {
                    this.fChildConfig.setProperty(ENTITY_RESOLVER, value);
                }
            }
        }
        catch (XMLConfigurationException e) {
            this.fEntityResolver = null;
        }
        try {
            value = (SecurityManager)componentManager.getProperty(SECURITY_MANAGER);
            if (value != null) {
                this.fSecurityManager = value;
                if (this.fChildConfig != null) {
                    this.fChildConfig.setProperty(SECURITY_MANAGER, value);
                }
            }
        }
        catch (XMLConfigurationException e) {
            this.fSecurityManager = null;
        }
        try {
            value = (Integer)componentManager.getProperty(BUFFER_SIZE);
            if (value != null && (Integer)value > 0) {
                this.fBufferSize = (Integer)value;
                if (this.fChildConfig != null) {
                    this.fChildConfig.setProperty(BUFFER_SIZE, value);
                }
            } else {
                this.fBufferSize = (Integer)this.getPropertyDefault(BUFFER_SIZE);
            }
        }
        catch (XMLConfigurationException e) {
            this.fBufferSize = (Integer)this.getPropertyDefault(BUFFER_SIZE);
        }
        if (this.fXInclude10TextReader != null) {
            this.fXInclude10TextReader.setBufferSize(this.fBufferSize);
        }
        if (this.fXInclude11TextReader != null) {
            this.fXInclude11TextReader.setBufferSize(this.fBufferSize);
        }
        this.fSettings = new ParserConfigurationSettings();
        this.copyFeatures(componentManager, this.fSettings);
        try {
            if (componentManager.getFeature(SCHEMA_VALIDATION)) {
                this.fSettings.setFeature(SCHEMA_VALIDATION, false);
                if (Constants.NS_XMLSCHEMA.equals(componentManager.getProperty(JAXP_SCHEMA_LANGUAGE))) {
                    this.fSettings.setFeature(VALIDATION, false);
                } else if (componentManager.getFeature(VALIDATION)) {
                    this.fSettings.setFeature(DYNAMIC_VALIDATION, true);
                }
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    @Override
    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    @Override
    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        if (featureId.equals(ALLOW_UE_AND_NOTATION_EVENTS)) {
            this.fSendUEAndNotationEvents = state;
        }
        if (this.fSettings != null) {
            this.fNeedCopyFeatures = true;
            this.fSettings.setFeature(featureId, state);
        }
    }

    @Override
    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    @Override
    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        if (propertyId.equals(SYMBOL_TABLE)) {
            this.fSymbolTable = (SymbolTable)value;
            if (this.fChildConfig != null) {
                this.fChildConfig.setProperty(propertyId, value);
            }
            return;
        }
        if (propertyId.equals(ERROR_REPORTER)) {
            this.setErrorReporter((XMLErrorReporter)value);
            if (this.fChildConfig != null) {
                this.fChildConfig.setProperty(propertyId, value);
            }
            return;
        }
        if (propertyId.equals(ENTITY_RESOLVER)) {
            this.fEntityResolver = (XMLEntityResolver)value;
            if (this.fChildConfig != null) {
                this.fChildConfig.setProperty(propertyId, value);
            }
            return;
        }
        if (propertyId.equals(SECURITY_MANAGER)) {
            this.fSecurityManager = (SecurityManager)value;
            if (this.fChildConfig != null) {
                this.fChildConfig.setProperty(propertyId, value);
            }
            return;
        }
        if (propertyId.equals(BUFFER_SIZE)) {
            Integer bufferSize = (Integer)value;
            if (this.fChildConfig != null) {
                this.fChildConfig.setProperty(propertyId, value);
            }
            if (bufferSize != null && bufferSize > 0) {
                this.fBufferSize = bufferSize;
                if (this.fXInclude10TextReader != null) {
                    this.fXInclude10TextReader.setBufferSize(this.fBufferSize);
                }
                if (this.fXInclude11TextReader != null) {
                    this.fXInclude11TextReader.setBufferSize(this.fBufferSize);
                }
            }
            return;
        }
    }

    @Override
    public Boolean getFeatureDefault(String featureId) {
        int i = 0;
        while (i < RECOGNIZED_FEATURES.length) {
            if (RECOGNIZED_FEATURES[i].equals(featureId)) {
                return FEATURE_DEFAULTS[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public Object getPropertyDefault(String propertyId) {
        int i = 0;
        while (i < RECOGNIZED_PROPERTIES.length) {
            if (RECOGNIZED_PROPERTIES[i].equals(propertyId)) {
                return PROPERTY_DEFAULTS[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public void setDocumentHandler(XMLDocumentHandler handler) {
        if (this.fDocumentHandler != handler) {
            this.fDocumentHandler = handler;
            if (this.fXIncludeChildConfig != null) {
                this.fXIncludeChildConfig.setDocumentHandler(handler);
            }
            if (this.fXPointerChildConfig != null) {
                this.fXPointerChildConfig.setDocumentHandler(handler);
            }
        }
    }

    @Override
    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    @Override
    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        this.fErrorReporter.setDocumentLocator(locator);
        if (!(namespaceContext instanceof XIncludeNamespaceSupport)) {
            this.reportFatalError("IncompatibleNamespaceContext");
        }
        this.fNamespaceContext = (XIncludeNamespaceSupport)namespaceContext;
        this.fDocLocation = locator;
        this.fXIncludeLocator.setLocator(this.fDocLocation);
        this.setupCurrentBaseURI(locator);
        this.saveBaseURI();
        if (augs == null) {
            augs = new AugmentationsImpl();
        }
        augs.putItem(CURRENT_BASE_URI, this.fCurrentBaseURI);
        if (!this.isRootDocument()) {
            this.fParentXIncludeHandler.fHasIncludeReportedContent = true;
            if (this.fParentXIncludeHandler.searchForRecursiveIncludes(this.fCurrentBaseURI.getExpandedSystemId())) {
                this.reportFatalError("RecursiveInclude", new Object[]{this.fCurrentBaseURI.getExpandedSystemId()});
            }
        }
        this.fCurrentLanguage = XMLSymbols.EMPTY_STRING;
        this.saveLanguage(this.fCurrentLanguage);
        if (this.isRootDocument() && this.fDocumentHandler != null) {
            this.fDocumentHandler.startDocument(this.fXIncludeLocator, encoding, namespaceContext, augs);
        }
    }

    @Override
    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
        this.fIsXML11 = "1.1".equals(version);
        if (this.isRootDocument() && this.fDocumentHandler != null) {
            this.fDocumentHandler.xmlDecl(version, encoding, standalone, augs);
        }
    }

    @Override
    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
        if (this.isRootDocument() && this.fDocumentHandler != null) {
            this.fDocumentHandler.doctypeDecl(rootElement, publicId, systemId, augs);
        }
    }

    @Override
    public void comment(XMLString text, Augmentations augs) throws XNIException {
        if (!this.fInDTD) {
            if (this.fDocumentHandler != null && this.getState() == 1) {
                ++this.fDepth;
                augs = this.modifyAugmentations(augs);
                this.fDocumentHandler.comment(text, augs);
                --this.fDepth;
            }
        } else if (this.fDTDHandler != null) {
            this.fDTDHandler.comment(text, augs);
        }
    }

    @Override
    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
        if (!this.fInDTD) {
            if (this.fDocumentHandler != null && this.getState() == 1) {
                ++this.fDepth;
                augs = this.modifyAugmentations(augs);
                this.fDocumentHandler.processingInstruction(target, data, augs);
                --this.fDepth;
            }
        } else if (this.fDTDHandler != null) {
            this.fDTDHandler.processingInstruction(target, data, augs);
        }
    }

    @Override
    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        ++this.fDepth;
        int lastState = this.getState(this.fDepth - 1);
        if (lastState == 3 && this.getState(this.fDepth - 2) == 3) {
            this.setState(2);
        } else {
            this.setState(lastState);
        }
        this.processXMLBaseAttributes(attributes);
        if (this.fFixupLanguage) {
            this.processXMLLangAttributes(attributes);
        }
        if (this.isIncludeElement(element)) {
            boolean success = this.handleIncludeElement(attributes);
            if (success) {
                this.setState(2);
            } else {
                this.setState(3);
            }
        } else if (this.isFallbackElement(element)) {
            this.handleFallbackElement();
        } else if (this.hasXIncludeNamespace(element)) {
            if (this.getSawInclude(this.fDepth - 1)) {
                this.reportFatalError("IncludeChild", new Object[]{element.rawname});
            }
            if (this.getSawFallback(this.fDepth - 1)) {
                this.reportFatalError("FallbackChild", new Object[]{element.rawname});
            }
            if (this.getState() == 1) {
                if (this.fResultDepth++ == 0) {
                    this.checkMultipleRootElements();
                }
                if (this.fDocumentHandler != null) {
                    augs = this.modifyAugmentations(augs);
                    attributes = this.processAttributes(attributes);
                    this.fDocumentHandler.startElement(element, attributes, augs);
                }
            }
        } else if (this.getState() == 1) {
            if (this.fResultDepth++ == 0) {
                this.checkMultipleRootElements();
            }
            if (this.fDocumentHandler != null) {
                augs = this.modifyAugmentations(augs);
                attributes = this.processAttributes(attributes);
                this.fDocumentHandler.startElement(element, attributes, augs);
            }
        }
    }

    @Override
    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        ++this.fDepth;
        int lastState = this.getState(this.fDepth - 1);
        if (lastState == 3 && this.getState(this.fDepth - 2) == 3) {
            this.setState(2);
        } else {
            this.setState(lastState);
        }
        this.processXMLBaseAttributes(attributes);
        if (this.fFixupLanguage) {
            this.processXMLLangAttributes(attributes);
        }
        if (this.isIncludeElement(element)) {
            boolean success = this.handleIncludeElement(attributes);
            if (success) {
                this.setState(2);
            } else {
                this.reportFatalError("NoFallback");
            }
        } else if (this.isFallbackElement(element)) {
            this.handleFallbackElement();
        } else if (this.hasXIncludeNamespace(element)) {
            if (this.getSawInclude(this.fDepth - 1)) {
                this.reportFatalError("IncludeChild", new Object[]{element.rawname});
            }
            if (this.getSawFallback(this.fDepth - 1)) {
                this.reportFatalError("FallbackChild", new Object[]{element.rawname});
            }
            if (this.getState() == 1) {
                if (this.fResultDepth == 0) {
                    this.checkMultipleRootElements();
                }
                if (this.fDocumentHandler != null) {
                    augs = this.modifyAugmentations(augs);
                    attributes = this.processAttributes(attributes);
                    this.fDocumentHandler.emptyElement(element, attributes, augs);
                }
            }
        } else if (this.getState() == 1) {
            if (this.fResultDepth == 0) {
                this.checkMultipleRootElements();
            }
            if (this.fDocumentHandler != null) {
                augs = this.modifyAugmentations(augs);
                attributes = this.processAttributes(attributes);
                this.fDocumentHandler.emptyElement(element, attributes, augs);
            }
        }
        this.setSawFallback(this.fDepth + 1, false);
        this.setSawInclude(this.fDepth, false);
        if (this.fBaseURIScope.size() > 0 && this.fDepth == this.fBaseURIScope.peek()) {
            this.restoreBaseURI();
        }
        --this.fDepth;
    }

    @Override
    public void endElement(QName element, Augmentations augs) throws XNIException {
        if (this.isIncludeElement(element) && this.getState() == 3 && !this.getSawFallback(this.fDepth + 1)) {
            this.reportFatalError("NoFallback");
        }
        if (this.isFallbackElement(element)) {
            if (this.getState() == 1) {
                this.setState(2);
            }
        } else if (this.getState() == 1) {
            --this.fResultDepth;
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.endElement(element, augs);
            }
        }
        this.setSawFallback(this.fDepth + 1, false);
        this.setSawInclude(this.fDepth, false);
        if (this.fBaseURIScope.size() > 0 && this.fDepth == this.fBaseURIScope.peek()) {
            this.restoreBaseURI();
        }
        if (this.fLanguageScope.size() > 0 && this.fDepth == this.fLanguageScope.peek()) {
            this.fCurrentLanguage = this.restoreLanguage();
        }
        --this.fDepth;
    }

    @Override
    public void startGeneralEntity(String name, XMLResourceIdentifier resId, String encoding, Augmentations augs) throws XNIException {
        if (this.getState() == 1) {
            if (this.fResultDepth == 0) {
                if (augs != null && Boolean.TRUE.equals(augs.getItem("ENTITY_SKIPPED"))) {
                    this.reportFatalError("UnexpandedEntityReferenceIllegal");
                }
            } else if (this.fDocumentHandler != null) {
                this.fDocumentHandler.startGeneralEntity(name, resId, encoding, augs);
            }
        }
    }

    @Override
    public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            this.fDocumentHandler.textDecl(version, encoding, augs);
        }
    }

    @Override
    public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1 && this.fResultDepth != 0) {
            this.fDocumentHandler.endGeneralEntity(name, augs);
        }
    }

    @Override
    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (this.getState() == 1) {
            if (this.fResultDepth == 0) {
                this.checkWhitespace(text);
            } else if (this.fDocumentHandler != null) {
                ++this.fDepth;
                augs = this.modifyAugmentations(augs);
                this.fDocumentHandler.characters(text, augs);
                --this.fDepth;
            }
        }
    }

    @Override
    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1 && this.fResultDepth != 0) {
            this.fDocumentHandler.ignorableWhitespace(text, augs);
        }
    }

    @Override
    public void startCDATA(Augmentations augs) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1 && this.fResultDepth != 0) {
            this.fDocumentHandler.startCDATA(augs);
        }
    }

    @Override
    public void endCDATA(Augmentations augs) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1 && this.fResultDepth != 0) {
            this.fDocumentHandler.endCDATA(augs);
        }
    }

    @Override
    public void endDocument(Augmentations augs) throws XNIException {
        if (this.isRootDocument()) {
            if (!this.fSeenRootElement) {
                this.reportFatalError("RootElementRequired");
            }
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.endDocument(augs);
            }
        }
    }

    @Override
    public void setDocumentSource(XMLDocumentSource source) {
        this.fDocumentSource = source;
    }

    @Override
    public XMLDocumentSource getDocumentSource() {
        return this.fDocumentSource;
    }

    @Override
    public void attributeDecl(String elementName, String attributeName, String type, String[] enumeration, String defaultType, XMLString defaultValue, XMLString nonNormalizedDefaultValue, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.attributeDecl(elementName, attributeName, type, enumeration, defaultType, defaultValue, nonNormalizedDefaultValue, augmentations);
        }
    }

    @Override
    public void elementDecl(String name, String contentModel, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.elementDecl(name, contentModel, augmentations);
        }
    }

    @Override
    public void endAttlist(Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endAttlist(augmentations);
        }
    }

    @Override
    public void endConditional(Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endConditional(augmentations);
        }
    }

    @Override
    public void endDTD(Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endDTD(augmentations);
        }
        this.fInDTD = false;
    }

    @Override
    public void endExternalSubset(Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endExternalSubset(augmentations);
        }
    }

    @Override
    public void endParameterEntity(String name, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endParameterEntity(name, augmentations);
        }
    }

    @Override
    public void externalEntityDecl(String name, XMLResourceIdentifier identifier, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.externalEntityDecl(name, identifier, augmentations);
        }
    }

    @Override
    public XMLDTDSource getDTDSource() {
        return this.fDTDSource;
    }

    @Override
    public void ignoredCharacters(XMLString text, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.ignoredCharacters(text, augmentations);
        }
    }

    @Override
    public void internalEntityDecl(String name, XMLString text, XMLString nonNormalizedText, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.internalEntityDecl(name, text, nonNormalizedText, augmentations);
        }
    }

    @Override
    public void notationDecl(String name, XMLResourceIdentifier identifier, Augmentations augmentations) throws XNIException {
        this.addNotation(name, identifier, augmentations);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.notationDecl(name, identifier, augmentations);
        }
    }

    @Override
    public void setDTDSource(XMLDTDSource source) {
        this.fDTDSource = source;
    }

    @Override
    public void startAttlist(String elementName, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startAttlist(elementName, augmentations);
        }
    }

    @Override
    public void startConditional(short type, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startConditional(type, augmentations);
        }
    }

    @Override
    public void startDTD(XMLLocator locator, Augmentations augmentations) throws XNIException {
        this.fInDTD = true;
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startDTD(locator, augmentations);
        }
    }

    @Override
    public void startExternalSubset(XMLResourceIdentifier identifier, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startExternalSubset(identifier, augmentations);
        }
    }

    @Override
    public void startParameterEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startParameterEntity(name, identifier, encoding, augmentations);
        }
    }

    @Override
    public void unparsedEntityDecl(String name, XMLResourceIdentifier identifier, String notation, Augmentations augmentations) throws XNIException {
        this.addUnparsedEntity(name, identifier, notation, augmentations);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.unparsedEntityDecl(name, identifier, notation, augmentations);
        }
    }

    @Override
    public XMLDTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    @Override
    public void setDTDHandler(XMLDTDHandler handler) {
        this.fDTDHandler = handler;
    }

    private void setErrorReporter(XMLErrorReporter reporter) {
        this.fErrorReporter = reporter;
        if (this.fErrorReporter != null) {
            this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xinclude", this.fXIncludeMessageFormatter);
            if (this.fDocLocation != null) {
                this.fErrorReporter.setDocumentLocator(this.fDocLocation);
            }
        }
    }

    protected void handleFallbackElement() {
        if (!this.getSawInclude(this.fDepth - 1)) {
            if (this.getState() == 2) {
                return;
            }
            this.reportFatalError("FallbackParent");
        }
        this.setSawInclude(this.fDepth, false);
        this.fNamespaceContext.setContextInvalid();
        if (this.getSawFallback(this.fDepth)) {
            this.reportFatalError("MultipleFallbacks");
        } else {
            this.setSawFallback(this.fDepth, true);
        }
        if (this.getState() == 3) {
            this.setState(1);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean handleIncludeElement(XMLAttributes attributes) throws XNIException {
        if (this.getSawInclude(this.fDepth - 1)) {
            this.reportFatalError("IncludeChild", new Object[]{XINCLUDE_INCLUDE});
        }
        if (this.getState() == 2) {
            return true;
        }
        this.setSawInclude(this.fDepth, true);
        this.fNamespaceContext.setContextInvalid();
        String href = attributes.getValue(XINCLUDE_ATTR_HREF);
        String parse = attributes.getValue(XINCLUDE_ATTR_PARSE);
        String xpointer = attributes.getValue(XPOINTER);
        String accept = attributes.getValue(XINCLUDE_ATTR_ACCEPT);
        String acceptLanguage = attributes.getValue(XINCLUDE_ATTR_ACCEPT_LANGUAGE);
        if (parse == null) {
            parse = XINCLUDE_PARSE_XML;
        }
        if (href == null) {
            href = XMLSymbols.EMPTY_STRING;
        }
        if (href.length() == 0 && XINCLUDE_PARSE_XML.equals(parse)) {
            if (xpointer == null) {
                this.reportFatalError("XpointerMissing");
            } else {
                Locale locale = this.fErrorReporter != null ? this.fErrorReporter.getLocale() : null;
                String reason = this.fXIncludeMessageFormatter.formatMessage(locale, "XPointerStreamability", null);
                this.reportResourceError("XMLResourceError", new Object[]{href, reason});
                return false;
            }
        }
        URI hrefURI = null;
        try {
            hrefURI = new URI(href, true);
            if (hrefURI.getFragment() != null) {
                this.reportFatalError("HrefFragmentIdentifierIllegal", new Object[]{href});
            }
        }
        catch (URI.MalformedURIException exc) {
            String newHref = this.escapeHref(href);
            if (href != newHref) {
                href = newHref;
                try {
                    hrefURI = new URI(href, true);
                    if (hrefURI.getFragment() != null) {
                        this.reportFatalError("HrefFragmentIdentifierIllegal", new Object[]{href});
                    }
                }
                catch (URI.MalformedURIException exc2) {
                    this.reportFatalError("HrefSyntacticallyInvalid", new Object[]{href});
                }
            }
            this.reportFatalError("HrefSyntacticallyInvalid", new Object[]{href});
        }
        if (accept != null && !this.isValidInHTTPHeader(accept)) {
            this.reportFatalError("AcceptMalformed", null);
            accept = null;
        }
        if (acceptLanguage != null && !this.isValidInHTTPHeader(acceptLanguage)) {
            this.reportFatalError("AcceptLanguageMalformed", null);
            acceptLanguage = null;
        }
        XMLInputSource includedSource = null;
        if (this.fEntityResolver != null) {
            try {
                XMLResourceIdentifierImpl resourceIdentifier = new XMLResourceIdentifierImpl(null, href, this.fCurrentBaseURI.getExpandedSystemId(), XMLEntityManager.expandSystemId(href, this.fCurrentBaseURI.getExpandedSystemId(), false));
                includedSource = this.fEntityResolver.resolveEntity(resourceIdentifier);
                if (!(includedSource == null || includedSource instanceof HTTPInputSource || accept == null && acceptLanguage == null || includedSource.getCharacterStream() != null || includedSource.getByteStream() != null)) {
                    includedSource = this.createInputSource(includedSource.getPublicId(), includedSource.getSystemId(), includedSource.getBaseSystemId(), accept, acceptLanguage);
                }
            }
            catch (IOException e) {
                this.reportResourceError("XMLResourceError", new Object[]{href, e.getMessage()}, e);
                return false;
            }
        }
        if (includedSource == null) {
            includedSource = accept != null || acceptLanguage != null ? this.createInputSource(null, href, this.fCurrentBaseURI.getExpandedSystemId(), accept, acceptLanguage) : new XMLInputSource(null, href, this.fCurrentBaseURI.getExpandedSystemId());
        }
        if (parse.equals(XINCLUDE_PARSE_XML)) {
            if (xpointer != null && this.fXPointerChildConfig == null || xpointer == null && this.fXIncludeChildConfig == null) {
                XIncludeHandler newHandler;
                String parserName = XINCLUDE_DEFAULT_CONFIGURATION;
                if (xpointer != null) {
                    parserName = "mf.org.apache.xerces.parsers.XPointerParserConfiguration";
                }
                this.fChildConfig = (XMLParserConfiguration)ObjectFactory.newInstance(parserName, ObjectFactory.findClassLoader(), true);
                if (this.fSymbolTable != null) {
                    this.fChildConfig.setProperty(SYMBOL_TABLE, this.fSymbolTable);
                }
                if (this.fErrorReporter != null) {
                    this.fChildConfig.setProperty(ERROR_REPORTER, this.fErrorReporter);
                }
                if (this.fEntityResolver != null) {
                    this.fChildConfig.setProperty(ENTITY_RESOLVER, this.fEntityResolver);
                }
                this.fChildConfig.setProperty(SECURITY_MANAGER, this.fSecurityManager);
                this.fChildConfig.setProperty(BUFFER_SIZE, new Integer(this.fBufferSize));
                this.fNeedCopyFeatures = true;
                this.fChildConfig.setProperty("http://apache.org/xml/properties/internal/namespace-context", this.fNamespaceContext);
                this.fChildConfig.setFeature(XINCLUDE_FIXUP_BASE_URIS, this.fFixupBaseURIs);
                this.fChildConfig.setFeature(XINCLUDE_FIXUP_LANGUAGE, this.fFixupLanguage);
                if (xpointer != null) {
                    newHandler = (XPointerHandler)this.fChildConfig.getProperty("http://apache.org/xml/properties/internal/xpointer-handler");
                    this.fXPtrProcessor = newHandler;
                    ((XPointerHandler)this.fXPtrProcessor).setProperty("http://apache.org/xml/properties/internal/namespace-context", this.fNamespaceContext);
                    ((XPointerHandler)this.fXPtrProcessor).setProperty(XINCLUDE_FIXUP_BASE_URIS, this.fFixupBaseURIs ? Boolean.TRUE : Boolean.FALSE);
                    ((XPointerHandler)this.fXPtrProcessor).setProperty(XINCLUDE_FIXUP_LANGUAGE, this.fFixupLanguage ? Boolean.TRUE : Boolean.FALSE);
                    if (this.fErrorReporter != null) {
                        ((XPointerHandler)this.fXPtrProcessor).setProperty(ERROR_REPORTER, this.fErrorReporter);
                    }
                    newHandler.setParent(this);
                    newHandler.setHref(href);
                    newHandler.setXIncludeLocator(this.fXIncludeLocator);
                    ((XPointerHandler)newHandler).setDocumentHandler(this.getDocumentHandler());
                    this.fXPointerChildConfig = this.fChildConfig;
                } else {
                    newHandler = (XIncludeHandler)this.fChildConfig.getProperty("http://apache.org/xml/properties/internal/xinclude-handler");
                    newHandler.setParent(this);
                    newHandler.setHref(href);
                    newHandler.setXIncludeLocator(this.fXIncludeLocator);
                    newHandler.setDocumentHandler(this.getDocumentHandler());
                    this.fXIncludeChildConfig = this.fChildConfig;
                }
            }
            if (xpointer != null) {
                this.fChildConfig = this.fXPointerChildConfig;
                try {
                    this.fXPtrProcessor.parseXPointer(xpointer);
                }
                catch (XNIException ex) {
                    this.reportResourceError("XMLResourceError", new Object[]{href, ex.getMessage()});
                    return false;
                }
            } else {
                this.fChildConfig = this.fXIncludeChildConfig;
            }
            if (this.fNeedCopyFeatures) {
                this.copyFeatures((XMLComponentManager)this.fSettings, this.fChildConfig);
            }
            this.fNeedCopyFeatures = false;
            try {
                this.fHasIncludeReportedContent = false;
                this.fNamespaceContext.pushScope();
                this.fChildConfig.parse(includedSource);
                this.fXIncludeLocator.setLocator(this.fDocLocation);
                if (this.fErrorReporter != null) {
                    this.fErrorReporter.setDocumentLocator(this.fDocLocation);
                }
                if (xpointer == null || this.fXPtrProcessor.isXPointerResolved()) return true;
                Locale locale = this.fErrorReporter != null ? this.fErrorReporter.getLocale() : null;
                String reason = this.fXIncludeMessageFormatter.formatMessage(locale, "XPointerResolutionUnsuccessful", null);
                this.reportResourceError("XMLResourceError", new Object[]{href, reason});
                return false;
            }
            catch (XNIException e) {
                this.fXIncludeLocator.setLocator(this.fDocLocation);
                if (this.fErrorReporter != null) {
                    this.fErrorReporter.setDocumentLocator(this.fDocLocation);
                }
                this.reportFatalError("XMLParseError", new Object[]{href});
                return true;
            }
            catch (IOException e) {
                this.fXIncludeLocator.setLocator(this.fDocLocation);
                if (this.fErrorReporter != null) {
                    this.fErrorReporter.setDocumentLocator(this.fDocLocation);
                }
                if (this.fHasIncludeReportedContent) {
                    throw new XNIException(e);
                }
                this.reportResourceError("XMLResourceError", new Object[]{href, e.getMessage()}, e);
                return false;
            }
            finally {
                this.fNamespaceContext.popScope();
            }
        }
        if (parse.equals(XINCLUDE_PARSE_TEXT)) {
            String encoding = attributes.getValue(XINCLUDE_ATTR_ENCODING);
            includedSource.setEncoding(encoding);
            XIncludeTextReader textReader = null;
            try {
                this.fHasIncludeReportedContent = false;
                if (!this.fIsXML11) {
                    if (this.fXInclude10TextReader == null) {
                        this.fXInclude10TextReader = new XIncludeTextReader(includedSource, this, this.fBufferSize);
                    } else {
                        this.fXInclude10TextReader.setInputSource(includedSource);
                    }
                    textReader = this.fXInclude10TextReader;
                } else {
                    if (this.fXInclude11TextReader == null) {
                        this.fXInclude11TextReader = new XInclude11TextReader(includedSource, this, this.fBufferSize);
                    } else {
                        this.fXInclude11TextReader.setInputSource(includedSource);
                    }
                    textReader = this.fXInclude11TextReader;
                }
                textReader.setErrorReporter(this.fErrorReporter);
                textReader.parse();
            }
            catch (MalformedByteSequenceException ex) {
                this.fErrorReporter.reportError(ex.getDomain(), ex.getKey(), ex.getArguments(), (short)2, ex);
                if (textReader == null) return true;
                try {
                    textReader.close();
                    return true;
                }
                catch (IOException e) {
                    this.reportResourceError("TextResourceError", new Object[]{href, e.getMessage()}, e);
                    return false;
                }
            }
            catch (CharConversionException e) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "CharConversionFailure", null, (short)2, e);
                if (textReader == null) return true;
                try {
                    textReader.close();
                    return true;
                }
                catch (IOException e2) {
                    this.reportResourceError("TextResourceError", new Object[]{href, e2.getMessage()}, e2);
                    return false;
                }
            }
            catch (IOException e) {
                if (this.fHasIncludeReportedContent) {
                    throw new XNIException(e);
                }
                this.reportResourceError("TextResourceError", new Object[]{href, e.getMessage()}, e);
                if (textReader == null) return false;
                {
                    catch (Throwable throwable) {
                        if (textReader == null) throw throwable;
                        try {
                            textReader.close();
                            throw throwable;
                        }
                        catch (IOException e3) {
                            this.reportResourceError("TextResourceError", new Object[]{href, e3.getMessage()}, e3);
                            return false;
                        }
                    }
                }
                try {
                    textReader.close();
                    return false;
                }
                catch (IOException e4) {
                    this.reportResourceError("TextResourceError", new Object[]{href, e4.getMessage()}, e4);
                    return false;
                }
            }
            if (textReader == null) return true;
            try {
                textReader.close();
                return true;
            }
            catch (IOException e) {
                this.reportResourceError("TextResourceError", new Object[]{href, e.getMessage()}, e);
                return false;
            }
        }
        this.reportFatalError("InvalidParseValue", new Object[]{parse});
        return true;
    }

    protected boolean hasXIncludeNamespace(QName element) {
        return element.uri == XINCLUDE_NS_URI || this.fNamespaceContext.getURI(element.prefix) == XINCLUDE_NS_URI;
    }

    protected boolean isIncludeElement(QName element) {
        return element.localpart.equals(XINCLUDE_INCLUDE) && this.hasXIncludeNamespace(element);
    }

    protected boolean isFallbackElement(QName element) {
        return element.localpart.equals(XINCLUDE_FALLBACK) && this.hasXIncludeNamespace(element);
    }

    protected boolean sameBaseURIAsIncludeParent() {
        String parentBaseURI = this.getIncludeParentBaseURI();
        String baseURI = this.fCurrentBaseURI.getExpandedSystemId();
        return parentBaseURI != null && parentBaseURI.equals(baseURI);
    }

    protected boolean sameLanguageAsIncludeParent() {
        String parentLanguage = this.getIncludeParentLanguage();
        return parentLanguage != null && parentLanguage.equalsIgnoreCase(this.fCurrentLanguage);
    }

    protected void setupCurrentBaseURI(XMLLocator locator) {
        this.fCurrentBaseURI.setBaseSystemId(locator.getBaseSystemId());
        if (locator.getLiteralSystemId() != null) {
            this.fCurrentBaseURI.setLiteralSystemId(locator.getLiteralSystemId());
        } else {
            this.fCurrentBaseURI.setLiteralSystemId(this.fHrefFromParent);
        }
        String expandedSystemId = locator.getExpandedSystemId();
        if (expandedSystemId == null) {
            try {
                expandedSystemId = XMLEntityManager.expandSystemId(this.fCurrentBaseURI.getLiteralSystemId(), this.fCurrentBaseURI.getBaseSystemId(), false);
                if (expandedSystemId == null) {
                    expandedSystemId = this.fCurrentBaseURI.getLiteralSystemId();
                }
            }
            catch (URI.MalformedURIException e) {
                this.reportFatalError("ExpandedSystemId");
            }
        }
        this.fCurrentBaseURI.setExpandedSystemId(expandedSystemId);
    }

    protected boolean searchForRecursiveIncludes(String includedSysId) {
        if (includedSysId.equals(this.fCurrentBaseURI.getExpandedSystemId())) {
            return true;
        }
        if (this.fParentXIncludeHandler == null) {
            return false;
        }
        return this.fParentXIncludeHandler.searchForRecursiveIncludes(includedSysId);
    }

    protected boolean isTopLevelIncludedItem() {
        return this.isTopLevelIncludedItemViaInclude() || this.isTopLevelIncludedItemViaFallback();
    }

    protected boolean isTopLevelIncludedItemViaInclude() {
        return this.fDepth == 1 && !this.isRootDocument();
    }

    protected boolean isTopLevelIncludedItemViaFallback() {
        return this.getSawFallback(this.fDepth - 1);
    }

    protected XMLAttributes processAttributes(XMLAttributes attributes) {
        if (this.isTopLevelIncludedItem()) {
            if (this.fFixupBaseURIs && !this.sameBaseURIAsIncludeParent()) {
                if (attributes == null) {
                    attributes = new XMLAttributesImpl();
                }
                String uri = null;
                try {
                    uri = this.getRelativeBaseURI();
                }
                catch (URI.MalformedURIException e) {
                    uri = this.fCurrentBaseURI.getExpandedSystemId();
                }
                int index = attributes.addAttribute(XML_BASE_QNAME, XMLSymbols.fCDATASymbol, uri);
                attributes.setSpecified(index, true);
            }
            if (this.fFixupLanguage && !this.sameLanguageAsIncludeParent()) {
                if (attributes == null) {
                    attributes = new XMLAttributesImpl();
                }
                int index = attributes.addAttribute(XML_LANG_QNAME, XMLSymbols.fCDATASymbol, this.fCurrentLanguage);
                attributes.setSpecified(index, true);
            }
            Enumeration inscopeNS = this.fNamespaceContext.getAllPrefixes();
            while (inscopeNS.hasMoreElements()) {
                int index;
                QName ns;
                String uri;
                String prefix = (String)inscopeNS.nextElement();
                String parentURI = this.fNamespaceContext.getURIFromIncludeParent(prefix);
                if (parentURI == (uri = this.fNamespaceContext.getURI(prefix)) || attributes == null) continue;
                if (prefix == XMLSymbols.EMPTY_STRING) {
                    if (attributes.getValue(NamespaceContext.XMLNS_URI, XMLSymbols.PREFIX_XMLNS) != null) continue;
                    if (attributes == null) {
                        attributes = new XMLAttributesImpl();
                    }
                    ns = (QName)NEW_NS_ATTR_QNAME.clone();
                    ns.prefix = null;
                    ns.localpart = XMLSymbols.PREFIX_XMLNS;
                    ns.rawname = XMLSymbols.PREFIX_XMLNS;
                    index = attributes.addAttribute(ns, XMLSymbols.fCDATASymbol, uri != null ? uri : XMLSymbols.EMPTY_STRING);
                    attributes.setSpecified(index, true);
                    this.fNamespaceContext.declarePrefix(prefix, uri);
                    continue;
                }
                if (attributes.getValue(NamespaceContext.XMLNS_URI, prefix) != null) continue;
                if (attributes == null) {
                    attributes = new XMLAttributesImpl();
                }
                ns = (QName)NEW_NS_ATTR_QNAME.clone();
                ns.localpart = prefix;
                ns.rawname = String.valueOf(ns.rawname) + prefix;
                ns.rawname = this.fSymbolTable != null ? this.fSymbolTable.addSymbol(ns.rawname) : ns.rawname.intern();
                index = attributes.addAttribute(ns, XMLSymbols.fCDATASymbol, uri != null ? uri : XMLSymbols.EMPTY_STRING);
                attributes.setSpecified(index, true);
                this.fNamespaceContext.declarePrefix(prefix, uri);
            }
        }
        if (attributes != null) {
            int length = attributes.getLength();
            int i = 0;
            while (i < length) {
                String type = attributes.getType(i);
                String value = attributes.getValue(i);
                if (type == XMLSymbols.fENTITYSymbol) {
                    this.checkUnparsedEntity(value);
                }
                if (type == XMLSymbols.fENTITIESSymbol) {
                    StringTokenizer st = new StringTokenizer(value);
                    while (st.hasMoreTokens()) {
                        String entName = st.nextToken();
                        this.checkUnparsedEntity(entName);
                    }
                } else if (type == XMLSymbols.fNOTATIONSymbol) {
                    this.checkNotation(value);
                }
                ++i;
            }
        }
        return attributes;
    }

    protected String getRelativeBaseURI() throws URI.MalformedURIException {
        int includeParentDepth = this.getIncludeParentDepth();
        String relativeURI = this.getRelativeURI(includeParentDepth);
        if (this.isRootDocument()) {
            return relativeURI;
        }
        if (relativeURI.length() == 0) {
            relativeURI = this.fCurrentBaseURI.getLiteralSystemId();
        }
        if (includeParentDepth == 0) {
            String literalAuthority;
            String literalScheme;
            if (this.fParentRelativeURI == null) {
                this.fParentRelativeURI = this.fParentXIncludeHandler.getRelativeBaseURI();
            }
            if (this.fParentRelativeURI.length() == 0) {
                return relativeURI;
            }
            URI base = new URI(this.fParentRelativeURI, true);
            URI uri = new URI(base, relativeURI);
            String baseScheme = base.getScheme();
            if (!this.isEqual(baseScheme, literalScheme = uri.getScheme())) {
                return relativeURI;
            }
            String baseAuthority = base.getAuthority();
            if (!this.isEqual(baseAuthority, literalAuthority = uri.getAuthority())) {
                return uri.getSchemeSpecificPart();
            }
            String literalPath = uri.getPath();
            String literalQuery = uri.getQueryString();
            String literalFragment = uri.getFragment();
            if (literalQuery != null || literalFragment != null) {
                StringBuffer buffer = new StringBuffer();
                if (literalPath != null) {
                    buffer.append(literalPath);
                }
                if (literalQuery != null) {
                    buffer.append('?');
                    buffer.append(literalQuery);
                }
                if (literalFragment != null) {
                    buffer.append('#');
                    buffer.append(literalFragment);
                }
                return buffer.toString();
            }
            return literalPath;
        }
        return relativeURI;
    }

    private String getIncludeParentBaseURI() {
        int depth = this.getIncludeParentDepth();
        if (!this.isRootDocument() && depth == 0) {
            return this.fParentXIncludeHandler.getIncludeParentBaseURI();
        }
        return this.getBaseURI(depth);
    }

    private String getIncludeParentLanguage() {
        int depth = this.getIncludeParentDepth();
        if (!this.isRootDocument() && depth == 0) {
            return this.fParentXIncludeHandler.getIncludeParentLanguage();
        }
        return this.getLanguage(depth);
    }

    private int getIncludeParentDepth() {
        int i = this.fDepth - 1;
        while (i >= 0) {
            if (!this.getSawInclude(i) && !this.getSawFallback(i)) {
                return i;
            }
            --i;
        }
        return 0;
    }

    private int getResultDepth() {
        return this.fResultDepth;
    }

    protected Augmentations modifyAugmentations(Augmentations augs) {
        return this.modifyAugmentations(augs, false);
    }

    protected Augmentations modifyAugmentations(Augmentations augs, boolean force) {
        if (force || this.isTopLevelIncludedItem()) {
            if (augs == null) {
                augs = new AugmentationsImpl();
            }
            augs.putItem(XINCLUDE_INCLUDED, Boolean.TRUE);
        }
        return augs;
    }

    protected int getState(int depth) {
        return this.fState[depth];
    }

    protected int getState() {
        return this.fState[this.fDepth];
    }

    protected void setState(int state) {
        if (this.fDepth >= this.fState.length) {
            int[] newarray = new int[this.fDepth * 2];
            System.arraycopy(this.fState, 0, newarray, 0, this.fState.length);
            this.fState = newarray;
        }
        this.fState[this.fDepth] = state;
    }

    protected void setSawFallback(int depth, boolean val) {
        if (depth >= this.fSawFallback.length) {
            boolean[] newarray = new boolean[depth * 2];
            System.arraycopy(this.fSawFallback, 0, newarray, 0, this.fSawFallback.length);
            this.fSawFallback = newarray;
        }
        this.fSawFallback[depth] = val;
    }

    protected boolean getSawFallback(int depth) {
        if (depth >= this.fSawFallback.length) {
            return false;
        }
        return this.fSawFallback[depth];
    }

    protected void setSawInclude(int depth, boolean val) {
        if (depth >= this.fSawInclude.length) {
            boolean[] newarray = new boolean[depth * 2];
            System.arraycopy(this.fSawInclude, 0, newarray, 0, this.fSawInclude.length);
            this.fSawInclude = newarray;
        }
        this.fSawInclude[depth] = val;
    }

    protected boolean getSawInclude(int depth) {
        if (depth >= this.fSawInclude.length) {
            return false;
        }
        return this.fSawInclude[depth];
    }

    protected void reportResourceError(String key) {
        this.reportResourceError(key, null);
    }

    protected void reportResourceError(String key, Object[] args) {
        this.reportResourceError(key, args, null);
    }

    protected void reportResourceError(String key, Object[] args, Exception exception) {
        this.reportError(key, args, (short)0, exception);
    }

    protected void reportFatalError(String key) {
        this.reportFatalError(key, null);
    }

    protected void reportFatalError(String key, Object[] args) {
        this.reportFatalError(key, args, null);
    }

    protected void reportFatalError(String key, Object[] args, Exception exception) {
        this.reportError(key, args, (short)2, exception);
    }

    private void reportError(String key, Object[] args, short severity, Exception exception) {
        if (this.fErrorReporter != null) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/xinclude", key, args, severity, exception);
        }
    }

    protected void setParent(XIncludeHandler parent) {
        this.fParentXIncludeHandler = parent;
    }

    protected void setHref(String href) {
        this.fHrefFromParent = href;
    }

    protected void setXIncludeLocator(XMLLocatorWrapper locator) {
        this.fXIncludeLocator = locator;
    }

    protected boolean isRootDocument() {
        return this.fParentXIncludeHandler == null;
    }

    protected void addUnparsedEntity(String name, XMLResourceIdentifier identifier, String notation, Augmentations augmentations) {
        UnparsedEntity ent = new UnparsedEntity();
        ent.name = name;
        ent.systemId = identifier.getLiteralSystemId();
        ent.publicId = identifier.getPublicId();
        ent.baseURI = identifier.getBaseSystemId();
        ent.expandedSystemId = identifier.getExpandedSystemId();
        ent.notation = notation;
        ent.augmentations = augmentations;
        this.fUnparsedEntities.add(ent);
    }

    protected void addNotation(String name, XMLResourceIdentifier identifier, Augmentations augmentations) {
        Notation not = new Notation();
        not.name = name;
        not.systemId = identifier.getLiteralSystemId();
        not.publicId = identifier.getPublicId();
        not.baseURI = identifier.getBaseSystemId();
        not.expandedSystemId = identifier.getExpandedSystemId();
        not.augmentations = augmentations;
        this.fNotations.add(not);
    }

    protected void checkUnparsedEntity(String entName) {
        UnparsedEntity ent = new UnparsedEntity();
        ent.name = entName;
        int index = this.fUnparsedEntities.indexOf(ent);
        if (index != -1) {
            ent = (UnparsedEntity)this.fUnparsedEntities.get(index);
            this.checkNotation(ent.notation);
            this.checkAndSendUnparsedEntity(ent);
        }
    }

    protected void checkNotation(String notName) {
        Notation not = new Notation();
        not.name = notName;
        int index = this.fNotations.indexOf(not);
        if (index != -1) {
            not = (Notation)this.fNotations.get(index);
            this.checkAndSendNotation(not);
        }
    }

    protected void checkAndSendUnparsedEntity(UnparsedEntity ent) {
        if (this.isRootDocument()) {
            int index = this.fUnparsedEntities.indexOf(ent);
            if (index == -1) {
                XMLResourceIdentifierImpl id = new XMLResourceIdentifierImpl(ent.publicId, ent.systemId, ent.baseURI, ent.expandedSystemId);
                this.addUnparsedEntity(ent.name, id, ent.notation, ent.augmentations);
                if (this.fSendUEAndNotationEvents && this.fDTDHandler != null) {
                    this.fDTDHandler.unparsedEntityDecl(ent.name, id, ent.notation, ent.augmentations);
                }
            } else {
                UnparsedEntity localEntity = (UnparsedEntity)this.fUnparsedEntities.get(index);
                if (!ent.isDuplicate(localEntity)) {
                    this.reportFatalError("NonDuplicateUnparsedEntity", new Object[]{ent.name});
                }
            }
        } else {
            this.fParentXIncludeHandler.checkAndSendUnparsedEntity(ent);
        }
    }

    protected void checkAndSendNotation(Notation not) {
        if (this.isRootDocument()) {
            int index = this.fNotations.indexOf(not);
            if (index == -1) {
                XMLResourceIdentifierImpl id = new XMLResourceIdentifierImpl(not.publicId, not.systemId, not.baseURI, not.expandedSystemId);
                this.addNotation(not.name, id, not.augmentations);
                if (this.fSendUEAndNotationEvents && this.fDTDHandler != null) {
                    this.fDTDHandler.notationDecl(not.name, id, not.augmentations);
                }
            } else {
                Notation localNotation = (Notation)this.fNotations.get(index);
                if (!not.isDuplicate(localNotation)) {
                    this.reportFatalError("NonDuplicateNotation", new Object[]{not.name});
                }
            }
        } else {
            this.fParentXIncludeHandler.checkAndSendNotation(not);
        }
    }

    private void checkWhitespace(XMLString value) {
        int end = value.offset + value.length;
        int i = value.offset;
        while (i < end) {
            if (!XMLChar.isSpace(value.ch[i])) {
                this.reportFatalError("ContentIllegalAtTopLevel");
                return;
            }
            ++i;
        }
    }

    private void checkMultipleRootElements() {
        if (this.getRootElementProcessed()) {
            this.reportFatalError("MultipleRootElements");
        }
        this.setRootElementProcessed(true);
    }

    private void setRootElementProcessed(boolean seenRoot) {
        if (this.isRootDocument()) {
            this.fSeenRootElement = seenRoot;
            return;
        }
        this.fParentXIncludeHandler.setRootElementProcessed(seenRoot);
    }

    private boolean getRootElementProcessed() {
        return this.isRootDocument() ? this.fSeenRootElement : this.fParentXIncludeHandler.getRootElementProcessed();
    }

    protected void copyFeatures(XMLComponentManager from, ParserConfigurationSettings to) {
        Enumeration features = Constants.getXercesFeatures();
        this.copyFeatures1(features, "http://apache.org/xml/features/", from, to);
        features = Constants.getSAXFeatures();
        this.copyFeatures1(features, "http://xml.org/sax/features/", from, to);
    }

    protected void copyFeatures(XMLComponentManager from, XMLParserConfiguration to) {
        Enumeration features = Constants.getXercesFeatures();
        this.copyFeatures1(features, "http://apache.org/xml/features/", from, to);
        features = Constants.getSAXFeatures();
        this.copyFeatures1(features, "http://xml.org/sax/features/", from, to);
    }

    private void copyFeatures1(Enumeration features, String featurePrefix, XMLComponentManager from, ParserConfigurationSettings to) {
        while (features.hasMoreElements()) {
            String featureId = String.valueOf(featurePrefix) + (String)features.nextElement();
            to.addRecognizedFeatures(new String[]{featureId});
            try {
                to.setFeature(featureId, from.getFeature(featureId));
            }
            catch (XMLConfigurationException xMLConfigurationException) {
                // empty catch block
            }
        }
    }

    private void copyFeatures1(Enumeration features, String featurePrefix, XMLComponentManager from, XMLParserConfiguration to) {
        while (features.hasMoreElements()) {
            String featureId = String.valueOf(featurePrefix) + (String)features.nextElement();
            boolean value = from.getFeature(featureId);
            try {
                to.setFeature(featureId, value);
            }
            catch (XMLConfigurationException xMLConfigurationException) {
                // empty catch block
            }
        }
    }

    protected void saveBaseURI() {
        this.fBaseURIScope.push(this.fDepth);
        this.fBaseURI.push(this.fCurrentBaseURI.getBaseSystemId());
        this.fLiteralSystemID.push(this.fCurrentBaseURI.getLiteralSystemId());
        this.fExpandedSystemID.push(this.fCurrentBaseURI.getExpandedSystemId());
    }

    protected void restoreBaseURI() {
        this.fBaseURI.pop();
        this.fLiteralSystemID.pop();
        this.fExpandedSystemID.pop();
        this.fBaseURIScope.pop();
        this.fCurrentBaseURI.setBaseSystemId((String)this.fBaseURI.peek());
        this.fCurrentBaseURI.setLiteralSystemId((String)this.fLiteralSystemID.peek());
        this.fCurrentBaseURI.setExpandedSystemId((String)this.fExpandedSystemID.peek());
    }

    protected void saveLanguage(String language) {
        this.fLanguageScope.push(this.fDepth);
        this.fLanguageStack.push(language);
    }

    public String restoreLanguage() {
        this.fLanguageStack.pop();
        this.fLanguageScope.pop();
        return (String)this.fLanguageStack.peek();
    }

    public String getBaseURI(int depth) {
        int scope = this.scopeOfBaseURI(depth);
        return (String)this.fExpandedSystemID.elementAt(scope);
    }

    public String getLanguage(int depth) {
        int scope = this.scopeOfLanguage(depth);
        return (String)this.fLanguageStack.elementAt(scope);
    }

    public String getRelativeURI(int depth) throws URI.MalformedURIException {
        int start = this.scopeOfBaseURI(depth) + 1;
        if (start == this.fBaseURIScope.size()) {
            return "";
        }
        URI uri = new URI("file", (String)this.fLiteralSystemID.elementAt(start));
        int i = start + 1;
        while (i < this.fBaseURIScope.size()) {
            uri = new URI(uri, (String)this.fLiteralSystemID.elementAt(i));
            ++i;
        }
        return uri.getPath();
    }

    private int scopeOfBaseURI(int depth) {
        int i = this.fBaseURIScope.size() - 1;
        while (i >= 0) {
            if (this.fBaseURIScope.elementAt(i) <= depth) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private int scopeOfLanguage(int depth) {
        int i = this.fLanguageScope.size() - 1;
        while (i >= 0) {
            if (this.fLanguageScope.elementAt(i) <= depth) {
                return i;
            }
            --i;
        }
        return -1;
    }

    protected void processXMLBaseAttributes(XMLAttributes attributes) {
        String baseURIValue = attributes.getValue(NamespaceContext.XML_URI, "base");
        if (baseURIValue != null) {
            try {
                String expandedValue = XMLEntityManager.expandSystemId(baseURIValue, this.fCurrentBaseURI.getExpandedSystemId(), false);
                this.fCurrentBaseURI.setLiteralSystemId(baseURIValue);
                this.fCurrentBaseURI.setBaseSystemId(this.fCurrentBaseURI.getExpandedSystemId());
                this.fCurrentBaseURI.setExpandedSystemId(expandedValue);
                this.saveBaseURI();
            }
            catch (URI.MalformedURIException malformedURIException) {
                // empty catch block
            }
        }
    }

    protected void processXMLLangAttributes(XMLAttributes attributes) {
        String language = attributes.getValue(NamespaceContext.XML_URI, "lang");
        if (language != null) {
            this.fCurrentLanguage = language;
            this.saveLanguage(this.fCurrentLanguage);
        }
    }

    private boolean isValidInHTTPHeader(String value) {
        int i = value.length() - 1;
        while (i >= 0) {
            char ch = value.charAt(i);
            if (ch < ' ' || ch > '~') {
                return false;
            }
            --i;
        }
        return true;
    }

    private XMLInputSource createInputSource(String publicId, String systemId, String baseSystemId, String accept, String acceptLanguage) {
        HTTPInputSource httpSource = new HTTPInputSource(publicId, systemId, baseSystemId);
        if (accept != null && accept.length() > 0) {
            httpSource.setHTTPRequestProperty(HTTP_ACCEPT, accept);
        }
        if (acceptLanguage != null && acceptLanguage.length() > 0) {
            httpSource.setHTTPRequestProperty(HTTP_ACCEPT_LANGUAGE, acceptLanguage);
        }
        return httpSource;
    }

    private boolean isEqual(String one, String two) {
        return one == two || one != null && one.equals(two);
    }

    private String escapeHref(String href) {
        int ch;
        int len = href.length();
        StringBuffer buffer = new StringBuffer(len * 3);
        int i = 0;
        while (i < len) {
            ch = href.charAt(i);
            if (ch > 126) break;
            if (ch < 32) {
                return href;
            }
            if (gNeedEscaping[ch]) {
                buffer.append('%');
                buffer.append(gAfterEscaping1[ch]);
                buffer.append(gAfterEscaping2[ch]);
            } else {
                buffer.append((char)ch);
            }
            ++i;
        }
        if (i < len) {
            int j = i;
            while (j < len) {
                int ch2;
                ch = href.charAt(j);
                if (!(ch >= 32 && ch <= 126 || ch >= 160 && ch <= 55295 || ch >= 63744 && ch <= 64975 || ch >= 65008 && ch <= 65519 || XMLChar.isHighSurrogate(ch) && ++j < len && XMLChar.isLowSurrogate(ch2 = href.charAt(j)) && (ch2 = XMLChar.supplemental((char)ch, (char)ch2)) < 983040 && (ch2 & 0xFFFF) <= 65533)) {
                    return href;
                }
                ++j;
            }
            byte[] bytes = null;
            try {
                bytes = href.substring(i).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return href;
            }
            len = bytes.length;
            i = 0;
            while (i < len) {
                byte b = bytes[i];
                if (b < 0) {
                    ch = b + 256;
                    buffer.append('%');
                    buffer.append(gHexChs[ch >> 4]);
                    buffer.append(gHexChs[ch & 0xF]);
                } else if (gNeedEscaping[b]) {
                    buffer.append('%');
                    buffer.append(gAfterEscaping1[b]);
                    buffer.append(gAfterEscaping2[b]);
                } else {
                    buffer.append((char)b);
                }
                ++i;
            }
        }
        if (buffer.length() != len) {
            return buffer.toString();
        }
        return href;
    }

    protected static class Notation {
        public String name;
        public String systemId;
        public String baseURI;
        public String publicId;
        public String expandedSystemId;
        public Augmentations augmentations;

        protected Notation() {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof Notation) {
                Notation other = (Notation)obj;
                return this.name.equals(other.name);
            }
            return false;
        }

        public boolean isDuplicate(Object obj) {
            if (obj != null && obj instanceof Notation) {
                Notation other = (Notation)obj;
                return this.name.equals(other.name) && this.isEqual(this.publicId, other.publicId) && this.isEqual(this.expandedSystemId, other.expandedSystemId);
            }
            return false;
        }

        private boolean isEqual(String one, String two) {
            return one == two || one != null && one.equals(two);
        }
    }

    protected static class UnparsedEntity {
        public String name;
        public String systemId;
        public String baseURI;
        public String publicId;
        public String expandedSystemId;
        public String notation;
        public Augmentations augmentations;

        protected UnparsedEntity() {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof UnparsedEntity) {
                UnparsedEntity other = (UnparsedEntity)obj;
                return this.name.equals(other.name);
            }
            return false;
        }

        public boolean isDuplicate(Object obj) {
            if (obj != null && obj instanceof UnparsedEntity) {
                UnparsedEntity other = (UnparsedEntity)obj;
                return this.name.equals(other.name) && this.isEqual(this.publicId, other.publicId) && this.isEqual(this.expandedSystemId, other.expandedSystemId) && this.isEqual(this.notation, other.notation);
            }
            return false;
        }

        private boolean isEqual(String one, String two) {
            return one == two || one != null && one.equals(two);
        }
    }
}

