/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.parsers;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Stack;
import java.util.StringTokenizer;
import mf.org.apache.xerces.dom.DOMErrorImpl;
import mf.org.apache.xerces.dom.DOMMessageFormatter;
import mf.org.apache.xerces.dom.DOMStringListImpl;
import mf.org.apache.xerces.impl.Constants;
import mf.org.apache.xerces.parsers.AbstractDOMParser;
import mf.org.apache.xerces.parsers.ObjectFactory;
import mf.org.apache.xerces.util.DOMEntityResolverWrapper;
import mf.org.apache.xerces.util.DOMErrorHandlerWrapper;
import mf.org.apache.xerces.util.DOMUtil;
import mf.org.apache.xerces.util.SymbolTable;
import mf.org.apache.xerces.util.XMLSymbols;
import mf.org.apache.xerces.xni.Augmentations;
import mf.org.apache.xerces.xni.NamespaceContext;
import mf.org.apache.xerces.xni.QName;
import mf.org.apache.xerces.xni.XMLAttributes;
import mf.org.apache.xerces.xni.XMLDTDContentModelHandler;
import mf.org.apache.xerces.xni.XMLDTDHandler;
import mf.org.apache.xerces.xni.XMLDocumentHandler;
import mf.org.apache.xerces.xni.XMLLocator;
import mf.org.apache.xerces.xni.XMLResourceIdentifier;
import mf.org.apache.xerces.xni.XMLString;
import mf.org.apache.xerces.xni.XNIException;
import mf.org.apache.xerces.xni.grammars.XMLGrammarPool;
import mf.org.apache.xerces.xni.parser.XMLConfigurationException;
import mf.org.apache.xerces.xni.parser.XMLDTDContentModelSource;
import mf.org.apache.xerces.xni.parser.XMLDTDSource;
import mf.org.apache.xerces.xni.parser.XMLDocumentSource;
import mf.org.apache.xerces.xni.parser.XMLEntityResolver;
import mf.org.apache.xerces.xni.parser.XMLInputSource;
import mf.org.apache.xerces.xni.parser.XMLParseException;
import mf.org.apache.xerces.xni.parser.XMLParserConfiguration;
import mf.org.w3c.dom.DOMConfiguration;
import mf.org.w3c.dom.DOMErrorHandler;
import mf.org.w3c.dom.DOMException;
import mf.org.w3c.dom.DOMStringList;
import mf.org.w3c.dom.Document;
import mf.org.w3c.dom.Element;
import mf.org.w3c.dom.Node;
import mf.org.w3c.dom.ls.LSException;
import mf.org.w3c.dom.ls.LSInput;
import mf.org.w3c.dom.ls.LSParser;
import mf.org.w3c.dom.ls.LSParserFilter;
import mf.org.w3c.dom.ls.LSResourceResolver;

public class DOMParserImpl
extends AbstractDOMParser
implements LSParser,
DOMConfiguration {
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    protected static final String XMLSCHEMA = "http://apache.org/xml/features/validation/schema";
    protected static final String XMLSCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    protected static final String NORMALIZE_DATA = "http://apache.org/xml/features/validation/schema/normalized-value";
    protected static final String DISALLOW_DOCTYPE_DECL_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
    protected static final String HONOUR_ALL_SCHEMALOCATIONS = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String NAMESPACE_GROWTH = "http://apache.org/xml/features/namespace-growth";
    protected static final String TOLERATE_DUPLICATES = "http://apache.org/xml/features/internal/tolerate-duplicates";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String PSVI_AUGMENT = "http://apache.org/xml/features/validation/schema/augment-psvi";
    protected boolean fNamespaceDeclarations = true;
    protected String fSchemaType = null;
    protected boolean fBusy = false;
    private boolean abortNow = false;
    private Thread currentThread;
    protected static final boolean DEBUG = false;
    private String fSchemaLocation = null;
    private DOMStringList fRecognizedParameters;
    private boolean fNullFilterInUse = false;
    private AbortHandler abortHandler = null;

    public DOMParserImpl(String configuration, String schemaType) {
        this((XMLParserConfiguration)ObjectFactory.createObject("mf.org.apache.xerces.xni.parser.XMLParserConfiguration", configuration));
        if (schemaType != null) {
            if (schemaType.equals(Constants.NS_DTD)) {
                this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_DTD);
                this.fSchemaType = Constants.NS_DTD;
            } else if (schemaType.equals(Constants.NS_XMLSCHEMA)) {
                this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_XMLSCHEMA);
            }
        }
    }

    public DOMParserImpl(XMLParserConfiguration config) {
        super(config);
        String[] domRecognizedFeatures = new String[]{"canonical-form", "cdata-sections", "charset-overrides-xml-encoding", "infoset", "namespace-declarations", "split-cdata-sections", "supported-media-types-only", "certified", "well-formed", "ignore-unknown-character-denormalizations"};
        this.fConfiguration.addRecognizedFeatures(domRecognizedFeatures);
        this.fConfiguration.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        this.fConfiguration.setFeature("namespace-declarations", true);
        this.fConfiguration.setFeature("well-formed", true);
        this.fConfiguration.setFeature("http://apache.org/xml/features/include-comments", true);
        this.fConfiguration.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", true);
        this.fConfiguration.setFeature(NAMESPACES, true);
        this.fConfiguration.setFeature(DYNAMIC_VALIDATION, false);
        this.fConfiguration.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", false);
        this.fConfiguration.setFeature("http://apache.org/xml/features/create-cdata-nodes", false);
        this.fConfiguration.setFeature("canonical-form", false);
        this.fConfiguration.setFeature("charset-overrides-xml-encoding", true);
        this.fConfiguration.setFeature("split-cdata-sections", true);
        this.fConfiguration.setFeature("supported-media-types-only", false);
        this.fConfiguration.setFeature("ignore-unknown-character-denormalizations", true);
        this.fConfiguration.setFeature("certified", true);
        try {
            this.fConfiguration.setFeature(NORMALIZE_DATA, false);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    public DOMParserImpl(SymbolTable symbolTable) {
        this((XMLParserConfiguration)ObjectFactory.createObject("mf.org.apache.xerces.xni.parser.XMLParserConfiguration", "mf.org.apache.xerces.parsers.XIncludeAwareParserConfiguration"));
        this.fConfiguration.setProperty(SYMBOL_TABLE, symbolTable);
    }

    public DOMParserImpl(SymbolTable symbolTable, XMLGrammarPool grammarPool) {
        this((XMLParserConfiguration)ObjectFactory.createObject("mf.org.apache.xerces.xni.parser.XMLParserConfiguration", "mf.org.apache.xerces.parsers.XIncludeAwareParserConfiguration"));
        this.fConfiguration.setProperty(SYMBOL_TABLE, symbolTable);
        this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/grammar-pool", grammarPool);
    }

    @Override
    public void reset() {
        super.reset();
        this.fNamespaceDeclarations = this.fConfiguration.getFeature("namespace-declarations");
        if (this.fNullFilterInUse) {
            this.fDOMFilter = null;
            this.fNullFilterInUse = false;
        }
        if (this.fSkippedElemStack != null) {
            this.fSkippedElemStack.removeAllElements();
        }
        this.fRejectedElementDepth = 0;
        this.fFilterReject = false;
        this.fSchemaType = null;
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return this;
    }

    @Override
    public LSParserFilter getFilter() {
        return !this.fNullFilterInUse ? this.fDOMFilter : null;
    }

    @Override
    public void setFilter(LSParserFilter filter) {
        if (this.fBusy && filter == null && this.fDOMFilter != null) {
            this.fNullFilterInUse = true;
            this.fDOMFilter = NullLSParserFilter.INSTANCE;
        } else {
            this.fDOMFilter = filter;
        }
        if (this.fSkippedElemStack == null) {
            this.fSkippedElemStack = new Stack();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setParameter(String name, Object value) throws DOMException {
        if (value instanceof Boolean) {
            boolean state = (Boolean)value;
            try {
                if (name.equalsIgnoreCase("comments")) {
                    this.fConfiguration.setFeature("http://apache.org/xml/features/include-comments", state);
                    return;
                }
                if (name.equalsIgnoreCase("datatype-normalization")) {
                    this.fConfiguration.setFeature(NORMALIZE_DATA, state);
                    return;
                }
                if (name.equalsIgnoreCase("entities")) {
                    this.fConfiguration.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", state);
                    return;
                }
                if (name.equalsIgnoreCase("disallow-doctype")) {
                    this.fConfiguration.setFeature(DISALLOW_DOCTYPE_DECL_FEATURE, state);
                    return;
                }
                if (name.equalsIgnoreCase("supported-media-types-only") || name.equalsIgnoreCase("normalize-characters") || name.equalsIgnoreCase("check-character-normalization") || name.equalsIgnoreCase("canonical-form")) {
                    if (!state) return;
                    throw DOMParserImpl.newFeatureNotSupportedError(name);
                }
                if (name.equalsIgnoreCase("namespaces")) {
                    this.fConfiguration.setFeature(NAMESPACES, state);
                    return;
                }
                if (name.equalsIgnoreCase("infoset")) {
                    if (!state) return;
                    this.fConfiguration.setFeature(NAMESPACES, true);
                    this.fConfiguration.setFeature("namespace-declarations", true);
                    this.fConfiguration.setFeature("http://apache.org/xml/features/include-comments", true);
                    this.fConfiguration.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", true);
                    this.fConfiguration.setFeature(DYNAMIC_VALIDATION, false);
                    this.fConfiguration.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", false);
                    this.fConfiguration.setFeature(NORMALIZE_DATA, false);
                    this.fConfiguration.setFeature("http://apache.org/xml/features/create-cdata-nodes", false);
                    return;
                }
                if (name.equalsIgnoreCase("cdata-sections")) {
                    this.fConfiguration.setFeature("http://apache.org/xml/features/create-cdata-nodes", state);
                    return;
                }
                if (name.equalsIgnoreCase("namespace-declarations")) {
                    this.fConfiguration.setFeature("namespace-declarations", state);
                    return;
                }
                if (name.equalsIgnoreCase("well-formed") || name.equalsIgnoreCase("ignore-unknown-character-denormalizations")) {
                    if (state) return;
                    throw DOMParserImpl.newFeatureNotSupportedError(name);
                }
                if (name.equalsIgnoreCase("validate")) {
                    this.fConfiguration.setFeature(VALIDATION_FEATURE, state);
                    if (this.fSchemaType != Constants.NS_DTD) {
                        this.fConfiguration.setFeature(XMLSCHEMA, state);
                        this.fConfiguration.setFeature(XMLSCHEMA_FULL_CHECKING, state);
                    }
                    if (!state) return;
                    this.fConfiguration.setFeature(DYNAMIC_VALIDATION, false);
                    return;
                }
                if (name.equalsIgnoreCase("validate-if-schema")) {
                    this.fConfiguration.setFeature(DYNAMIC_VALIDATION, state);
                    if (!state) return;
                    this.fConfiguration.setFeature(VALIDATION_FEATURE, false);
                    return;
                }
                if (name.equalsIgnoreCase("element-content-whitespace")) {
                    this.fConfiguration.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", state);
                    return;
                }
                if (name.equalsIgnoreCase("psvi")) {
                    this.fConfiguration.setFeature(PSVI_AUGMENT, true);
                    this.fConfiguration.setProperty("http://apache.org/xml/properties/dom/document-class-name", "mf.org.apache.xerces.dom.PSVIDocumentImpl");
                    return;
                }
                String normalizedName = name.equalsIgnoreCase(HONOUR_ALL_SCHEMALOCATIONS) ? HONOUR_ALL_SCHEMALOCATIONS : (name.equals(NAMESPACE_GROWTH) ? NAMESPACE_GROWTH : (name.equals(TOLERATE_DUPLICATES) ? TOLERATE_DUPLICATES : name.toLowerCase(Locale.ENGLISH)));
                this.fConfiguration.setFeature(normalizedName, state);
                return;
            }
            catch (XMLConfigurationException e) {
                throw DOMParserImpl.newFeatureNotFoundError(name);
            }
        }
        if (name.equalsIgnoreCase("error-handler")) {
            if (!(value instanceof DOMErrorHandler) && value != null) throw DOMParserImpl.newTypeMismatchError(name);
            try {
                this.fErrorHandler = new DOMErrorHandlerWrapper((DOMErrorHandler)value);
                this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/error-handler", this.fErrorHandler);
                return;
            }
            catch (XMLConfigurationException state) {}
            return;
        }
        if (name.equalsIgnoreCase("resource-resolver")) {
            if (!(value instanceof LSResourceResolver) && value != null) throw DOMParserImpl.newTypeMismatchError(name);
            try {
                this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", new DOMEntityResolverWrapper((LSResourceResolver)value));
                return;
            }
            catch (XMLConfigurationException state) {}
            return;
        }
        if (name.equalsIgnoreCase("schema-location")) {
            if (!(value instanceof String) && value != null) throw DOMParserImpl.newTypeMismatchError(name);
            try {
                if (value == null) {
                    this.fSchemaLocation = null;
                    this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", null);
                    return;
                }
                this.fSchemaLocation = (String)value;
                StringTokenizer t = new StringTokenizer(this.fSchemaLocation, " \n\t\r");
                if (t.hasMoreTokens()) {
                    ArrayList<String> locations = new ArrayList<String>();
                    locations.add(t.nextToken());
                    while (t.hasMoreTokens()) {
                        locations.add(t.nextToken());
                    }
                    this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", locations.toArray());
                    return;
                }
                this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", value);
                return;
            }
            catch (XMLConfigurationException t) {}
            return;
        }
        if (name.equalsIgnoreCase("schema-type")) {
            if (!(value instanceof String) && value != null) throw DOMParserImpl.newTypeMismatchError(name);
            try {
                if (value == null) {
                    this.fConfiguration.setFeature(XMLSCHEMA, false);
                    this.fConfiguration.setFeature(XMLSCHEMA_FULL_CHECKING, false);
                    this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", null);
                    this.fSchemaType = null;
                    return;
                }
                if (value.equals(Constants.NS_XMLSCHEMA)) {
                    this.fConfiguration.setFeature(XMLSCHEMA, true);
                    this.fConfiguration.setFeature(XMLSCHEMA_FULL_CHECKING, true);
                    this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_XMLSCHEMA);
                    this.fSchemaType = Constants.NS_XMLSCHEMA;
                    return;
                }
                if (!value.equals(Constants.NS_DTD)) return;
                this.fConfiguration.setFeature(XMLSCHEMA, false);
                this.fConfiguration.setFeature(XMLSCHEMA_FULL_CHECKING, false);
                this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_DTD);
                this.fSchemaType = Constants.NS_DTD;
                return;
            }
            catch (XMLConfigurationException t) {}
            return;
        }
        if (name.equalsIgnoreCase("http://apache.org/xml/properties/dom/document-class-name")) {
            this.fConfiguration.setProperty("http://apache.org/xml/properties/dom/document-class-name", value);
            return;
        } else {
            String normalizedName = name.toLowerCase(Locale.ENGLISH);
            try {
                this.fConfiguration.setProperty(normalizedName, value);
                return;
            }
            catch (XMLConfigurationException xMLConfigurationException) {
                try {
                    if (name.equalsIgnoreCase(HONOUR_ALL_SCHEMALOCATIONS)) {
                        normalizedName = HONOUR_ALL_SCHEMALOCATIONS;
                    } else if (name.equals(NAMESPACE_GROWTH)) {
                        normalizedName = NAMESPACE_GROWTH;
                    } else if (name.equals(TOLERATE_DUPLICATES)) {
                        normalizedName = TOLERATE_DUPLICATES;
                    }
                    this.fConfiguration.getFeature(normalizedName);
                    throw DOMParserImpl.newTypeMismatchError(name);
                }
                catch (XMLConfigurationException xMLConfigurationException2) {
                    throw DOMParserImpl.newFeatureNotFoundError(name);
                }
            }
        }
    }

    @Override
    public Object getParameter(String name) throws DOMException {
        if (name.equalsIgnoreCase("comments")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/include-comments") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("datatype-normalization")) {
            return this.fConfiguration.getFeature(NORMALIZE_DATA) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("entities")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("namespaces")) {
            return this.fConfiguration.getFeature(NAMESPACES) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("validate")) {
            return this.fConfiguration.getFeature(VALIDATION_FEATURE) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("validate-if-schema")) {
            return this.fConfiguration.getFeature(DYNAMIC_VALIDATION) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("element-content-whitespace")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("disallow-doctype")) {
            return this.fConfiguration.getFeature(DISALLOW_DOCTYPE_DECL_FEATURE) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("infoset")) {
            boolean infoset = this.fConfiguration.getFeature(NAMESPACES) && this.fConfiguration.getFeature("namespace-declarations") && this.fConfiguration.getFeature("http://apache.org/xml/features/include-comments") && this.fConfiguration.getFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace") && !this.fConfiguration.getFeature(DYNAMIC_VALIDATION) && !this.fConfiguration.getFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes") && !this.fConfiguration.getFeature(NORMALIZE_DATA) && !this.fConfiguration.getFeature("http://apache.org/xml/features/create-cdata-nodes");
            return infoset ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("cdata-sections")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/create-cdata-nodes") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("check-character-normalization") || name.equalsIgnoreCase("normalize-characters")) {
            return Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("namespace-declarations") || name.equalsIgnoreCase("well-formed") || name.equalsIgnoreCase("ignore-unknown-character-denormalizations") || name.equalsIgnoreCase("canonical-form") || name.equalsIgnoreCase("supported-media-types-only") || name.equalsIgnoreCase("split-cdata-sections") || name.equalsIgnoreCase("charset-overrides-xml-encoding")) {
            return this.fConfiguration.getFeature(name.toLowerCase(Locale.ENGLISH)) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("error-handler")) {
            if (this.fErrorHandler != null) {
                return this.fErrorHandler.getErrorHandler();
            }
            return null;
        }
        if (name.equalsIgnoreCase("resource-resolver")) {
            try {
                XMLEntityResolver entityResolver = (XMLEntityResolver)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-resolver");
                if (entityResolver != null && entityResolver instanceof DOMEntityResolverWrapper) {
                    return ((DOMEntityResolverWrapper)entityResolver).getEntityResolver();
                }
            }
            catch (XMLConfigurationException entityResolver) {
                // empty catch block
            }
            return null;
        }
        if (name.equalsIgnoreCase("schema-type")) {
            return this.fConfiguration.getProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage");
        }
        if (name.equalsIgnoreCase("schema-location")) {
            return this.fSchemaLocation;
        }
        if (name.equalsIgnoreCase(SYMBOL_TABLE)) {
            return this.fConfiguration.getProperty(SYMBOL_TABLE);
        }
        if (name.equalsIgnoreCase("http://apache.org/xml/properties/dom/document-class-name")) {
            return this.fConfiguration.getProperty("http://apache.org/xml/properties/dom/document-class-name");
        }
        String normalizedName = name.equalsIgnoreCase(HONOUR_ALL_SCHEMALOCATIONS) ? HONOUR_ALL_SCHEMALOCATIONS : (name.equals(NAMESPACE_GROWTH) ? NAMESPACE_GROWTH : (name.equals(TOLERATE_DUPLICATES) ? TOLERATE_DUPLICATES : name.toLowerCase(Locale.ENGLISH)));
        try {
            return this.fConfiguration.getFeature(normalizedName) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            try {
                return this.fConfiguration.getProperty(normalizedName);
            }
            catch (XMLConfigurationException xMLConfigurationException2) {
                throw DOMParserImpl.newFeatureNotFoundError(name);
            }
        }
    }

    @Override
    public boolean canSetParameter(String name, Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Boolean) {
            boolean state = (Boolean)value;
            if (name.equalsIgnoreCase("supported-media-types-only") || name.equalsIgnoreCase("normalize-characters") || name.equalsIgnoreCase("check-character-normalization") || name.equalsIgnoreCase("canonical-form")) {
                return !state;
            }
            if (name.equalsIgnoreCase("well-formed") || name.equalsIgnoreCase("ignore-unknown-character-denormalizations")) {
                return state;
            }
            if (name.equalsIgnoreCase("cdata-sections") || name.equalsIgnoreCase("charset-overrides-xml-encoding") || name.equalsIgnoreCase("comments") || name.equalsIgnoreCase("datatype-normalization") || name.equalsIgnoreCase("disallow-doctype") || name.equalsIgnoreCase("entities") || name.equalsIgnoreCase("infoset") || name.equalsIgnoreCase("namespaces") || name.equalsIgnoreCase("namespace-declarations") || name.equalsIgnoreCase("validate") || name.equalsIgnoreCase("validate-if-schema") || name.equalsIgnoreCase("element-content-whitespace") || name.equalsIgnoreCase("xml-declaration")) {
                return true;
            }
            try {
                String normalizedName = name.equalsIgnoreCase(HONOUR_ALL_SCHEMALOCATIONS) ? HONOUR_ALL_SCHEMALOCATIONS : (name.equalsIgnoreCase(NAMESPACE_GROWTH) ? NAMESPACE_GROWTH : (name.equalsIgnoreCase(TOLERATE_DUPLICATES) ? TOLERATE_DUPLICATES : name.toLowerCase(Locale.ENGLISH)));
                this.fConfiguration.getFeature(normalizedName);
                return true;
            }
            catch (XMLConfigurationException e) {
                return false;
            }
        }
        if (name.equalsIgnoreCase("error-handler")) {
            return value instanceof DOMErrorHandler || value == null;
        }
        if (name.equalsIgnoreCase("resource-resolver")) {
            return value instanceof LSResourceResolver || value == null;
        }
        if (name.equalsIgnoreCase("schema-type")) {
            return value instanceof String && (value.equals(Constants.NS_XMLSCHEMA) || value.equals(Constants.NS_DTD)) || value == null;
        }
        if (name.equalsIgnoreCase("schema-location")) {
            return value instanceof String || value == null;
        }
        if (name.equalsIgnoreCase("http://apache.org/xml/properties/dom/document-class-name")) {
            return true;
        }
        try {
            this.fConfiguration.getProperty(name.toLowerCase(Locale.ENGLISH));
            return true;
        }
        catch (XMLConfigurationException e) {
            return false;
        }
    }

    @Override
    public DOMStringList getParameterNames() {
        if (this.fRecognizedParameters == null) {
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add("namespaces");
            parameters.add("cdata-sections");
            parameters.add("canonical-form");
            parameters.add("namespace-declarations");
            parameters.add("split-cdata-sections");
            parameters.add("entities");
            parameters.add("validate-if-schema");
            parameters.add("validate");
            parameters.add("datatype-normalization");
            parameters.add("charset-overrides-xml-encoding");
            parameters.add("check-character-normalization");
            parameters.add("supported-media-types-only");
            parameters.add("ignore-unknown-character-denormalizations");
            parameters.add("normalize-characters");
            parameters.add("well-formed");
            parameters.add("infoset");
            parameters.add("disallow-doctype");
            parameters.add("element-content-whitespace");
            parameters.add("comments");
            parameters.add("error-handler");
            parameters.add("resource-resolver");
            parameters.add("schema-location");
            parameters.add("schema-type");
            this.fRecognizedParameters = new DOMStringListImpl(parameters);
        }
        return this.fRecognizedParameters;
    }

    @Override
    public Document parseURI(String uri) throws LSException {
        block7: {
            if (this.fBusy) {
                throw DOMParserImpl.newInvalidStateError();
            }
            XMLInputSource source = new XMLInputSource(null, uri, null);
            try {
                this.currentThread = Thread.currentThread();
                this.fBusy = true;
                this.parse(source);
                this.fBusy = false;
                if (this.abortNow && this.currentThread.isInterrupted()) {
                    this.abortNow = false;
                    Thread.interrupted();
                }
            }
            catch (Exception e) {
                this.fBusy = false;
                if (this.abortNow && this.currentThread.isInterrupted()) {
                    Thread.interrupted();
                }
                if (this.abortNow) {
                    this.abortNow = false;
                    this.restoreHandlers();
                    return null;
                }
                if (e == AbstractDOMParser.Abort.INSTANCE) break block7;
                if (!(e instanceof XMLParseException) && this.fErrorHandler != null) {
                    DOMErrorImpl error = new DOMErrorImpl();
                    error.fException = e;
                    error.fMessage = e.getMessage();
                    error.fSeverity = (short)3;
                    this.fErrorHandler.getErrorHandler().handleError(error);
                }
                throw (LSException)DOMUtil.createLSException((short)81, e).fillInStackTrace();
            }
        }
        Document doc = this.getDocument();
        this.dropDocumentReferences();
        return doc;
    }

    @Override
    public Document parse(LSInput is) throws LSException {
        block7: {
            XMLInputSource xmlInputSource = this.dom2xmlInputSource(is);
            if (this.fBusy) {
                throw DOMParserImpl.newInvalidStateError();
            }
            try {
                this.currentThread = Thread.currentThread();
                this.fBusy = true;
                this.parse(xmlInputSource);
                this.fBusy = false;
                if (this.abortNow && this.currentThread.isInterrupted()) {
                    this.abortNow = false;
                    Thread.interrupted();
                }
            }
            catch (Exception e) {
                this.fBusy = false;
                if (this.abortNow && this.currentThread.isInterrupted()) {
                    Thread.interrupted();
                }
                if (this.abortNow) {
                    this.abortNow = false;
                    this.restoreHandlers();
                    return null;
                }
                if (e == AbstractDOMParser.Abort.INSTANCE) break block7;
                if (!(e instanceof XMLParseException) && this.fErrorHandler != null) {
                    DOMErrorImpl error = new DOMErrorImpl();
                    error.fException = e;
                    error.fMessage = e.getMessage();
                    error.fSeverity = (short)3;
                    this.fErrorHandler.getErrorHandler().handleError(error);
                }
                throw (LSException)DOMUtil.createLSException((short)81, e).fillInStackTrace();
            }
        }
        Document doc = this.getDocument();
        this.dropDocumentReferences();
        return doc;
    }

    private void restoreHandlers() {
        this.fConfiguration.setDocumentHandler(this);
        this.fConfiguration.setDTDHandler(this);
        this.fConfiguration.setDTDContentModelHandler(this);
    }

    @Override
    public Node parseWithContext(LSInput is, Node cnode, short action) throws DOMException, LSException {
        throw new DOMException(9, "Not supported");
    }

    XMLInputSource dom2xmlInputSource(LSInput is) {
        XMLInputSource xis = null;
        if (is.getCharacterStream() != null) {
            xis = new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), is.getCharacterStream(), "UTF-16");
        } else if (is.getByteStream() != null) {
            xis = new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), is.getByteStream(), is.getEncoding());
        } else if (is.getStringData() != null && is.getStringData().length() > 0) {
            xis = new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), new StringReader(is.getStringData()), "UTF-16");
        } else if (is.getSystemId() != null && is.getSystemId().length() > 0 || is.getPublicId() != null && is.getPublicId().length() > 0) {
            xis = new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI());
        } else {
            if (this.fErrorHandler != null) {
                DOMErrorImpl error = new DOMErrorImpl();
                error.fType = "no-input-specified";
                error.fMessage = "no-input-specified";
                error.fSeverity = (short)3;
                this.fErrorHandler.getErrorHandler().handleError(error);
            }
            throw new LSException(81, "no-input-specified");
        }
        return xis;
    }

    @Override
    public boolean getAsync() {
        return false;
    }

    @Override
    public boolean getBusy() {
        return this.fBusy;
    }

    @Override
    public void abort() {
        if (this.fBusy) {
            this.fBusy = false;
            if (this.currentThread != null) {
                this.abortNow = true;
                if (this.abortHandler == null) {
                    this.abortHandler = new AbortHandler();
                }
                this.fConfiguration.setDocumentHandler(this.abortHandler);
                this.fConfiguration.setDTDHandler(this.abortHandler);
                this.fConfiguration.setDTDContentModelHandler(this.abortHandler);
                if (this.currentThread == Thread.currentThread()) {
                    throw AbstractDOMParser.Abort.INSTANCE;
                }
                this.currentThread.interrupt();
            }
        }
    }

    @Override
    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) {
        if (!this.fNamespaceDeclarations && this.fNamespaceAware) {
            int len = attributes.getLength();
            int i = len - 1;
            while (i >= 0) {
                if (XMLSymbols.PREFIX_XMLNS == attributes.getPrefix(i) || XMLSymbols.PREFIX_XMLNS == attributes.getQName(i)) {
                    attributes.removeAttributeAt(i);
                }
                --i;
            }
        }
        super.startElement(element, attributes, augs);
    }

    private static DOMException newInvalidStateError() {
        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null);
        throw new DOMException(11, msg);
    }

    private static DOMException newFeatureNotSupportedError(String name) {
        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
        return new DOMException(9, msg);
    }

    private static DOMException newFeatureNotFoundError(String name) {
        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
        return new DOMException(8, msg);
    }

    private static DOMException newTypeMismatchError(String name) {
        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "TYPE_MISMATCH_ERR", new Object[]{name});
        return new DOMException(17, msg);
    }

    private static final class AbortHandler
    implements XMLDocumentHandler,
    XMLDTDHandler,
    XMLDTDContentModelHandler {
        private XMLDocumentSource documentSource;
        private XMLDTDContentModelSource dtdContentSource;
        private XMLDTDSource dtdSource;

        private AbortHandler() {
        }

        @Override
        public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void comment(XMLString text, Augmentations augs) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void startGeneralEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void characters(XMLString text, Augmentations augs) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void endElement(QName element, Augmentations augs) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void startCDATA(Augmentations augs) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void endCDATA(Augmentations augs) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void endDocument(Augmentations augs) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void setDocumentSource(XMLDocumentSource source) {
            this.documentSource = source;
        }

        @Override
        public XMLDocumentSource getDocumentSource() {
            return this.documentSource;
        }

        @Override
        public void startDTD(XMLLocator locator, Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void startParameterEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void endParameterEntity(String name, Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void startExternalSubset(XMLResourceIdentifier identifier, Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void endExternalSubset(Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void elementDecl(String name, String contentModel, Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void startAttlist(String elementName, Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void attributeDecl(String elementName, String attributeName, String type, String[] enumeration, String defaultType, XMLString defaultValue, XMLString nonNormalizedDefaultValue, Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void endAttlist(Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void internalEntityDecl(String name, XMLString text, XMLString nonNormalizedText, Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void externalEntityDecl(String name, XMLResourceIdentifier identifier, Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void unparsedEntityDecl(String name, XMLResourceIdentifier identifier, String notation, Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void notationDecl(String name, XMLResourceIdentifier identifier, Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void startConditional(short type, Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void ignoredCharacters(XMLString text, Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void endConditional(Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void endDTD(Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void setDTDSource(XMLDTDSource source) {
            this.dtdSource = source;
        }

        @Override
        public XMLDTDSource getDTDSource() {
            return this.dtdSource;
        }

        @Override
        public void startContentModel(String elementName, Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void any(Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void empty(Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void startGroup(Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void pcdata(Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void element(String elementName, Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void separator(short separator, Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void occurrence(short occurrence, Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void endGroup(Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void endContentModel(Augmentations augmentations) throws XNIException {
            throw AbstractDOMParser.Abort.INSTANCE;
        }

        @Override
        public void setDTDContentModelSource(XMLDTDContentModelSource source) {
            this.dtdContentSource = source;
        }

        @Override
        public XMLDTDContentModelSource getDTDContentModelSource() {
            return this.dtdContentSource;
        }
    }

    static final class NullLSParserFilter
    implements LSParserFilter {
        static final NullLSParserFilter INSTANCE = new NullLSParserFilter();

        private NullLSParserFilter() {
        }

        @Override
        public short acceptNode(Node nodeArg) {
            return 1;
        }

        @Override
        public int getWhatToShow() {
            return -1;
        }

        @Override
        public short startElement(Element elementArg) {
            return 1;
        }
    }
}

