/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.impl.dv.xs;

import java.math.BigDecimal;
import java.math.BigInteger;
import mf.javax.xml.datatype.Duration;
import mf.org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import mf.org.apache.xerces.impl.dv.ValidationContext;
import mf.org.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import mf.org.apache.xerces.impl.dv.xs.DurationDV;

class DayTimeDurationDV
extends DurationDV {
    DayTimeDurationDV() {
    }

    @Override
    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        try {
            return this.parse(content, 2);
        }
        catch (Exception ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "dayTimeDuration"});
        }
    }

    @Override
    protected Duration getDuration(AbstractDateTimeDV.DateTimeData date) {
        int sign = 1;
        if (date.day < 0 || date.hour < 0 || date.minute < 0 || date.second < 0.0) {
            sign = -1;
        }
        return datatypeFactory.newDuration(sign == 1, null, null, date.day != Integer.MIN_VALUE ? BigInteger.valueOf(sign * date.day) : null, date.hour != Integer.MIN_VALUE ? BigInteger.valueOf(sign * date.hour) : null, date.minute != Integer.MIN_VALUE ? BigInteger.valueOf(sign * date.minute) : null, date.second != -2.147483648E9 ? new BigDecimal(String.valueOf((double)sign * date.second)) : null);
    }
}

