/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.impl.dv.xs;

import java.io.UnsupportedEncodingException;
import mf.org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import mf.org.apache.xerces.impl.dv.ValidationContext;
import mf.org.apache.xerces.impl.dv.xs.TypeValidator;
import mf.org.apache.xerces.util.URI;

public class AnyURIDV
extends TypeValidator {
    private static final URI BASE_URI;
    private static boolean[] gNeedEscaping;
    private static char[] gAfterEscaping1;
    private static char[] gAfterEscaping2;
    private static char[] gHexChs;

    static {
        URI uri = null;
        try {
            uri = new URI("abc://def.ghi.jkl");
        }
        catch (URI.MalformedURIException malformedURIException) {
            // empty catch block
        }
        BASE_URI = uri;
        gNeedEscaping = new boolean[128];
        gAfterEscaping1 = new char[128];
        gAfterEscaping2 = new char[128];
        gHexChs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int i = 0;
        while (i <= 31) {
            AnyURIDV.gNeedEscaping[i] = true;
            AnyURIDV.gAfterEscaping1[i] = gHexChs[i >> 4];
            AnyURIDV.gAfterEscaping2[i] = gHexChs[i & 0xF];
            ++i;
        }
        AnyURIDV.gNeedEscaping[127] = true;
        AnyURIDV.gAfterEscaping1[127] = 55;
        AnyURIDV.gAfterEscaping2[127] = 70;
        char[] escChs = new char[]{' ', '<', '>', '\"', '{', '}', '|', '\\', '^', '~', '`'};
        int len = escChs.length;
        int i2 = 0;
        while (i2 < len) {
            char ch = escChs[i2];
            AnyURIDV.gNeedEscaping[ch] = true;
            AnyURIDV.gAfterEscaping1[ch] = gHexChs[ch >> 4];
            AnyURIDV.gAfterEscaping2[ch] = gHexChs[ch & 0xF];
            ++i2;
        }
    }

    @Override
    public short getAllowedFacets() {
        return 2079;
    }

    @Override
    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        try {
            if (content.length() != 0) {
                String encoded = AnyURIDV.encode(content);
                new URI(BASE_URI, encoded);
            }
        }
        catch (URI.MalformedURIException ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "anyURI"});
        }
        return content;
    }

    private static String encode(String anyURI) {
        int ch;
        int len = anyURI.length();
        StringBuffer buffer = new StringBuffer(len * 3);
        int i = 0;
        while (i < len) {
            ch = anyURI.charAt(i);
            if (ch >= 128) break;
            if (gNeedEscaping[ch]) {
                buffer.append('%');
                buffer.append(gAfterEscaping1[ch]);
                buffer.append(gAfterEscaping2[ch]);
            } else {
                buffer.append((char)ch);
            }
            ++i;
        }
        if (i < len) {
            byte[] bytes = null;
            try {
                bytes = anyURI.substring(i).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return anyURI;
            }
            len = bytes.length;
            i = 0;
            while (i < len) {
                byte b = bytes[i];
                if (b < 0) {
                    ch = b + 256;
                    buffer.append('%');
                    buffer.append(gHexChs[ch >> 4]);
                    buffer.append(gHexChs[ch & 0xF]);
                } else if (gNeedEscaping[b]) {
                    buffer.append('%');
                    buffer.append(gAfterEscaping1[b]);
                    buffer.append(gAfterEscaping2[b]);
                } else {
                    buffer.append((char)b);
                }
                ++i;
            }
        }
        if (buffer.length() != len) {
            return buffer.toString();
        }
        return anyURI;
    }
}

