/*
 * Decompiled with CFR 0.152.
 */
package mf.javax.xml.transform;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import mf.javax.xml.transform.SourceLocator;

public class TransformerException
extends Exception {
    SourceLocator locator;
    Throwable containedException;

    public SourceLocator getLocator() {
        return this.locator;
    }

    public void setLocator(SourceLocator location) {
        this.locator = location;
    }

    public Throwable getException() {
        return this.containedException;
    }

    @Override
    public Throwable getCause() {
        return this.containedException == this ? null : this.containedException;
    }

    @Override
    public synchronized Throwable initCause(Throwable cause) {
        if (this.containedException != null) {
            throw new IllegalStateException("Can't overwrite cause");
        }
        if (cause == this) {
            throw new IllegalArgumentException("Self-causation not permitted");
        }
        this.containedException = cause;
        return this;
    }

    public TransformerException(String message) {
        super(message);
        this.containedException = null;
        this.locator = null;
    }

    public TransformerException(Throwable e) {
        super(e.toString());
        this.containedException = e;
        this.locator = null;
    }

    public TransformerException(String message, Throwable e) {
        super(message == null || message.length() == 0 ? e.toString() : message);
        this.containedException = e;
        this.locator = null;
    }

    public TransformerException(String message, SourceLocator locator) {
        super(message);
        this.containedException = null;
        this.locator = locator;
    }

    public TransformerException(String message, SourceLocator locator, Throwable e) {
        super(message);
        this.containedException = e;
        this.locator = locator;
    }

    public String getMessageAndLocation() {
        StringBuffer sbuffer = new StringBuffer();
        String message = super.getMessage();
        if (message != null) {
            sbuffer.append(message);
        }
        if (this.locator != null) {
            String systemID = this.locator.getSystemId();
            int line = this.locator.getLineNumber();
            int column = this.locator.getColumnNumber();
            if (systemID != null) {
                sbuffer.append("; SystemID: ");
                sbuffer.append(systemID);
            }
            if (line != 0) {
                sbuffer.append("; Line#: ");
                sbuffer.append(line);
            }
            if (column != 0) {
                sbuffer.append("; Column#: ");
                sbuffer.append(column);
            }
        }
        return sbuffer.toString();
    }

    public String getLocationAsString() {
        if (this.locator != null) {
            StringBuffer sbuffer = new StringBuffer();
            String systemID = this.locator.getSystemId();
            int line = this.locator.getLineNumber();
            int column = this.locator.getColumnNumber();
            if (systemID != null) {
                sbuffer.append("; SystemID: ");
                sbuffer.append(systemID);
            }
            if (line != 0) {
                sbuffer.append("; Line#: ");
                sbuffer.append(line);
            }
            if (column != 0) {
                sbuffer.append("; Column#: ");
                sbuffer.append(column);
            }
            return sbuffer.toString();
        }
        return null;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(new PrintWriter(System.err, true));
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this.printStackTrace(new PrintWriter(s));
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        if (s == null) {
            s = new PrintWriter(System.err, true);
        }
        try {
            String locInfo = this.getLocationAsString();
            if (locInfo != null) {
                s.println(locInfo);
            }
            super.printStackTrace(s);
        }
        catch (Throwable locInfo) {
            // empty catch block
        }
        Throwable exception = this.getException();
        int i = 0;
        while (i < 10 && exception != null) {
            s.println("---------");
            try {
                String locInfo;
                if (exception instanceof TransformerException && (locInfo = ((TransformerException)exception).getLocationAsString()) != null) {
                    s.println(locInfo);
                }
                exception.printStackTrace(s);
            }
            catch (Throwable e) {
                s.println("Could not print stack trace...");
            }
            try {
                Method meth = exception.getClass().getMethod("getException", null);
                if (meth != null) {
                    Throwable prev = exception;
                    if (prev == (exception = (Throwable)meth.invoke((Object)exception, null))) {
                        break;
                    }
                } else {
                    exception = null;
                }
            }
            catch (InvocationTargetException ite) {
                exception = null;
            }
            catch (IllegalAccessException iae) {
                exception = null;
            }
            catch (NoSuchMethodException nsme) {
                exception = null;
            }
            ++i;
        }
        s.flush();
    }
}

