/**
 * Flogman (Foto bLOG, Mail is All you Need)
 * Copyright (C) 2003 Junya Ishihara (http://flogman.sourceforge.net)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package net.sourceforge.flogman;
import java.io.*;
import java.util.*;

public class UploadFiles{
  String ftp_server;
  String ftp_user;
  String ftp_pwd;


  public UploadFiles(String ftp_server, String ftp_user, String ftp_pwd) {
    this.ftp_server = ftp_server;
    this.ftp_user = ftp_user;
    this.ftp_pwd = ftp_pwd;
  }

  public void uploadFiles(String startdir, String dirname, String filename) throws IOException {
    try {
      FtpCom ftp = new FtpCom(ftp_server,ftp_user,ftp_pwd);
      ftp.cd(startdir);
      ftp.binary();
      try {
        ftp.mkd(dirname);
      } catch( Exception e) {}
      ftp.cd(dirname);
      ftp.binary();
      ftp.put(Flogman.prop.getProperty("upload_file_location") + Flogman.prop.getProperty("path_delimiter") + filename, filename);
      ftp.noop();
      ftp.logout();
    } catch( Exception e ) {
      e.printStackTrace();
    }
  }

  public void uploadFiles(String startdir, String filename) throws IOException {
    try {
      FtpCom ftp = new FtpCom(ftp_server,ftp_user,ftp_pwd);
      ftp.cd(startdir);
      ftp.binary();
      ftp.put(filename);
      ftp.noop();
      ftp.logout();
    } catch( Exception e ) {
      e.printStackTrace();
    }
  }

  public static void main(String[] argv) throws IOException {
    if (argv.length == 0) {
      System.err.println("Usage: UploadFiles startdir dirname filename");
      System.exit(1);
    }
    UploadFiles uf = new UploadFiles(argv[0], argv[1], argv[2]);
    uf.uploadFiles(argv[3], argv[4], argv[5]);
  }
}
