/**
 * Flogman (Foto bLOG, Mail is All you Need)
 * Copyright (C) 2003 Junya Ishihara (http://flogman.sourceforge.net)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package net.sourceforge.flogman;
import java.io.*;
import java.util.*;

public class SubjectParser{
  private String subject;
  private String separator;
  private String dirname;
  private String description;


  public static void main(String[] argv) throws Exception {
    if (argv.length == 0) {
      System.err.println("Usage: SubjectParser subject separator");
      System.exit(1);
    }
    SubjectParser sp = new SubjectParser(argv[0], argv[1]);
    System.out.println("Dirname:" + sp.getFirstPart());
    System.out.println("Description:" + sp.getSecondPart());			  }

  public SubjectParser(String subject, String separator) {
    this.subject = subject;
    this.separator = separator;
  }	

  public String getFirstPart() {
    try {
      StringTokenizer st = new StringTokenizer(this.subject, this.separator);
      return(st.nextToken());
    } catch (Exception e) {
      return("");
    }
  }

  public String getSecondPart() throws Exception{
    try {
      StringTokenizer st = new StringTokenizer(this.subject, this.separator);
        st.nextToken();
        return(st.nextToken());
    } catch (Exception e) {
      return("");
    }
  }
}
