/**
 * Flogman (Foto bLOG, Mail is All you Need)
 * Copyright (C) 2003 Junya Ishihara (http://flogman.sourceforge.net)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package net.sourceforge.flogman;
import java.util.*;
import javax.mail.*;
import javax.mail.internet.*;

public class SendMail {
    public SendMail() {}

    public static void send(String smtpHost, String from, String to, String subject, String msgtxt) throws Exception {

        try {

            String charset = "iso-2022-jp";

            //
            //  Initialization
            //
            Properties props = new Properties();
            props.put("mail.smtp.host", smtpHost);
            Session sess = Session.getInstance(props, null);

            //
            //  Set from and to
            //
            MimeMessage msg = new MimeMessage(sess);
            msg.setFrom(new InternetAddress(from));
            InternetAddress[] toAddress = {new InternetAddress(to)};
            msg.setRecipients(Message.RecipientType.TO, toAddress);

            //
            //  Set subject and body
            //
            msg.setSubject(subject, charset);
            msg.setText(msgtxt, charset);

            //
            //  Send a mail
            //
            Transport.send(msg);

            //System.out.println("Mail sent.");
        } catch(Exception e) {
            e.printStackTrace();
        }
    }

    public static void main (String[] args) throws Exception{

        if (args.length < 5) {
            System.out.println("Missing parameter.");
            return;
        }

        String smtpHost = args[0];
        String from = args[1];
        String to = args[2];
        String subject = args[3];
        String msgtxt = args[4];
        SendMail.send(smtpHost, from, to, subject, msgtxt);
    }
}
