/**
 * Flogman (Foto bLOG, Mail is All you Need)
 * Copyright (C) 2003 Junya Ishihara (http://flogman.sourceforge.net)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package net.sourceforge.flogman;
import java.io.*;
import java.util.*;
import java.text.*;

public class MyUtility {

  /** Nobody should need to create an instance; all methods are static */
  private MyUtility() { }


  /** Sava a file from InputStream */
  public static void saveFile(String fileName, InputStream is) throws FileNotFoundException, IOException {

    BufferedOutputStream os = 
    new BufferedOutputStream(new FileOutputStream(fileName));

    int b;  // the byte read from the file
    while ((b = is.read()) != -1) {
      os.write(b);
    }
    is.close();
    os.close();
  }


  /** Get file type from file extension */
  public static String getFileType(String filename) {
    try{
      StringTokenizer st = new StringTokenizer(filename, ".");
      st.nextToken();
      String fileext = (st.nextToken()).toLowerCase();

      if (fileext.equals("jpg") || fileext.equals("jpeg")) {
        return ("jpg");
      } else if (fileext.equals("mpg") || fileext.equals("mpeg")) {
        return ("mpg");
      } else {
        return ("error");
      }
    } catch (Exception e){
      return ("error");
    }
  }

  public static boolean isOld(String date) throws Exception {
    SimpleDateFormat formatter = new SimpleDateFormat ("yyyyMMddHHmm");
    Date d;
    d = formatter.parse(date);
    Flogman.cat.info("dirname converted to date:" + d);

    /* Today's date */
    Date td = new Date();

    long diff = td.getTime() - d.getTime();

     Flogman.cat.info("The item is " + diff/(1000*60*60*24) + " days old.");
     if (diff/(1000*60*60*24) >= Integer.parseInt(Flogman.prop.getProperty("keep_new_tag_in_days"))) {
       Flogman.cat.info("Old enough to delete new tag.");
       return(true);
     } else {
       Flogman.cat.info("Not old enough to delete new tag.");
       return(false);
     }
  }
}
