/**
 * Flogman (Foto bLOG, Mail is All you Need)
 * Copyright (C) 2003 Junya Ishihara (http://flogman.sourceforge.net)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package net.sourceforge.flogman;
import javax.xml.parsers.*;
import com.sun.xml.tree.*;
import org.w3c.dom.*;
import java.io.*;
import java.util.*;

public class ModifyHtml {
  private String xml_file;
  private String xml_charset;

  public ModifyHtml(String xml_file, String xml_charset) {
    this.xml_file = xml_file;
    this.xml_charset = xml_charset;
  }

  public boolean delete(String dir) throws Exception {
    boolean deleted = false;
    try{
      XmlDocument xmldoc = XmlDocument.createXmlDocument(
      new FileInputStream(xml_file), false) ;

      Node root = (Node) xmldoc.getDocumentElement() ;
      NodeList children = root.getChildNodes();
      
      LOOP: for (int i = 0; i < children.getLength(); i++) {
	Node child = children.item(i);
	int k = 0;

	if (child.getNodeName().equals("section")) {
	  NodeList gchildren = child.getChildNodes();

	  for (int j = 0; j < gchildren.getLength(); j++) {
	    Node gchild = gchildren.item(j);

	    if (gchild.getNodeName().equals("dir")) {
	      Node dirnode = gchild;
              String dirnodevalue = dirnode.getFirstChild().getNodeValue();
	      if ((dir.equals(dirnodevalue))) {
                root.removeChild(child);

                //delete the node before to clean unnecessary line break
                root.removeChild(children.item(i-1));

                Flogman.cat.info(dir + " is deleted.");
                deleted = true;

                // Update xml file
                BufferedWriter out = new BufferedWriter( new FileWriter(xml_file));
                xmldoc.write(out, xml_charset);
                out.flush();
                out.close();
                break LOOP;
              }
            }
          }
        }
      }
    }catch (java.lang.NumberFormatException exc) {
      Flogman.cat.error("The second parameter must be integer.");

    }catch (org.xml.sax.SAXException exc) {
		System.err.println("Found invalid XML during processing:");
		exc.printStackTrace();
    }
    return (deleted);
  }

  public static void main(String[] args) throws Exception{
    ModifyHtml mh = new ModifyHtml(args[0], args[1]);
    mh.delete(args[0]);
  }
}
