/**
 * Flogman (Foto bLOG, Mail is All you Need)
 * Copyright (C) 2003 Junya Ishihara (http://flogman.sourceforge.net)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package net.sourceforge.flogman;
import javax.xml.parsers.*;
import com.sun.xml.tree.*;
import org.w3c.dom.*;
import java.io.*;
import java.util.*;
import java.text.*;

public class MakeHtml{
  private String xml_file;
  private String xml_charset;

  public MakeHtml (String xml_file, String xml_charset){
    this.xml_file = xml_file;
    this.xml_charset = xml_charset;
  }

  public void makeHtml(String date, String body, String filename, String filetype) throws Exception {
    try{
      XmlDocument xmldoc = XmlDocument.createXmlDocument(
      new FileInputStream(xml_file), false) ;
      Node root = (Node) xmldoc.getDocumentElement() ;

      Date dNow = new Date();
      System.out.println("It is now " + dNow.toString());

      Node nodenew = xmldoc.createElement("new");
      Node nodenewvalue = xmldoc.createTextNode("true");
      nodenew.appendChild(nodenewvalue);

      Node newdate = xmldoc.createElement("date");
      Node newdatevalue = xmldoc.createTextNode(dNow.toString());
      newdate.appendChild(newdatevalue);

      Node newdir = xmldoc.createElement("dir");
      Node newdirvalue = xmldoc.createTextNode(date);
      newdir.appendChild(newdirvalue);

      Node item = createItemNode(xmldoc, body, filename, filetype);
      Node newsection = xmldoc.createElement("section");

      newsection.appendChild(nodenew);
      newsection.appendChild(newdate);
      newsection.appendChild(newdir);
      newsection.appendChild(item);
      root.appendChild(newsection);
      Node linebreak = xmldoc.createTextNode("\n\n");
      root.appendChild(linebreak);

      BufferedWriter out = new BufferedWriter( new FileWriter(xml_file));
      xmldoc.write(out, xml_charset);
      out.flush();
      out.close();

    }catch (org.xml.sax.SAXException exc) {
      Flogman.cat.error("Found invalid XML during processing:");
      exc.printStackTrace();
    }
  }

  private Node createItemNode(XmlDocument xmldoc, String body, String filename, String filetype) throws Exception {
    Node newbody = createNode(xmldoc, "body", body);
    Node type = createNode(xmldoc, "type", filetype);
    Node newfile = createNode(xmldoc, "file", filename);

    Node image = xmldoc.createElement("image");
    image.appendChild(type);
    image.appendChild(newfile);

    Node item = xmldoc.createElement("item");
    item.appendChild(newbody);
    item.appendChild(image);		

    return(item);
  }

  private Node createNode(XmlDocument xmldoc, String nodename, String nodevalue) throws Exception {
    Node newnode = xmldoc.createElement(nodename);
    Node newnodevalue = xmldoc.createTextNode(nodevalue);
    newnode.appendChild(newnodevalue);
    return(newnode);
  }

  public static void main(String[] args) throws Exception{
    // MakeHtml xml_file xml_charset date body filename filetype
    MakeHtml mhtml = new MakeHtml(args[0], args[1]);
    mhtml.makeHtml(args[2], args[3], args[4], args[5]);
  }
}
