package com.small_it_office.flatserve.aop.internal;

import java.lang.reflect.Method;

import org.aopalliance.intercept.MethodInterceptor;

import com.small_it_office.flatserve.core.ApplicationException;
import com.small_it_office.shared.meslog.message.Message;

/**
 * C^[Zv^KpΏۃNX̃pbP[WwłAXyNgłB
 * w肳ꂽpbP[W̃NX̃\bhsꍇ݂̂̃\bhɑ΂ăC^[Zv^KpꍇɎgp܂B
 * TupbP[W͑ΏۂɂȂ܂B
 */
public class PackageAssignedAspect extends Aspect {

	/**
	 * C^[Zv^KpΏۂ̃pbP[WB
	 */
	private String targetPackage;

	/**
	 * RXgN^B
	 * @param interceptor C^[Zv^
	 * @param targetPackage C^[Zv^KpΏۂƂpbP[W
	 */
	public PackageAssignedAspect(MethodInterceptor interceptor, String targetPackage) {
		super(interceptor);
		this.targetPackage = targetPackage;
	}

	/**
	 * {@inheritDoc}
	 * ̃NXKpΏۃpbP[W̃NXłꍇ̂trueԂ܂B
	 */
	public boolean isAssignable(Class<?> serviceClass, Method serviceMethod) {
		return serviceClass.getPackage().getName().equals(targetPackage);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void validate() {
		super.validate();
		if (targetPackage == null) {
			throw new ApplicationException(Message.get("FSAOP-ERR005"));
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return "package assignable aspect(" + targetPackage + ")";
	}
}
