package com.small_it_office.flatserve.aop.internal;

import javax.servlet.ServletConfig;

import com.small_it_office.flatserve.aop.AspectConfig;
import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginImplementation;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMapper;
import com.small_it_office.flatserve.core.request.internal.RequestParameterReader;
import com.small_it_office.flatserve.core.response.internal.ResponseSender;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.flatserve.core.service.internal.HttpServiceFactory;

/**
 * AOPvOC̎\NXłB
 */
public class AOPPluginImplementation implements PluginImplementation {

	/**
	 * {@inheritDoc}
	 */
	public HttpServiceExecutor getHttpServiceExecutor() {
		return new AspectHttpServiceExecutor();
	}

	/**
	 * {@inheritDoc}
	 */
	public HttpServiceFactory getHttpServiceFactory() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public RequestParameterReader getRequestParameterReader() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public RequestParameterMapper getRequestParameterMapper() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public ResponseSender getResponseSender() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {
		AspectConfig aspectConfig = config.getOptionalConfig(AspectConfig.class);
		if (aspectConfig == null) {
			aspectConfig = new AspectConfig();
			config.addOptionalConfig(aspectConfig);
		}

		for (Aspect aspect : aspectConfig.getAspectList()) {
			aspect.validate();
		}
	}

}
