package com.small_it_office.flatserve.core.service.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.service.HttpService;
import com.small_it_office.flatserve.core.service.IllegalHttpServiceException;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;

/**
 * NGXgURĨpXHTTPServicẽNXƃ\bhA ŕێ邽߂̃NXłB
 */
public class HttpServiceResolver {

	/**
	 * HTTPServiceNXB
	 */
	private Class<?> serviceClass;

	/**
	 * HTTPServicẽ\bhB
	 */
	private Method serviceMethod;

	/**
	 * ݒB
	 */
	private Config config;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * RXgN^B
	 * @param config ݒ
	 */
	public HttpServiceResolver(Config config) {
		this.config = config;
	}

	/**
	 * HTTPT[rXNXƃ\bh܂B
	 * NXƃ\bh͓Őĕێ܂B
	 * @param path NGXgURI"/"͂܂pX
	 * @param contextPath AvP[ṼReLXg[gBftHgReLXgȊÔ̏ꍇ"/"Ŏn܂KvB
	 * @throws IllegalHttpServiceException Ώۂ̃\bhI[o[[hĂꍇ
	 */
	public void resolveURI(String path, String contextPath) {
		logger.debug("FSCORE-LOGD007", path);

		String pathWithoutContextRoot;
		if (path.startsWith(contextPath)) {
			pathWithoutContextRoot = path.substring(contextPath.length() + 1);
		} else {
			//̂悤ȃP[X݂邩sB
			pathWithoutContextRoot = path.substring(1);
			logger.warn("FSCORE-LOGW001", path, contextPath);
		}
		int lastSlashIndex = pathWithoutContextRoot.lastIndexOf("/");
		int lastDotIndex = pathWithoutContextRoot.lastIndexOf(".");
		String pathWithoutExtention;
		if (lastSlashIndex < lastDotIndex) {
			pathWithoutExtention = pathWithoutContextRoot.substring(0, lastDotIndex);
		} else {
			pathWithoutExtention = pathWithoutContextRoot;
		}
		if (pathWithoutExtention.endsWith("/")) {
			logger.debug("FSCORE-LOGD008", path);
			return;
		}

		// ReLXg[gƊgqpXŁANXƂ̃}bsOB
		serviceClass = config.pathToClass(pathWithoutExtention);
		String methodName;
		if (serviceClass == null) {
			// pXNXw蕔ƃ\bhɕB\bh܂܂Ȃꍇ̓ftHg̃\bhKpB
			methodName = pathWithoutExtention.substring(pathWithoutExtention.lastIndexOf("/") + 1);
			String pathWithoutMethod;
			if (pathWithoutExtention.length() > methodName.length() && Character.isLowerCase(methodName.charAt(0))) {
				pathWithoutMethod = pathWithoutExtention.substring(0, pathWithoutExtention.lastIndexOf("/"));
				logger.debug("FSCORE-LOGD009", methodName, pathWithoutMethod);
			} else {
				logger.debug("FSCORE-LOGD010", path);
				methodName = "execute";
				pathWithoutMethod = pathWithoutExtention;
			}

			serviceClass = createServiceClass(pathWithoutMethod);

		} else {
			logger.debug("FSCORE-LOGD011", path);
			methodName = "execute";
		}

		if (serviceClass == null) {
			logger.debug("FSCORE-LOGD016");
		} else {
			logger.debug("FSCORE-LOGD012", serviceClass.getName(), methodName);
			serviceMethod = reflectTargetMethod(methodName, serviceClass);
		}

	}

	/**
	 * NXHTTPT[rXNX𐶐܂B
	 * NXłȂꍇnullԂ܂B
	 * @param pathWithoutMethod NX肷邽߂ɕKvURĨpẌꕔ
	 * @return ĐNX
	 */
	private Class<?> createServiceClass(String pathWithoutMethod) {
		Class<?> result = config.pathToClass(pathWithoutMethod);
		if (result == null) {
			logger.debug("FSCORE-LOGD013", pathWithoutMethod);
			String packageFromPath = pathWithoutMethod.replaceAll("/", ".");
			String packagePrefix = config.getPackagePrefix();
			String className;
			if (packagePrefix == null) {
				className = packageFromPath;
			} else {
				logger.debug("FSCORE-LOGD014", packageFromPath, packagePrefix);
				className = packagePrefix + "." + packageFromPath;
			}
			logger.debug("FSCORE-LOGD015", className);
			try {
				result = Class.forName(className);
			} catch (ClassNotFoundException e) {
				//ł́uNXȂvƂO͕svB
				//Ăяo\bhŏo͂邽߁B
				return null;
			}
		} else {
			logger.debug("FSCORE-LOGD017", pathWithoutMethod);
		}
		return result;
	}

	/**
	 * HTTPT[rX\bhtNVŐ܂B
	 * T[rX\bhƂĎs\ȃ\bh𐶐łȂꍇnullԂ܂B
	 * @param methodName \bh
	 * @param serviceClass \bh`NX
	 * @return \bh
	 * @throws IllegalHttpServiceException NXɓHTTPT[rX\bh`Ăꍇ
	 */
	private Method reflectTargetMethod(String methodName, Class<?> serviceClass) {
		Method targetMethod = null;
		Method[] methods = serviceClass.getMethods();
		for (Method m : methods) {
			if (methodName.equals(m.getName())) {
				if (!isHttpServiceAnnotated(m)) {
					logger.debug("FSCORE-LOGD018", m.getDeclaringClass().getName(), m.getName());
				} else if (targetMethod != null) {
					throw new IllegalHttpServiceException(Message.get("FSCORE-ERR010", m.getName(), serviceClass.getName()));
				} else {
					logger.debug("FSCORE-LOGD020", serviceClass.getName(), m.getName());
					targetMethod = m;
				}
			}
		}

		if (targetMethod == null) {
			logger.debug("FSCORE-LOGD021", serviceClass.getName(), methodName);
		}

		return targetMethod;
	}

	/**
	 * \bhHTTPT[rXł邱ƂAme[VŐ錾Ă邩ǂmF܂B
	 * {@link HttpService}Ame[V\bhɐ錾ĂꍇtrueԂ܂B
	 * @param method mFΏۂ̃\bh
	 * @return HTTPT[rXƂĐ錾Ăꍇtrue
	 */
	private boolean isHttpServiceAnnotated(Method method) {
		Annotation annotation = method.getAnnotation(HttpService.class);
		return annotation != null;
	}

	/**
	 * ςHTTPT[rXNX擾܂B
	 * sȃNGXgpXȂǂ̂߉łĂȂꍇnullԂ܂B
	 * @return HTTPT[rXNX
	 */
	public Class<?> getServiceClass() {
		return serviceClass;
	}

	/**
	 * ςHTTPT[rX\bh擾܂B
	 * sȃNGXgpXȂǂ̂߉łĂȂꍇnullԂ܂B
	 * @return HTTPT[rX\bh
	 */
	public Method getServiceMethod() {
		return serviceMethod;
	}

}
