package com.small_it_office.flatserve.core.service.internal;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import javax.servlet.ServletConfig;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.service.HttpServiceException;
import com.small_it_office.flatserve.core.service.Singleton;
import com.small_it_office.flatserve.core.util.internal.AnnotationUtil;
import com.small_it_office.shared.meslog.message.Message;


/**
 * HTTPT[rXNX̃CX^X𐶐t@NgNXłB
 */
public class HttpServiceFactoryImpl implements HttpServiceFactory {

	/**
	 * ̃vOCi̗D揇ʁB
	 */
	private static final int PLUGIN_PRIORITY = 1024;

	/**
	 * SingletonHTTPT[rX\bhێMapB
	 */
	private static Map<Class<?>, Object> singletonInstances = new ConcurrentHashMap<Class<?>, Object>();

	/**
	 * {@inheritDoc}
	 */
	public Object create(Class<?> serviceClass, Method method) {
		Object service;

		if (singletonInstances.containsKey(serviceClass)) {
			return singletonInstances.get(serviceClass);
		}

		try {
			service = serviceClass.newInstance();
		} catch (Exception e) {
			throw new HttpServiceException(Message.get("FSCORE-ERR008", serviceClass.getName()), e);
		}

		if (AnnotationUtil.isSuperClassAnnotated(serviceClass, Singleton.class)) {
			singletonInstances.put(serviceClass, service);
		}
		return service;
	}

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {
	}

	/**
	 * ̃vOCi̓lXgi܂B
	 * @return false
	 * @see PluginPart#nest()
	 */
	public boolean nest() {
		return false;
	}

	/**
	 * ̃vOCi̓lXgiȂ߁Ã\bh͉s܂B
	 * @param o lXgvOCi
	 * @see PluginPart#setNestedObject(PluginPart)
	 */
	public void setNestedObject(PluginPart o) {
	}

	/**
	 * ̃vOCi̗D揇ʂłB
	 * 1024Ԃ܂B
	 * @return 1024
	 * @see PluginPart#priority()
	 */
	public int priority() {
		return PLUGIN_PRIORITY;
	}
}
