package com.small_it_office.flatserve.core.request.type.internal;

import java.lang.annotation.Annotation;


import com.small_it_office.flatserve.core.request.internal.NullObject;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;


/**
 * HTTPT[rX\bḧ}bsOΏۊǑ^łꍇɓKpRequestParameterMapping̎B
 * mapParameter\bh́AlȂ0AIuWFNgȂnullȂǁA^ɑΉftHglԂB
 */
public class UnsupportedTypeMapping implements TypeMapping {

	/**
	 * Ώۂ̃\bḧ^B
	 */
	private Class<?> type;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * RXgN^B
	 * @param type Ώۂ̃\bḧ^
	 */
	public UnsupportedTypeMapping(Class<?> type) {
		this.type = type;
	}

	/**
	 * {@inheritDoc}
	 * ̃NX̎ł́Ǎ^̃ftHglA܂A0܂nullԂ܂B
	 */
	public MappedParameter mapParameter(Annotation[] annotations, Object readParam) {

		if (readParam != null && readParam != NullObject.getInstance()) {
			logger.debug("FSCORE-LOGD028", readParam);
			return null;
		}

		logger.debug("FSCORE-LOGD054", type.getName());

		if (type == boolean.class) {
			return new MappedParameter(false, null);
		} else if (type == long.class) {
			return new MappedParameter(0L, null);
		} else if (type == int.class) {
			return new MappedParameter(0, null);
		} else if (type == byte.class) {
			return new MappedParameter((byte)0, null);
		} else if (type == short.class) {
			return new MappedParameter((short)0, null);
		} else if (type == char.class) {
			return new MappedParameter((char)0, null);
		} else if (type == float.class) {
			return new MappedParameter(0f, null);
		} else if (type == double.class) {
			return new MappedParameter(0d, null);
		}
		return null;
	}

}
