package com.small_it_office.flatserve.core.request.type.internal;

import java.lang.annotation.Annotation;
import java.util.Map;

import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.RequestBody;
import com.small_it_office.flatserve.core.request.internal.NullObject;
import com.small_it_office.flatserve.core.request.internal.ParamNameConstants;
import com.small_it_office.flatserve.core.util.internal.AnnotationUtil;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * HTTPT[rX\bḧbyte[]^̏ꍇɃNGXgp[^Ƃ̃}bsOs܂B
 * ̃NXmapParameter\bh́AT[rX\bḧ@RequestBodyAme[V
 * t^Ă΁ANGXg{fBXg[ǂݍ݁AoCgzƂĕԂ܂B
 */
public class ByteArrayTypeMapping implements TypeMapping {

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	public MappedParameter mapParameter(Annotation[] annotations, Object readParam) {
		logger.debug("FSCORE-LOGD027", "byte[]", this.getClass().getSimpleName());
		if (readParam != null && readParam != NullObject.getInstance()) {
			logger.debug("FSCORE-LOGD028", readParam);
			return null;
		}
		RequestBody annotation = AnnotationUtil.findAnnotation(annotations, RequestBody.class);
		byte[] body = null;
		if (annotation != null) {
			Map<String, Object> requestParams = RequestContext.get().getRequestParams();
			body = (byte[])requestParams.get(ParamNameConstants.REQUEST_BODY);
		}
		logger.debug("FSCORE-LOGD050");
		return new MappedParameter(body, body);
	}
}
