package com.small_it_office.flatserve.core.request.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Map;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.RequestBody;
import com.small_it_office.flatserve.core.util.internal.AnnotationUtil;
import com.small_it_office.flatserve.core.util.internal.RequestUtil;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * NGXgp[^ǂݍރNXłB
 */
public class RequestParameterReaderImpl implements RequestParameterReader {

	/**
	 * ̃vOCi̗D揇ʁB
	 */
	private static final int PLUGIN_PRIORITY = 1024;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	public Map<String, Object> process(Class<?> serviceClass, Method method, Map<String, Object> readParams,
	        boolean streamRead, boolean paramRead) {
		logger.debug("FSCORE-LOGD023");
		RequestContext context = RequestContext.get();
		HttpServletRequest request = context.getHttpServletRequest();
		if (containsRequestBodyParam(method)) {
			if (!streamRead && !paramRead) {
				readParams.put(ParamNameConstants.REQUEST_BODY, RequestUtil.readBody(request));
			}
		} else if (!streamRead) {
			readRequestParams(request, readParams);
		}
		readHeader(request, readParams);
		readParams.put(ParamNameConstants.HTTP_SERVLET_REQUEST, request);
		readParams.put(ParamNameConstants.HTTP_SERVLET_RESPONSE, context.getHttpServletResponse());
		readParams.put(ParamNameConstants.SERVLET_CONFIG, context.getServletConfig());
		logger.debug("FSCORE-LOGD024");
		return readParams;
	}

	/**
	 * \bh{@link RequestBody}Ame[Vt^ꂽ邩ǂmF܂B
	 * @param method \bhB
	 * @return {@link RequestBody}Ame[Vt^ꂽꍇtrueB
	 */
	private boolean containsRequestBodyParam(Method method) {
		Annotation[][] paramAnnotations = method.getParameterAnnotations();
		for (Annotation[] annotations : paramAnnotations) {
			if (AnnotationUtil.findAnnotation(annotations, RequestBody.class) != null) {
				return true;
			}
		}
		return false;
	}

	/**
	 * NGXgp[^NGXgIuWFNgǂݍ݂܂B
	 * @param request HTTPNGXgIuWFNgB
	 * @param readParams ǂݍ񂾃p[^i[MapB
	 */
	private void readRequestParams(HttpServletRequest request, Map<String, Object> readParams) {
		Enumeration<?> paramNames = request.getParameterNames();
		while (paramNames.hasMoreElements()) {
			String paramName = (String)paramNames.nextElement();
			if (!readParams.containsKey(paramName)) {
				readParams.put(paramName, request.getParameterValues(paramName));
			}
		}
	}

	/**
	 * NGXgwb_NGXgIuWFNgǂݍ݂܂B
	 * @param request HTTPNGXgIuWFNgB
	 * @param readParams ǂݍ񂾃wb_i[MapB
	 */
	private void readHeader(HttpServletRequest request, Map<String, Object> readParams) {
		Enumeration<?> headerNames = request.getHeaderNames();
		while (headerNames.hasMoreElements()) {
			String headerName = headerNames.nextElement().toString().toLowerCase();
			String headerKey = ParamNameConstants.REQUEST_HEADER_KEY_PREFIX + headerName;
			if (!readParams.containsKey(headerKey)) {
				readParams.put(headerKey, request.getHeader(headerName));
			}
		}
	}

	/**
	 * ̃vOCi̓lXgi܂B
	 * @return false
	 * @see PluginPart#nest()
	 */
	public boolean nest() {
		return false;
	}

	/**
	 * ̃vOCi̓lXgiȂ߁Ã\bh͉s܂B
	 * @param o lXgvOCi
	 * @see PluginPart#setNestedObject(PluginPart)
	 */
	public void setNestedObject(PluginPart o) {
		//NOP
	}

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {
	}

	/**
	 * ̃vOCi̗D揇ʂłB
	 * 1024Ԃ܂B
	 * @return 1024
	 * @see PluginPart#priority()
	 */
	public int priority() {
		return PLUGIN_PRIORITY;
	}

}
